/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.block;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import io.horizen.block.Equihash;
import io.horizen.block.MainchainHeader$;
import io.horizen.block.MainchainHeaderSerializer$;
import io.horizen.block.ProofOfWorkVerifier$;
import io.horizen.history.validation.InvalidMainchainHeaderException;
import io.horizen.history.validation.InvalidMainchainHeaderException$;
import io.horizen.history.validation.MainchainHeaderTimestampInFutureException;
import io.horizen.history.validation.MainchainHeaderTimestampInFutureException$;
import io.horizen.json.Views;
import io.horizen.params.NetworkParams;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Utils;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.serialization.BytesSerializable;
import sparkz.core.serialization.SparkzSerializer;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"mainchainHeaderBytes", "hashHex"})
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u0013&\u00011B\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003I\u0011!a\u0005A!b\u0001\n\u0003q\u0004\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B \t\u00119\u0003!Q1A\u0005\u0002yB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t!\u0002\u0011)\u0019!C\u0001}!A\u0011\u000b\u0001B\u0001B\u0003%q\b\u0003\u0005S\u0001\t\u0015\r\u0011\"\u0001H\u0011!\u0019\u0006A!A!\u0002\u0013A\u0005\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011A$\t\u0011U\u0003!\u0011!Q\u0001\n!C\u0001B\u0016\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t/\u0002\u0011\t\u0011)A\u0005\u007f!A\u0001\f\u0001BC\u0002\u0013\u0005a\b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011!9\u0007\u0001#b\u0001\n\u0003q\u0004\u0002\u00035\u0001\u0011\u000b\u0007I\u0011A5\u0006\tU\u0004\u0001\u0005\u0018\u0005\u0006m\u0002!\te\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002<\u0001!\t%!\u0010\b\u000f\u0005\u0005U\u0005#\u0001\u0002\u0004\u001a1A%\nE\u0001\u0003\u000bCaA\u0017\u0010\u0005\u0002\u00055\u0005\u0002CAH=\t\u0007I\u0011A$\t\u000f\u0005Ee\u0004)A\u0005\u0011\"9\u00111\u0013\u0010\u0005\u0002\u0005U\u0005\"CAQ=\u0005\u0005I\u0011BAR\u0005=i\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014(B\u0001\u0014(\u0003\u0015\u0011Gn\\2l\u0015\tA\u0013&A\u0004i_JL'0\u001a8\u000b\u0003)\n!![8\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!4(D\u00016\u0015\t1t'A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003qe\nAaY8sK*\t!(\u0001\u0004ta\u0006\u00148N_\u0005\u0003yU\u0012\u0011CQ=uKN\u001cVM]5bY&T\u0018M\u00197f\u0003Qi\u0017-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014()\u001f;fgV\tq\bE\u0002/\u0001\nK!!Q\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u00059\u001a\u0015B\u0001#0\u0005\u0011\u0011\u0015\u0010^3\u0002+5\f\u0017N\\2iC&t\u0007*Z1eKJ\u0014\u0015\u0010^3tA\u00059a/\u001a:tS>tW#\u0001%\u0011\u00059J\u0015B\u0001&0\u0005\rIe\u000e^\u0001\tm\u0016\u00148/[8oA\u0005i\u0001.Y:i!J,gO\u00117pG.\fa\u0002[1tQB\u0013XM\u001e\"m_\u000e\\\u0007%\u0001\biCNDW*\u001a:lY\u0016\u0014vn\u001c;\u0002\u001f!\f7\u000f['fe.dWMU8pi\u0002\n1\u0003[1tQN\u001bG\u000b_:D_6l\u0017\u000e^7f]R\fA\u0003[1tQN\u001bG\u000b_:D_6l\u0017\u000e^7f]R\u0004\u0013\u0001\u0002;j[\u0016\fQ\u0001^5nK\u0002\nAAY5ug\u0006)!-\u001b;tA\u0005)an\u001c8dK\u00061an\u001c8dK\u0002\n\u0001b]8mkRLwN\\\u0001\ng>dW\u000f^5p]\u0002\na\u0001P5oSRtDC\u0003/_?\u0002\f'm\u00193fMB\u0011Q\fA\u0007\u0002K!)Qh\u0005a\u0001\u007f!)ai\u0005a\u0001\u0011\")Aj\u0005a\u0001\u007f!)aj\u0005a\u0001\u007f!)\u0001k\u0005a\u0001\u007f!)!k\u0005a\u0001\u0011\")Ak\u0005a\u0001\u0011\")ak\u0005a\u0001\u007f!)\u0001l\u0005a\u0001\u007f\u0005!\u0001.Y:i\u0003\u001dA\u0017m\u001d5IKb,\u0012A\u001b\t\u0003WJt!\u0001\u001c9\u0011\u00055|S\"\u00018\u000b\u0005=\\\u0013A\u0002\u001fs_>$h(\u0003\u0002r_\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\rM#(/\u001b8h\u0015\t\txFA\u0001N\u0003)\u0019XM]5bY&TXM]\u000b\u0002qB\u0019A'\u001f/\n\u0005i,$\u0001E*qCJ\\'pU3sS\u0006d\u0017N_3s\u0003A\u0019X-\\1oi&\u001cg+\u00197jI&$\u0018\u0010F\u0002~\u0003\u001b\u0001RA`A\u0002\u0003\u000fi\u0011a \u0006\u0004\u0003\u0003y\u0013\u0001B;uS2L1!!\u0002\u0000\u0005\r!&/\u001f\t\u0004]\u0005%\u0011bAA\u0006_\t!QK\\5u\u0011\u001d\ty\u0001\u0007a\u0001\u0003#\ta\u0001]1sC6\u001c\b\u0003BA\n\u0003/i!!!\u0006\u000b\u0007\u0005=q%\u0003\u0003\u0002\u001a\u0005U!!\u0004(fi^|'o\u001b)be\u0006l7/\u0001\u0006jgB\u000b'/\u001a8u\u001f\u001a$B!a\b\u0002&A\u0019a&!\t\n\u0007\u0005\rrFA\u0004C_>dW-\u00198\t\r\u0005\u001d\u0012\u00041\u0001]\u0003\u0019AW-\u00193fe\u0006A\u0001.Y:i\u0007>$W\rF\u0001I\u0003\u0019)\u0017/^1mgR!\u0011qDA\u0019\u0011\u001d\t\u0019d\u0007a\u0001\u0003k\t1a\u001c2k!\rq\u0013qG\u0005\u0004\u0003sy#aA!os\u0006AAo\\*ue&tw\rF\u0001kQ\u001d\u0001\u0011\u0011IA-\u00037\u0002B!a\u0011\u0002V5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0006b]:|G/\u0019;j_:TA!a\u0013\u0002N\u00059!.Y2lg>t'\u0002BA(\u0003#\n\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u0005M\u0013aA2p[&!\u0011qKA#\u0005QQ5o\u001c8JO:|'/\u001a)s_B,'\u000f^5fg\u0006)a/\u00197vK2\"\u0011QLA0C\u0005i\u0014%\u00015)\u000f\u0001\t\u0019'!\u0017\u0002jA!\u00111IA3\u0013\u0011\t9'!\u0012\u0003\u0011)\u001bxN\u001c,jK^d#!a\u001b$\u0005\u00055\u0004\u0003BA8\u0003wrA!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003k:\u0013\u0001\u00026t_:LA!!\u001f\u0002t\u0005)a+[3xg&!\u0011QPA@\u0005\u001d!UMZ1vYRTA!!\u001f\u0002t\u0005yQ*Y5oG\"\f\u0017N\u001c%fC\u0012,'\u000f\u0005\u0002^=M!a$LAD!\rq\u0013\u0011R\u0005\u0004\u0003\u0017{#\u0001D*fe&\fG.\u001b>bE2,GCAAB\u0003=AU)\u0011#F%~k\u0015JT0T\u0013j+\u0015\u0001\u0005%F\u0003\u0012+%kX'J\u001d~\u001b\u0016JW#!\u0003\u0019\u0019'/Z1uKR1\u0011qSAM\u0003;\u0003BA`A\u00029\"1\u00111\u0014\u0012A\u0002}\n1\u0002[3bI\u0016\u0014()\u001f;fg\"1\u0011q\u0014\u0012A\u0002!\u000baa\u001c4gg\u0016$\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!*\u0011\t\u0005\u001d\u0016\u0011W\u0007\u0003\u0003SSA!a+\u0002.\u0006!A.\u00198h\u0015\t\ty+\u0001\u0003kCZ\f\u0017\u0002BAZ\u0003S\u0013aa\u00142kK\u000e$\b")
public class MainchainHeader
implements BytesSerializable {
    private byte[] hash;
    private String hashHex;
    private final byte[] mainchainHeaderBytes;
    private final int version;
    private final byte[] hashPrevBlock;
    private final byte[] hashMerkleRoot;
    private final byte[] hashScTxsCommitment;
    private final int time;
    private final int bits;
    private final byte[] nonce;
    private final byte[] solution;
    private volatile byte bitmap$0;

    public static Try<MainchainHeader> create(byte[] byArray, int n) {
        return MainchainHeader$.MODULE$.create(byArray, n);
    }

    public static int HEADER_MIN_SIZE() {
        return MainchainHeader$.MODULE$.HEADER_MIN_SIZE();
    }

    public byte[] bytes() {
        return BytesSerializable.bytes$((BytesSerializable)this);
    }

    public byte[] mainchainHeaderBytes() {
        return this.mainchainHeaderBytes;
    }

    public int version() {
        return this.version;
    }

    public byte[] hashPrevBlock() {
        return this.hashPrevBlock;
    }

    public byte[] hashMerkleRoot() {
        return this.hashMerkleRoot;
    }

    public byte[] hashScTxsCommitment() {
        return this.hashScTxsCommitment;
    }

    public int time() {
        return this.time;
    }

    public int bits() {
        return this.bits;
    }

    public byte[] nonce() {
        return this.nonce;
    }

    public byte[] solution() {
        return this.solution;
    }

    private byte[] hash$lzycompute() {
        MainchainHeader mainchainHeader = this;
        synchronized (mainchainHeader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.hash = BytesUtils.reverseBytes(Utils.doubleSHA256Hash(this.mainchainHeaderBytes()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.hash;
    }

    public byte[] hash() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.hash$lzycompute() : this.hash;
    }

    private String hashHex$lzycompute() {
        MainchainHeader mainchainHeader = this;
        synchronized (mainchainHeader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hashHex = BytesUtils.toHexString(this.hash());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hashHex;
    }

    public String hashHex() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hashHex$lzycompute() : this.hashHex;
    }

    public SparkzSerializer<MainchainHeader> serializer() {
        return MainchainHeaderSerializer$.MODULE$;
    }

    public Try<BoxedUnit> semanticValidity(NetworkParams params) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.hashPrevBlock() == null || this.hashPrevBlock().length != 32 || this.hashMerkleRoot() == null || this.hashMerkleRoot().length != 32 || this.hashScTxsCommitment() == null || this.hashScTxsCommitment().length != 32 || this.nonce() == null || this.nonce().length != 32 || this.solution() == null || this.solution().length != params.EquihashSolutionLength() || this.time() <= 0) {
                throw new InvalidMainchainHeaderException("MainchainHeader contains null or out of bound fields.", InvalidMainchainHeaderException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!ProofOfWorkVerifier$.MODULE$.checkProofOfWork(this, params)) {
                throw new InvalidMainchainHeaderException(new StringBuilder(32).append("MainchainHeader ").append(this.hashHex()).append(" PoW is invalid.").toString(), InvalidMainchainHeaderException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!new Equihash(params.EquihashN(), params.EquihashK()).checkEquihashSolution((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.mainchainHeaderBytes())).slice(0, this.mainchainHeaderBytes().length - params.EquihashCompactSizeLength() - params.EquihashSolutionLength()), this.solution())) {
                throw new InvalidMainchainHeaderException(new StringBuilder(46).append("MainchainHeader ").append(this.hashHex()).append(" Equihash solution is invalid.").toString(), InvalidMainchainHeaderException$.MODULE$.$lessinit$greater$default$2());
            }
            if ((long)this.time() > Instant.now().getEpochSecond() + 7200L) {
                throw new MainchainHeaderTimestampInFutureException(new StringBuilder(44).append("MainchainHeader ").append(this.hashHex()).append(" time ").append(this.time()).append(" is too far in future.").toString(), MainchainHeaderTimestampInFutureException$.MODULE$.$lessinit$greater$default$2());
            }
        });
    }

    public boolean isParentOf(MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.hashPrevBlock())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.hash()));
    }

    public int hashCode() {
        return Arrays.hashCode(this.mainchainHeaderBytes());
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof MainchainHeader) {
            MainchainHeader mainchainHeader = (MainchainHeader)object;
            bl = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.hash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(mainchainHeader.hash()));
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return new StringBuilder(33).append("MainchainHeader(").append(this.mainchainHeaderBytes()).append(", ").append(this.version()).append(", ").append(this.hashPrevBlock()).append(", ").append(this.hashMerkleRoot()).append(", ").append(this.hashScTxsCommitment()).append(", ").append(this.time()).append(", ").append(this.bits()).append(", ").append(this.nonce()).append(", ").append(this.solution()).append(")").toString();
    }

    public MainchainHeader(byte[] mainchainHeaderBytes, int version, byte[] hashPrevBlock, byte[] hashMerkleRoot, byte[] hashScTxsCommitment, int time, int bits, byte[] nonce, byte[] solution) {
        this.mainchainHeaderBytes = mainchainHeaderBytes;
        this.version = version;
        this.hashPrevBlock = hashPrevBlock;
        this.hashMerkleRoot = hashMerkleRoot;
        this.hashScTxsCommitment = hashScTxsCommitment;
        this.time = time;
        this.bits = bits;
        this.nonce = nonce;
        this.solution = solution;
        BytesSerializable.$init$((BytesSerializable)this);
    }
}

