/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.api.http;

import akka.http.javadsl.marshallers.jackson.Jackson;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpEntities;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.RequestEntity;
import akka.http.javadsl.server.Directives;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.unmarshalling.Unmarshaller;
import io.horizen.SidechainNodeViewBase;
import io.horizen.api.http.ApiResponse;
import io.horizen.api.http.ApiResponseUtil;
import io.horizen.api.http.FunctionsApplierOnSidechainNodeView;
import io.horizen.api.http.InternalExceptionApiErrorResponse;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.node.NodeHistoryBase;
import io.horizen.node.NodeMemoryPoolBase;
import io.horizen.node.NodeStateBase;
import io.horizen.node.NodeWalletBase;
import io.horizen.transaction.Transaction;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class ApplicationBaseApiGroup<TX extends Transaction, H extends SidechainBlockHeaderBase, PM extends SidechainBlockBase<TX, H>, FPI extends AbstractFeePaymentsInfo, NH extends NodeHistoryBase<TX, H, PM, FPI>, S extends NodeStateBase, W extends NodeWalletBase, P extends NodeMemoryPoolBase<TX>, NV extends SidechainNodeViewBase<TX, H, PM, FPI, NH, S, W, P>> {
    private FunctionsApplierOnSidechainNodeView<TX, H, PM, FPI, NH, S, W, P, NV> functionsApplierOnSidechainNodeView;

    public abstract String basePath();

    public abstract List<Route> getRoutes();

    public final FunctionsApplierOnSidechainNodeView<TX, H, PM, FPI, NH, S, W, P, NV> getFunctionsApplierOnSidechainNodeView() {
        return this.functionsApplierOnSidechainNodeView;
    }

    public final void setFunctionsApplierOnSidechainNodeView(FunctionsApplierOnSidechainNodeView<TX, H, PM, FPI, NH, S, W, P, NV> functionsApplierOnSidechainNodeView) {
        this.functionsApplierOnSidechainNodeView = functionsApplierOnSidechainNodeView;
    }

    protected static Route buildRouteForApiResponse(ApiResponse data) {
        try {
            return ApiResponseUtil.toResponseAsJava(data);
        }
        catch (Exception e) {
            return Directives.complete((HttpResponse)((HttpResponse)HttpResponse.create().withStatus(500).withEntity((RequestEntity)HttpEntities.create((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, (String)("{\"error\":500, \"reason\"=" + e.getMessage() + ", detail=\"\"}")))));
        }
    }

    protected final <T> Route bindPostRequest(String path, Function<T, ApiResponse> functionToBind, Class<T> requestBodyClazz) {
        Unmarshaller unmarshaller = Jackson.unmarshaller(requestBodyClazz);
        return Directives.path((String)path, () -> Directives.post(() -> Directives.entity((Unmarshaller)unmarshaller, functionToBind.andThen(ApplicationBaseApiGroup::buildRouteForApiResponse))));
    }

    protected final <T> Route bindPostRequest(String path, BiFunction<NV, T, ApiResponse> functionToBind, Class<T> clazz) {
        Function<Object, ApiResponse> transformedFunction = ApplicationBaseApiGroup.secondArgumentPartialApply(this::applyBiFunctionOnSidechainNodeView, functionToBind);
        return this.bindPostRequest(path, transformedFunction, clazz);
    }

    protected final Route bindPostRequest(String path, Function<NV, ApiResponse> functionToBind) {
        return Directives.path((String)path, () -> Directives.post(() -> Directives.requestEntityEmpty(() -> Directives.onSuccess(CompletableFuture.supplyAsync(() -> this.applyFunctionOnSidechainNodeView(functionToBind)), ApplicationBaseApiGroup::buildRouteForApiResponse))));
    }

    private ApiResponse applyFunctionOnSidechainNodeView(Function<NV, ApiResponse> func) {
        try {
            return this.getFunctionsApplierOnSidechainNodeView().applyFunctionOnSidechainNodeView(func);
        }
        catch (Exception e) {
            return new InternalExceptionApiErrorResponse(Optional.of(e));
        }
    }

    private <T> ApiResponse applyBiFunctionOnSidechainNodeView(T functionParameter, BiFunction<NV, T, ApiResponse> func) {
        try {
            return this.getFunctionsApplierOnSidechainNodeView().applyBiFunctionOnSidechainNodeView(func, functionParameter);
        }
        catch (Exception e) {
            return new InternalExceptionApiErrorResponse(Optional.of(e));
        }
    }

    public static <T, U, R> Function<T, R> secondArgumentPartialApply(BiFunction<T, U, R> f, U x) {
        Function<Object, Object> partialAppliedFunction = y -> f.apply(y, x);
        return partialAppliedFunction;
    }
}

