/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.api.http;

import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpEntities;
import akka.http.javadsl.model.RequestEntity;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.server.Directives$;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.directives.RouteAdapter;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import com.google.common.base.Throwables;
import io.horizen.api.http.ApiResponse;
import io.horizen.api.http.ErrorResponse;
import io.horizen.api.http.SidechainApiResponse$;
import io.horizen.api.http.SuccessResponse;
import io.horizen.json.SerializationUtil;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Future;

public final class ApiResponseUtil$ {
    public static ApiResponseUtil$ MODULE$;

    static {
        new ApiResponseUtil$();
    }

    public Function1<RequestContext, Future<RouteResult>> toResponse(ApiResponse response) {
        Function1<RequestContext, Future<RouteResult>> function1;
        ApiResponse apiResponse = response;
        if (apiResponse instanceof SuccessResponse) {
            function1 = SidechainApiResponse$.MODULE$.apply(SerializationUtil.serializeWithResult(response));
        } else if (apiResponse instanceof ErrorResponse) {
            Function1<RequestContext, Future<RouteResult>> function12;
            ErrorResponse errorResponse = (ErrorResponse)apiResponse;
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(errorResponse.exception()));
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable thr = (Throwable)some.value();
                String msg = thr.getMessage();
                function12 = msg != null && new StringOps(Predef$.MODULE$.augmentString(msg)).nonEmpty() ? SidechainApiResponse$.MODULE$.apply(SerializationUtil.serializeErrorWithResult(errorResponse.code(), errorResponse.description(), msg)) : SidechainApiResponse$.MODULE$.apply(SerializationUtil.serializeErrorWithResult(errorResponse.code(), errorResponse.description(), ""));
            } else if (None$.MODULE$.equals(option)) {
                function12 = SidechainApiResponse$.MODULE$.apply(SerializationUtil.serializeErrorWithResult(errorResponse.code(), errorResponse.description(), ""));
            } else {
                throw new MatchError((Object)option);
            }
            function1 = function12;
        } else {
            throw new MatchError((Object)apiResponse);
        }
        return function1;
    }

    public Function1<RequestContext, Future<RouteResult>> toResponseWithoutResultWrapper(ApiResponse response) {
        return SidechainApiResponse$.MODULE$.apply(SerializationUtil.serialize(response));
    }

    public Route toResponseAsJava(ApiResponse response) {
        RouteAdapter routeAdapter;
        ApiResponse apiResponse = response;
        if (apiResponse instanceof SuccessResponse) {
            routeAdapter = Directives$.MODULE$.complete(StatusCodes.OK, (RequestEntity)HttpEntities.create((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, (String)SerializationUtil.serializeWithResult(response)));
        } else if (apiResponse instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)apiResponse;
            String exceptionMessage = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(errorResponse.exception())).map((Function1 & Serializable & scala.Serializable)x$1 -> Throwables.getStackTraceAsString((Throwable)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            routeAdapter = Directives$.MODULE$.complete(StatusCodes.OK, (RequestEntity)HttpEntities.create((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, (String)SerializationUtil.serializeErrorWithResult(errorResponse.code(), errorResponse.description(), exceptionMessage)));
        } else {
            throw new MatchError((Object)apiResponse);
        }
        return routeAdapter;
    }

    private ApiResponseUtil$() {
        MODULE$ = this;
    }
}

