/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.websocket;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.api.rpc.service.RpcFilter$;
import io.horizen.account.api.rpc.types.EthereumLogView;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.serialization.EthJsonMapper;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.websocket.WebSocketAccountChannelImpl;
import io.horizen.account.websocket.data.Subscription;
import io.horizen.account.websocket.data.SubscriptionWithFilter;
import io.horizen.account.websocket.data.WebSocketAccountEvent;
import io.horizen.account.websocket.data.WebSocketAccountEvent$;
import io.horizen.account.websocket.data.WebSocketAccountEventParams;
import io.horizen.account.websocket.data.WebSocketEthereumBlockView;
import io.horizen.account.websocket.data.WebSocketSyncEvent;
import io.horizen.account.websocket.data.WebSocketSyncStatus;
import io.horizen.evm.Address;
import io.horizen.network.SyncStatus;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import org.web3j.utils.Numeric;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.util.SparkzLogging;

public final class WebSocketAccountServerEndpoint$
implements SparkzLogging {
    public static WebSocketAccountServerEndpoint$ MODULE$;
    private AtomicInteger subscriptionCounter;
    private List<Subscription> newHeadsSubscriptions;
    private List<Subscription> newPendingTransactionsSubscriptions;
    private List<SubscriptionWithFilter> logsSubscriptions;
    private List<Subscription> syncingSubscriptions;
    private final WebSocketAccountChannelImpl webSocketAccountChannelImpl;
    private Set<Address> walletAddresses;
    private List<Tuple2<String, Set<EthereumLogView>>> cachedBlocksReceipts;
    private final int maxCachedBlockReceipts;
    private final Logger logger;

    static {
        new WebSocketAccountServerEndpoint$();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public AtomicInteger subscriptionCounter() {
        return this.subscriptionCounter;
    }

    public void subscriptionCounter_$eq(AtomicInteger x$1) {
        this.subscriptionCounter = x$1;
    }

    public List<Subscription> newHeadsSubscriptions() {
        return this.newHeadsSubscriptions;
    }

    public void newHeadsSubscriptions_$eq(List<Subscription> x$1) {
        this.newHeadsSubscriptions = x$1;
    }

    public List<Subscription> newPendingTransactionsSubscriptions() {
        return this.newPendingTransactionsSubscriptions;
    }

    public void newPendingTransactionsSubscriptions_$eq(List<Subscription> x$1) {
        this.newPendingTransactionsSubscriptions = x$1;
    }

    public List<SubscriptionWithFilter> logsSubscriptions() {
        return this.logsSubscriptions;
    }

    public void logsSubscriptions_$eq(List<SubscriptionWithFilter> x$1) {
        this.logsSubscriptions = x$1;
    }

    public List<Subscription> syncingSubscriptions() {
        return this.syncingSubscriptions;
    }

    public void syncingSubscriptions_$eq(List<Subscription> x$1) {
        this.syncingSubscriptions = x$1;
    }

    public WebSocketAccountChannelImpl webSocketAccountChannelImpl() {
        return this.webSocketAccountChannelImpl;
    }

    private Set<Address> walletAddresses() {
        return this.walletAddresses;
    }

    private void walletAddresses_$eq(Set<Address> x$1) {
        this.walletAddresses = x$1;
    }

    private List<Tuple2<String, Set<EthereumLogView>>> cachedBlocksReceipts() {
        return this.cachedBlocksReceipts;
    }

    private void cachedBlocksReceipts_$eq(List<Tuple2<String, Set<EthereumLogView>>> x$1) {
        this.cachedBlocksReceipts = x$1;
    }

    private int maxCachedBlockReceipts() {
        return this.maxCachedBlockReceipts;
    }

    public void notifySemanticallySuccessfulModifier(AccountBlock block) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug(new StringBuilder(30).append("Websocket received new block: ").append(block.toString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try<WebSocketEthereumBlockView> try_ = this.webSocketAccountChannelImpl().accountBlockToWebsocketJson(block);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            WebSocketEthereumBlockView blockJson = (WebSocketEthereumBlockView)success.value();
            this.newHeadsSubscriptions().foreach((Function1 & Serializable & scala.Serializable)subscription -> {
                WebSocketAccountServerEndpoint$.$anonfun$notifySemanticallySuccessfulModifier$1(blockJson, subscription);
                return BoxedUnit.UNIT;
            });
            while (this.cachedBlocksReceipts().nonEmpty() && !((String)((Tuple2)this.cachedBlocksReceipts().head())._1()).equals(block.parentId())) {
                Tuple2 oldTip = (Tuple2)this.cachedBlocksReceipts().head();
                this.logsSubscriptions().foreach((Function1 & Serializable & scala.Serializable)subscription -> {
                    WebSocketAccountServerEndpoint$.$anonfun$notifySemanticallySuccessfulModifier$2(oldTip, subscription);
                    return BoxedUnit.UNIT;
                });
                this.cachedBlocksReceipts_$eq((List<Tuple2<String, Set<EthereumLogView>>>)this.cachedBlocksReceipts().drop(1));
            }
            this.processBlockReceipt(block);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit3;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(35).append("Websocket failed to get block info ").append(exception.getMessage()).toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit3;
        } else {
            throw new MatchError(try_);
        }
    }

    public void notifyNewPendingTransaction(EthereumTransaction tx) {
        block2: {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(27).append("Websocket received new tx: ").append(tx.id()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!this.walletAddresses().contains((Object)tx.getFromAddress())) break block2;
            this.newPendingTransactionsSubscriptions().foreach((Function1 & Serializable & scala.Serializable)subscription -> {
                WebSocketAccountServerEndpoint$.$anonfun$notifyNewPendingTransaction$1(tx, subscription);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void notifyNewExecTransactions(Seq<EthereumTransaction> newExecTxs) {
        newExecTxs.foreach((Function1 & Serializable & scala.Serializable)tx -> {
            WebSocketAccountServerEndpoint$.MODULE$.notifyNewPendingTransaction(tx);
            return BoxedUnit.UNIT;
        });
    }

    public void notifySyncStarted(SyncStatus syncStatus) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Websocket received notification on sync update.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.syncingSubscriptions().foreach((Function1 & Serializable & scala.Serializable)subscription -> {
            WebSocketAccountServerEndpoint$.MODULE$.send(new WebSocketAccountEventParams(subscription.subscriptionId(), new WebSocketSyncEvent(true, new WebSocketSyncStatus(syncStatus))), subscription.session());
            return BoxedUnit.UNIT;
        });
    }

    public void notifySyncStopped() {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Websocket received notification on sync stop.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.syncingSubscriptions().foreach((Function1 & Serializable & scala.Serializable)subscription -> {
            WebSocketAccountServerEndpoint$.MODULE$.send(new WebSocketAccountEventParams(subscription.subscriptionId(), new WebSocketSyncEvent(false, null)), subscription.session());
            return BoxedUnit.UNIT;
        });
    }

    private void processBlockReceipt(AccountBlock block) {
        block0: {
            ObjectRef relevantBlockReceipt = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            this.logsSubscriptions().foreach((Function1 & Serializable & scala.Serializable)subscription -> {
                WebSocketAccountServerEndpoint$.$anonfun$processBlockReceipt$1(block, relevantBlockReceipt, subscription);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple2 = new Tuple2((Object)block.id(), ((Seq)relevantBlockReceipt.elem).toSet().map((Function1 & Serializable & scala.Serializable)log -> {
                log.updateRemoved(true);
                return log;
            }, Set$.MODULE$.canBuildFrom()));
            this.cachedBlocksReceipts_$eq((List<Tuple2<String, Set<EthereumLogView>>>)((List)this.cachedBlocksReceipts().$plus$colon((Object)tuple2, List$.MODULE$.canBuildFrom())));
            if (this.cachedBlocksReceipts().size() <= this.maxCachedBlockReceipts()) break block0;
            this.cachedBlocksReceipts_$eq((List<Tuple2<String, Set<EthereumLogView>>>)((List)this.cachedBlocksReceipts().dropRight(1)));
        }
    }

    private void sendTransactionLog(Seq<EthereumLogView> txLogs, SubscriptionWithFilter subscription) {
        txLogs.foreach((Function1 & Serializable & scala.Serializable)txLog -> {
            WebSocketAccountServerEndpoint$.$anonfun$sendTransactionLog$1(subscription, txLog);
            return BoxedUnit.UNIT;
        });
    }

    public void onVaultChanged() {
        Try<Set<Address>> try_ = this.webSocketAccountChannelImpl().getWalletAddresses();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Set addresses = (Set)success.value();
            this.walletAddresses_$eq((Set<Address>)addresses);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(43).append("Websocket failed to update walletAddresses ").append(exception.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }

    public void addNewHeadsSubscription(Subscription subscription) {
        Subscription subscription2 = subscription;
        this.newHeadsSubscriptions_$eq((List<Subscription>)this.newHeadsSubscriptions().$colon$colon((Object)subscription2));
    }

    public void addNewPendingTransactionsSubscription(Subscription subscription) {
        Subscription subscription2 = subscription;
        this.newPendingTransactionsSubscriptions_$eq((List<Subscription>)this.newPendingTransactionsSubscriptions().$colon$colon((Object)subscription2));
    }

    public void addLogsSubscription(SubscriptionWithFilter subscription) {
        SubscriptionWithFilter subscriptionWithFilter = subscription;
        this.logsSubscriptions_$eq((List<SubscriptionWithFilter>)this.logsSubscriptions().$colon$colon((Object)subscriptionWithFilter));
    }

    public void addSyncingSubscription(Subscription subscription) {
        Subscription subscription2 = subscription;
        this.syncingSubscriptions_$eq((List<Subscription>)this.syncingSubscriptions().$colon$colon((Object)subscription2));
    }

    public boolean removeSubscription(BigInteger subscriptionIdToRemove) {
        int foundNewHeadsSubscriptionToRemove = this.newHeadsSubscriptions().indexWhere((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$1(subscriptionIdToRemove, subscription)));
        if (foundNewHeadsSubscriptionToRemove != -1) {
            this.newHeadsSubscriptions_$eq((List<Subscription>)((List)this.newHeadsSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$2(subscriptionIdToRemove, subscription)))));
            return true;
        }
        int foundNewPendingTransactionsSubscriptionToRemove = this.newPendingTransactionsSubscriptions().indexWhere((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$3(subscriptionIdToRemove, subscription)));
        if (foundNewPendingTransactionsSubscriptionToRemove != -1) {
            this.newPendingTransactionsSubscriptions_$eq((List<Subscription>)((List)this.newPendingTransactionsSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$4(subscriptionIdToRemove, subscription)))));
            return true;
        }
        int foundLogSubscriptionToRemove = this.logsSubscriptions().indexWhere((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$5(subscriptionIdToRemove, subscription)));
        if (foundLogSubscriptionToRemove != -1) {
            this.logsSubscriptions_$eq((List<SubscriptionWithFilter>)((List)this.logsSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$6(subscriptionIdToRemove, subscription)))));
            return true;
        }
        int foundSyncingSubscriptionToRemove = this.syncingSubscriptions().indexWhere((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$7(subscriptionIdToRemove, subscription)));
        if (foundSyncingSubscriptionToRemove != -1) {
            this.syncingSubscriptions_$eq((List<Subscription>)((List)this.syncingSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSubscription$8(subscriptionIdToRemove, subscription)))));
            return true;
        }
        return false;
    }

    public void removeSession(Session session) {
        this.newHeadsSubscriptions_$eq((List<Subscription>)((List)this.newHeadsSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSession$1(session, subscription)))));
        this.newPendingTransactionsSubscriptions_$eq((List<Subscription>)((List)this.newPendingTransactionsSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSession$2(session, subscription)))));
        this.logsSubscriptions_$eq((List<SubscriptionWithFilter>)((List)this.logsSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSession$3(session, subscription)))));
        this.syncingSubscriptions_$eq((List<Subscription>)((List)this.syncingSubscriptions().filterNot((Function1 & Serializable & scala.Serializable)subscription -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountServerEndpoint$.$anonfun$removeSession$4(session, subscription)))));
    }

    public void send(Object websocketResponse, Session session) {
        block3: {
            try {
                session.getAsyncRemote().sendText(EthJsonMapper.serialize(websocketResponse), new SendHandler(session){
                    private final Session session$2;

                    public void onResult(SendResult sendResult) {
                        block2: {
                            BoxedUnit boxedUnit;
                            if (sendResult.isOK()) break block2;
                            if (WebSocketAccountServerEndpoint$.MODULE$.log().underlying().isDebugEnabled()) {
                                WebSocketAccountServerEndpoint$.MODULE$.log().underlying().debug(new StringBuilder(31).append("Websocket send message failed. ").append(this.session$2.getId()).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    {
                        this.session$2 = session$2;
                    }
                });
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug(new StringBuilder(30).append("Websocket send message error. ").append(session.getId()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void sendRpcResponse(Object rpcResponse, Session session) {
        block3: {
            try {
                session.getAsyncRemote().sendObject(rpcResponse, new SendHandler(session){
                    private final Session session$3;

                    public void onResult(SendResult sendResult) {
                        block2: {
                            BoxedUnit boxedUnit;
                            if (sendResult.isOK()) break block2;
                            if (WebSocketAccountServerEndpoint$.MODULE$.log().underlying().isDebugEnabled()) {
                                WebSocketAccountServerEndpoint$.MODULE$.log().underlying().debug(new StringBuilder(31).append("Websocket send message failed. ").append(this.session$3.getId()).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    {
                        this.session$3 = session$3;
                    }
                });
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug(new StringBuilder(30).append("Websocket send message error. ").append(session.getId()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$notifySemanticallySuccessfulModifier$1(WebSocketEthereumBlockView blockJson$1, Subscription subscription) {
        WebSocketAccountEventParams x$1 = new WebSocketAccountEventParams(subscription.subscriptionId(), blockJson$1);
        String x$2 = WebSocketAccountEvent$.MODULE$.$lessinit$greater$default$1();
        MODULE$.send(new WebSocketAccountEvent(x$2, (Object)x$1), subscription.session());
    }

    public static final /* synthetic */ void $anonfun$notifySemanticallySuccessfulModifier$2(Tuple2 oldTip$1, SubscriptionWithFilter subscription) {
        Set logsToSend = (Set)((TraversableLike)oldTip$1._2()).filter((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)RpcFilter$.MODULE$.testLog(subscription.filter().address, subscription.filter().topics, log)));
        MODULE$.sendTransactionLog((Seq<EthereumLogView>)logsToSend.toSeq(), subscription);
    }

    public static final /* synthetic */ void $anonfun$notifyNewPendingTransaction$1(EthereumTransaction tx$1, Subscription subscription) {
        WebSocketAccountEventParams x$1 = new WebSocketAccountEventParams(subscription.subscriptionId(), Numeric.prependHexPrefix((String)tx$1.id()));
        String x$2 = WebSocketAccountEvent$.MODULE$.$lessinit$greater$default$1();
        MODULE$.send(new WebSocketAccountEvent(x$2, (Object)x$1), subscription.session());
    }

    public static final /* synthetic */ void $anonfun$processBlockReceipt$1(AccountBlock block$1, ObjectRef relevantBlockReceipt$1, SubscriptionWithFilter subscription) {
        Try<Seq<EthereumLogView>> try_ = MODULE$.webSocketAccountChannelImpl().getEthereumLogsFromBlock(block$1, subscription);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq logs = (Seq)success.value();
            MODULE$.sendTransactionLog((Seq<EthereumLogView>)logs, subscription);
            Seq seq = logs;
            relevantBlockReceipt$1.elem = (Seq)((Seq)relevantBlockReceipt$1.elem).$plus$plus$colon((Traversable)seq, Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (MODULE$.log().underlying().isDebugEnabled()) {
                MODULE$.log().underlying().debug(new StringBuilder(41).append("Websocket failed to get transaction logs ").append(exception.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }

    public static final /* synthetic */ void $anonfun$sendTransactionLog$1(SubscriptionWithFilter subscription$2, EthereumLogView txLog) {
        WebSocketAccountEventParams x$1 = new WebSocketAccountEventParams(subscription$2.subscriptionId(), txLog);
        String x$2 = WebSocketAccountEvent$.MODULE$.$lessinit$greater$default$1();
        MODULE$.send(new WebSocketAccountEvent(x$2, (Object)x$1), subscription$2.session());
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$1(BigInteger subscriptionIdToRemove$1, Subscription subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$2(BigInteger subscriptionIdToRemove$1, Subscription subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$3(BigInteger subscriptionIdToRemove$1, Subscription subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$4(BigInteger subscriptionIdToRemove$1, Subscription subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$5(BigInteger subscriptionIdToRemove$1, SubscriptionWithFilter subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$6(BigInteger subscriptionIdToRemove$1, SubscriptionWithFilter subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$7(BigInteger subscriptionIdToRemove$1, Subscription subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSubscription$8(BigInteger subscriptionIdToRemove$1, Subscription subscription) {
        return subscription.subscriptionId().equals(subscriptionIdToRemove$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSession$1(Session session$1, Subscription subscription) {
        return subscription.session().getId().equals(session$1.getId());
    }

    public static final /* synthetic */ boolean $anonfun$removeSession$2(Session session$1, Subscription subscription) {
        return subscription.session().getId().equals(session$1.getId());
    }

    public static final /* synthetic */ boolean $anonfun$removeSession$3(Session session$1, SubscriptionWithFilter subscription) {
        return subscription.session().getId().equals(session$1.getId());
    }

    public static final /* synthetic */ boolean $anonfun$removeSession$4(Session session$1, Subscription subscription) {
        return subscription.session().getId().equals(session$1.getId());
    }

    private WebSocketAccountServerEndpoint$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.subscriptionCounter = new AtomicInteger(0);
        this.newHeadsSubscriptions = Nil$.MODULE$;
        this.newPendingTransactionsSubscriptions = Nil$.MODULE$;
        this.logsSubscriptions = Nil$.MODULE$;
        this.syncingSubscriptions = Nil$.MODULE$;
        this.webSocketAccountChannelImpl = new WebSocketAccountChannelImpl();
        this.walletAddresses = (Set)this.webSocketAccountChannelImpl().getWalletAddresses().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        this.cachedBlocksReceipts = Nil$.MODULE$;
        this.maxCachedBlockReceipts = 100;
    }
}

