/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import java.util.ArrayList;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import sparkz.util.serialization.Reader;

public class RlpStreamDecoder {
    public static int OFFSET_SHORT_STRING = 128;
    public static int OFFSET_LONG_STRING = 183;
    public static int OFFSET_SHORT_LIST = 192;
    public static int OFFSET_LONG_LIST = 247;

    public static RlpList decode(Reader reader) {
        RlpList rlpList = new RlpList(new ArrayList());
        if (reader != null) {
            RlpStreamDecoder.traverse(reader, -1, rlpList);
        }
        return rlpList;
    }

    private static void traverse(Reader reader, int levelBytesToRead, RlpList rlpList) {
        try {
            if (reader == null || reader.remaining() == 0) {
                return;
            }
            if (levelBytesToRead > reader.remaining()) {
                throw new RuntimeException("RLP invalid parameters while decoding");
            }
            int startLevelConsumedBytes = reader.consumed();
            while (reader.remaining() > 0) {
                int consumedBytes = reader.consumed();
                if (levelBytesToRead < 0 ? consumedBytes > startLevelConsumedBytes : startLevelConsumedBytes + levelBytesToRead == consumedBytes) {
                    return;
                }
                int prefix = reader.getUByte();
                if (prefix < OFFSET_SHORT_STRING) {
                    byte[] rlpData = new byte[]{(byte)prefix};
                    rlpList.getValues().add(RlpString.create((byte[])rlpData));
                    continue;
                }
                if (prefix == OFFSET_SHORT_STRING) {
                    rlpList.getValues().add(RlpString.create((byte[])new byte[0]));
                    continue;
                }
                if (prefix <= OFFSET_LONG_STRING) {
                    byte strLen = (byte)(prefix - OFFSET_SHORT_STRING);
                    if (reader.remaining() < strLen) {
                        throw new RuntimeException("RLP length mismatch: remaining bytes in stream reader: " + reader.remaining() + ", wanted: " + strLen);
                    }
                    byte[] rlpData = reader.getBytes((int)strLen);
                    if (strLen == 1 && (rlpData[0] & 0xFF) < OFFSET_SHORT_STRING) {
                        throw new RuntimeException("RLP bad encoding: 1 byte value not minimally encoded");
                    }
                    rlpList.getValues().add(RlpString.create((byte[])rlpData));
                    continue;
                }
                if (prefix < OFFSET_SHORT_LIST) {
                    byte lenOfStrLen = (byte)(prefix - OFFSET_LONG_STRING);
                    int strLen = RlpStreamDecoder.calcLength(lenOfStrLen, reader);
                    if (strLen < 56) {
                        throw new RuntimeException("RLP bad encoding: strlen is too small for this encoding: " + strLen);
                    }
                    if (reader.remaining() < strLen) {
                        throw new RuntimeException("RLP length mismatch: remaining bytes in stream reader: " + reader.remaining() + ", wanted: " + strLen);
                    }
                    byte[] rlpData = reader.getBytes(strLen);
                    rlpList.getValues().add(RlpString.create((byte[])rlpData));
                    continue;
                }
                if (prefix <= OFFSET_LONG_LIST) {
                    byte listLen = (byte)(prefix - OFFSET_SHORT_LIST);
                    RlpList newLevelList = new RlpList(new ArrayList());
                    RlpStreamDecoder.traverse(reader, listLen, newLevelList);
                    rlpList.getValues().add(newLevelList);
                    continue;
                }
                byte lenOfListLen = (byte)(prefix - OFFSET_LONG_LIST);
                int listLen = RlpStreamDecoder.calcLength(lenOfListLen, reader);
                if (listLen < 56) {
                    throw new RuntimeException("RLP bad encoding: strlen is too small for this encoding: " + listLen);
                }
                RlpList newLevelList = new RlpList(new ArrayList());
                RlpStreamDecoder.traverse(reader, listLen, newLevelList);
                rlpList.getValues().add(newLevelList);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("RLP wrong encoding at stream pos " + reader.position(), e);
        }
    }

    private static int calcLength(int lengthOfLength, Reader reader) {
        byte initialByteValue;
        byte pow = (byte)(lengthOfLength - 1);
        if (pow > 0 && (initialByteValue = reader.peekByte()) == 0) {
            throw new RuntimeException("RLP length encoding is not minimal");
        }
        long length = 0L;
        for (int i = 1; i <= lengthOfLength; ++i) {
            length += (long)reader.getUByte() << 8 * pow;
            pow = (byte)(pow - 1);
        }
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new RuntimeException("RLP too many bytes to decode");
        }
        return (int)length;
    }
}

