/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.history.AccountHistory;
import io.horizen.params.NetworkParams;
import io.horizen.utils.TimeToEpochUtils$;
import java.math.BigInteger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;

public final class FeeUtils$ {
    public static FeeUtils$ MODULE$;
    private final BigInteger INITIAL_BASE_FEE;

    static {
        new FeeUtils$();
    }

    public BigInteger INITIAL_BASE_FEE() {
        return this.INITIAL_BASE_FEE;
    }

    public BigInteger calculateBaseFee(AccountHistory history, String parentId) {
        String string = parentId;
        String string2 = history.params().sidechainGenesisBlockParentId();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.INITIAL_BASE_FEE();
        }
        return (BigInteger)history.modifierById(parentId).map((Function1 & java.io.Serializable & Serializable)x$1 -> MODULE$.calculateBaseFeeForBlock((AccountBlock)x$1, history.params())).getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.INITIAL_BASE_FEE());
    }

    public BigInteger calculateNextBaseFee(AccountBlock block, NetworkParams params) {
        return block == null ? this.INITIAL_BASE_FEE() : this.calculateBaseFeeForBlock(block, params);
    }

    private BigInteger calculateBaseFeeForBlock(AccountBlock block, NetworkParams params) {
        BigInteger bigInteger;
        AccountBlockHeader blockHeader = block.header();
        GasFeeFork feeFork = GasFeeFork$.MODULE$.get(TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params, blockHeader.timestamp()));
        BigInteger gasTarget = blockHeader.gasLimit().divide(feeFork.baseFeeElasticityMultiplier());
        if (blockHeader.gasUsed().equals(gasTarget)) {
            bigInteger = blockHeader.baseFee();
        } else {
            BigInteger gasDiff = blockHeader.gasUsed().subtract(gasTarget);
            BigInteger baseFeeDiff = gasDiff.abs().multiply(blockHeader.baseFee()).divide(gasTarget).divide(feeFork.baseFeeChangeDenominator());
            bigInteger = gasDiff.signum() == 1 ? blockHeader.baseFee().add(baseFeeDiff.max(BigInteger.ONE)) : blockHeader.baseFee().subtract(baseFeeDiff);
        }
        BigInteger nextBaseFee = bigInteger;
        return nextBaseFee.max(feeFork.baseFeeMinimum());
    }

    private FeeUtils$() {
        MODULE$ = this;
        this.INITIAL_BASE_FEE = BigInteger.valueOf(1000000000L);
    }
}

