/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import java.math.BigInteger;
import java.util.Arrays;

public class BigIntegerUInt256 {
    private static final int MAX_UINT256_BITS = 256;
    private final BigInteger bigInt;

    public BigIntegerUInt256(byte[] bytes) {
        if (bytes.length == 0) {
            this.bigInt = BigInteger.ZERO;
        } else {
            this.bigInt = new BigInteger(1, bytes);
            int size = this.bigInt.bitLength();
            if (size > 256) {
                throw new IllegalArgumentException(String.format("Bit size %d exceeds the limit of %d", size, 256));
            }
        }
    }

    public BigInteger getBigInt() {
        return this.bigInt;
    }

    public static byte[] getUnsignedByteArray(BigInteger bi) {
        byte[] barr = bi.toByteArray();
        if (barr[0] == 0) {
            return Arrays.copyOfRange(barr, 1, barr.length);
        }
        return barr;
    }
}

