/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.state.receipt.EthereumReceiptSerializer$;
import io.horizen.account.storage.AccountStateMetadataStorageReader;
import io.horizen.account.storage.AccountStateMetadataStorageView$;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountBlockFeeInfoSerializer$;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.block.SidechainBlockBase$;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.block.WithdrawalEpochCertificateSerializer$;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochInfoSerializer$;
import io.horizen.utils.package$;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001\u00020`\u0001!D\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011)\tI\u0001\u0001b\u0001\n\u0003\u0019\u00171\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u000e!Q\u00111\u0004\u0001C\u0002\u0013\u00051-a\u0003\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u001bA!\"a\b\u0001\u0005\u0004%\taYA\u0006\u0011!\t\t\u0003\u0001Q\u0001\n\u00055\u0001BCA\u0012\u0001\t\u0007I\u0011A2\u0002\f!A\u0011Q\u0005\u0001!\u0002\u0013\ti\u0001\u0003\u0006\u0002(\u0001\u0011\r\u0011\"\u0001d\u0003\u0017A\u0001\"!\u000b\u0001A\u0003%\u0011Q\u0002\u0005\u000b\u0003W\u0001!\u0019!C\u0001G\u0006-\u0001\u0002CA\u0017\u0001\u0001\u0006I!!\u0004\t\u0013\u0005=\u0002A1A\u0005\n\u0005E\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\r\t\u0015\u0005m\u0002\u00011A\u0005\u0002\r\fi\u0004\u0003\u0006\u0002L\u0001\u0001\r\u0011\"\u0001d\u0003\u001bB\u0001\"!\u0017\u0001A\u0003&\u0011q\b\u0005\u000b\u00037\u0002\u0001\u0019!C\u0001G\u0006u\u0003BCA4\u0001\u0001\u0007I\u0011A2\u0002j!A\u0011Q\u000e\u0001!B\u0013\ty\u0006\u0003\u0006\u0002p\u0001\u0001\r\u0011\"\u0001d\u0003cB!\"!!\u0001\u0001\u0004%\taYAB\u0011!\t9\t\u0001Q!\n\u0005M\u0004BCAE\u0001\u0001\u0007I\u0011A2\u0002\f\"Q\u0011q\u0012\u0001A\u0002\u0013\u00051-!%\t\u0011\u0005U\u0005\u0001)Q\u0005\u0003\u001bC!\"a&\u0001\u0001\u0004%\taYAM\u0011)\tI\f\u0001a\u0001\n\u0003\u0019\u00171\u0018\u0005\t\u0003\u007f\u0003\u0001\u0015)\u0003\u0002\u001c\"Q\u0011\u0011\u0019\u0001A\u0002\u0013\u00051-a1\t\u0015\u0005E\u0007\u00011A\u0005\u0002\r\f\u0019\u000e\u0003\u0005\u0002X\u0002\u0001\u000b\u0015BAc\u0011)\tI\u000e\u0001a\u0001\n\u0003\u0019\u00171\u001c\u0005\u000b\u0003w\u0004\u0001\u0019!C\u0001G\u0006u\b\u0002\u0003B\u0001\u0001\u0001\u0006K!!8\t\u0015\t\r\u0001\u00011A\u0005\u0002\r\u0014)\u0001\u0003\u0006\u0003\u0016\u0001\u0001\r\u0011\"\u0001d\u0005/A\u0001Ba\u0007\u0001A\u0003&!q\u0001\u0005\u000b\u0005;\u0001\u0001\u0019!C\u0001G\n}\u0001B\u0003B\"\u0001\u0001\u0007I\u0011A2\u0003F!A!\u0011\n\u0001!B\u0013\u0011\t\u0003\u0003\u0006\u0003L\u0001\u0001\r\u0011\"\u0001d\u0005\u001bB!B!\u0019\u0001\u0001\u0004%\ta\u0019B2\u0011!\u00119\u0007\u0001Q!\n\t=\u0003b\u0002B5\u0001\u0011\u0005#1\u000e\u0005\t\u0005[\u0002A\u0011A2\u0002^!9!q\u000e\u0001\u0005B\tE\u0004b\u0002B=\u0001\u0011\u0005#1\u0010\u0005\b\u0005\u0003\u0003A\u0011IAF\u0011!\u0011\u0019\t\u0001C\u0001G\u0006-\u0005b\u0002BC\u0001\u0011\u0005\u0013\u0011\u0014\u0005\t\u0005\u000f\u0003A\u0011A2\u0002\u001a\"A!\u0011\u0012\u0001\u0005\u0002\r\u0014Y\tC\u0004\u0003\u0010\u0002!\t%a7\t\u0011\tE\u0005\u0001\"\u0001d\u00037DqAa%\u0001\t\u0003\u0012)\nC\u0004\u0003\u0018\u0002!\t%!\r\t\u0011\te\u0005\u0001\"\u0001d\u0005\u000bAqAa'\u0001\t\u0003\u0012i\n\u0003\u0005\u0003 \u0002!\ta\u0019BQ\u0011\u001d\u0011I\u000b\u0001C!\u0005WCqAa,\u0001\t\u0003\u0011\t\fC\u0004\u00038\u0002!\tA!/\t\u000f\t}\u0006\u0001\"\u0001\u0003B\"9!Q\u0019\u0001\u0005\u0002\t\u001d\u0007b\u0002Bg\u0001\u0011\u0005!q\u001a\u0005\b\u0005+\u0004A\u0011\u0001Bl\u0011\u001d\u0011i\u000e\u0001C\u0001\u0005?DqA!:\u0001\t\u0003\u00119\u000fC\u0004\u0003n\u0002!\tAa<\t\u000f\tU\b\u0001\"\u0001\u0003N!9!q\u001f\u0001\u0005\u0002\te\bb\u0002B~\u0001\u0011\u0005!Q \u0005\b\u0005\u007f\u0004A\u0011AB\u0001\u0011!\u0019Y\u0002\u0001C\u0001G\nu\b\u0002CB\u000f\u0001\u0011\u00051ma\b\t\u000f\r\r\u0002\u0001\"\u0003\u0004&!91\u0011\u0006\u0001\u0005\u0002\r-\u0002\u0002CB\u0019\u0001\u0011\u00051ma\r\t\u0011\r]\u0002\u0001\"\u0001d\u0007sA\u0001b!\u0010\u0001\t\u0003\u00197q\b\u0005\t\u0007\u000f\u0002A\u0011A2\u0004J!Q1Q\n\u0001C\u0002\u0013\u00051-a\u0003\t\u0011\r=\u0003\u0001)A\u0005\u0003\u001bA!b!\u0015\u0001\u0005\u0004%\taYA\u0006\u0011!\u0019\u0019\u0006\u0001Q\u0001\n\u00055qaBB+?\"\u00051q\u000b\u0004\u0007=~C\ta!\u0017\t\u000f\u0005\u0005!\f\"\u0001\u0004\\!I1Q\f.C\u0002\u0013\u0005!Q\u0014\u0005\t\u0007?R\u0006\u0015!\u0003\u0003\n\ty\u0012iY2pk:$8\u000b^1uK6+G/\u00193bi\u0006\u001cFo\u001c:bO\u00164\u0016.Z<\u000b\u0005\u0001\f\u0017aB:u_J\fw-\u001a\u0006\u0003E\u000e\fq!Y2d_VtGO\u0003\u0002eK\u00069\u0001n\u001c:ju\u0016t'\"\u00014\u0002\u0005%|7\u0001A\n\u0005\u0001%|7\u000f\u0005\u0002k[6\t1NC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7N\u0001\u0004B]f\u0014VM\u001a\t\u0003aFl\u0011aX\u0005\u0003e~\u0013\u0011%Q2d_VtGo\u0015;bi\u0016lU\r^1eCR\f7\u000b^8sC\u001e,'+Z1eKJ\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\tU$\u0018\u000e\u001c\u0006\u0002q\u000611\u000f]1sWjL!A_;\u0003\u001bM\u0003\u0018M]6{\u0019><w-\u001b8h!\tah0D\u0001~\u0015\t\u00017-\u0003\u0002\u0000{\n91\u000b^8sC\u001e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003\u0002\u0006\u0005\u001d\u0001C\u00019\u0001\u0011\u0015\u0001'\u00011\u0001|\u0003=\u0019W-Y:j]\u001e\u001cF/\u0019;f\u0017\u0016LXCAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nG\u0006)Q\u000f^5mg&!\u0011qCA\t\u0005A\u0011\u0015\u0010^3BeJ\f\u0017p\u0016:baB,'/\u0001\tdK\u0006\u001c\u0018N\\4Ti\u0006$XmS3zA\u0005I\u0001.Z5hQR\\U-_\u0001\u000bQ\u0016Lw\r\u001b;LKf\u0004\u0013!H<ji\"$'/Y<bY\u0016\u0003xn\u00195J]\u001a|'/\\1uS>t7*Z=\u0002=]LG\u000f\u001b3sC^\fG.\u00129pG\"LeNZ8s[\u0006$\u0018n\u001c8LKf\u0004\u0013!E2p]N,gn];t\u000bB|7\r[&fs\u0006\u00112m\u001c8tK:\u001cXo]#q_\u000eD7*Z=!\u0003M\t7mY8v]R\u001cF/\u0019;f%>|GoS3z\u0003Q\t7mY8v]R\u001cF/\u0019;f%>|GoS3zA\u0005Q!-Y:f\r\u0016,7*Z=\u0002\u0017\t\f7/\u001a$fK.+\u0017\u0010I\u0001\u001dk:$WMZ5oK\u0012\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0007>,h\u000e^3s+\t\t\u0019\u0004E\u0002k\u0003kI1!a\u000el\u0005\rIe\u000e^\u0001\u001ek:$WMZ5oK\u0012\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0007>,h\u000e^3sA\u0005a\u0001.Y:DK\u0006\u001cX\rZ(qiV\u0011\u0011q\b\t\u0006U\u0006\u0005\u0013QI\u0005\u0004\u0003\u0007Z'AB(qi&|g\u000eE\u0002k\u0003\u000fJ1!!\u0013l\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0003[1t\u0007\u0016\f7/\u001a3PaR|F%Z9\u0015\t\u0005=\u0013Q\u000b\t\u0004U\u0006E\u0013bAA*W\n!QK\\5u\u0011%\t9FEA\u0001\u0002\u0004\ty$A\u0002yIE\nQ\u0002[1t\u0007\u0016\f7/\u001a3PaR\u0004\u0013AF<ji\"$'/Y<bY\u0016\u0003xn\u00195J]\u001a|w\n\u001d;\u0016\u0005\u0005}\u0003#\u00026\u0002B\u0005\u0005\u0004\u0003BA\b\u0003GJA!!\u001a\u0002\u0012\t\u0019r+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_\u0006Qr/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_>\u0003Ho\u0018\u0013fcR!\u0011qJA6\u0011%\t9&FA\u0001\u0002\u0004\ty&A\fxSRDGM]1xC2,\u0005o\\2i\u0013:4wn\u00149uA\u0005ABo\u001c9Rk\u0006d\u0017\u000e^=DKJ$\u0018NZ5dCR,w\n\u001d;\u0016\u0005\u0005M\u0004#\u00026\u0002B\u0005U\u0004\u0003BA<\u0003{j!!!\u001f\u000b\u0007\u0005m4-A\u0003cY>\u001c7.\u0003\u0003\u0002\u0000\u0005e$AG,ji\"$'/Y<bY\u0016\u0003xn\u00195DKJ$\u0018NZ5dCR,\u0017\u0001\b;paF+\u0018\r\\5us\u000e+'\u000f^5gS\u000e\fG/Z(qi~#S-\u001d\u000b\u0005\u0003\u001f\n)\tC\u0005\u0002Xa\t\t\u00111\u0001\u0002t\u0005IBo\u001c9Rk\u0006d\u0017\u000e^=DKJ$\u0018NZ5dCR,w\n\u001d;!\u0003\u0005b\u0017m\u001d;DKJ$\u0018NZ5dCR,'+\u001a4fe\u0016t7-\u001a3Fa>\u001c\u0007n\u00149u+\t\ti\tE\u0003k\u0003\u0003\n\u0019$A\u0013mCN$8)\u001a:uS\u001aL7-\u0019;f%\u00164WM]3oG\u0016$W\t]8dQ>\u0003Ho\u0018\u0013fcR!\u0011qJAJ\u0011%\t9fGA\u0001\u0002\u0004\ti)\u0001\u0012mCN$8)\u001a:uS\u001aL7-\u0019;f%\u00164WM]3oG\u0016$W\t]8dQ>\u0003H\u000fI\u0001#Y\u0006\u001cHoQ3si&4\u0017nY1uKNKG-Z2iC&t'\t\\8dW&#w\n\u001d;\u0016\u0005\u0005m\u0005#\u00026\u0002B\u0005u\u0005\u0003BAP\u0003gsA!!)\u00020:!\u00111UAW\u001d\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAUO\u00061AH]8pizJ\u0011\u0001_\u0005\u0003m^L1!!-v\u0003\u001d\u0001\u0018mY6bO\u0016LA!!.\u00028\nQQj\u001c3jM&,'/\u00133\u000b\u0007\u0005EV/\u0001\u0014mCN$8)\u001a:uS\u001aL7-\u0019;f'&$Wm\u00195bS:\u0014En\\2l\u0013\u0012|\u0005\u000f^0%KF$B!a\u0014\u0002>\"I\u0011q\u000b\u0010\u0002\u0002\u0003\u0007\u00111T\u0001$Y\u0006\u001cHoQ3si&4\u0017nY1uKNKG-Z2iC&t'\t\\8dW&#w\n\u001d;!\u0003=\u0011Gn\\2l\r\u0016,\u0017J\u001c4p\u001fB$XCAAc!\u0015Q\u0017\u0011IAd!\u0011\tI-!4\u000e\u0005\u0005-'bAA\nC&!\u0011qZAf\u0005M\t5mY8v]R\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0003M\u0011Gn\\2l\r\u0016,\u0017J\u001c4p\u001fB$x\fJ3r)\u0011\ty%!6\t\u0013\u0005]\u0013%!AA\u0002\u0005\u0015\u0017\u0001\u00052m_\u000e\\g)Z3J]\u001a|w\n\u001d;!\u0003E\u0019wN\\:f]N,8/\u00129pG\"|\u0005\u000f^\u000b\u0003\u0003;\u0004RA[A!\u0003?\u0004B!!9\u0002v:!\u00111]Ay\u001d\u0011\t)/!<\u000f\t\u0005\u001d\u00181\u001e\b\u0005\u0003K\u000bI/C\u0001g\u0013\t!W-C\u0002\u0002p\u000e\f\u0011bY8og\u0016t7/^:\n\t\u0005E\u00161\u001f\u0006\u0004\u0003_\u001c\u0017\u0002BA|\u0003s\u0014AcQ8og\u0016t7/^:Fa>\u001c\u0007NT;nE\u0016\u0014(\u0002BAY\u0003g\fQcY8og\u0016t7/^:Fa>\u001c\u0007n\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002P\u0005}\b\"CA,I\u0005\u0005\t\u0019AAo\u0003I\u0019wN\\:f]N,8/\u00129pG\"|\u0005\u000f\u001e\u0011\u0002'\u0005\u001c7m\\;oiN#\u0018\r^3S_>$x\n\u001d;\u0016\u0005\t\u001d\u0001#\u00026\u0002B\t%\u0001#\u00026\u0003\f\t=\u0011b\u0001B\u0007W\n)\u0011I\u001d:bsB\u0019!N!\u0005\n\u0007\tM1N\u0001\u0003CsR,\u0017aF1dG>,h\u000e^*uCR,'k\\8u\u001fB$x\fJ3r)\u0011\tyE!\u0007\t\u0013\u0005]s%!AA\u0002\t\u001d\u0011\u0001F1dG>,h\u000e^*uCR,'k\\8u\u001fB$\b%A\u0006sK\u000e,\u0017\u000e\u001d;t\u001fB$XC\u0001B\u0011!\u0015Q\u0017\u0011\tB\u0012!\u0019\u0011)C!\f\u000349!!q\u0005B\u0016\u001d\u0011\t)K!\u000b\n\u00031L1!!-l\u0013\u0011\u0011yC!\r\u0003\u0007M+\u0017OC\u0002\u00022.\u0004BA!\u000e\u0003@5\u0011!q\u0007\u0006\u0005\u0005s\u0011Y$A\u0004sK\u000e,\u0017\u000e\u001d;\u000b\u0007\tu\u0012-A\u0003ti\u0006$X-\u0003\u0003\u0003B\t]\"aD#uQ\u0016\u0014X-^7SK\u000e,\u0017\u000e\u001d;\u0002\u001fI,7-Z5qiN|\u0005\u000f^0%KF$B!a\u0014\u0003H!I\u0011q\u000b\u0016\u0002\u0002\u0003\u0007!\u0011E\u0001\re\u0016\u001cW-\u001b9ug>\u0003H\u000fI\u0001\u000f]\u0016DHOQ1tK\u001a+Wm\u00149u+\t\u0011y\u0005E\u0003k\u0003\u0003\u0012\t\u0006\u0005\u0003\u0003T\tuSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\t5\fG\u000f\u001b\u0006\u0003\u00057\nAA[1wC&!!q\fB+\u0005)\u0011\u0015nZ%oi\u0016<WM]\u0001\u0013]\u0016DHOQ1tK\u001a+Wm\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002P\t\u0015\u0004\"CA,[\u0005\u0005\t\u0019\u0001B(\u0003=qW\r\u001f;CCN,g)Z3PaR\u0004\u0013AF4fi^KG\u000f\u001b3sC^\fG.\u00129pG\"LeNZ8\u0016\u0005\u0005\u0005\u0014!I4fi^KG\u000f\u001b3sC^\fG.\u00129pG\"LeNZ8Ge>l7\u000b^8sC\u001e,\u0017AD4fi\u001a+W\rU1z[\u0016tGo\u001d\u000b\u0005\u0005g\u0012)\b\u0005\u0004\u0003&\t5\u0012q\u0019\u0005\b\u0005o\n\u0004\u0019AA\u001a\u0003U9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eDg*^7cKJ\f\u0001dZ3u)>\u0004\u0018+^1mSRL8)\u001a:uS\u001aL7-\u0019;f)\u0011\t\u0019H! \t\u000f\t}$\u00071\u0001\u00024\u0005I\"/\u001a4fe\u0016t7-\u001a3XSRDGM]1xC2,\u0005o\\2i\u0003ya\u0017m\u001d;DKJ$\u0018NZ5dCR,'+\u001a4fe\u0016t7-\u001a3Fa>\u001c\u0007.A\u0015mCN$8)\u001a:uS\u001aL7-\u0019;f%\u00164WM]3oG\u0016$W\t]8dQ\u001a\u0013x.\\*u_J\fw-Z\u0001 Y\u0006\u001cHoQ3si&4\u0017nY1uKNKG-Z2iC&t'\t\\8dW&#\u0017A\u000b7bgR\u001cUM\u001d;jM&\u001c\u0017\r^3TS\u0012,7\r[1j]\ncwnY6JI\u001a\u0013x.\\*u_J\fw-Z\u0001$O\u0016$Hk\u001c9Rk\u0006d\u0017\u000e^=DKJ$\u0018NZ5dCR,gI]8n'R|'/Y4f)\u0011\t\u0019H!$\t\u000f\t}t\u00071\u0001\u00024\u00059r-\u001a;D_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM]\u0001#O\u0016$8i\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJ4%o\\7Ti>\u0014\u0018mZ3\u0002\u0013!\f7oQ3bg\u0016$WCAA#\u0003%9W\r\u001e%fS\u001eDG/\u0001\u0010hKR\f5mY8v]R\u001cF/\u0019;f%>|GO\u0012:p[N#xN]1hK\u0006\u0019r-\u001a;BG\u000e|WO\u001c;Ti\u0006$XMU8piV\u0011!\u0011B\u0001!O\u0016$HK]1og\u0006\u001cG/[8o%\u0016\u001cW-\u001b9u\rJ|Wn\u0015;pe\u0006<W\r\u0006\u0003\u0003$\n\u0015\u0006#\u00026\u0002B\tM\u0002b\u0002BT}\u0001\u0007!\u0011B\u0001\u0007ibD\u0015m\u001d5\u0002+\u001d,G\u000f\u0016:b]N\f7\r^5p]J+7-Z5qiR!!1\u0015BW\u0011\u001d\u00119k\u0010a\u0001\u0005\u0013\t\u0011$\u001e9eCR,w+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_R!\u0011q\nBZ\u0011\u001d\u0011)\f\u0011a\u0001\u0003C\n1c^5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[%oM>\f1$\u001e9eCR,Gk\u001c9Rk\u0006d\u0017\u000e^=DKJ$\u0018NZ5dCR,G\u0003BA(\u0005wCqA!0B\u0001\u0004\t)(A\u000bu_B\fV/\u00197jif\u001cUM\u001d;jM&\u001c\u0017\r^3\u0002IU\u0004H-\u0019;f\u0019\u0006\u001cHoQ3si&4\u0017nY1uKJ+g-\u001a:f]\u000e,G-\u00129pG\"$B!a\u0014\u0003D\"9!\u0011\u0011\"A\u0002\u0005M\u0012\u0001K;qI\u0006$X\rT1ti\u000e+'\u000f^5gS\u000e\fG/Z*jI\u0016\u001c\u0007.Y5o\u00052|7m[%e\u001fB$H\u0003BA(\u0005\u0013DqAa3D\u0001\u0004\ti*A\u0004cY>\u001c7.\u00133\u00023U\u0004H-\u0019;f)J\fgn]1di&|gNU3dK&\u0004Ho\u001d\u000b\u0005\u0003\u001f\u0012\t\u000eC\u0004\u0003T\u0012\u0003\rAa\t\u0002\u0011I,7-Z5qiN\fA#\u001e9eCR,g)Z3QCflWM\u001c;J]\u001a|G\u0003BA(\u00053DqAa7F\u0001\u0004\t9-\u0001\u0007cY>\u001c7NR3f\u0013:4w.\u0001\u000eva\u0012\fG/Z\"p]N,gn];t\u000bB|7\r\u001b(v[\n,'\u000f\u0006\u0003\u0002P\t\u0005\bb\u0002Br\r\u0002\u0007\u0011q\\\u0001\u0012G>t7/\u001a8tkN,\u0005o\\2i\u001dVl\u0017AF;qI\u0006$X-Q2d_VtGo\u0015;bi\u0016\u0014vn\u001c;\u0015\t\u0005=#\u0011\u001e\u0005\b\u0005W<\u0005\u0019\u0001B\u0005\u0003A\t7mY8v]R\u001cF/\u0019;f%>|G/A\tva\u0012\fG/\u001a(fqR\u0014\u0015m]3GK\u0016$B!a\u0014\u0003r\"9!1\u001f%A\u0002\tE\u0013a\u00022bg\u00164U-Z\u0001\u001aO\u0016$h*\u001a=u\u0005\u0006\u001cXMR3f\rJ|Wn\u0015;pe\u0006<W-\u0001\bhKRtU\r\u001f;CCN,g)Z3\u0016\u0005\tE\u0013!C:fi\u000e+\u0017m]3e)\t\ty%\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003\u001f\u001a\u0019\u0001C\u0004\u0004\u00061\u0003\raa\u0002\u0002\u000fY,'o]5p]B!1\u0011BB\u000b\u001d\u0011\u0019Ya!\u0005\u000f\t\u0005\r6QB\u0005\u0004\u0007\u001f9\u0018\u0001B2pe\u0016LA!!-\u0004\u0014)\u00191qB<\n\t\r]1\u0011\u0004\u0002\u000b-\u0016\u00148/[8o)\u0006<'\u0002BAY\u0007'\tAb\u00197fC:,\u0006oQ1dQ\u0016\fQb]1wKR{7\u000b^8sC\u001e,G\u0003BA(\u0007CAqa!\u0002O\u0001\u0004\ti!\u0001\fhKR\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0007>,h\u000e^3s)\u0011\t\u0019da\n\t\u000f\t]t\n1\u0001\u00024\u0005a1-\u00197dk2\fG/Z&fsR!\u0011QBB\u0017\u0011\u001d\u0019y\u0003\u0015a\u0001\u0005\u0013\t1a[3z\u0003m9W\r\u001e+paF+\u0018\r\\5us\u000e+'\u000f^5gS\u000e\fG/Z&fsR!\u0011QBB\u001b\u0011\u001d\u0011y(\u0015a\u0001\u0003g\t\u0011dZ3u\u00052|7m\u001b$fK&sgm\\\"pk:$XM]&fsR!\u0011QBB\u001e\u0011\u001d\u00119H\u0015a\u0001\u0003g\t!cZ3u\u00052|7m\u001b$fK&sgm\\&fsR1\u0011QBB!\u0007\u0007BqAa\u001eT\u0001\u0004\t\u0019\u0004C\u0004\u0004FM\u0003\r!a\r\u0002\u000f\r|WO\u001c;fe\u0006iq-\u001a;SK\u000e,\u0017\u000e\u001d;LKf$B!!\u0004\u0004L!9!q\u0015+A\u0002\t%\u0011\u0001I4fi2\u000b7\u000f^\"feRLg-[2bi\u0016,\u0005o\\2i\u001dVl'-\u001a:LKf\f\u0011eZ3u\u0019\u0006\u001cHoQ3si&4\u0017nY1uK\u0016\u0003xn\u00195Ok6\u0014WM]&fs\u0002\n!\u0005\\1ti\u000e+'\u000f^5gS\u000e\fG/Z*jI\u0016\u001c\u0007.Y5o\u00052|7m[%e\u0017\u0016L\u0018a\t7bgR\u001cUM\u001d;jM&\u001c\u0017\r^3TS\u0012,7\r[1j]\ncwnY6JI.+\u0017\u0010I\u0001 \u0003\u000e\u001cw.\u001e8u'R\fG/Z'fi\u0006$\u0017\r^1Ti>\u0014\u0018mZ3WS\u0016<\bC\u00019['\tQ\u0016\u000e\u0006\u0002\u0004X\u0005QB)\u0012$B+2#v,Q\"D\u001fVsEkX*U\u0003R+uLU(P)\u0006YB)\u0012$B+2#v,Q\"D\u001fVsEkX*U\u0003R+uLU(P)\u0002\u0002")
public class AccountStateMetadataStorageView
implements AccountStateMetadataStorageReader,
SparkzLogging {
    private final Storage storage;
    private final ByteArrayWrapper ceasingStateKey;
    private final ByteArrayWrapper heightKey;
    private final ByteArrayWrapper withdrawalEpochInformationKey;
    private final ByteArrayWrapper consensusEpochKey;
    private final ByteArrayWrapper accountStateRootKey;
    private final ByteArrayWrapper baseFeeKey;
    private final int undefinedBlockFeeInfoCounter;
    private Option<Object> hasCeasedOpt;
    private Option<WithdrawalEpochInfo> withdrawalEpochInfoOpt;
    private Option<WithdrawalEpochCertificate> topQualityCertificateOpt;
    private Option<Object> lastCertificateReferencedEpochOpt;
    private Option<String> lastCertificateSidechainBlockIdOpt;
    private Option<AccountBlockFeeInfo> blockFeeInfoOpt;
    private Option<Object> consensusEpochOpt;
    private Option<byte[]> accountStateRootOpt;
    private Option<Seq<EthereumReceipt>> receiptsOpt;
    private Option<BigInteger> nextBaseFeeOpt;
    private final ByteArrayWrapper getLastCertificateEpochNumberKey;
    private final ByteArrayWrapper lastCertificateSidechainBlockIdKey;
    private final Logger logger;

    public static byte[] DEFAULT_ACCOUNT_STATE_ROOT() {
        return AccountStateMetadataStorageView$.MODULE$.DEFAULT_ACCOUNT_STATE_ROOT();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper ceasingStateKey() {
        return this.ceasingStateKey;
    }

    public ByteArrayWrapper heightKey() {
        return this.heightKey;
    }

    public ByteArrayWrapper withdrawalEpochInformationKey() {
        return this.withdrawalEpochInformationKey;
    }

    public ByteArrayWrapper consensusEpochKey() {
        return this.consensusEpochKey;
    }

    public ByteArrayWrapper accountStateRootKey() {
        return this.accountStateRootKey;
    }

    public ByteArrayWrapper baseFeeKey() {
        return this.baseFeeKey;
    }

    private int undefinedBlockFeeInfoCounter() {
        return this.undefinedBlockFeeInfoCounter;
    }

    public Option<Object> hasCeasedOpt() {
        return this.hasCeasedOpt;
    }

    public void hasCeasedOpt_$eq(Option<Object> x$1) {
        this.hasCeasedOpt = x$1;
    }

    public Option<WithdrawalEpochInfo> withdrawalEpochInfoOpt() {
        return this.withdrawalEpochInfoOpt;
    }

    public void withdrawalEpochInfoOpt_$eq(Option<WithdrawalEpochInfo> x$1) {
        this.withdrawalEpochInfoOpt = x$1;
    }

    public Option<WithdrawalEpochCertificate> topQualityCertificateOpt() {
        return this.topQualityCertificateOpt;
    }

    public void topQualityCertificateOpt_$eq(Option<WithdrawalEpochCertificate> x$1) {
        this.topQualityCertificateOpt = x$1;
    }

    public Option<Object> lastCertificateReferencedEpochOpt() {
        return this.lastCertificateReferencedEpochOpt;
    }

    public void lastCertificateReferencedEpochOpt_$eq(Option<Object> x$1) {
        this.lastCertificateReferencedEpochOpt = x$1;
    }

    public Option<String> lastCertificateSidechainBlockIdOpt() {
        return this.lastCertificateSidechainBlockIdOpt;
    }

    public void lastCertificateSidechainBlockIdOpt_$eq(Option<String> x$1) {
        this.lastCertificateSidechainBlockIdOpt = x$1;
    }

    public Option<AccountBlockFeeInfo> blockFeeInfoOpt() {
        return this.blockFeeInfoOpt;
    }

    public void blockFeeInfoOpt_$eq(Option<AccountBlockFeeInfo> x$1) {
        this.blockFeeInfoOpt = x$1;
    }

    public Option<Object> consensusEpochOpt() {
        return this.consensusEpochOpt;
    }

    public void consensusEpochOpt_$eq(Option<Object> x$1) {
        this.consensusEpochOpt = x$1;
    }

    public Option<byte[]> accountStateRootOpt() {
        return this.accountStateRootOpt;
    }

    public void accountStateRootOpt_$eq(Option<byte[]> x$1) {
        this.accountStateRootOpt = x$1;
    }

    public Option<Seq<EthereumReceipt>> receiptsOpt() {
        return this.receiptsOpt;
    }

    public void receiptsOpt_$eq(Option<Seq<EthereumReceipt>> x$1) {
        this.receiptsOpt = x$1;
    }

    public Option<BigInteger> nextBaseFeeOpt() {
        return this.nextBaseFeeOpt;
    }

    public void nextBaseFeeOpt_$eq(Option<BigInteger> x$1) {
        this.nextBaseFeeOpt = x$1;
    }

    @Override
    public WithdrawalEpochInfo getWithdrawalEpochInfo() {
        return (WithdrawalEpochInfo)this.withdrawalEpochInfoOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.getWithdrawalEpochInfoFromStorage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new WithdrawalEpochInfo(0, 0));
    }

    public Option<WithdrawalEpochInfo> getWithdrawalEpochInfoFromStorage() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.withdrawalEpochInformationKey())));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochInfo> try_ = WithdrawalEpochInfoSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochInfo withdrawalEpochInfo = (WithdrawalEpochInfo)success.value();
                option3 = Option$.MODULE$.apply((Object)withdrawalEpochInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch info information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<AccountBlockFeeInfo> getFeePayments(int withdrawalEpochNumber) {
        void var2_2;
        block0: {
            ListBuffer blockFees = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            int lastCounter = this.getBlockFeeInfoCounter(withdrawalEpochNumber);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
                Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getBlockFeeInfoKey(withdrawalEpochNumber, counter))));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                    Try<AccountBlockFeeInfo> try_ = AccountBlockFeeInfoSerializer$.MODULE$.parseBytesTry(baw.data());
                    if (!(try_ instanceof Success)) {
                        if (try_ instanceof Failure) {
                            BoxedUnit boxedUnit;
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            if (this.log().underlying().isErrorEnabled()) {
                                this.log().underlying().error("Error while fee payment parsing.", exception);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            throw new IllegalStateException("Error while fee payment parsing.", exception);
                        }
                        throw new MatchError(try_);
                    }
                    Success success = (Success)try_;
                    AccountBlockFeeInfo info = (AccountBlockFeeInfo)success.value();
                    blockFees.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccountBlockFeeInfo[]{info}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error("Error while fee payments retrieving: record expected to exist for epoch {} and counter {}", new Object[]{BoxesRunTime.boxToInteger((int)withdrawalEpochNumber), BoxesRunTime.boxToInteger((int)counter)});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new IllegalStateException("Error while fee payments retrieving: record expected to exist.");
                    }
                    throw new MatchError((Object)option);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
            if (this.getWithdrawalEpochInfo().epoch() != withdrawalEpochNumber) break block0;
            this.blockFeeInfoOpt().foreach((Function1 & Serializable & scala.Serializable)blockFeeInfo -> {
                blockFees.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccountBlockFeeInfo[]{blockFeeInfo}));
                return BoxedUnit.UNIT;
            });
        }
        return var2_2;
    }

    @Override
    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        Some some;
        WithdrawalEpochCertificate certificate;
        Option<WithdrawalEpochCertificate> option = this.topQualityCertificateOpt();
        Option<WithdrawalEpochCertificate> option2 = option instanceof Some && (certificate = (WithdrawalEpochCertificate)(some = (Some)option).value()).epochNumber() == referencedWithdrawalEpoch ? this.topQualityCertificateOpt() : this.getTopQualityCertificateFromStorage(referencedWithdrawalEpoch);
        return option2;
    }

    @Override
    public Option<Object> lastCertificateReferencedEpoch() {
        return this.lastCertificateReferencedEpochOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.lastCertificateReferencedEpochFromStorage());
    }

    public Option<Object> lastCertificateReferencedEpochFromStorage() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getLastCertificateEpochNumberKey()))).flatMap((Function1 & Serializable & scala.Serializable)baw -> {
            Some some;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int epoch = BoxesRunTime.unboxToInt((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToInteger((int)epoch));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while last certificate referenced epoch parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            return some;
        });
    }

    @Override
    public Option<String> lastCertificateSidechainBlockId() {
        return this.lastCertificateSidechainBlockIdOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.lastCertificateSidechainBlockIdFromStorage());
    }

    public Option<String> lastCertificateSidechainBlockIdFromStorage() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.lastCertificateSidechainBlockIdKey()))).flatMap((Function1 & Serializable & scala.Serializable)baw -> {
            Some some;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sparkz.util.package$.MODULE$.bytesToId(baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String blockId = (String)success.value();
                some = new Some((Object)blockId);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while last certificate sidechain block id parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            return some;
        });
    }

    public Option<WithdrawalEpochCertificate> getTopQualityCertificateFromStorage(int referencedWithdrawalEpoch) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getTopQualityCertificateKey(referencedWithdrawalEpoch))));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochCertificate> try_ = WithdrawalEpochCertificateSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochCertificate certificate = (WithdrawalEpochCertificate)success.value();
                option3 = Option$.MODULE$.apply((Object)certificate);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch certificate information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    @Override
    public Option<Object> getConsensusEpochNumber() {
        return this.consensusEpochOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.getConsensusEpochNumberFromStorage());
    }

    public Option<Object> getConsensusEpochNumberFromStorage() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.consensusEpochKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int epoch = BoxesRunTime.unboxToInt((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToInteger((int)io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(epoch)));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while consensus epoch information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    @Override
    public boolean hasCeased() {
        return BoxesRunTime.unboxToBoolean((Object)this.hasCeasedOpt().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.storage.get(this.ceasingStateKey()).isPresent()));
    }

    @Override
    public int getHeight() {
        return BoxesRunTime.unboxToInt((Object)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.heightKey()))).map((Function1 & Serializable & scala.Serializable)baw -> BoxesRunTime.boxToInteger((int)AccountStateMetadataStorageView.$anonfun$getHeight$1(baw))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public Option<byte[]> getAccountStateRootFromStorage() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.accountStateRootKey()))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    @Override
    public byte[] getAccountStateRoot() {
        return (byte[])this.accountStateRootOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.getAccountStateRootFromStorage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AccountStateMetadataStorageView$.MODULE$.DEFAULT_ACCOUNT_STATE_ROOT());
    }

    public Option<EthereumReceipt> getTransactionReceiptFromStorage(byte[] txHash) {
        None$ none$;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getReceiptKey(txHash))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper serData = (ByteArrayWrapper)some.value();
            EthereumReceipt decodedReceipt = (EthereumReceipt)EthereumReceiptSerializer$.MODULE$.parseBytes(package$.MODULE$.wrapperToByteArray(serData));
            none$ = new Some((Object)decodedReceipt);
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public Option<EthereumReceipt> getTransactionReceipt(byte[] txHash) {
        Option option;
        ByteArrayWrapper bawTxHash = new ByteArrayWrapper(txHash);
        Option<Seq<EthereumReceipt>> option2 = this.receiptsOpt();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Seq receipts = (Seq)some.value();
            option = receipts.find((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)AccountStateMetadataStorageView.$anonfun$getTransactionReceipt$1(bawTxHash, r)));
        } else if (None$.MODULE$.equals(option2)) {
            option = this.getTransactionReceiptFromStorage(txHash);
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public void updateWithdrawalEpochInfo(WithdrawalEpochInfo withdrawalEpochInfo) {
        this.withdrawalEpochInfoOpt_$eq((Option<WithdrawalEpochInfo>)new Some((Object)withdrawalEpochInfo));
    }

    public void updateTopQualityCertificate(WithdrawalEpochCertificate topQualityCertificate) {
        this.topQualityCertificateOpt_$eq((Option<WithdrawalEpochCertificate>)new Some((Object)topQualityCertificate));
    }

    public void updateLastCertificateReferencedEpoch(int lastCertificateReferencedEpoch) {
        this.lastCertificateReferencedEpochOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)lastCertificateReferencedEpoch)));
    }

    public void updateLastCertificateSidechainBlockIdOpt(String blockId) {
        this.lastCertificateSidechainBlockIdOpt_$eq((Option<String>)new Some((Object)blockId));
    }

    public void updateTransactionReceipts(Seq<EthereumReceipt> receipts) {
        this.receiptsOpt_$eq((Option<Seq<EthereumReceipt>>)new Some(receipts));
    }

    public void updateFeePaymentInfo(AccountBlockFeeInfo blockFeeInfo) {
        this.blockFeeInfoOpt_$eq((Option<AccountBlockFeeInfo>)new Some((Object)blockFeeInfo));
    }

    public void updateConsensusEpochNumber(int consensusEpochNum) {
        this.consensusEpochOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)consensusEpochNum)));
    }

    public void updateAccountStateRoot(byte[] accountStateRoot) {
        this.accountStateRootOpt_$eq((Option<byte[]>)new Some((Object)accountStateRoot));
    }

    public void updateNextBaseFee(BigInteger baseFee) {
        this.nextBaseFeeOpt_$eq((Option<BigInteger>)new Some((Object)baseFee));
    }

    public Option<BigInteger> getNextBaseFeeFromStorage() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.baseFeeKey()))).map((Function1 & Serializable & scala.Serializable)wrapper -> new BigInteger(wrapper.data()));
    }

    public BigInteger getNextBaseFee() {
        return (BigInteger)this.nextBaseFeeOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.getNextBaseFeeFromStorage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> FeeUtils$.MODULE$.INITIAL_BASE_FEE());
    }

    public void setCeased() {
        this.hasCeasedOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public void commit(String version) {
        Try result = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.saveToStorage(package$.MODULE$.byteArrayToWrapper(sparkz.core.package$.MODULE$.versionToBytes(version))));
        this.cleanUpCache();
        Try try_ = result;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(78).append("Error while committing metadata for version ").append(version).append(". The modifications won't be saved").toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void cleanUpCache() {
        this.hasCeasedOpt_$eq((Option<Object>)None$.MODULE$);
        this.withdrawalEpochInfoOpt_$eq((Option<WithdrawalEpochInfo>)None$.MODULE$);
        this.topQualityCertificateOpt_$eq((Option<WithdrawalEpochCertificate>)None$.MODULE$);
        this.lastCertificateReferencedEpochOpt_$eq((Option<Object>)None$.MODULE$);
        this.lastCertificateSidechainBlockIdOpt_$eq((Option<String>)None$.MODULE$);
        this.blockFeeInfoOpt_$eq((Option<AccountBlockFeeInfo>)None$.MODULE$);
        this.consensusEpochOpt_$eq((Option<Object>)None$.MODULE$);
        this.accountStateRootOpt_$eq((Option<byte[]>)None$.MODULE$);
        this.receiptsOpt_$eq((Option<Seq<EthereumReceipt>>)None$.MODULE$);
        this.nextBaseFeeOpt_$eq((Option<BigInteger>)None$.MODULE$);
    }

    public void saveToStorage(ByteArrayWrapper version) {
        BoxedUnit boxedUnit;
        Object object;
        Predef$.MODULE$.require(this.accountStateRootOpt().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Account State Root must be NOT NULL.");
        ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
        ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
        this.withdrawalEpochInfoOpt().foreach((Function1 & Serializable & scala.Serializable)epochInfo -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.withdrawalEpochInformationKey(), new ByteArrayWrapper(WithdrawalEpochInfoSerializer$.MODULE$.toBytes(epochInfo))))));
        this.topQualityCertificateOpt().foreach((Function1 & Serializable & scala.Serializable)certificate -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getTopQualityCertificateKey(certificate.epochNumber()), package$.MODULE$.byteArrayToWrapper(WithdrawalEpochCertificateSerializer$.MODULE$.toBytes(certificate))))));
        this.lastCertificateReferencedEpochOpt().foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)epoch -> updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getLastCertificateEpochNumberKey(), package$.MODULE$.byteArrayToWrapper(Ints.toByteArray((int)epoch)))));
        this.lastCertificateSidechainBlockIdOpt().foreach((Function1 & Serializable & scala.Serializable)blockId -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.lastCertificateSidechainBlockIdKey(), package$.MODULE$.byteArrayToWrapper(sparkz.util.package$.MODULE$.idToBytes(blockId))))));
        this.blockFeeInfoOpt().foreach((Function1 & Serializable & scala.Serializable)feeInfo -> BoxesRunTime.boxToBoolean((boolean)AccountStateMetadataStorageView.$anonfun$saveToStorage$6(this, updateList, feeInfo)));
        this.consensusEpochOpt().foreach((Function1 & Serializable & scala.Serializable)currConsensusEpoch -> AccountStateMetadataStorageView.$anonfun$saveToStorage$8(this, updateList, BoxesRunTime.unboxToInt((Object)currConsensusEpoch)));
        updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.accountStateRootKey(), new ByteArrayWrapper((byte[])this.accountStateRootOpt().get())));
        this.hasCeasedOpt().foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.ceasingStateKey(), new ByteArrayWrapper(Array$.MODULE$.emptyByteArray())))));
        if (!version.equals(new ByteArrayWrapper(SidechainBlockBase$.MODULE$.GENESIS_BLOCK_PARENT_ID()))) {
            int nextHeight = this.getHeight() + 1;
            object = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.heightKey(), new ByteArrayWrapper(Ints.toByteArray((int)nextHeight)))));
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<WithdrawalEpochInfo> option = this.withdrawalEpochInfoOpt();
        if (option instanceof Some) {
            Object object2;
            Some some;
            WithdrawalEpochInfo storedEpochInfo;
            Some some2 = (Some)option;
            WithdrawalEpochInfo epochInfo2 = (WithdrawalEpochInfo)some2.value();
            Option<WithdrawalEpochInfo> option2 = this.getWithdrawalEpochInfoFromStorage();
            boolean bl = option2 instanceof Some ? (storedEpochInfo = (WithdrawalEpochInfo)(some = (Some)option2).value()).epoch() != epochInfo2.epoch() : false;
            boolean isWithdrawalEpochSwitched = bl;
            if (isWithdrawalEpochSwitched) {
                int certEpochNumberToRemove = epochInfo2.epoch() - 4;
                removeList.add(this.getTopQualityCertificateKey(certEpochNumberToRemove));
                int blockFeeInfoEpochToRemove = epochInfo2.epoch() - 1;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getBlockFeeInfoCounter(blockFeeInfoEpochToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getBlockFeeInfoKey(blockFeeInfoEpochToRemove, counter)));
                object2 = BoxesRunTime.boxToBoolean((boolean)removeList.add(this.getBlockFeeInfoCounterKey(blockFeeInfoEpochToRemove)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            boxedUnit = object2;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.receiptsOpt().foreach((Function1 & Serializable & scala.Serializable)receipts -> {
            receipts.foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)AccountStateMetadataStorageView.$anonfun$saveToStorage$13($this, updateList$1, r)));
            return BoxedUnit.UNIT;
        });
        this.nextBaseFeeOpt().foreach((Function1 & Serializable & scala.Serializable)baseFee -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.baseFeeKey(), new ByteArrayWrapper(baseFee.toByteArray())))));
        this.storage.update(version, updateList, removeList);
    }

    private int getBlockFeeInfoCounter(int withdrawalEpochNumber) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getBlockFeeInfoCounterKey(withdrawalEpochNumber))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedBlockFeeInfoCounter()));
        } else {
            n = this.undefinedBlockFeeInfoCounter();
        }
        return n;
    }

    public ByteArrayWrapper calculateKey(byte[] key) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.hash(key));
    }

    public ByteArrayWrapper getTopQualityCertificateKey(int referencedWithdrawalEpoch) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"topQualityCertificate".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)referencedWithdrawalEpoch)}));
    }

    public ByteArrayWrapper getBlockFeeInfoCounterKey(int withdrawalEpochNumber) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfoCounter".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpochNumber)}));
    }

    public ByteArrayWrapper getBlockFeeInfoKey(int withdrawalEpochNumber, int counter) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfo".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpochNumber), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getReceiptKey(byte[] txHash) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"receipt".getBytes(StandardCharsets.UTF_8), txHash}));
    }

    public ByteArrayWrapper getLastCertificateEpochNumberKey() {
        return this.getLastCertificateEpochNumberKey;
    }

    public ByteArrayWrapper lastCertificateSidechainBlockIdKey() {
        return this.lastCertificateSidechainBlockIdKey;
    }

    public static final /* synthetic */ int $anonfun$getHeight$1(ByteArrayWrapper baw) {
        return Ints.fromByteArray((byte[])baw.data());
    }

    public static final /* synthetic */ boolean $anonfun$getTransactionReceipt$1(ByteArrayWrapper bawTxHash$1, EthereumReceipt r) {
        ByteArrayWrapper byteArrayWrapper = new ByteArrayWrapper(r.transactionHash());
        ByteArrayWrapper byteArrayWrapper2 = bawTxHash$1;
        return !(byteArrayWrapper != null ? !((Object)byteArrayWrapper).equals(byteArrayWrapper2) : byteArrayWrapper2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$saveToStorage$6(AccountStateMetadataStorageView $this, ArrayList updateList$1, AccountBlockFeeInfo feeInfo) {
        WithdrawalEpochInfo epochInfo = (WithdrawalEpochInfo)$this.withdrawalEpochInfoOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.getWithdrawalEpochInfo());
        int nextBlockFeeInfoCounter = $this.getBlockFeeInfoCounter(epochInfo.epoch()) + 1;
        updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.getBlockFeeInfoCounterKey(epochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextBlockFeeInfoCounter))));
        return updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.getBlockFeeInfoKey(epochInfo.epoch(), nextBlockFeeInfoCounter), new ByteArrayWrapper(AccountBlockFeeInfoSerializer$.MODULE$.toBytes(feeInfo))));
    }

    public static final /* synthetic */ Object $anonfun$saveToStorage$8(AccountStateMetadataStorageView $this, ArrayList updateList$1, int currConsensusEpoch) {
        return BoxesRunTime.unboxToInt((Object)$this.getConsensusEpochNumberFromStorage().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(0))) != currConsensusEpoch ? BoxesRunTime.boxToBoolean((boolean)updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.consensusEpochKey(), new ByteArrayWrapper(Ints.toByteArray((int)currConsensusEpoch))))) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$saveToStorage$13(AccountStateMetadataStorageView $this, ArrayList updateList$1, EthereumReceipt r) {
        ByteArrayWrapper key = $this.getReceiptKey(r.transactionHash());
        ByteArrayWrapper value = new ByteArrayWrapper(EthereumReceiptSerializer$.MODULE$.toBytes(r));
        return updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, value));
    }

    public AccountStateMetadataStorageView(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.ceasingStateKey = this.calculateKey("ceasingStateKey".getBytes(StandardCharsets.UTF_8));
        this.heightKey = this.calculateKey("heightKey".getBytes(StandardCharsets.UTF_8));
        this.withdrawalEpochInformationKey = this.calculateKey("withdrawalEpochInformation".getBytes(StandardCharsets.UTF_8));
        this.consensusEpochKey = this.calculateKey("consensusEpoch".getBytes(StandardCharsets.UTF_8));
        this.accountStateRootKey = this.calculateKey("accountStateRoot".getBytes(StandardCharsets.UTF_8));
        this.baseFeeKey = this.calculateKey("baseFee".getBytes(StandardCharsets.UTF_8));
        this.undefinedBlockFeeInfoCounter = -1;
        this.hasCeasedOpt = None$.MODULE$;
        this.withdrawalEpochInfoOpt = None$.MODULE$;
        this.topQualityCertificateOpt = None$.MODULE$;
        this.lastCertificateReferencedEpochOpt = None$.MODULE$;
        this.lastCertificateSidechainBlockIdOpt = None$.MODULE$;
        this.blockFeeInfoOpt = None$.MODULE$;
        this.consensusEpochOpt = None$.MODULE$;
        this.accountStateRootOpt = None$.MODULE$;
        this.receiptsOpt = None$.MODULE$;
        this.nextBaseFeeOpt = None$.MODULE$;
        this.getLastCertificateEpochNumberKey = this.calculateKey("lastCertificateEpochNumber".getBytes(StandardCharsets.UTF_8));
        this.lastCertificateSidechainBlockIdKey = this.calculateKey("lastCertificateSidechainBlockId".getBytes(StandardCharsets.UTF_8));
    }
}

