/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.OutOfGasException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.evm.StateDB;
import java.math.BigInteger;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u000b\u0017\u0001}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!AQ\b\u0001B\u0001B\u0003%a\bC\u0003B\u0001\u0011\u0005!\tC\u0003H\u0001\u0011%\u0001\nC\u0003[\u0001\u0011%1\fC\u0003g\u0001\u0011%q\rC\u0003r\u0001\u0011\u0005#\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003|\u0001\u0011\u0005C\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!!\n\u0001\t\u0003\n9\u0003C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\ty\u0006\u0001C!\u0003C\u0012\u0011e\u0015;bi\u0016$%-Q2d_VtGo\u0015;bi\u00164\u0016.Z<HCN$&/Y2lK\u0012T!a\u0006\r\u0002\u000bM$\u0018\r^3\u000b\u0005eQ\u0012aB1dG>,h\u000e\u001e\u0006\u00037q\tq\u0001[8sSj,gNC\u0001\u001e\u0003\tIwn\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011#\u001b\u00051\u0012BA\u0012\u0017\u0005]\u0019F/\u0019;f\t\n\f5mY8v]R\u001cF/\u0019;f-&,w/A\u0004ti\u0006$X\r\u00122\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!R\u0012aA3w[&\u0011!f\n\u0002\b'R\fG/\u001a#C\u0003EiWm]:bO\u0016\u0004&o\\2fgN|'o\u001d\t\u0004[]RdB\u0001\u00185\u001d\ty#'D\u00011\u0015\t\td$\u0001\u0004=e>|GOP\u0005\u0002g\u0005)1oY1mC&\u0011QGN\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0019\u0014B\u0001\u001d:\u0005\r\u0019V-\u001d\u0006\u0003kY\u0002\"!I\u001e\n\u0005q2\"\u0001E'fgN\fw-\u001a)s_\u000e,7o]8s\u0003\r9\u0017m\u001d\t\u0003C}J!\u0001\u0011\f\u0003\u000f\u001d\u000b7\u000fU8pY\u00061A(\u001b8jiz\"Ba\u0011#F\rB\u0011\u0011\u0005\u0001\u0005\u0006I\u0011\u0001\r!\n\u0005\u0006W\u0011\u0001\r\u0001\f\u0005\u0006{\u0011\u0001\rAP\u0001\u000eC\u000e\u001cw.\u001e8u\u0003\u000e\u001cWm]:\u0015\u0005%k\u0005C\u0001&L\u001b\u00051\u0014B\u0001'7\u0005\u0011)f.\u001b;\t\u000b9+\u0001\u0019A(\u0002\u000f\u0005$GM]3tgB\u0011a\u0005U\u0005\u0003#\u001e\u0012q!\u00113ee\u0016\u001c8\u000fK\u0002\u0006'f\u00032A\u0013+W\u0013\t)fG\u0001\u0004uQJ|wo\u001d\t\u0003C]K!\u0001\u0017\f\u0003#=+Ho\u00144HCN,\u0005pY3qi&|gnI\u0001W\u00035\u0019Ho\u001c:bO\u0016\f5mY3tgR\u0019\u0011\nX/\t\u000b93\u0001\u0019A(\t\u000by3\u0001\u0019A0\u0002\tMdw\u000e\u001e\t\u0004\u0015\u0002\u0014\u0017BA17\u0005\u0015\t%O]1z!\tQ5-\u0003\u0002em\t!!)\u001f;fQ\r11+W\u0001\u0013gR|'/Y4f/JLG/Z!dG\u0016\u001c8\u000f\u0006\u0003JQ&t\u0007\"\u0002(\b\u0001\u0004y\u0005\"\u00026\b\u0001\u0004Y\u0017aA6fsB\u0011a\u0005\\\u0005\u0003[\u001e\u0012A\u0001S1tQ\")qn\u0002a\u0001W\u0006)a/\u00197vK\"\u001aqaU-\u0002\u001b\u0005\u001c7m\\;oi\u0016C\u0018n\u001d;t)\t\u0019h\u000f\u0005\u0002Ki&\u0011QO\u000e\u0002\b\u0005>|G.Z1o\u0011\u0015q\u0005\u00021\u0001P\u00031I7/R8b\u0003\u000e\u001cw.\u001e8u)\t\u0019\u0018\u0010C\u0003O\u0013\u0001\u0007q\nK\u0002\n'f\u000ba#[:T[\u0006\u0014HoQ8oiJ\f7\r^!dG>,h\u000e\u001e\u000b\u0003gvDQA\u0014\u0006A\u0002=C3AC*Z\u0003-9W\r^\"pI\u0016D\u0015m\u001d5\u0015\u0007}\u000b\u0019\u0001C\u0003O\u0017\u0001\u0007q\nK\u0002\f'f\u000bqaZ3u\u0007>$W\rF\u0002`\u0003\u0017AQA\u0014\u0007A\u0002=C3\u0001D*Z\u0003!9W\r\u001e(p]\u000e,G\u0003BA\n\u0003G\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003nCRD'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\u000b\u0005&<\u0017J\u001c;fO\u0016\u0014\b\"\u0002(\u000e\u0001\u0004y\u0015!D5oGJ,\u0017m]3O_:\u001cW\rF\u0002J\u0003SAQA\u0014\bA\u0002=\u000b!bZ3u\u0005\u0006d\u0017M\\2f)\u0011\t\u0019\"a\f\t\u000b9{\u0001\u0019A()\u0007=\u0019\u0016,\u0001\u0006bI\u0012\u0014\u0015\r\\1oG\u0016$R!SA\u001c\u0003sAQA\u0014\tA\u0002=Cq!a\u000f\u0011\u0001\u0004\t\u0019\"\u0001\u0004b[>,h\u000e\u001e\u0015\u0004!MK\u0016AC:vE\n\u000bG.\u00198dKR)\u0011*a\u0011\u0002F!)a*\u0005a\u0001\u001f\"9\u00111H\tA\u0002\u0005M\u0001fA\tT3\u0006\tr-\u001a;BG\u000e|WO\u001c;Ti>\u0014\u0018mZ3\u0015\u000b}\u000bi%a\u0014\t\u000b9\u0013\u0002\u0019A(\t\u000b)\u0014\u0002\u0019A0)\u0007I\u0019\u0016,\u0001\u000bva\u0012\fG/Z!dG>,h\u000e^*u_J\fw-\u001a\u000b\b\u0013\u0006]\u0013\u0011LA.\u0011\u0015q5\u00031\u0001P\u0011\u0015Q7\u00031\u0001`\u0011\u0015y7\u00031\u0001`Q\r\u00192+W\u0001\u0007C\u0012$Gj\\4\u0015\u0007%\u000b\u0019\u0007C\u0004\u0002fQ\u0001\r!a\u001a\u0002\u00071|w\r\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\tiGF\u0001\be\u0016\u001cW-\u001b9u\u0013\u0011\t\t(a\u001b\u00031\u0015#\b.\u001a:fk6\u001cuN\\:f]N,8\u000fR1uC2{w\rK\u0002\u0015'f\u0003")
public class StateDbAccountStateViewGasTracked
extends StateDbAccountStateView {
    private final StateDB stateDb;
    private final GasPool gas;

    private void accountAccess(Address address) throws OutOfGasException {
        boolean warm = this.stateDb.accessAccount(address);
        this.gas.subGas(warm ? GasUtil$.MODULE$.WarmStorageReadCostEIP2929() : GasUtil$.MODULE$.ColdAccountAccessCostEIP2929());
    }

    private void storageAccess(Address address, byte[] slot) throws OutOfGasException {
        boolean warm = this.stateDb.accessSlot(address, new Hash(slot));
        this.gas.subGas(warm ? GasUtil$.MODULE$.WarmStorageReadCostEIP2929() : GasUtil$.MODULE$.ColdSloadCostEIP2929());
    }

    private void storageWriteAccess(Address address, Hash key, Hash value) throws OutOfGasException {
        BigInteger bigInteger;
        Hash current;
        if (this.gas.getGas().compareTo(GasUtil$.MODULE$.SstoreSentryGasEIP2200()) <= 0) {
            throw new OutOfGasException("account storage write gas sentry fail");
        }
        if (!this.stateDb.accessSlot(address, key)) {
            this.gas.subGas(GasUtil$.MODULE$.ColdSloadCostEIP2929());
        }
        if (value.equals((Object)(current = this.stateDb.getStorage(address, key)))) {
            bigInteger = GasUtil$.MODULE$.WarmStorageReadCostEIP2929();
        } else {
            Hash original = this.stateDb.getCommittedStorage(address, key);
            if (original.equals((Object)current)) {
                if (original.equals((Object)Hash.ZERO)) {
                    bigInteger = GasUtil$.MODULE$.SstoreSetGasEIP2200();
                } else {
                    if (value.equals((Object)Hash.ZERO)) {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreClearsScheduleRefundEIP3529());
                    }
                    bigInteger = GasUtil$.MODULE$.SstoreResetGasEIP2200().subtract(GasUtil$.MODULE$.ColdSloadCostEIP2929());
                }
            } else {
                if (!original.equals((Object)Hash.ZERO)) {
                    if (current.equals((Object)Hash.ZERO)) {
                        this.stateDb.subRefund(GasUtil$.MODULE$.SstoreClearsScheduleRefundEIP3529());
                    } else if (value.equals((Object)Hash.ZERO)) {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreClearsScheduleRefundEIP3529());
                    }
                }
                if (original.equals((Object)value)) {
                    if (original.equals((Object)Hash.ZERO)) {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreSetGasEIP2200().subtract(GasUtil$.MODULE$.WarmStorageReadCostEIP2929()));
                    } else {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreResetGasEIP2200().subtract(GasUtil$.MODULE$.ColdSloadCostEIP2929()).subtract(GasUtil$.MODULE$.WarmStorageReadCostEIP2929()));
                    }
                }
                bigInteger = GasUtil$.MODULE$.WarmStorageReadCostEIP2929();
            }
        }
        BigInteger writeGasCost = bigInteger;
        this.gas.subGas(writeGasCost);
    }

    @Override
    public boolean accountExists(Address address) {
        this.accountAccess(address);
        return super.accountExists(address);
    }

    @Override
    public boolean isEoaAccount(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.isEoaAccount(address);
    }

    @Override
    public boolean isSmartContractAccount(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.isSmartContractAccount(address);
    }

    @Override
    public byte[] getCodeHash(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.getCodeHash(address);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getCode(Address address) throws OutOfGasException {
        void var2_2;
        block0: {
            this.accountAccess(address);
            byte[] code = super.getCode(address);
            if (code == null) break block0;
            this.gas.subGas(GasUtil$.MODULE$.codeCopy(code.length));
        }
        return var2_2;
    }

    @Override
    public BigInteger getNonce(Address address) {
        this.accountAccess(address);
        return super.getNonce(address);
    }

    @Override
    public void increaseNonce(Address address) {
        this.accountAccess(address);
        super.increaseNonce(address);
    }

    @Override
    public BigInteger getBalance(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.getBalance(address);
    }

    @Override
    public void addBalance(Address address, BigInteger amount) throws OutOfGasException {
        this.accountAccess(address);
        super.addBalance(address, amount);
    }

    @Override
    public void subBalance(Address address, BigInteger amount) throws OutOfGasException {
        this.accountAccess(address);
        super.subBalance(address, amount);
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) throws OutOfGasException {
        this.storageAccess(address, key);
        return super.getAccountStorage(address, key);
    }

    @Override
    public void updateAccountStorage(Address address, byte[] key, byte[] value) throws OutOfGasException {
        this.storageWriteAccess(address, new Hash(key), new Hash(value));
        super.updateAccountStorage(address, key, value);
    }

    @Override
    public void addLog(EthereumConsensusDataLog log) throws OutOfGasException {
        this.gas.subGas(GasUtil$.MODULE$.logGas(log));
        super.addLog(log);
    }

    public StateDbAccountStateViewGasTracked(StateDB stateDb, Seq<MessageProcessor> messageProcessors, GasPool gas) {
        this.stateDb = stateDb;
        this.gas = gas;
        super(stateDb, messageProcessors);
    }
}

