/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.CertificateKeysProvider;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.InvalidMessageException;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.StateDbAccountStateViewGasTracked;
import io.horizen.account.state.StateTransition;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.WithdrawalRequestProvider;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt$ReceiptStatus$;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.account.utils.MainchainTxCrosschainOutputAddressUtil$;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import io.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.StateDB;
import io.horizen.evm.results.EvmLog;
import io.horizen.evm.results.ProofAccountResult;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.transaction.mainchain.ForwardTransfer;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Optional;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\r\u0015d\u0001B\u001a5\u0001uB\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t?\u0002\u0011\t\u0011)A\u0005A\")q\u000e\u0001C\u0001a\"AA\u000f\u0001EC\u0002\u0013\u0005Q\u000f\u0003\u0005z\u0001!\u0015\r\u0011\"\u0001{\u0011!q\b\u0001#b\u0001\n\u0003y\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\t9\f\u0001C\u0001\u0003sCqA!\u0001\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003L\u0001!\tE!\u0014\t\u000f\te\u0003\u0001\"\u0011\u0003\\!9!q\f\u0001\u0005B\t\u0005\u0004b\u0002B3\u0001\u0011\u0005#q\r\u0005\b\u0005_\u0002A\u0011\tB9\u0011\u001d\u0011)\b\u0001C!\u0005oBqA!$\u0001\t\u0003\u0012y\tC\u0004\u0003\u0018\u0002!\tE!'\t\u000f\t\u0005\u0006\u0001\"\u0011\u0003$\"9!Q\u0016\u0001\u0005F\t=\u0006\"\u0003B[\u0001\t\u0007I\u0011\u0002B\\\u0011!\u0011I\f\u0001Q\u0001\n\u0005m\u0006b\u0002B^\u0001\u0011%!Q\u0018\u0005\b\u0005\u000b\u0004AQ\tBd\u0011\u001d\u0011i\r\u0001C#\u0005\u001fDqAa6\u0001\t\u000b\u0012I\u000eC\u0004\u0003`\u0002!\tA!9\t\u000f\tU\b\u0001\"\u0011\u0003x\"9!1 \u0001\u0005B\tu\bbBB\u0001\u0001\u0011\u000531\u0001\u0005\b\u0007\u000f\u0001A\u0011IB\u0005\u0011\u001d\u0019i\u0001\u0001C!\u0007\u001fAqa!\b\u0001\t\u0003\u001ay\u0002C\u0004\u0004&\u0001!\tea\n\t\u000f\r%\u0002\u0001\"\u0011\u0004,!911\u0007\u0001\u0005B\t]\u0006bBB\u001b\u0001\u0011\u00051q\u0007\u0005\b\u0007\u000b\u0002A\u0011AB$\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0007\u001bBqaa\u0014\u0001\t\u0003\u0019\t\u0006C\u0004\u0004T\u0001!\taa\n\t\u000f\rU\u0003\u0001\"\u0001\u0004X!91Q\f\u0001\u0005B\r}#aF*uCR,GIY!dG>,h\u000e^*uCR,g+[3x\u0015\t)d'A\u0003ti\u0006$XM\u0003\u00028q\u00059\u0011mY2pk:$(BA\u001d;\u0003\u001dAwN]5{K:T\u0011aO\u0001\u0003S>\u001c\u0001aE\u0003\u0001}\u0011C\u0005\u000b\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0004B]f\u0014VM\u001a\t\u0003\u000b\u001ak\u0011\u0001N\u0005\u0003\u000fR\u0012ACQ1tK\u0006\u001b7m\\;oiN#\u0018\r^3WS\u0016<\bCA%O\u001b\u0005Q%BA&M\u0003\u0011a\u0017M\\4\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T\u0011!V\u0001\u0007gB\f'o\u001b>\n\u0005]\u0013&!D*qCJ\\'\u0010T8hO&tw-A\u0004ti\u0006$X\r\u00122\u0011\u0005ikV\"A.\u000b\u0005qC\u0014aA3w[&\u0011al\u0017\u0002\b'R\fG/\u001a#C\u0003EiWm]:bO\u0016\u0004&o\\2fgN|'o\u001d\t\u0004C&dgB\u00012h\u001d\t\u0019g-D\u0001e\u0015\t)G(\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0011\u0001\u000eQ\u0001\ba\u0006\u001c7.Y4f\u0013\tQ7NA\u0002TKFT!\u0001\u001b!\u0011\u0005\u0015k\u0017B\u000185\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'/\u0001\u0004=S:LGO\u0010\u000b\u0004cJ\u001c\bCA#\u0001\u0011\u0015A6\u00011\u0001Z\u0011\u0015y6\u00011\u0001a\u0003U9\u0018\u000e\u001e5ee\u0006<\u0018\r\u001c*fcB\u0013xN^5eKJ,\u0012A\u001e\t\u0003\u000b^L!\u0001\u001f\u001b\u00033]KG\u000f\u001b3sC^\fGNU3rk\u0016\u001cH\u000f\u0015:pm&$WM]\u0001\u0015M>\u0014x-\u001a:Ti\u0006\\Wm\u001d)s_ZLG-\u001a:\u0016\u0003m\u0004\"!\u0012?\n\u0005u$$\u0001\u0006$pe\u001e,'o\u0015;bW\u0016\u001c\bK]8wS\u0012,'/A\fdKJ$\u0018NZ5dCR,7*Z=t!J|g/\u001b3feV\u0011\u0011\u0011\u0001\t\u0004\u000b\u0006\r\u0011bAA\u0003i\t92)\u001a:uS\u001aL7-\u0019;f\u0017\u0016L8\u000f\u0015:pm&$WM]\u0001\u0011W\u0016L(k\u001c;bi&|g\u000e\u0015:p_\u001a$\u0002\"a\u0003\u0002\"\u0005-\u0012q\u0006\t\u0006\u007f\u00055\u0011\u0011C\u0005\u0004\u0003\u001f\u0001%AB(qi&|g\u000e\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\t-,\u0017p\u001d\u0006\u0004\u00037A\u0014\u0001F2feRLg-[2bi\u0016\u001cXOY7jiR,'/\u0003\u0003\u0002 \u0005U!\u0001E&fsJ{G/\u0019;j_:\u0004&o\\8g\u0011\u001d\t\u0019c\u0002a\u0001\u0003K\tqb^5uQ\u0012\u0014\u0018m^1m\u000bB|7\r\u001b\t\u0004\u007f\u0005\u001d\u0012bAA\u0015\u0001\n\u0019\u0011J\u001c;\t\u000f\u00055r\u00011\u0001\u0002&\u0005i\u0011N\u001c3fq>37+[4oKJDq!!\r\b\u0001\u0004\t)#A\u0004lKf$\u0016\u0010]3\u0002\u001d\r,'\u000f^5gS\u0016\u00148oS3zgR!\u0011qGA !\u0015y\u0014QBA\u001d!\u0011\t\u0019\"a\u000f\n\t\u0005u\u0012Q\u0003\u0002\u000f\u0007\u0016\u0014H/\u001b4jKJ\u001c8*Z=t\u0011\u001d\t\u0019\u0003\u0003a\u0001\u0003K\tQcZ3u/&$\b\u000e\u001a:bo\u0006d'+Z9vKN$8\u000f\u0006\u0003\u0002F\u00055\u0003\u0003B1j\u0003\u000f\u00022!RA%\u0013\r\tY\u0005\u000e\u0002\u0012/&$\b\u000e\u001a:bo\u0006d'+Z9vKN$\bbBA\u0012\u0013\u0001\u0007\u0011QE\u0001\u0013O\u0016$hi\u001c:hKJ\u001cF/Y6f\t\u0006$\u0018\r\u0006\u0003\u0002T\u0005m\u0003#B \u0002\u000e\u0005U\u0003cA#\u0002X%\u0019\u0011\u0011\f\u001b\u0003\u001f\u0019{'oZ3s'R\f7.\u001a#bi\u0006Dq!!\u0018\u000b\u0001\u0004\ty&A\u0004ti\u0006\\W-\u00133\u0011\t\u0005\u0005\u0014\u0011\u000e\b\u0005\u0003G\n)\u0007\u0005\u0002d\u0001&\u0019\u0011q\r!\u0002\rA\u0013X\rZ3g\u0013\u0011\tY'!\u001c\u0003\rM#(/\u001b8h\u0015\r\t9\u0007Q\u0001\u000eSN4uN]4j]\u001e|\u0005/\u001a8\u0016\u0005\u0005M\u0004cA \u0002v%\u0019\u0011q\u000f!\u0003\u000f\t{w\u000e\\3b]\u00061r-\u001a;MSN$xJ\u001a$pe\u001e,'o]*uC.,7/\u0006\u0002\u0002~A!\u0011-[A@!\r)\u0015\u0011Q\u0005\u0004\u0003\u0007#$aF!dG>,h\u000e\u001e$pe\u001eLgnZ*uC.,\u0017J\u001c4p\u0003Q9W\r^!mY><X\r\u001a$pe\u001e,'\u000fT5tiV\u0011\u0011\u0011\u0012\t\u0005C&\f)#\u0001\u0011baBd\u00170T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3ECR\fG\u0003BAH\u0003+\u00032aPAI\u0013\r\t\u0019\n\u0011\u0002\u0005+:LG\u000fC\u0004\u0002\u0018:\u0001\r!!'\u0002\u000fI,g\rR1uCB!\u00111TAQ\u001b\t\tiJC\u0002\u0002 b\nQA\u00197pG.LA!a)\u0002\u001e\nYR*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a#bi\u0006\fadZ3u\u001fJ$WM]3e\r>\u0014x-\u001b8h'R\f7.Z:J]\u001a|7+Z9\u0016\u0005\u0005%\u0006\u0003B1j\u0003W\u0003B!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003cC\u0014!C2p]N,gn];t\u0013\u0011\t),a,\u0003!\u0019{'oZ5oON#\u0018m[3J]\u001a|\u0017\u0001D1qa2LX*Z:tC\u001e,G\u0003CA^\u0003\u000f\f\t.a7\u0011\u000b}\ni,!1\n\u0007\u0005}\u0006IA\u0003BeJ\f\u0017\u0010E\u0002@\u0003\u0007L1!!2A\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005%\u0007\u00031\u0001\u0002L\u0006\u0019Qn]4\u0011\u0007\u0015\u000bi-C\u0002\u0002PR\u0012q!T3tg\u0006<W\rC\u0004\u0002TB\u0001\r!!6\u0002\u0019\tdwnY6HCN\u0004vn\u001c7\u0011\u0007\u0015\u000b9.C\u0002\u0002ZR\u0012qaR1t!>|G\u000eC\u0004\u0002^B\u0001\r!a8\u0002\u0019\tdwnY6D_:$X\r\u001f;\u0011\u0007\u0015\u000b\t/C\u0002\u0002dR\u0012AB\u00117pG.\u001cuN\u001c;fqRDS\u0001EAt\u0003g\u0004RaPAu\u0003[L1!a;A\u0005\u0019!\bN]8xgB\u0019Q)a<\n\u0007\u0005EHG\u0001\rFq\u0016\u001cW\u000f^5p]\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u001c#!!<)\u000bA\t90a@\u0011\u000b}\nI/!?\u0011\u0007\u0015\u000bY0C\u0002\u0002~R\u0012q#\u00138wC2LG-T3tg\u0006<W-\u0012=dKB$\u0018n\u001c8$\u0005\u0005e\u0018\u0001E1qa2LHK]1og\u0006\u001cG/[8o))\u0011)Aa\u0007\u0003D\t\u001d#\u0011\n\t\u0007\u0005\u000f\u0011YAa\u0004\u000e\u0005\t%!BA*A\u0013\u0011\u0011iA!\u0003\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\r\u0011)\u0002N\u0001\be\u0016\u001cW-\u001b9u\u0013\u0011\u0011IBa\u0005\u00039\u0015#\b.\u001a:fk6\u001cuN\\:f]N,8\u000fR1uCJ+7-Z5qi\"9!QD\tA\u0002\t}\u0011A\u0001;y!!\u0011\tCa\n\u0003,\t]RB\u0001B\u0012\u0015\r\u0011)CN\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0003*\t\r\"AE!dG>,h\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u0004BA!\f\u000345\u0011!q\u0006\u0006\u0004\u0005cA\u0014a\u00039s_B|7/\u001b;j_:LAA!\u000e\u00030\tY\u0001K]8q_NLG/[8o!\u0019\u0011IDa\u0010\u0003,5\u0011!1\b\u0006\u0004\u0005{A\u0014!\u00029s_>4\u0017\u0002\u0002B!\u0005w\u0011Q\u0001\u0015:p_\u001aDqA!\u0012\u0012\u0001\u0004\t)#A\u0004uq&sG-\u001a=\t\u000f\u0005M\u0017\u00031\u0001\u0002V\"9\u0011Q\\\tA\u0002\u0005}\u0017\u0001D5t\u000b>\f\u0017iY2pk:$H\u0003BA:\u0005\u001fBqA!\u0015\u0013\u0001\u0004\u0011\u0019&A\u0004bI\u0012\u0014Xm]:\u0011\u0007i\u0013)&C\u0002\u0003Xm\u0013q!\u00113ee\u0016\u001c8/\u0001\fjgNk\u0017M\u001d;D_:$(/Y2u\u0003\u000e\u001cw.\u001e8u)\u0011\t\u0019H!\u0018\t\u000f\tE3\u00031\u0001\u0003T\u0005i\u0011mY2pk:$X\t_5tiN$B!a\u001d\u0003d!9!\u0011\u000b\u000bA\u0002\tM\u0013AC1eI\u0006\u001b7m\\;oiR1\u0011q\u0012B5\u0005WBqA!\u0015\u0016\u0001\u0004\u0011\u0019\u0006C\u0004\u0003nU\u0001\r!a/\u0002\t\r|G-Z\u0001\u000eS:\u001c'/Z1tK:{gnY3\u0015\t\u0005=%1\u000f\u0005\b\u0005#2\u0002\u0019\u0001B*\u0003)\tG\r\u001a\"bY\u0006t7-\u001a\u000b\u0007\u0003\u001f\u0013IHa\u001f\t\u000f\tEs\u00031\u0001\u0003T!9!QP\fA\u0002\t}\u0014AB1n_VtG\u000f\u0005\u0003\u0003\u0002\n\u001dUB\u0001BB\u0015\r\u0011)\tT\u0001\u0005[\u0006$\b.\u0003\u0003\u0003\n\n\r%A\u0003\"jO&sG/Z4fe\"*q#a:\u0002t\u0006Q1/\u001e2CC2\fgnY3\u0015\r\u0005=%\u0011\u0013BJ\u0011\u001d\u0011\t\u0006\u0007a\u0001\u0005'BqA! \u0019\u0001\u0004\u0011y\bK\u0003\u0019\u0003O\f\u00190A\thKR\f5mY8v]R\u001cFo\u001c:bO\u0016$b!a/\u0003\u001c\nu\u0005b\u0002B)3\u0001\u0007!1\u000b\u0005\b\u0005?K\u0002\u0019AA^\u0003\rYW-_\u0001\u0015kB$\u0017\r^3BG\u000e|WO\u001c;Ti>\u0014\u0018mZ3\u0015\u0011\u0005=%Q\u0015BT\u0005SCqA!\u0015\u001b\u0001\u0004\u0011\u0019\u0006C\u0004\u0003 j\u0001\r!a/\t\u000f\t-&\u00041\u0001\u0002<\u0006)a/\u00197vK\u0006!\"/Z7pm\u0016\f5mY8v]R\u001cFo\u001c:bO\u0016$b!a$\u00032\nM\u0006b\u0002B)7\u0001\u0007!1\u000b\u0005\b\u0005?[\u0002\u0019AA^\u00031\u0019\u0007.\u001e8l\u0017\u0016L8+\u00197u+\t\tY,A\u0007dQVt7nS3z'\u0006dG\u000fI\u0001\fO\u0016$8\t[;oW.+\u0017\u0010\u0006\u0004\u0002<\n}&\u0011\u0019\u0005\b\u0005?s\u0002\u0019AA^\u0011\u001d\u0011\u0019M\ba\u0001\u0003K\t!b\u00195v].Le\u000eZ3y\u0003Y9W\r^!dG>,h\u000e^*u_J\fw-\u001a\"zi\u0016\u001cHCBA^\u0005\u0013\u0014Y\rC\u0004\u0003R}\u0001\rAa\u0015\t\u000f\t}u\u00041\u0001\u0002<\u0006IR\u000f\u001d3bi\u0016\f5mY8v]R\u001cFo\u001c:bO\u0016\u0014\u0015\u0010^3t)!\tyI!5\u0003T\nU\u0007b\u0002B)A\u0001\u0007!1\u000b\u0005\b\u0005?\u0003\u0003\u0019AA^\u0011\u001d\u0011Y\u000b\ta\u0001\u0003w\u000b\u0011D]3n_Z,\u0017iY2pk:$8\u000b^8sC\u001e,')\u001f;fgR1\u0011q\u0012Bn\u0005;DqA!\u0015\"\u0001\u0004\u0011\u0019\u0006C\u0004\u0003 \u0006\u0002\r!a/\u0002\u0011\u001d,G\u000f\u0015:p_\u001a$bAa9\u0003p\nE\b\u0003\u0002Bs\u0005Wl!Aa:\u000b\u0007\t%8,A\u0004sKN,H\u000e^:\n\t\t5(q\u001d\u0002\u0013!J|wNZ!dG>,h\u000e\u001e*fgVdG\u000fC\u0004\u0003R\t\u0002\rAa\u0015\t\u000f\u0005]!\u00051\u0001\u0003tB)q(!0\u0002<\u0006Aq-\u001a;O_:\u001cW\r\u0006\u0003\u0003\u0000\te\bb\u0002B)G\u0001\u0007!1K\u0001\u000bO\u0016$()\u00197b]\u000e,G\u0003\u0002B@\u0005\u007fDqA!\u0015%\u0001\u0004\u0011\u0019&A\u0006hKR\u001cu\u000eZ3ICNDG\u0003BA^\u0007\u000bAqA!\u0015&\u0001\u0004\u0011\u0019&A\u0004hKR\u001cu\u000eZ3\u0015\t\u0005m61\u0002\u0005\b\u0005#2\u0003\u0019\u0001B*\u0003\u001d9W\r\u001e'pON$Ba!\u0005\u0004\u001aA)q(!0\u0004\u0014A!!\u0011CB\u000b\u0013\u0011\u00199Ba\u0005\u00031\u0015#\b.\u001a:fk6\u001cuN\\:f]N,8\u000fR1uC2{w\rC\u0004\u0004\u001c\u001d\u0002\r!a/\u0002\rQD\b*Y:i\u0003\u0019\tG\r\u001a'pOR!\u0011qRB\u0011\u0011\u001d\u0019\u0019\u0003\u000ba\u0001\u0007'\t1\u0001\\8h\u0003\u0015\u0019Gn\\:f)\t\ty)\u0001\thKR\u001cF/\u0019;f\t\nD\u0015M\u001c3mKV\u00111Q\u0006\t\u00045\u000e=\u0012bAB\u00197\nq!+Z:pkJ\u001cW\rS1oI2,\u0017aE4fi&sG/\u001a:nK\u0012L\u0017\r^3S_>$\u0018AD:fiV\u0004H\u000b_\"p]R,\u0007\u0010\u001e\u000b\u0007\u0003\u001f\u001bIda\u000f\t\u000f\rmA\u00061\u0001\u0002<\"91Q\b\u0017A\u0002\r}\u0012aA5eqB\u0019\u0011j!\u0011\n\u0007\r\r#JA\u0004J]R,w-\u001a:\u0002\u001fM,G/\u001e9BG\u000e,7o\u001d'jgR$B!a$\u0004J!9\u0011\u0011Z\u0017A\u0002\u0005-\u0017!C4fiJ+g-\u001e8e+\t\u0011y(\u0001\u0005t]\u0006\u00048\u000f[8u+\t\t)#A\bgS:\fG.\u001b>f\u0007\"\fgnZ3t\u0003A\u0011XM^3siR{7K\\1qg\"|G\u000f\u0006\u0003\u0002\u0010\u000ee\u0003bBB.c\u0001\u0007\u0011QE\u0001\u000be\u00164\u0018n]5p]&#\u0017!E4fi\u001e\u000b7\u000f\u0016:bG.,GMV5foR\u0019Ai!\u0019\t\u000f\r\r$\u00071\u0001\u0002V\u0006\u0019q-Y:")
public class StateDbAccountStateView
implements BaseAccountStateView,
AutoCloseable,
SparkzLogging {
    private WithdrawalRequestProvider withdrawalReqProvider;
    private ForgerStakesProvider forgerStakesProvider;
    private CertificateKeysProvider certificateKeysProvider;
    private final StateDB stateDb;
    private final Seq<MessageProcessor> messageProcessors;
    private final byte[] chunkKeySalt;
    private final Logger logger;
    private volatile byte bitmap$0;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private WithdrawalRequestProvider withdrawalReqProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.withdrawalReqProvider = (WithdrawalRequestProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$withdrawalReqProvider$1(x$1))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.withdrawalReqProvider;
    }

    public WithdrawalRequestProvider withdrawalReqProvider() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.withdrawalReqProvider$lzycompute() : this.withdrawalReqProvider;
    }

    private ForgerStakesProvider forgerStakesProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.forgerStakesProvider = (ForgerStakesProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$forgerStakesProvider$1(x$2))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.forgerStakesProvider;
    }

    public ForgerStakesProvider forgerStakesProvider() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.forgerStakesProvider$lzycompute() : this.forgerStakesProvider;
    }

    private CertificateKeysProvider certificateKeysProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.certificateKeysProvider = (CertificateKeysProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$certificateKeysProvider$1(x$3))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.certificateKeysProvider;
    }

    public CertificateKeysProvider certificateKeysProvider() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.certificateKeysProvider$lzycompute() : this.certificateKeysProvider;
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return this.certificateKeysProvider().getKeyRotationProof(withdrawalEpoch, indexOfSigner, KeyRotationProofTypes$.MODULE$.apply(keyType), this);
    }

    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        return new Some((Object)this.certificateKeysProvider().getCertifiersKeys(withdrawalEpoch, this));
    }

    @Override
    public Seq<WithdrawalRequest> getWithdrawalRequests(int withdrawalEpoch) {
        return this.withdrawalReqProvider().getListOfWithdrawalReqRecords(withdrawalEpoch, this);
    }

    @Override
    public Option<ForgerStakeData> getForgerStakeData(String stakeId) {
        return this.forgerStakesProvider().findStakeData(this, BytesUtils.fromHexString(stakeId));
    }

    @Override
    public boolean isForgingOpen() {
        return this.forgerStakesProvider().isForgerListOpen(this);
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes() {
        return this.forgerStakesProvider().getListOfForgersStakes(this);
    }

    @Override
    public Seq<Object> getAllowedForgerList() {
        return this.forgerStakesProvider().getAllowedForgerListIndexes(this);
    }

    public void applyMainchainBlockReferenceData(MainchainBlockReferenceData refData) {
        refData.sidechainRelatedAggregatedTransaction().foreach((Function1 & Serializable & scala.Serializable)aggTx -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(aggTx.mc2scTransactionsOutputs()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StateDbAccountStateView.$anonfun$applyMainchainBlockReferenceData$2(this, x0$1);
            return BoxedUnit.UNIT;
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq() {
        return (Seq)((TraversableOnce)this.getListOfForgersStakes().view().groupBy((Function1 & Serializable & scala.Serializable)stake -> new Tuple2((Object)stake.forgerStakeData().forgerPublicKeys().blockSignPublicKey(), (Object)stake.forgerStakeData().forgerPublicKeys().vrfPublicKey())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SeqView stakes;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    stakes = (SeqView)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            PublicKey25519Proposition blockSignKey = (PublicKey25519Proposition)tuple2._1();
            VrfPublicKey vrfKey = (VrfPublicKey)tuple2._2();
            ForgingStakeInfo forgingStakeInfo = new ForgingStakeInfo(blockSignKey, vrfKey, BoxesRunTime.unboxToLong((Object)((TraversableOnce)stakes.map((Function1 & Serializable & scala.Serializable)stake -> BoxesRunTime.boxToLong((long)ZenWeiConverter$.MODULE$.convertWeiToZennies(stake.forgerStakeData().stakedAmount())), SeqView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            return forgingStakeInfo;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted(package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reverse());
    }

    public byte[] applyMessage(Message msg, GasPool blockGasPool, BlockContext blockContext) throws InvalidMessageException, ExecutionFailedException {
        return new StateTransition(this, this.messageProcessors, blockGasPool, blockContext).transition(msg);
    }

    public Try<EthereumConsensusDataReceipt> applyTransaction(AccountTransaction<Proposition, Proof<Proposition>> tx, int txIndex, GasPool blockGasPool, BlockContext blockContext) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Enumeration.Value value;
            BoxedUnit boxedUnit3;
            if (!(tx instanceof EthereumTransaction)) {
                throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported transaction type ").append(tx.getClass().getName()).toString());
            }
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if (!ethTx.isSigned()) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Transaction is not signed: ").append(ethTx.id()).toString());
            }
            byte[] txHash = BytesUtils.fromHexString(ethTx.id());
            Message msg = ethTx.asMessage(blockContext$1.baseFee);
            this.setupTxContext(txHash, Predef$.MODULE$.int2Integer(txIndex));
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("applying msg: used pool gas {}", new Object[]{blockGasPool.getUsedGas()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            try {
                try {
                    this.applyMessage(msg, blockGasPool, blockContext);
                    value = EthereumConsensusDataReceipt$ReceiptStatus$.MODULE$.SUCCESSFUL();
                }
                catch (ExecutionFailedException err) {
                    BoxedUnit boxedUnit4;
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug("applying message failed, tx id: {}, reason: {}", (Object[])new String[]{ethTx.id(), err.getMessage()});
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    value = EthereumConsensusDataReceipt$ReceiptStatus$.MODULE$.FAILED();
                }
            }
            finally {
                $this.stateDb.finalizeChanges();
            }
            Enumeration.Value status = value;
            EthereumConsensusDataReceipt consensusDataReceipt = new EthereumConsensusDataReceipt(ethTx.version(), status.id(), blockGasPool.getUsedGas(), (Seq<EthereumConsensusDataLog>)Predef$.MODULE$.wrapRefArray((Object[])this.getLogs(txHash)));
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("Returning consensus data receipt: {}", new Object[]{consensusDataReceipt.toString()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("applied msg: used pool gas {}", new Object[]{blockGasPool.getUsedGas()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return consensusDataReceipt;
        });
    }

    @Override
    public boolean isEoaAccount(Address address) {
        return this.stateDb.isEoaAccount(address);
    }

    @Override
    public boolean isSmartContractAccount(Address address) {
        return this.stateDb.isSmartContractAccount(address);
    }

    @Override
    public boolean accountExists(Address address) {
        return !this.stateDb.isEmpty(address);
    }

    @Override
    public void addAccount(Address address, byte[] code) {
        this.stateDb.setCode(address, code);
    }

    @Override
    public void increaseNonce(Address address) {
        this.stateDb.setNonce(address, this.getNonce(address).add(BigInteger.ONE));
    }

    @Override
    public void addBalance(Address address, BigInteger amount) throws ExecutionFailedException {
        block3: {
            int n = amount.signum();
            switch (n) {
                default: 
            }
            if (n == 0) break block3;
            if (n < 0) {
                throw new ExecutionFailedException("cannot add negative amount to balance");
            }
            this.stateDb.addBalance(address, amount);
        }
    }

    @Override
    public void subBalance(Address address, BigInteger amount) throws ExecutionFailedException {
        block3: {
            int n = amount.signum();
            switch (n) {
                default: 
            }
            if (n == 0) break block3;
            if (n < 0) {
                throw new ExecutionFailedException("cannot subtract negative amount from balance");
            }
            this.stateDb.subBalance(address, amount);
        }
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) {
        return this.stateDb.getStorage(address, new Hash(key)).toBytes();
    }

    @Override
    public void updateAccountStorage(Address address, byte[] key, byte[] value) {
        this.stateDb.setStorage(address, new Hash(key), new Hash(value));
    }

    @Override
    public final void removeAccountStorage(Address address, byte[] key) {
        this.updateAccountStorage(address, key, Hash.ZERO.toBytes());
    }

    private byte[] chunkKeySalt() {
        return this.chunkKeySalt;
    }

    private byte[] getChunkKey(byte[] key, int chunkIndex) {
        return Keccak256$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.chunkKeySalt(), key, BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(chunkIndex))}));
    }

    @Override
    public final byte[] getAccountStorageBytes(Address address, byte[] key) {
        int length = new BigInteger(1, this.getAccountStorage(address, key)).intValueExact();
        byte[] data = new byte[length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (length + 32 - 1) / 32).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)chunkIndex -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.getAccountStorage(address, this.getChunkKey(key, chunkIndex)))).copyToArray((Object)data, chunkIndex * 32));
        return data;
    }

    @Override
    public final void updateAccountStorageBytes(Address address, byte[] key, byte[] value) {
        int oldLength = new BigInteger(1, this.getAccountStorage(address, key)).intValueExact();
        int newLength = value.length;
        this.updateAccountStorage(address, key, BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(newLength)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Math.max(newLength, oldLength)).by(32).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)start -> {
            int chunkIndex = start / 32;
            byte[] chunkKey = this.getChunkKey(key, chunkIndex);
            if (start < newLength) {
                this.updateAccountStorage(address, chunkKey, (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value)).slice(start, start + 32))).padTo(32, (Object)BoxesRunTime.boxToByte((byte)((byte)0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
            } else {
                this.removeAccountStorage(address, chunkKey);
            }
        });
    }

    @Override
    public final void removeAccountStorageBytes(Address address, byte[] key) {
        this.updateAccountStorageBytes(address, key, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
    }

    public ProofAccountResult getProof(Address address, byte[][] keys) {
        return this.stateDb.getProof(address, (Hash[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).map((Function1 & Serializable & scala.Serializable)x$4 -> new Hash(x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Hash.class))));
    }

    @Override
    public BigInteger getNonce(Address address) {
        return this.stateDb.getNonce(address);
    }

    @Override
    public BigInteger getBalance(Address address) {
        return this.stateDb.getBalance(address);
    }

    @Override
    public byte[] getCodeHash(Address address) {
        return this.stateDb.getCodeHash(address).toBytes();
    }

    @Override
    public byte[] getCode(Address address) {
        return this.stateDb.getCode(address);
    }

    @Override
    public EthereumConsensusDataLog[] getLogs(byte[] txHash) {
        return (EthereumConsensusDataLog[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.stateDb.getLogs(new Hash(txHash)))).map((Function1 & Serializable & scala.Serializable)log -> new EthereumConsensusDataLog(log.address, log.topics, log.data), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(EthereumConsensusDataLog.class)));
    }

    @Override
    public void addLog(EthereumConsensusDataLog log) {
        this.stateDb.addLog(new EvmLog(log.address(), log.topics(), log.data()));
    }

    @Override
    public void close() {
        this.stateDb.close();
    }

    @Override
    public ResourceHandle getStateDbHandle() {
        return this.stateDb;
    }

    @Override
    public byte[] getIntermediateRoot() {
        return this.stateDb.getIntermediateRoot().toBytes();
    }

    public void setupTxContext(byte[] txHash, Integer idx) {
        this.stateDb.setTxContext(new Hash(txHash), Predef$.MODULE$.Integer2int(idx));
    }

    public void setupAccessList(Message msg) {
        this.stateDb.accessSetup(msg.getFrom(), msg.getTo().orElse(Address.ZERO));
    }

    public BigInteger getRefund() {
        return this.stateDb.getRefund();
    }

    public int snapshot() {
        return this.stateDb.snapshot();
    }

    public void finalizeChanges() {
        this.stateDb.finalizeChanges();
    }

    public void revertToSnapshot(int revisionId) {
        this.stateDb.revertToSnapshot(revisionId);
    }

    @Override
    public BaseAccountStateView getGasTrackedView(GasPool gas) {
        return new StateDbAccountStateViewGasTracked(this.stateDb, this.messageProcessors, gas);
    }

    public static final /* synthetic */ boolean $anonfun$withdrawalReqProvider$1(MessageProcessor x$1) {
        return x$1 instanceof WithdrawalRequestProvider;
    }

    public static final /* synthetic */ boolean $anonfun$forgerStakesProvider$1(MessageProcessor x$2) {
        return x$2 instanceof ForgerStakesProvider;
    }

    public static final /* synthetic */ boolean $anonfun$certificateKeysProvider$1(MessageProcessor x$3) {
        return x$3 instanceof CertificateKeysProvider;
    }

    public static final /* synthetic */ void $anonfun$applyMainchainBlockReferenceData$2(StateDbAccountStateView $this, SidechainRelatedMainchainOutput x0$1) {
        SidechainRelatedMainchainOutput sidechainRelatedMainchainOutput = x0$1;
        if (sidechainRelatedMainchainOutput instanceof SidechainCreation) {
            BoxedUnit boxedUnit;
            SidechainCreation sidechainCreation = (SidechainCreation)sidechainRelatedMainchainOutput;
            MainchainTxSidechainCreationCrosschainOutput scOut = sidechainCreation.getScCrOutput();
            BigInteger stakedAmount = ZenWeiConverter$.MODULE$.convertZenniesToWei(scOut.amount());
            Address ownerAddress = MainchainTxCrosschainOutputAddressUtil$.MODULE$.getAccountAddress(scOut.address());
            VrfPublicKey vrfPublicKey = new VrfPublicKey((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(scOut.customCreationData())).take(VrfPublicKey.KEY_LENGTH));
            PublicKey25519Proposition blockSignerProposition = new PublicKey25519Proposition((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(scOut.customCreationData())).slice(VrfPublicKey.KEY_LENGTH, VrfPublicKey.KEY_LENGTH + PublicKey25519Proposition.KEY_LENGTH));
            AddNewStakeCmdInput cmdInput = new AddNewStakeCmdInput(new ForgerPublicKeys(blockSignerProposition, vrfPublicKey), ownerAddress);
            byte[] data = Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd()), cmdInput.encode()});
            Message message = new Message(ownerAddress, Optional.of(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS()), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, stakedAmount, BigInteger.ONE.negate(), data, false);
            byte[] returnData = $this.forgerStakesProvider().addScCreationForgerStake(message, $this);
            if ($this.log().underlying().isDebugEnabled()) {
                $this.log().underlying().debug("sc creation forging stake added with stakeid: {}", new Object[]{BytesUtils.toHexString(returnData)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (sidechainRelatedMainchainOutput instanceof ForwardTransfer) {
            BoxedUnit boxedUnit;
            ForwardTransfer forwardTransfer = (ForwardTransfer)sidechainRelatedMainchainOutput;
            MainchainTxForwardTransferCrosschainOutput ftOut = forwardTransfer.getFtOutput();
            BigInteger value = ZenWeiConverter$.MODULE$.convertZenniesToWei(ftOut.amount());
            AddressProposition recipientProposition = new AddressProposition(MainchainTxCrosschainOutputAddressUtil$.MODULE$.getAccountAddress(ftOut.propositionBytes()));
            if ($this.isEoaAccount(recipientProposition.address())) {
                $this.addBalance(recipientProposition.address(), value);
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("added FT amount = {} to address={}", new Object[]{value, recipientProposition});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                BoxedUnit boxedUnit3;
                Address burnAddress = Address.ZERO;
                if ($this.log().underlying().isWarnEnabled()) {
                    $this.log().underlying().warn("ignored FT to non-EOA account, amount={} to address={} (the amount was burned by sending balance to {} address)", new Object[]{value, recipientProposition, burnAddress});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                $this.addBalance(burnAddress, value);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError((Object)sidechainRelatedMainchainOutput);
        }
    }

    public StateDbAccountStateView(StateDB stateDb, Seq<MessageProcessor> messageProcessors) {
        this.stateDb = stateDb;
        this.messageProcessors = messageProcessors;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.chunkKeySalt = BytesUtils.fromHexString("fa09428dd8121ea57327c9f21af74ffad8bfd5e6e39dc3dc6c53241a85ec5b0d");
    }
}

