/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.events.EthereumEvent;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import java.io.Serializable;
import scala.Function1;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\u0007\u000f\u0003\u00039\u0002\"\u0002\u0017\u0001\t\u0003i\u0003bB\u0018\u0001\u0005\u00045\t\u0001\r\u0005\bo\u0001\u0011\rQ\"\u00019\u0011!\u0011\u0005\u0001#b\u0001\n\u0003A\u0004\"B\"\u0001\t\u0003\"\u0005\"\u0002>\u0001\t\u0003Z\bbBA\u0006\u0001\u0011\u0005\u0011QB\u0004\b\u0003Kq\u0001\u0012AA\u0014\r\u0019ia\u0002#\u0001\u0002*!1A&\u0003C\u0001\u0003cA\u0001\"a\r\n\u0005\u0004%\t\u0001\u000f\u0005\b\u0003kI\u0001\u0015!\u0003:\u0005}q\u0015\r^5wKNk\u0017M\u001d;D_:$(/Y2u\u001bN<\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u001fA\tQa\u001d;bi\u0016T!!\u0005\n\u0002\u000f\u0005\u001c7m\\;oi*\u00111\u0003F\u0001\bQ>\u0014\u0018N_3o\u0015\u0005)\u0012AA5p\u0007\u0001\u0019B\u0001\u0001\r!IA\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB(cU\u0016\u001cG\u000f\u0005\u0002\"E5\ta\"\u0003\u0002$\u001d\t\u0001R*Z:tC\u001e,\u0007K]8dKN\u001cxN\u001d\t\u0003K)j\u0011A\n\u0006\u0003O!\nA!\u001e;jY*\t\u0011&\u0001\u0004ta\u0006\u00148N_\u0005\u0003W\u0019\u0012Qb\u00159be.THj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001/!\t\t\u0003!A\bd_:$(/Y2u\u0003\u0012$'/Z:t+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0013\u0003\r)g/\\\u0005\u0003mM\u0012q!\u00113ee\u0016\u001c8/\u0001\u0007d_:$(/Y2u\u0007>$W-F\u0001:!\rQThP\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t)\u0011I\u001d:bsB\u0011!\bQ\u0005\u0003\u0003n\u0012AAQ=uK\u0006\u00012m\u001c8ue\u0006\u001cGoQ8eK\"\u000b7\u000f[\u0001\u0005S:LG\u000f\u0006\u0002F\u0011B\u0011!HR\u0005\u0003\u000fn\u0012A!\u00168ji\")\u0011*\u0002a\u0001\u0015\u0006!a/[3x!\t\t3*\u0003\u0002M\u001d\t!\")Y:f\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a,jK^D3!\u0002(U!\rQt*U\u0005\u0003!n\u0012a\u0001\u001e5s_^\u001c\bCA\u0011S\u0013\t\u0019fBA\u0014NKN\u001c\u0018mZ3Qe>\u001cWm]:pe&s\u0017\u000e^5bY&T\u0018\r^5p]\u0016C8-\u001a9uS>t\u0017\u0007\u0002\u0010VAf\u0004\"AV/\u000f\u0005][\u0006C\u0001-<\u001b\u0005I&B\u0001.\u0017\u0003\u0019a$o\\8u}%\u0011AlO\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]wE*1%Y3uMV\u0011!mY\u000b\u0002+\u0012)AM\u0006b\u0001S\n\tA+\u0003\u0002gO\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!\u0001[\u001e\u0002\rQD'o\\<t#\tQW\u000e\u0005\u0002;W&\u0011An\u000f\u0002\b\u001d>$\b.\u001b8h!\tq\u0017O\u0004\u0002;_&\u0011\u0001oO\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118OA\u0005UQJ|w/\u00192mK*\u0011\u0001oO\u0019\u0006GU4x\u000f\u001b\b\u0003uYL!\u0001[\u001e2\t\tR4\b\u001f\u0002\u0006g\u000e\fG.Y\u0019\u0003ME\u000b!bY1o!J|7-Z:t)\u0011ax0!\u0003\u0011\u0005ij\u0018B\u0001@<\u0005\u001d\u0011un\u001c7fC:Dq!!\u0001\u0007\u0001\u0004\t\u0019!A\u0002ng\u001e\u00042!IA\u0003\u0013\r\t9A\u0004\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u0015Ie\u00011\u0001K\u0003m9W\r^#uQ\u0016\u0014X-^7D_:\u001cXM\\:vg\u0012\u000bG/\u0019'pOR!\u0011qBA\u000e!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b\u001d\u00059!/Z2fSB$\u0018\u0002BA\r\u0003'\u0011\u0001$\u0012;iKJ,W/\\\"p]N,gn];t\t\u0006$\u0018\rT8h\u0011\u001d\tib\u0002a\u0001\u0003?\tQ!\u001a<f]R\u00042AOA\u0011\u0013\r\t\u0019c\u000f\u0002\u0004\u0003:L\u0018a\b(bi&4XmU7beR\u001cuN\u001c;sC\u000e$Xj]4Qe>\u001cWm]:peB\u0011\u0011%C\n\u0004\u0013\u0005-\u0002c\u0001\u001e\u0002.%\u0019\u0011qF\u001e\u0003\r\u0005s\u0017PU3g)\t\t9#\u0001\nO+2cu\fS#Y?N#&+\u0013(H?N\u0012\u0014a\u0005(V\u00192{\u0006*\u0012-`'R\u0013\u0016JT$`gI\u0002\u0003")
public abstract class NativeSmartContractMsgProcessor
implements MessageProcessor,
SparkzLogging {
    private byte[] contractCodeHash;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static byte[] NULL_HEX_STRING_32() {
        return NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public abstract Address contractAddress();

    public abstract byte[] contractCode();

    private byte[] contractCodeHash$lzycompute() {
        NativeSmartContractMsgProcessor nativeSmartContractMsgProcessor = this;
        synchronized (nativeSmartContractMsgProcessor) {
            if (!this.bitmap$0) {
                this.contractCodeHash = Keccak256$.MODULE$.hash(this.contractCode());
                this.bitmap$0 = true;
            }
        }
        return this.contractCodeHash;
    }

    public byte[] contractCodeHash() {
        return !this.bitmap$0 ? this.contractCodeHash$lzycompute() : this.contractCodeHash;
    }

    @Override
    public void init(BaseAccountStateView view) throws MessageProcessorInitializationException {
        if (!view.accountExists(this.contractAddress())) {
            BoxedUnit boxedUnit;
            view.addAccount(this.contractAddress(), this.contractCode());
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("created Message Processor account {}", new Object[]{this.contractAddress()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            String errorMsg = new StringBuilder(23).append("Account ").append(this.contractAddress()).append(" already exists").toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(errorMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new MessageProcessorInitializationException(errorMsg);
        }
    }

    @Override
    public boolean canProcess(Message msg, BaseAccountStateView view) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(msg.getTo())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NativeSmartContractMsgProcessor.$anonfun$canProcess$1(this, x$1)));
    }

    public EthereumConsensusDataLog getEthereumConsensusDataLog(Object event) {
        return EthereumEvent.getEthereumConsensusDataLog(this.contractAddress(), event);
    }

    public static final /* synthetic */ boolean $anonfun$canProcess$1(NativeSmartContractMsgProcessor $this, Address x$1) {
        return $this.contractAddress().equals((Object)x$1);
    }

    public NativeSmartContractMsgProcessor() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

