/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountForgingStakeInfoListEncoder$;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.AddNewStakeCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeDataSerializer$;
import io.horizen.account.state.ForgerStakeLinkedList$;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.LinkedListNode;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.OpenStakeForgerListCmdInput;
import io.horizen.account.state.OpenStakeForgerListCmdInputDecoder$;
import io.horizen.account.state.RemoveStakeCmdInput;
import io.horizen.account.state.RemoveStakeCmdInputDecoder$;
import io.horizen.account.state.events.DelegateForgerStake;
import io.horizen.account.state.events.DelegateForgerStake$;
import io.horizen.account.state.events.OpenForgerList;
import io.horizen.account.state.events.OpenForgerList$;
import io.horizen.account.state.events.WithdrawForgerStake;
import io.horizen.account.state.events.WithdrawForgerStake$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001\u0002 @\u0001\"C\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00057\")\u0011\r\u0001C\u0001E\"9Q\r\u0001b\u0001\n\u00032\u0007BB7\u0001A\u0003%q\rC\u0004o\u0001\t\u0007I\u0011I8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001d9\bA1A\u0005\u0002iCa\u0001\u001f\u0001!\u0002\u0013Y\u0006\"B=\u0001\t\u0003Q\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002h\u0001!\t%!\u001b\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!I\u00111\u0010\u0001\u0012\u0002\u0013\u0005\u0011Q\u0010\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\tI\n\u0001C!\u00037Cq!!0\u0001\t\u0003\ty\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u00111\u001b\u0001\u0005\n\u0005U\u0007bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0003C\u0004A\u0011IAr\u0011!\u0011i\u0001\u0001C!\u0007\n=\u0001\u0002\u0003B\u0011\u0001\u0011\u00053Ia\t\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!A!q\u0006\u0001\u0005B\r\u0013\t\u0004C\u0005\u0003>\u0001\t\t\u0011\"\u0001\u0003@!I!1\t\u0001\u0012\u0002\u0013\u0005!Q\t\u0005\n\u0005\u0013\u0002\u0011\u0011!C!\u0005\u0017B\u0011B!\u0017\u0001\u0003\u0003%\tAa\u0017\t\u0013\tu\u0003!!A\u0005\u0002\t}\u0003\"\u0003B6\u0001\u0005\u0005I\u0011\tB7\u0011%\u0011Y\bAA\u0001\n\u0003\u0011i\bC\u0005\u0003\u0002\u0002\t\t\u0011\"\u0011\u0003\u0004\"I!Q\u0011\u0001\u0002\u0002\u0013\u0005#q\u0011\u0005\n\u0005\u0013\u0003\u0011\u0011!C!\u0005\u0017;qAa$@\u0011\u0003\u0011\tJ\u0002\u0004?\u007f!\u0005!1\u0013\u0005\u0007C&\"\tAa'\t\u0011\tu\u0015F1A\u0005\u0002=DqAa(*A\u0003%\u0001\u000f\u0003\u0005\u0003\"&\u0012\r\u0011\"\u0001p\u0011\u001d\u0011\u0019+\u000bQ\u0001\nAD\u0001B!**\u0005\u0004%\ta\u001c\u0005\b\u0005OK\u0003\u0015!\u0003q\u0011%\u0011I+\u000bb\u0001\n\u0003\u0011Y\u000b\u0003\u0005\u0003<&\u0002\u000b\u0011\u0002BW\u0011%\u0011i,\u000bb\u0001\n\u0003\u0011Y\u000b\u0003\u0005\u0003@&\u0002\u000b\u0011\u0002BW\u0011%\u0011\t-\u000bb\u0001\n\u0003\u0011Y\u000b\u0003\u0005\u0003D&\u0002\u000b\u0011\u0002BW\u0011%\u0011)-\u000bb\u0001\n\u0003\u0011Y\u000b\u0003\u0005\u0003H&\u0002\u000b\u0011\u0002BW\u0011\u001d\u0011I-\u000bC\u0001\u0005\u0017DqAa6*\t\u0003\u0011I\u000eC\u0005\u0003d&\n\t\u0011\"!\u0003f\"I!\u0011^\u0015\u0002\u0002\u0013\u0005%1\u001e\u0005\n\u0005gL\u0013\u0011!C\u0005\u0005k\u0014qCR8sO\u0016\u00148\u000b^1lK6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\u0001\u000b\u0015!B:uCR,'B\u0001\"D\u0003\u001d\t7mY8v]RT!\u0001R#\u0002\u000f!|'/\u001b>f]*\ta)\u0001\u0002j_\u000e\u00011#\u0002\u0001J\u001bB3\u0006C\u0001&L\u001b\u0005y\u0014B\u0001'@\u0005}q\u0015\r^5wKNk\u0017M\u001d;D_:$(/Y2u\u001bN<\u0007K]8dKN\u001cxN\u001d\t\u0003\u0015:K!aT \u0003)\u0019{'oZ3s'R\f7.Z:Qe>4\u0018\u000eZ3s!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u001d\u0001&o\u001c3vGR\u0004\"!U,\n\u0005a\u0013&\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00029be\u0006l7/F\u0001\\!\taf,D\u0001^\u0015\tI6)\u0003\u0002`;\nia*\u001a;x_J\\\u0007+\u0019:b[N\fq\u0001]1sC6\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0012\u0004\"A\u0013\u0001\t\u000be\u001b\u0001\u0019A.\u0002\u001f\r|g\u000e\u001e:bGR\fE\r\u001a:fgN,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u000e\u000b1!\u001a<n\u0013\ta\u0017NA\u0004BI\u0012\u0014Xm]:\u0002!\r|g\u000e\u001e:bGR\fE\r\u001a:fgN\u0004\u0013\u0001D2p]R\u0014\u0018m\u0019;D_\u0012,W#\u00019\u0011\u0007E\u000b8/\u0003\u0002s%\n)\u0011I\u001d:bsB\u0011\u0011\u000b^\u0005\u0003kJ\u0013AAQ=uK\u0006i1m\u001c8ue\u0006\u001cGoQ8eK\u0002\nQB\\3uo>\u00148\u000eU1sC6\u001c\u0018A\u00048fi^|'o\u001b)be\u0006l7\u000fI\u0001\u000bO\u0016$8\u000b^1lK&#GC\u00019|\u0011\u0015a(\u00021\u0001~\u0003\ri7o\u001a\t\u0003\u0015zL!a` \u0003\u000f5+7o]1hK\u0006!\u0011N\\5u)\u0011\t)!a\u0003\u0011\u0007E\u000b9!C\u0002\u0002\nI\u0013A!\u00168ji\"9\u0011QB\u0006A\u0002\u0005=\u0011\u0001\u0002<jK^\u00042ASA\t\u0013\r\t\u0019b\u0010\u0002\u0015\u0005\u0006\u001cX-Q2d_VtGo\u0015;bi\u00164\u0016.Z<\u0002\u001f\u0015D\u0018n\u001d;t'R\f7.\u001a#bi\u0006$b!!\u0007\u0002 \u0005\u0005\u0002cA)\u0002\u001c%\u0019\u0011Q\u0004*\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0002\u0007A\u0002\u0005=\u0001BBA\u0012\u0019\u0001\u0007\u0001/A\u0004ti\u0006\\W-\u00133\u0002\u001d\u0005$GMR8sO\u0016\u00148\u000b^1lKRq\u0011QAA\u0015\u0003W\ti#!\u0010\u0002H\u0005-\u0003bBA\u0007\u001b\u0001\u0007\u0011q\u0002\u0005\u0007\u0003Gi\u0001\u0019\u00019\t\u000f\u0005=R\u00021\u0001\u00022\u0005!\"\r\\8dWNKwM\u001c)s_B|7/\u001b;j_:\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o\u0019\u0015a\u00039s_B|7/\u001b;j_:LA!a\u000f\u00026\tI\u0002+\u001e2mS\u000e\\U-\u001f\u001a6kEJ\u0004K]8q_NLG/[8o\u0011\u001d\ty$\u0004a\u0001\u0003\u0003\nAB\u001e:g!V\u0014G.[2LKf\u0004B!a\r\u0002D%!\u0011QIA\u001b\u000511&O\u001a)vE2L7mS3z\u0011\u0019\tI%\u0004a\u0001O\u0006qqn\u001e8feB+(\r\\5d\u0017\u0016L\bbBA'\u001b\u0001\u0007\u0011qJ\u0001\rgR\f7.\u001a3B[>,h\u000e\u001e\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011i\u0017\r\u001e5\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006LA!!\u0018\u0002T\tQ!)[4J]R,w-\u001a:\u0002#I,Wn\u001c<f\r>\u0014x-\u001a:Ti\u0006\\W\r\u0006\u0004\u0002\u0006\u0005\r\u0014Q\r\u0005\b\u0003\u001bq\u0001\u0019AA\b\u0011\u0019\t\u0019C\u0004a\u0001a\u0006A\u0012\r\u001a3TG\u000e\u0013X-\u0019;j_:4uN]4feN#\u0018m[3\u0015\u000bA\fY'!\u001c\t\u000bq|\u0001\u0019A?\t\u000f\u00055q\u00021\u0001\u0002\u0010\u0005\u0001Bm\\!eI:+wo\u0015;bW\u0016\u001cU\u000e\u001a\u000b\ba\u0006M\u0014QOA<\u0011\u0015a\b\u00031\u0001~\u0011\u001d\ti\u0001\u0005a\u0001\u0003\u001fA\u0011\"!\u001f\u0011!\u0003\u0005\r!!\u0007\u0002'%\u001cx)\u001a8fg&\u001c8kY\"sK\u0006$\u0018n\u001c8\u00025\u0011|\u0017\t\u001a3OK^\u001cF/Y6f\u00076$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}$\u0006BA\r\u0003\u0003[#!a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\u0013\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011SAD\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019G\",7m[$fi2K7\u000f^(g\r>\u0014x-\u001a:t\u00076$G\u0003BA\u0003\u0003/CQ\u0001 \nA\u0002u\facZ3u\u0019&\u001cHo\u00144G_J<WM]:Ti\u0006\\Wm\u001d\u000b\u0005\u0003;\u000bY\f\u0005\u0004\u0002 \u0006=\u0016Q\u0017\b\u0005\u0003C\u000bYK\u0004\u0003\u0002$\u0006%VBAAS\u0015\r\t9kR\u0001\u0007yI|w\u000e\u001e \n\u0003MK1!!,S\u0003\u001d\u0001\u0018mY6bO\u0016LA!!-\u00024\n\u00191+Z9\u000b\u0007\u00055&\u000bE\u0002K\u0003oK1!!/@\u0005]\t5mY8v]R4uN]4j]\u001e\u001cF/Y6f\u0013:4w\u000eC\u0004\u0002\u000eM\u0001\r!a\u0004\u0002I\u0011|WK\\2iK\u000e\\W\rZ$fi2K7\u000f^(g\r>\u0014x-\u001a:t'R\f7.Z:D[\u0012$2\u0001]Aa\u0011\u001d\ti\u0001\u0006a\u0001\u0003\u001f\tQ\u0003Z8HKRd\u0015n\u001d;PM\u001a{'oZ3sg\u000ekG\rF\u0003q\u0003\u000f\fI\rC\u0003}+\u0001\u0007Q\u0010C\u0004\u0002\u000eU\u0001\r!a\u0004\u0002!\u0011|'+Z7pm\u0016\u001cF/Y6f\u00076$G#\u00029\u0002P\u0006E\u0007\"\u0002?\u0017\u0001\u0004i\bbBA\u0007-\u0001\u0007\u0011qB\u0001\u001bO\u0016$\u0018\t\u001c7po\u0016$gi\u001c:hKJ\u001c\u0018J\u001c3fq2K7\u000f\u001e\u000b\u0004a\u0006]\u0007bBA\u0007/\u0001\u0007\u0011qB\u0001\u0019I>|\u0005/\u001a8Ti\u0006\\WMR8sO\u0016\u0014H*[:u\u00076$G#\u00029\u0002^\u0006}\u0007\"\u0002?\u0019\u0001\u0004i\bbBA\u00071\u0001\u0007\u0011qB\u0001\baJ|7-Z:t)%\u0001\u0018Q]At\u0003S\f\u0019\u0010C\u0003}3\u0001\u0007Q\u0010C\u0004\u0002\u000ee\u0001\r!a\u0004\t\u000f\u0005-\u0018\u00041\u0001\u0002n\u0006\u0019q-Y:\u0011\u0007)\u000by/C\u0002\u0002r~\u0012qaR1t!>|G\u000eC\u0004\u0002vf\u0001\r!a>\u0002\u0019\tdwnY6D_:$X\r\u001f;\u0011\u0007)\u000bI0C\u0002\u0002|~\u0012AB\u00117pG.\u001cuN\u001c;fqRDS!GA\u0000\u0005\u0017\u0001R!\u0015B\u0001\u0005\u000bI1Aa\u0001S\u0005\u0019!\bN]8xgB\u0019!Ja\u0002\n\u0007\t%qH\u0001\rFq\u0016\u001cW\u000f^5p]\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u001c#A!\u0002\u0002\u001b\u0019Lg\u000eZ*uC.,G)\u0019;b)\u0019\u0011\tB!\b\u0003 A)\u0011Ka\u0005\u0003\u0018%\u0019!Q\u0003*\u0003\r=\u0003H/[8o!\rQ%\u0011D\u0005\u0004\u00057y$a\u0004$pe\u001e,'o\u0015;bW\u0016$\u0015\r^1\t\u000f\u00055!\u00041\u0001\u0002\u0010!1\u00111\u0005\u000eA\u0002A\f\u0001#[:G_J<WM\u001d'jgR|\u0005/\u001a8\u0015\t\u0005e!Q\u0005\u0005\b\u0003\u001bY\u0002\u0019AA\b\u0003eI7OR8sO\u0016\u0014H*[:u\u001fB,g.\u00168dQ\u0016\u001c7.\u001a3\u0015\t\u0005e!1\u0006\u0005\u0007\u0005[a\u0002\u0019\u00019\u0002\t1L7\u000f^\u0001\u001cO\u0016$\u0018\t\u001c7po\u0016$gi\u001c:hKJd\u0015n\u001d;J]\u0012,\u00070Z:\u0015\t\tM\"1\b\t\u0007\u0003?\u000byK!\u000e\u0011\u0007E\u00139$C\u0002\u0003:I\u00131!\u00138u\u0011\u001d\ti!\ba\u0001\u0003\u001f\tAaY8qsR\u00191M!\u0011\t\u000fes\u0002\u0013!a\u00017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B$U\rY\u0016\u0011Q\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t5\u0003\u0003\u0002B(\u0005+j!A!\u0015\u000b\t\tM\u0013qK\u0001\u0005Y\u0006tw-\u0003\u0003\u0003X\tE#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00036\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B1\u0005O\u00022!\u0015B2\u0013\r\u0011)G\u0015\u0002\u0004\u0003:L\b\"\u0003B5E\u0005\u0005\t\u0019\u0001B\u001b\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u000e\t\u0007\u0005c\u00129H!\u0019\u000e\u0005\tM$b\u0001B;%\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te$1\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u001a\t}\u0004\"\u0003B5I\u0005\u0005\t\u0019\u0001B1\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u001b\u0003!!xn\u0015;sS:<GC\u0001B'\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0004BG\u0011%\u0011IgJA\u0001\u0002\u0004\u0011\t'A\fG_J<WM]*uC.,Wj]4Qe>\u001cWm]:peB\u0011!*K\n\u0005S\tUe\u000bE\u0002R\u0005/K1A!'S\u0005\u0019\te.\u001f*fMR\u0011!\u0011S\u0001\u0011\u0019&t7.\u001a3MSN$H+\u001b9LKf\f\u0011\u0003T5oW\u0016$G*[:u)&\u00048*Z=!\u0003Ma\u0015N\\6fI2K7\u000f\u001e(vY24\u0016\r\\;f\u0003Qa\u0015N\\6fI2K7\u000f\u001e(vY24\u0016\r\\;fA\u0005I\"+Z:ue&\u001cG/\u001a3G_J<WM\u001d$mC\u001e\u001cH*[:u\u0003i\u0011Vm\u001d;sS\u000e$X\r\u001a$pe\u001e,'O\u00127bONd\u0015n\u001d;!\u0003M9U\r\u001e'jgR|eMR8sO\u0016\u00148oQ7e+\t\u0011i\u000b\u0005\u0003\u00030\n]f\u0002\u0002BY\u0005g\u00032!a)S\u0013\r\u0011)LU\u0001\u0007!J,G-\u001a4\n\t\t]#\u0011\u0018\u0006\u0004\u0005k\u0013\u0016\u0001F$fi2K7\u000f^(g\r>\u0014x-\u001a:t\u00076$\u0007%\u0001\bBI\u0012tUm^*uC.,7)\u001c3\u0002\u001f\u0005#GMT3x'R\f7.Z\"nI\u0002\naBU3n_Z,7\u000b^1lK\u000ekG-A\bSK6|g/Z*uC.,7)\u001c3!\u0003Yy\u0005/\u001a8Ti\u0006\\WMR8sO\u0016\u0014H*[:u\u00076$\u0017aF(qK:\u001cF/Y6f\r>\u0014x-\u001a:MSN$8)\u001c3!\u0003y9W\r\u001e*f[>4Xm\u0015;bW\u0016\u001cU\u000eZ'fgN\fw-\u001a+p'&<g\u000eF\u0004q\u0005\u001b\u0014yMa5\t\r\u0005\r\u0012\b1\u0001q\u0011\u0019\u0011\t.\u000fa\u0001O\u0006!aM]8n\u0011\u0019\u0011).\u000fa\u0001a\u0006)an\u001c8dK\u00061s-\u001a;Pa\u0016t7\u000b^1lK\u001a{'oZ3s\u0019&\u001cHoQ7e\u001b\u0016\u001c8/Y4f)>\u001c\u0016n\u001a8\u0015\u000fA\u0014YNa8\u0003b\"9!Q\u001c\u001eA\u0002\tU\u0012a\u00034pe\u001e,'/\u00138eKbDaA!5;\u0001\u00049\u0007B\u0002Bku\u0001\u0007\u0001/A\u0003baBd\u0017\u0010F\u0002d\u0005ODQ!W\u001eA\u0002m\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003n\n=\b\u0003B)\u0003\u0014mC\u0001B!==\u0003\u0003\u0005\raY\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa>\u0011\t\t=#\u0011`\u0005\u0005\u0005w\u0014\tF\u0001\u0004PE*,7\r\u001e")
public class ForgerStakeMsgProcessor
extends NativeSmartContractMsgProcessor
implements ForgerStakesProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;
    private final NetworkParams networkParams;

    public static Option<NetworkParams> unapply(ForgerStakeMsgProcessor forgerStakeMsgProcessor) {
        return ForgerStakeMsgProcessor$.MODULE$.unapply(forgerStakeMsgProcessor);
    }

    public static ForgerStakeMsgProcessor apply(NetworkParams networkParams) {
        return ForgerStakeMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static byte[] getOpenStakeForgerListCmdMessageToSign(int n, Address address, byte[] byArray) {
        return ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(n, address, byArray);
    }

    public static byte[] getRemoveStakeCmdMessageToSign(byte[] byArray, Address address, byte[] byArray2) {
        return ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(byArray, address, byArray2);
    }

    public static String OpenStakeForgerListCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
    }

    public static String RemoveStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
    }

    public static String AddNewStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
    }

    public static String GetListOfForgersCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
    }

    public static byte[] RestrictedForgerFlagsList() {
        return ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList();
    }

    public static byte[] LinkedListNullValue() {
        return ForgerStakeMsgProcessor$.MODULE$.LinkedListNullValue();
    }

    public static byte[] LinkedListTipKey() {
        return ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    public NetworkParams networkParams() {
        return this.networkParams;
    }

    public byte[] getStakeId(Message msg) {
        return Keccak256$.MODULE$.hash(Bytes.concat((byte[][])new byte[][]{msg.getFrom().toBytes(), msg.getNonce().toByteArray(), msg.getValue().toByteArray(), msg.getData()}));
    }

    @Override
    public void init(BaseAccountStateView view) {
        super.init(view);
        byte[] initialTip = view.getAccountStorage(this.contractAddress(), ForgerStakeLinkedList$.MODULE$.LinkedListTipKey());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("initial tip already set");
        }
        view.updateAccountStorage(this.contractAddress(), ForgerStakeLinkedList$.MODULE$.LinkedListTipKey(), ForgerStakeLinkedList$.MODULE$.LinkedListNullValue());
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("restrictForgerList already set");
        }
    }

    public boolean existsStakeData(BaseAccountStateView view, byte[] stakeId) {
        byte[] data = view.getAccountStorage(this.contractAddress(), stakeId);
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    public void addForgerStake(BaseAccountStateView view, byte[] stakeId, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, Address ownerPublicKey, BigInteger stakedAmount) {
        ForgerStakeLinkedList$.MODULE$.addNewNodeToList(view, stakeId);
        ForgerStakeData forgerStakeData = new ForgerStakeData(new ForgerPublicKeys(blockSignProposition, vrfPublicKey), new AddressProposition(ownerPublicKey), stakedAmount);
        view.updateAccountStorageBytes(this.contractAddress(), stakeId, ForgerStakeDataSerializer$.MODULE$.toBytes(forgerStakeData));
    }

    public void removeForgerStake(BaseAccountStateView view, byte[] stakeId) {
        byte[] nodeToRemoveId = Blake2b256$.MODULE$.hash(stakeId);
        LinkedListNode nodeToRemove = (LinkedListNode)ForgerStakeLinkedList$.MODULE$.findLinkedListNode(view, nodeToRemoveId).get();
        ForgerStakeLinkedList$.MODULE$.modifyNode(view, nodeToRemove.previousNodeKey(), (Function1<LinkedListNode, LinkedListNode>)(Function1 & Serializable & scala.Serializable)previousNode -> new LinkedListNode(previousNode.dataKey(), previousNode.previousNodeKey(), nodeToRemove.nextNodeKey()));
        ForgerStakeLinkedList$.MODULE$.modifyNode(view, nodeToRemove.nextNodeKey(), (Function1<LinkedListNode, LinkedListNode>)(Function1 & Serializable & scala.Serializable)nextNode -> new LinkedListNode(nextNode.dataKey(), nodeToRemove.previousNodeKey(), nextNode.nextNodeKey())).getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> view.updateAccountStorage(this.contractAddress(), ForgerStakeLinkedList$.MODULE$.LinkedListTipKey(), nodeToRemove.previousNodeKey()));
        view.removeAccountStorageBytes(this.contractAddress(), stakeId);
        view.removeAccountStorageBytes(this.contractAddress(), nodeToRemoveId);
    }

    @Override
    public byte[] addScCreationForgerStake(Message msg, BaseAccountStateView view) {
        return this.doAddNewStakeCmd(msg, view, true);
    }

    public byte[] doAddNewStakeCmd(Message msg, BaseAccountStateView view, boolean isGenesisScCreation) {
        BoxedUnit boxedUnit;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        if (msg.getValue().signum() <= 0) {
            throw new ExecutionRevertedException("Value must not be zero");
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(msg.getValue())) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Value is not a legal wei amount: ").append(msg.getValue().toString()).toString());
        }
        if (!view.accountExists(msg.getFrom()) && !isGenesisScCreation) {
            throw new ExecutionRevertedException(new StringBuilder(31).append("Sender account does not exist: ").append(msg.getFrom()).toString());
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        AddNewStakeCmdInput cmdInput = (AddNewStakeCmdInput)AddNewStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        PublicKey25519Proposition blockSignPublicKey = cmdInput.forgerPublicKeys().blockSignPublicKey();
        VrfPublicKey vrfPublicKey = cmdInput.forgerPublicKeys().vrfPublicKey();
        Address ownerAddress = cmdInput.ownerAddress();
        if (!view.isEoaAccount(cmdInput.ownerAddress())) {
            throw new ExecutionRevertedException("Owner account is not an EOA");
        }
        if (!(isGenesisScCreation || this.isForgerListOpen(view) || this.networkParams().allowedForgersList().contains((Object)new Tuple2((Object)blockSignPublicKey, (Object)vrfPublicKey)))) {
            throw new ExecutionRevertedException("Forger is not in the allowed list");
        }
        byte[] newStakeId = this.getStakeId(msg);
        if (this.existsStakeData(view, newStakeId)) {
            throw new ExecutionRevertedException(new StringBuilder(21).append("Stake ").append(BytesUtils.toHexString(newStakeId)).append(" already exists").toString());
        }
        BigInteger stakedAmount = msg.getValue();
        this.addForgerStake(view, newStakeId, blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Added stake to stateDb: newStakeId={}, blockSignPublicKey={}, vrfPublicKey={}, ownerAddress={}, stakedAmount={}", new Object[]{BytesUtils.toHexString(newStakeId), blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DelegateForgerStake addNewStakeEvt = DelegateForgerStake$.MODULE$.apply(msg.getFrom(), ownerAddress, newStakeId, stakedAmount);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewStakeEvt);
        view.addLog(evmLog);
        if (isGenesisScCreation) {
            view.addBalance(this.contractAddress(), stakedAmount);
        } else {
            view.subBalance(msg.getFrom(), stakedAmount);
            view.addBalance(this.contractAddress(), stakedAmount);
        }
        return newStakeId;
    }

    public boolean doAddNewStakeCmd$default$3() {
        return false;
    }

    private void checkGetListOfForgersCmd(Message msg) {
        if (ABIUtil.getArgumentsFromData(msg.getData()).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(msg.getData().length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(BaseAccountStateView view) {
        void var3_2;
        Seq stakeList = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), ForgerStakeLinkedList$.MODULE$.LinkedListTipKey());
        while (!ForgerStakeLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
            AccountForgingStakeInfo accountForgingStakeInfo;
            byte[] prevNodeReference;
            block4: {
                Tuple2<AccountForgingStakeInfo, byte[]> tuple2;
                block3: {
                    tuple2 = ForgerStakeLinkedList$.MODULE$.getListItem(view, nodeReference);
                    if (tuple2 == null) break block3;
                    AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple2._1();
                    prevNodeReference = (byte[])tuple2._2();
                    if (item == null) break block3;
                    accountForgingStakeInfo = item;
                    if (prevNodeReference != null) break block4;
                }
                throw new MatchError(tuple2);
            }
            byte[] byArray = prevNodeReference;
            Tuple2 tuple2 = new Tuple2((Object)accountForgingStakeInfo, (Object)byArray);
            Tuple2 tuple22 = tuple2;
            AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple22._1();
            byte[] prevNodeReference2 = (byte[])tuple22._2();
            AccountForgingStakeInfo accountForgingStakeInfo2 = item;
            stakeList = (Seq)stakeList.$plus$colon((Object)accountForgingStakeInfo2, Seq$.MODULE$.canBuildFrom());
            nodeReference = prevNodeReference2;
        }
        return var3_2;
    }

    public byte[] doUncheckedGetListOfForgersStakesCmd(BaseAccountStateView view) {
        Seq<AccountForgingStakeInfo> stakeList = this.getListOfForgersStakes(view);
        return AccountForgingStakeInfoListEncoder$.MODULE$.encode((List)JavaConverters$.MODULE$.seqAsJavaListConverter(stakeList).asJava());
    }

    public byte[] doGetListOfForgersCmd(Message msg, BaseAccountStateView view) {
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        this.checkGetListOfForgersCmd(msg);
        return this.doUncheckedGetListOfForgersStakesCmd(view);
    }

    public byte[] doRemoveStakeCmd(Message msg, BaseAccountStateView view) {
        boolean result;
        byte[] msgToSign;
        ForgerStakeData stakeData;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        RemoveStakeCmdInput cmdInput = (RemoveStakeCmdInput)RemoveStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        byte[] stakeId = cmdInput.stakeId();
        SignatureSecp256k1 signature = cmdInput.signature();
        Try try_ = Try$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ForgerStakeMsgProcessor.$anonfun$doRemoveStakeCmd$2(signature, stakeData = (ForgerStakeData)this.findStakeData(view, stakeId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("No such stake id in state-db");
        }), msgToSign = ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(stakeId, msg.getFrom(), msg.getNonce().toByteArray()))));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(39).append("Could not verify ill-formed signature: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        boolean bl = result = BoxesRunTime.unboxToBoolean((Object)success.value());
        boolean isValid = bl;
        if (!isValid) {
            throw new ExecutionRevertedException("Invalid signature");
        }
        this.removeForgerStake(view, stakeId);
        WithdrawForgerStake removeStakeEvt = WithdrawForgerStake$.MODULE$.apply(stakeData.ownerPublicKey().address(), stakeId);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(removeStakeEvt);
        view.addLog(evmLog);
        view.subBalance(this.contractAddress(), stakeData.stakedAmount());
        view.addBalance(stakeData.ownerPublicKey().address(), stakeData.stakedAmount());
        return stakeId;
    }

    private byte[] getAllowedForgersIndexList(BaseAccountStateView view) {
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new IllegalStateException("Illegal call when list of forger is empty");
        }
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32())) ? new byte[this.networkParams().allowedForgersList().size()] : view.getAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
    }

    public byte[] doOpenStakeForgerListCmd(Message msg, BaseAccountStateView view) {
        byte[] msgToSign;
        if (!this.networkParams().restrictForgers()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is not restricted");
        }
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is empty");
        }
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        OpenStakeForgerListCmdInput cmdInput = (OpenStakeForgerListCmdInput)OpenStakeForgerListCmdInputDecoder$.MODULE$.decode(inputParams);
        int forgerIndex = cmdInput.forgerIndex();
        Signature25519 signature = cmdInput.signature();
        if (this.networkParams().allowedForgersList().size() < forgerIndex + 1) {
            throw new ExecutionRevertedException(new StringBuilder(46).append("Invalid forgerIndex=").append(forgerIndex).append(": allowedForgersList size=").append(this.networkParams().allowedForgersList().size()).toString());
        }
        PublicKey25519Proposition blockSignerProposition = (PublicKey25519Proposition)((Tuple2)this.networkParams().allowedForgersList().apply(forgerIndex))._1();
        if (!signature.isValid(blockSignerProposition, msgToSign = ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(forgerIndex, msg.getFrom(), msg.getNonce().toByteArray()))) {
            throw new ExecutionRevertedException(new StringBuilder(69).append("Invalid signature, could not validate against blockSignerProposition=").append(blockSignerProposition).toString());
        }
        byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
        if (this.isForgerListOpenUnchecked(restrictForgerList)) {
            throw new ExecutionRevertedException("Forger list already open");
        }
        if (restrictForgerList[forgerIndex] == 1) {
            throw new ExecutionRevertedException("Forger index already processed");
        }
        restrictForgerList[forgerIndex] = 1;
        view.updateAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList(), restrictForgerList);
        OpenForgerList addOpenStakeForgerListEvt = OpenForgerList$.MODULE$.apply(forgerIndex, msg.getFrom(), blockSignerProposition);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addOpenStakeForgerListEvt);
        view.addLog(evmLog);
        return restrictForgerList;
    }

    @Override
    public byte[] process(Message msg, BaseAccountStateView view, GasPool gas, BlockContext blockContext) throws ExecutionFailedException {
        byte[] byArray;
        BaseAccountStateView gasView = view.getGasTrackedView(gas);
        String string = ABIUtil.getFunctionSignature(msg.getData());
        String string2 = ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byArray = this.doGetListOfForgersCmd(msg, gasView);
        } else {
            String string4 = ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.doAddNewStakeCmd(msg, gasView, this.doAddNewStakeCmd$default$3());
            } else {
                String string6 = ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    byArray = this.doRemoveStakeCmd(msg, gasView);
                } else {
                    String string8 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        byArray = this.doOpenStakeForgerListCmd(msg, gasView);
                    } else {
                        throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                    }
                }
            }
        }
        return byArray;
    }

    @Override
    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId) {
        return ForgerStakeLinkedList$.MODULE$.findStakeData(view, stakeId);
    }

    @Override
    public boolean isForgerListOpen(BaseAccountStateView view) {
        boolean bl;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            bl = this.isForgerListOpenUnchecked(restrictForgerList);
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isForgerListOpenUnchecked(byte[] list) {
        return BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(list)).sum((Numeric)Numeric.ByteIsIntegral$.MODULE$)) > list.length / 2;
    }

    @Override
    public Seq<Object> getAllowedForgerListIndexes(BaseAccountStateView view) {
        Seq seq;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            seq = (Seq)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToByte((Object)x$3)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    public ForgerStakeMsgProcessor copy(NetworkParams params) {
        return new ForgerStakeMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "ForgerStakeMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ForgerStakeMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ForgerStakeMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ForgerStakeMsgProcessor forgerStakeMsgProcessor = (ForgerStakeMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = forgerStakeMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!forgerStakeMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveStakeCmd$2(SignatureSecp256k1 signature$1, ForgerStakeData stakeData$1, byte[] msgToSign$1) {
        return signature$1.isValid(stakeData$1.ownerPublicKey(), msgToSign$1);
    }

    public ForgerStakeMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("ForgerStakeSmartContractCode");
        this.networkParams = params;
    }
}

