/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeDataSerializer$;
import io.horizen.account.state.LinkedListNode;
import io.horizen.account.state.LinkedListNodeSerializer$;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import org.web3j.utils.Numeric;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.crypto.hash.Blake2b256$;

public final class ForgerStakeLinkedList$ {
    public static ForgerStakeLinkedList$ MODULE$;
    private final byte[] LinkedListTipKey;
    private final byte[] LinkedListNullValue;

    static {
        new ForgerStakeLinkedList$();
    }

    public byte[] LinkedListTipKey() {
        return this.LinkedListTipKey;
    }

    public byte[] LinkedListNullValue() {
        return this.LinkedListNullValue;
    }

    public Option<LinkedListNode> findLinkedListNode(BaseAccountStateView view, byte[] nodeId) {
        None$ none$;
        byte[] data = view.getAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), nodeId);
        if (data.length == 0) {
            none$ = None$.MODULE$;
        } else {
            Try<LinkedListNode> try_ = LinkedListNodeSerializer$.MODULE$.parseBytesTry(data);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ExecutionRevertedException("Error while parsing forger info.", exception);
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            LinkedListNode obj = (LinkedListNode)success.value();
            Some some = new Some((Object)obj);
            none$ = some;
        }
        return none$;
    }

    public void addNewNodeToList(BaseAccountStateView view, byte[] stakeId) {
        byte[] oldTip = view.getAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.LinkedListTipKey());
        byte[] newTip = Blake2b256$.MODULE$.hash(stakeId);
        this.modifyNode(view, oldTip, (Function1<LinkedListNode, LinkedListNode>)(Function1 & Serializable & scala.Serializable)previousNode -> new LinkedListNode(previousNode.dataKey(), previousNode.previousNodeKey(), newTip));
        view.updateAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.LinkedListTipKey(), newTip);
        view.updateAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), newTip, LinkedListNodeSerializer$.MODULE$.toBytes(new LinkedListNode(stakeId, oldTip, this.LinkedListNullValue())));
    }

    public Option<BoxedUnit> modifyNode(BaseAccountStateView view, byte[] nodeId, Function1<LinkedListNode, LinkedListNode> modify) {
        if (this.linkedListNodeRefIsNull(nodeId)) {
            return None$.MODULE$;
        }
        return this.findLinkedListNode(view, nodeId).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException(new StringBuilder(23).append("Failed to update node: ").append(Numeric.toHexString((byte[])nodeId)).toString());
        }).map(modify).map((Function1 & Serializable & scala.Serializable)obj -> LinkedListNodeSerializer$.MODULE$.toBytes(obj)).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            view.updateAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), nodeId, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId) {
        None$ none$;
        byte[] data = view.getAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId);
        if (data.length == 0) {
            none$ = None$.MODULE$;
        } else {
            Try<ForgerStakeData> try_ = ForgerStakeDataSerializer$.MODULE$.parseBytesTry(data);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ExecutionRevertedException("Error while parsing forger data.", exception);
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            ForgerStakeData obj = (ForgerStakeData)success.value();
            Some some = new Some((Object)obj);
            none$ = some;
        }
        return none$;
    }

    public Tuple2<AccountForgingStakeInfo, byte[]> getListItem(BaseAccountStateView view, byte[] tip) {
        if (this.linkedListNodeRefIsNull(tip)) {
            throw new ExecutionRevertedException("Tip has the null value, no list here");
        }
        LinkedListNode node = (LinkedListNode)this.findLinkedListNode(view, tip).get();
        ForgerStakeData stakeData = (ForgerStakeData)this.findStakeData(view, node.dataKey()).get();
        AccountForgingStakeInfo listItem = new AccountForgingStakeInfo(node.dataKey(), new ForgerStakeData(new ForgerPublicKeys(stakeData.forgerPublicKeys().blockSignPublicKey(), stakeData.forgerPublicKeys().vrfPublicKey()), stakeData.ownerPublicKey(), stakeData.stakedAmount()));
        byte[] prevNodeKey = node.previousNodeKey();
        return new Tuple2((Object)listItem, (Object)prevNodeKey);
    }

    public boolean linkedListNodeRefIsNull(byte[] ref) {
        return BytesUtils.toHexString(ref).equals(BytesUtils.toHexString(this.LinkedListNullValue()));
    }

    private ForgerStakeLinkedList$() {
        MODULE$ = this;
        this.LinkedListTipKey = Blake2b256$.MODULE$.hash("Tip");
        this.LinkedListNullValue = Blake2b256$.MODULE$.hash("Null");
    }
}

