/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.horizen.certnative.BackwardTransfer;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AbstractState;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.history.validation.InvalidTransactionChainIdException;
import io.horizen.account.history.validation.InvalidTransactionChainIdException$;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.SenderNotEoaException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountFeePaymentsUtils$;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.account.utils.Secp256k1;
import io.horizen.block.MainchainBackwardTransferCertificateOutput;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.evm.Address;
import io.horizen.evm.Database;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.StateDB;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.state.State;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ClosableResourceHandler;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.package$;
import sparkz.core.transaction.Transaction;
import sparkz.core.transaction.state.TransactionValidation;
import sparkz.core.utils.NetworkTimeProvider;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u00115c\u0001B A\u0001%C!\"a\b\u0001\u0005\u000b\u0007I\u0011AA\u0011\u0011)\ti\u0003\u0001B\u0001B\u0003%\u00111\u0005\u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005E\u0002BCA\u001e\u0001\t\u0005\t\u0015!\u0003\u0002>!Q\u00111\t\u0001\u0003\u0006\u0004%\t%!\u0012\t\u0015\u0005\r\u0004A!A!\u0002\u0013\t9\u0005\u0003\u0006\u0002f\u0001\u0011\t\u0011)A\u0005\u0003OB!\"a\u001d\u0001\u0005\u0003\u0005\u000b\u0011BA;\u0011)\t\t\t\u0001B\u0001B\u0003%\u00111\u0011\u0005\b\u0003;\u0003A\u0011AAP\u000b\u0015\ty\u000b\u0001\u0011j\u0011\u001d\t\t\f\u0001C\u0005\u0003gCq!a1\u0001\t\u0003\n)\rC\u0004\u0002L\u0002!I!!4\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u00111 \u0001\u0005B\u0005u\bb\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0005\b\u0005+\u0001A\u0011\tB\f\u0011\u001d\u0011y\u0002\u0001C!\u0005CAqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u0003>\u0001!\tEa\u0010\t\u000f\t5\u0003\u0001\"\u0011\u0003P!9!q\r\u0001\u0005B\t%\u0004b\u0002BF\u0001\u0011\u0005#Q\u0012\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u0011y\n\u0001C!\u0005CCqA!.\u0001\t\u0003\u00129\fC\u0004\u0003@\u0002!\tE!1\t\u000f\t\u0015\u0007\u0001\"\u0011\u0003H\"9!\u0011\u001a\u0001\u0005B\t-\u0007\"\u0003Bt\u0001E\u0005I\u0011\u0001Bu\u0011\u001d\u0011y\u0010\u0001C!\u0007\u0003Aqaa\u0001\u0001\t\u0003\u001a)\u0001C\u0004\u0004&\u0001!\tea\n\t\u000f\rM\u0002\u0001\"\u0011\u00046!911\t\u0001\u0005B\r\u0015\u0003bBB1\u0001\u0011\u000531\r\u0005\b\u0007K\u0002A\u0011IB4\u0011\u001d\u0019Y\u0007\u0001C!\u0007[Bqa!\u001d\u0001\t\u0003\u001a\u0019\bC\u0004\u0004~\u0001!\tea \t\u000f\r\r\u0005\u0001\"\u0011\u0004\u0006\"911\u0015\u0001\u0005B\r\u0015\u0006bBB]\u0001\u0011\u000531\r\u0005\b\u0007w\u0003A\u0011IB_\u0011\u001d\u0019\t\r\u0001C!\u0007\u0007Dqa!2\u0001\t\u0003\u001a9\rC\u0004\u0004T\u0002!\te!6\t\u000f\ru\u0007\u0001\"\u0011\u0004`\"91q\u001d\u0001\u0005B\r%\bbBBx\u0001\u0011\u00053\u0011\u001f\u0005\b\u0007k\u0004A\u0011IB|\u0011\u001d\u0019Y\u0010\u0001C!\u0007{Dq\u0001\"\u0001\u0001\t\u0003\"\u0019\u0001C\u0004\u0005\f\u0001!\t\u0005\"\u0004\t\u000f\u0011=\u0001\u0001\"\u0011\u0005\u000e!9A\u0011\u0003\u0001\u0005B\u0011Mqa\u0002C\r\u0001\"\u0005A1\u0004\u0004\u0007\u007f\u0001C\t\u0001\"\b\t\u000f\u0005u5\b\"\u0001\u0005&!AAqE\u001e\u0005\u0002\u0011#I\u0003\u0003\u0005\u0005:m\"\t\u0001\u0012C\u001e\u00051\t5mY8v]R\u001cF/\u0019;f\u0015\t\t%)A\u0003ti\u0006$XM\u0003\u0002D\t\u00069\u0011mY2pk:$(BA#G\u0003\u001dAwN]5{K:T\u0011aR\u0001\u0003S>\u001c\u0001aE\u0005\u0001\u0015.\u001cX0a\u0002\u0002\u0014A11\n\u0014(aM&l\u0011\u0001R\u0005\u0003\u001b\u0012\u0013Q\"\u00112tiJ\f7\r^*uCR,\u0007\u0003B(S)jk\u0011\u0001\u0015\u0006\u0003#\n\u000b1\u0002\u001e:b]N\f7\r^5p]&\u00111\u000b\u0015\u0002\u0013\u0003\u000e\u001cw.\u001e8u)J\fgn]1di&|g\u000e\u0005\u0002V16\taK\u0003\u0002X\t\u0006Y\u0001O]8q_NLG/[8o\u0013\tIfKA\u0006Qe>\u0004xn]5uS>t\u0007cA._)6\tAL\u0003\u0002^\t\u0006)\u0001O]8pM&\u0011q\f\u0018\u0002\u0006!J|wN\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\n\u000bQA\u00197pG.L!!\u001a2\u0003%\u0005\u001b7m\\;oi\ncwnY6IK\u0006$WM\u001d\t\u0003C\u001eL!\u0001\u001b2\u0003\u0019\u0005\u001b7m\\;oi\ncwnY6\u0011\u0005)\u0004Q\"\u0001!\u0011\r1tgJ\u001a9j\u001b\u0005i'BA!E\u0013\tyWNA\u0003Ti\u0006$X\r\u0005\u0002kc&\u0011!\u000f\u0011\u0002\u0011\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a,jK^\u00042\u0001^>O\u001b\u0005)(BA!w\u0015\t\tvO\u0003\u0002ys\u0006!1m\u001c:f\u0015\u0005Q\u0018AB:qCJ\\'0\u0003\u0002}k\n)BK]1og\u0006\u001cG/[8o-\u0006d\u0017\u000eZ1uS>t\u0007c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\t\u000bAA\\8eK&\u0019\u0011QA@\u0003!9{G-Z!dG>,h\u000e^*uCR,\u0007\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055A)A\u0003vi&d7/\u0003\u0003\u0002\u0012\u0005-!aF\"m_N\f'\r\\3SKN|WO]2f\u0011\u0006tG\r\\3s!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rs\u0006!Q\u000f^5m\u0013\u0011\ti\"a\u0006\u0003\u001bM\u0003\u0018M]6{\u0019><w-\u001b8h\u0003\u0019\u0001\u0018M]1ngV\u0011\u00111\u0005\t\u0005\u0003K\tI#\u0004\u0002\u0002()\u0019\u0011q\u0004#\n\t\u0005-\u0012q\u0005\u0002\u000e\u001d\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:\u0002\u000fA\f'/Y7tA\u0005aA/[7f!J|g/\u001b3feB!\u00111GA\u001c\u001b\t\t)DC\u0002\u0002\u000e]LA!!\u000f\u00026\t\u0019b*\u001a;x_J\\G+[7f!J|g/\u001b3fe\u0006\t\"\r\\8dW\"\u000b7\u000f\u001b)s_ZLG-\u001a:\u0011\u0007)\fy$C\u0002\u0002B\u0001\u0013\u0001\u0004S5ti>\u0014\u0018P\u00117pG.D\u0015m\u001d5Qe>4\u0018\u000eZ3s\u0003\u001d1XM]:j_:,\"!a\u0012\u0011\t\u0005%\u0013Q\f\b\u0005\u0003\u0017\nIF\u0004\u0003\u0002N\u0005]c\u0002BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0003*\u0001\u0004=e>|GOP\u0005\u0002u&\u0011\u00010_\u0005\u0004\u00037:\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003?\n\tG\u0001\u0006WKJ\u001c\u0018n\u001c8UC\u001eT1!a\u0017x\u0003!1XM]:j_:\u0004\u0013\u0001F:uCR,W*\u001a;bI\u0006$\u0018m\u0015;pe\u0006<W\r\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\tiGQ\u0001\bgR|'/Y4f\u0013\u0011\t\t(a\u001b\u00037\u0005\u001b7m\\;oiN#\u0018\r^3NKR\fG-\u0019;b'R|'/Y4f\u00039\u0019H/\u0019;f\t\n\u001cFo\u001c:bO\u0016\u0004B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003w\"\u0015aA3w[&!\u0011qPA=\u0005!!\u0015\r^1cCN,\u0017!E7fgN\fw-\u001a)s_\u000e,7o]8sgB1\u0011QQAI\u0003/sA!a\"\u0002\u000e:!\u0011qJAE\u0013\t\tY)A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\\\u0005=%BAAF\u0013\u0011\t\u0019*!&\u0003\u0007M+\u0017O\u0003\u0003\u0002\\\u0005=\u0005c\u00016\u0002\u001a&\u0019\u00111\u0014!\u0003!5+7o]1hKB\u0013xnY3tg>\u0014\u0018A\u0002\u001fj]&$h\bF\bj\u0003C\u000b\u0019+!*\u0002(\u0006%\u00161VAW\u0011\u001d\tyB\u0003a\u0001\u0003GAq!a\f\u000b\u0001\u0004\t\t\u0004C\u0004\u0002<)\u0001\r!!\u0010\t\u000f\u0005\r#\u00021\u0001\u0002H!9\u0011Q\r\u0006A\u0002\u0005\u001d\u0004bBA:\u0015\u0001\u0007\u0011Q\u000f\u0005\b\u0003\u0003S\u0001\u0019AAB\u0005\u0011qek\u0011+\u0002\u001d%t\u0017\u000e\u001e)s_\u000e,7o]8sgR!\u0011QWA`!\u0015\t9,a/j\u001b\t\tIL\u0003\u0003\u0002\u001a\u0005=\u0015\u0002BA_\u0003s\u00131\u0001\u0016:z\u0011\u001d\t\t\r\u0004a\u0001\u0003\u000f\na\"\u001b8ji&\fGNV3sg&|g.A\u0007baBd\u00170T8eS\u001aLWM\u001d\u000b\u0005\u0003k\u000b9\r\u0003\u0004\u0002J6\u0001\rAZ\u0001\u0004[>$\u0017!E3wC24uN]4feN\u0014Vm^1sIRA\u0011qZAl\u00033\f\u0019\u000f\u0005\u0003\u0002R\u0006MWBAAH\u0013\u0011\t).a$\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0013t\u0001\u0019\u00014\t\u000f\u0005mg\u00021\u0001\u0002^\u00061Rn\u001c3XSRDGM]1xC2,\u0005o\\2i\u0013:4w\u000e\u0005\u0003\u0002\n\u0005}\u0017\u0002BAq\u0003\u0017\u00111cV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[%oM>Da!!:\u000f\u0001\u0004\u0001\u0018!C:uCR,g+[3x\u0003u1\u0018\r\\5eCR,Gk\u001c9Rk\u0006d\u0017\u000e^=DKJ$\u0018NZ5dCR,GCBAh\u0003W\fI\u0010C\u0004\u0002n>\u0001\r!a<\u0002+Q|\u0007/U;bY&$\u0018pQ3si&4\u0017nY1uKB!\u0011\u0011_A{\u001b\t\t\u0019P\u0003\u0002d\t&!\u0011q_Az\u0005i9\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD7)\u001a:uS\u001aL7-\u0019;f\u0011\u0019\t)o\u0004a\u0001a\u0006I\u0012n]*xSR\u001c\u0007.\u001b8h\u0007>t7/\u001a8tkN,\u0005o\\2i)\u0011\tyP!\u0002\u0011\t\u0005E'\u0011A\u0005\u0005\u0005\u0007\tyIA\u0004C_>dW-\u00198\t\u000f\t\u001d\u0001\u00031\u0001\u0003\n\u0005q!\r\\8dWRKW.Z*uC6\u0004\b\u0003BAi\u0005\u0017IAA!\u0004\u0002\u0010\n!Aj\u001c8h\u0003)\u0011x\u000e\u001c7cC\u000e\\Gk\u001c\u000b\u0005\u0003k\u0013\u0019\u0002C\u0004\u0002DE\u0001\r!a\u0012\u0002!5\f\u0007PU8mY\n\f7m\u001b#faRDWC\u0001B\r!\u0011\t\tNa\u0007\n\t\tu\u0011q\u0012\u0002\u0004\u0013:$\u0018aB4fiZKWm^\u000b\u0002a\u00061r-\u001a;Ti\u0006$X\r\u00122WS\u0016<hI]8n%>|G\u000f\u0006\u0003\u0003(\t5\u0002c\u00016\u0003*%\u0019!1\u0006!\u0003/M#\u0018\r^3EE\u0006\u001b7m\\;oiN#\u0018\r^3WS\u0016<\bb\u0002B\u0018)\u0001\u0007!\u0011G\u0001\ngR\fG/\u001a*p_R\u0004b!!5\u00034\t]\u0012\u0002\u0002B\u001b\u0003\u001f\u0013Q!\u0011:sCf\u0004B!!5\u0003:%!!1HAH\u0005\u0011\u0011\u0015\u0010^3\u0002+\u001d,GoV5uQ\u0012\u0014\u0018m^1m%\u0016\fX/Z:ugR!!\u0011\tB%!\u0019\t))!%\u0003DA\u0019!N!\u0012\n\u0007\t\u001d\u0003IA\tXSRDGM]1xC2\u0014V-];fgRDqAa\u0013\u0016\u0001\u0004\u0011I\"A\bxSRDGM]1xC2,\u0005o\\2i\u0003E\u0011\u0017mY6xCJ$GK]1og\u001a,'o\u001d\u000b\u0005\u0005#\u0012)\u0007\u0005\u0004\u0002\u0006\u0006E%1\u000b\t\u0005\u0005+\u0012\t'\u0004\u0002\u0003X)!!\u0011\fB.\u0003)\u0019WM\u001d;oCRLg/\u001a\u0006\u0004\u000b\nu#B\u0001B0\u0003\r\u0019w.\\\u0005\u0005\u0005G\u00129F\u0001\tCC\u000e\\w/\u0019:e)J\fgn\u001d4fe\"9!1\n\fA\u0002\te\u0011\u0001E6fsJ{G/\u0019;j_:\u0004&o\\8g)!\u0011YG!!\u0003\u0004\n\u001d\u0005CBAi\u0005[\u0012\t(\u0003\u0003\u0003p\u0005=%AB(qi&|g\u000e\u0005\u0003\u0003t\tuTB\u0001B;\u0015\u0011\u00119H!\u001f\u0002\t-,\u0017p\u001d\u0006\u0004\u0005w\"\u0015\u0001F2feRLg-[2bi\u0016\u001cXOY7jiR,'/\u0003\u0003\u0003\u0000\tU$\u0001E&fsJ{G/\u0019;j_:\u0004&o\\8g\u0011\u001d\u0011Ye\u0006a\u0001\u00053AqA!\"\u0018\u0001\u0004\u0011I\"A\u0007j]\u0012,\u0007p\u00144TS\u001etWM\u001d\u0005\b\u0005\u0013;\u0002\u0019\u0001B\r\u0003\u001dYW-\u001f+za\u0016\fabY3si&4\u0017.\u001a:t\u0017\u0016L8\u000f\u0006\u0003\u0003\u0010\n]\u0005CBAi\u0005[\u0012\t\n\u0005\u0003\u0003t\tM\u0015\u0002\u0002BK\u0005k\u0012abQ3si&4\u0017.\u001a:t\u0017\u0016L8\u000fC\u0004\u0003La\u0001\rA!\u0007\u0002=1\f7\u000f^\"feRLg-[2bi\u0016\u0014VMZ3sK:\u001cW\rZ#q_\u000eDWC\u0001BO!\u0019\t\tN!\u001c\u0003\u001a\u0005yB.Y:u\u0007\u0016\u0014H/\u001b4jG\u0006$XmU5eK\u000eD\u0017-\u001b8CY>\u001c7.\u00133\u0015\u0005\t\r\u0006CBAi\u0005[\u0012)\u000b\u0005\u0003\u0003(\n=f\u0002\u0002BU\u0005[sA!!\u0014\u0003,&\u0019\u0011\u0011D=\n\t\u0005m\u0013qC\u0005\u0005\u0005c\u0013\u0019L\u0001\u0006N_\u0012Lg-[3s\u0013\u0012TA!a\u0017\u0002\u0018\u0005Y1-\u001a:uS\u001aL7-\u0019;f)\u0011\u0011ILa/\u0011\r\u0005E'QNAx\u0011\u001d\u0011il\u0007a\u0001\u00053\t\u0011D]3gKJ,gnY3e/&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u0006Ar-\u001a;U_B\fV/\u00197jif\u001cUM\u001d;jM&\u001c\u0017\r^3\u0015\t\te&1\u0019\u0005\b\u0005{c\u0002\u0019\u0001B\r\u0003%A\u0017m]\"fCN,G\r\u0006\u0002\u0002\u0000\u0006\u0011r-\u001a;GK\u0016\u0004\u0016-_7f]R\u001c\u0018J\u001c4p)\u0019\u0011iM!7\u0003\\B1\u0011QQAI\u0005\u001f\u0004BA!5\u0003V6\u0011!1\u001b\u0006\u0004\u0003\u001b\u0011\u0015\u0002\u0002Bl\u0005'\u0014a\"Q2d_VtG\u000fU1z[\u0016tG\u000fC\u0004\u0003Ly\u0001\rA!\u0007\t\u0013\tug\u0004%AA\u0002\t}\u0017\u0001\u00062m_\u000e\\Gk\\!qa\u0016tGMR3f\u0013:4w\u000e\u0005\u0004\u0002R\n5$\u0011\u001d\t\u0005\u0005#\u0014\u0019/\u0003\u0003\u0003f\nM'aE!dG>,h\u000e\u001e\"m_\u000e\\g)Z3J]\u001a|\u0017\u0001H4fi\u001a+W\rU1z[\u0016tGo]%oM>$C-\u001a4bk2$HEM\u000b\u0003\u0005WTCAa8\u0003n.\u0012!q\u001e\t\u0005\u0005c\u0014Y0\u0004\u0002\u0003t*!!Q\u001fB|\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003z\u0006=\u0015AC1o]>$\u0018\r^5p]&!!Q Bz\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017O\u0016$x+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_V\u0011\u0011Q\\\u0001\u0018O\u0016$8i\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJ,\"aa\u0002\u0011\r\u0005E'QNB\u0005!\u0011\u0019Yaa\b\u000f\t\r511\u0004\b\u0005\u0007\u001f\u00199B\u0004\u0003\u0004\u0012\rUa\u0002BA(\u0007'I\u0011aR\u0005\u0003\u000b\u001aK1a!\u0007E\u0003%\u0019wN\\:f]N,8/\u0003\u0003\u0002\\\ru!bAB\r\t&!1\u0011EB\u0012\u0005Q\u0019uN\\:f]N,8/\u00129pG\"tU/\u001c2fe*!\u00111LB\u000f\u0003y9W\r^(sI\u0016\u0014X\r\u001a$pe\u001eLgnZ*uC.,7/\u00138g_N+\u0017\u000f\u0006\u0002\u0004*A1\u0011QQAI\u0007W\u0001Ba!\f\u000405\u00111QD\u0005\u0005\u0007c\u0019iB\u0001\tG_J<\u0017N\\4Ti\u0006\\W-\u00138g_\u0006ar-\u001a;DkJ\u0014XM\u001c;D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|WCAB\u001c!!\t\tn!\u000f\u0003&\u000eu\u0012\u0002BB\u001e\u0003\u001f\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BB\u0017\u0007\u007fIAa!\u0011\u0004\u001e\t\u00112i\u001c8tK:\u001cXo]#q_\u000eD\u0017J\u001c4p\u0003)9W\r\u001e\"bY\u0006t7-\u001a\u000b\u0005\u0007\u000f\u001a9\u0006\u0005\u0003\u0004J\rMSBAB&\u0015\u0011\u0019iea\u0014\u0002\t5\fG\u000f\u001b\u0006\u0003\u0007#\nAA[1wC&!1QKB&\u0005)\u0011\u0015nZ%oi\u0016<WM\u001d\u0005\b\u00073\"\u0003\u0019AB.\u0003\u001d\tG\r\u001a:fgN\u0004B!a\u001e\u0004^%!1qLA=\u0005\u001d\tE\r\u001a:fgN\f1cZ3u\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a*p_R,\"A!\r\u0002\u0017\u001d,GoQ8eK\"\u000b7\u000f\u001b\u000b\u0005\u0005c\u0019I\u0007C\u0004\u0004Z\u0019\u0002\raa\u0017\u0002\u0011\u001d,GOT8oG\u0016$Baa\u0012\u0004p!91\u0011L\u0014A\u0002\rm\u0013AF4fi2K7\u000f^(g\r>\u0014x-\u001a:t'R\f7.Z:\u0016\u0005\rU\u0004CBAC\u0003#\u001b9\bE\u0002k\u0007sJ1aa\u001fA\u0005]\t5mY8v]R4uN]4j]\u001e\u001cF/Y6f\u0013:4w.\u0001\u000bhKR\fE\u000e\\8xK\u00124uN]4fe2K7\u000f^\u000b\u0003\u0007\u0003\u0003b!!\"\u0002\u0012\ne\u0011AE4fi\u001a{'oZ3s'R\f7.\u001a#bi\u0006$Baa\"\u0004\u0010B1\u0011\u0011\u001bB7\u0007\u0013\u00032A[BF\u0013\r\u0019i\t\u0011\u0002\u0010\r>\u0014x-\u001a:Ti\u0006\\W\rR1uC\"91\u0011\u0013\u0016A\u0002\rM\u0015aB:uC.,\u0017\n\u001a\t\u0005\u0007+\u001biJ\u0004\u0003\u0004\u0018\u000ee\u0005\u0003BA(\u0003\u001fKAaa'\u0002\u0010\u00061\u0001K]3eK\u001aLAaa(\u0004\"\n11\u000b\u001e:j]\u001eTAaa'\u0002\u0010\u00069q-\u001a;M_\u001e\u001cH\u0003BBT\u0007k\u0003b!!5\u00034\r%\u0006\u0003BBV\u0007ck!a!,\u000b\u0007\r=\u0006)A\u0004sK\u000e,\u0017\u000e\u001d;\n\t\rM6Q\u0016\u0002\u0019\u000bRDWM]3v[\u000e{gn]3ogV\u001cH)\u0019;b\u0019><\u0007bBB\\W\u0001\u0007!\u0011G\u0001\u0007ibD\u0015m\u001d5\u0002'\u001d,G/\u00138uKJlW\rZ5bi\u0016\u0014vn\u001c;\u0002\u000f\u001d,GoQ8eKR!!\u0011GB`\u0011\u001d\u0019I&\fa\u0001\u00077\nabZ3u\u001d\u0016DHOQ1tK\u001a+W-\u0006\u0002\u0004H\u0005)r-\u001a;Ue\u0006t7/Y2uS>t'+Z2fSB$H\u0003BBe\u0007#\u0004b!!5\u0003n\r-\u0007\u0003BBV\u0007\u001bLAaa4\u0004.\nyQ\t\u001e5fe\u0016,XNU3dK&\u0004H\u000fC\u0004\u00048>\u0002\rA!\r\u0002!\u001d,Go\u0015;bi\u0016$%\rS1oI2,WCABl!\u0011\t9h!7\n\t\rm\u0017\u0011\u0010\u0002\u000f%\u0016\u001cx.\u001e:dK\"\u000bg\u000e\u001a7f\u0003E9W\r^!dG>,h\u000e^*u_J\fw-\u001a\u000b\u0007\u0005c\u0019\toa9\t\u000f\re\u0013\u00071\u0001\u0004\\!91Q]\u0019A\u0002\tE\u0012aA6fs\u00061r-\u001a;BG\u000e|WO\u001c;Ti>\u0014\u0018mZ3CsR,7\u000f\u0006\u0004\u00032\r-8Q\u001e\u0005\b\u00073\u0012\u0004\u0019AB.\u0011\u001d\u0019)O\ra\u0001\u0005c\tQ\"Y2d_VtG/\u0012=jgR\u001cH\u0003BA\u0000\u0007gDqa!\u00174\u0001\u0004\u0019Y&\u0001\u0007jg\u0016{\u0017-Q2d_VtG\u000f\u0006\u0003\u0002\u0000\u000ee\bbBB-i\u0001\u000711L\u0001\u0017SN\u001cV.\u0019:u\u0007>tGO]1di\u0006\u001b7m\\;oiR!\u0011q`B\u0000\u0011\u001d\u0019I&\u000ea\u0001\u00077\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\t\u000b!9\u0001\u0005\u0004\u00028\u0006m\u0016q\u001a\u0005\u0007\t\u00131\u0004\u0019\u0001(\u0002\u0005QD\u0018AG5t/&$\b\u000e\u001a:bo\u0006dW\t]8dQ2\u000b7\u000f^%oI\u0016DXCAA\u0000\u00035I7OR8sO&twm\u00149f]\u0006\u0011R\u000f\u001e=p\u001b\u0016\u00148\u000e\\3Ue\u0016,'k\\8u)\u0011!)\u0002b\u0006\u0011\r\u0005E'Q\u000eB\u0019\u0011\u001d\u0011Y%\u000fa\u0001\u00053\tA\"Q2d_VtGo\u0015;bi\u0016\u0004\"A[\u001e\u0014\u000bm\"y\"a\u0005\u0011\t\u0005EG\u0011E\u0005\u0005\tG\tyI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\t7\tAB]3ti>\u0014Xm\u0015;bi\u0016$b\u0002b\u000b\u0005.\u0011=B\u0011\u0007C\u001a\tk!9\u0004E\u0003\u0002R\n5\u0014\u000eC\u0004\u0002fu\u0002\r!a\u001a\t\u000f\u0005MT\b1\u0001\u0002v!9\u0011\u0011Q\u001fA\u0002\u0005\r\u0005bBA\u0010{\u0001\u0007\u00111\u0005\u0005\b\u0003_i\u0004\u0019AA\u0019\u0011\u001d\tY$\u0010a\u0001\u0003{\t!c\u0019:fCR,w)\u001a8fg&\u001c8\u000b^1uKR\u0001\u0012Q\u0017C\u001f\t\u007f!\t\u0005b\u0011\u0005F\u0011\u001dC\u0011\n\u0005\b\u0003Kr\u0004\u0019AA4\u0011\u001d\t\u0019H\u0010a\u0001\u0003kBq!!!?\u0001\u0004\t\u0019\tC\u0004\u0002 y\u0002\r!a\t\t\u000f\u0005=b\b1\u0001\u00022!9\u00111\b A\u0002\u0005u\u0002B\u0002C&}\u0001\u0007a-\u0001\u0007hK:,7/[:CY>\u001c7\u000e")
public class AccountState
extends AbstractState<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountState>
implements State<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlock, AccountStateView, AccountState>,
TransactionValidation<AccountTransaction<Proposition, Proof<Proposition>>>,
NodeAccountState,
ClosableResourceHandler,
SparkzLogging {
    private final NetworkParams params;
    private final NetworkTimeProvider timeProvider;
    private final HistoryBlockHashProvider blockHashProvider;
    private final String version;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final Database stateDbStorage;
    private final Seq<MessageProcessor> messageProcessors;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public <A extends AutoCloseable, B> B using(A resource, Function1<A, B> fun) {
        return (B)ClosableResourceHandler.using$(this, resource, fun);
    }

    public boolean isValid(Transaction tx) {
        return TransactionValidation.isValid$((TransactionValidation)this, (Transaction)tx);
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> filterValid(Seq<AccountTransaction<Proposition, Proof<Proposition>>> txs) {
        return TransactionValidation.filterValid$((TransactionValidation)this, txs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetworkParams params() {
        return this.params;
    }

    public String version() {
        return this.version;
    }

    public Try<AccountState> io$horizen$account$state$AccountState$$initProcessors(String initialVersion) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)view -> {
            $this.messageProcessors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
                processor.init(view);
                return BoxedUnit.UNIT;
            });
            try {
                view.commit(initialVersion);
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(44).append("Could not commit view with initial version: ").append(initialVersion).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg, t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw t;
            }
            return this;
        }));
    }

    public Try<AccountState> applyModifier(AccountBlock mod) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(package$.MODULE$.versionToBytes(this.version()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray((byte[])package$.MODULE$.idToBytes().apply((Object)mod.parentId()))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Incorrect state version!: ").append(mod.parentId()).append(" found, ").append(this.version()).append(" expected").toString());
            return (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                BoxedUnit boxedUnit;
                if (stateView.hasCeased()) {
                    BoxedUnit boxedUnit2;
                    String errMsg = new StringBuilder(53).append("Can't apply Block ").append(mod.id()).append(", because the sidechain has ceased.").toString();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error(errMsg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    throw new IllegalStateException(errMsg);
                }
                mod.sidechainTransactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                    tx.semanticValidity();
                    return BoxedUnit.UNIT;
                });
                WithdrawalEpochInfo currentWithdrawalEpochInfo = this.getWithdrawalEpochInfo();
                WithdrawalEpochInfo modWithdrawalEpochInfo = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mod, currentWithdrawalEpochInfo, this.params());
                if (this.params().isNonCeasing()) {
                    ((IterableLike)mod.mainchainBlockReferencesData().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.topQualityCertificate()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)cert -> {
                        this.validateTopQualityCertificate(cert, stateView);
                        return BoxedUnit.UNIT;
                    });
                } else if (WithdrawalEpochUtils$.MODULE$.hasReachedCertificateSubmissionWindowEnd(mod, currentWithdrawalEpochInfo, this.params())) {
                    int certReferencedEpochNumber = modWithdrawalEpochInfo.epoch() - 1;
                    Option topQualityCertificateOpt = mod.topQualityCertificateOpt().orElse((Function0 & Serializable & scala.Serializable)() -> stateView.getTopQualityCertificate(certReferencedEpochNumber));
                    Option option = topQualityCertificateOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        WithdrawalEpochCertificate cert2 = (WithdrawalEpochCertificate)some.value();
                        this.validateTopQualityCertificate(cert2, (AccountStateView)stateView);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit4;
                        if (this.log().underlying().isInfoEnabled()) {
                            this.log().underlying().info(new StringBuilder(131).append("In the end of the certificate submission window of epoch ").append(modWithdrawalEpochInfo.epoch()).append(" ").append("there are no certificates referenced to the epoch ").append(certReferencedEpochNumber).append(". Sidechain has ceased.").toString());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        stateView.setCeased();
                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                }
                stateView.updateWithdrawalEpochInfo(modWithdrawalEpochInfo);
                int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params(), mod.timestamp());
                stateView.updateConsensusEpochNumber(consensusEpochNumber);
                mod.mainchainBlockReferencesData().foreach((Function1 & Serializable & scala.Serializable)mcBlockRefData -> {
                    AccountState.$anonfun$applyModifier$8(stateView, mod, mcBlockRefData);
                    return BoxedUnit.UNIT;
                });
                ListBuffer receiptList = new ListBuffer();
                int blockNumber = $this.stateMetadataStorage.getHeight() + 1;
                byte[] blockHash = (byte[])package$.MODULE$.idToBytes().apply((Object)mod.id());
                ObjectRef cumGasUsed = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumBaseFee = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumForgerTips = ObjectRef.create((Object)BigInteger.ZERO);
                GasPool blockGasPool = new GasPool(mod.header().gasLimit());
                BlockContext blockContext = new BlockContext(mod.header(), blockNumber, consensusEpochNumber, modWithdrawalEpochInfo.epoch(), this.params().chainId(), $this.blockHashProvider);
                ((TraversableLike)mod.sidechainTransactions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AccountState.$anonfun$applyModifier$9(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    AccountState.$anonfun$applyModifier$10(this, stateView, blockGasPool, blockContext, cumGasUsed, blockHash, blockNumber, receiptList, cumBaseFee, cumForgerTips, x$3);
                    return BoxedUnit.UNIT;
                });
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("cumBaseFee={}, cumForgerTips={}", (Object[])new BigInteger[]{(BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stateView.updateFeePaymentInfo(new AccountBlockFeeInfo((BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem, mod.header().forgerAddress()));
                this.evalForgersReward(mod, modWithdrawalEpochInfo, (AccountStateView)stateView);
                mod.verifyLogsBloomConsistency((Seq<EthereumReceipt>)receiptList);
                mod.verifyReceiptDataConsistency((Seq<EthereumConsensusDataReceipt>)((Seq)receiptList.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.consensusDataReceipt(), ListBuffer$.MODULE$.canBuildFrom())));
                BigInteger gasUsed = (BigInteger)receiptList.lastOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.consensusDataReceipt().cumulativeGasUsed()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
                mod.verifyGasUsedConsistency(gasUsed);
                byte[] stateRoot = stateView.getIntermediateRoot();
                mod.verifyStateRootDataConsistency(stateRoot);
                stateView.updateTransactionReceipts((Seq<EthereumReceipt>)receiptList);
                stateView.updateNextBaseFee(FeeUtils$.MODULE$.calculateNextBaseFee(mod, this.params()));
                stateView.commit(package$.MODULE$.idToVersion(mod.id()));
                return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, package$.MODULE$.idToVersion(mod.id()), $this.stateMetadataStorage, $this.stateDbStorage, $this.messageProcessors);
            });
        });
    }

    private void evalForgersReward(AccountBlock mod, WithdrawalEpochInfo modWithdrawalEpochInfo, AccountStateView stateView) {
        boolean isWithdrawalEpochFinished = WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(modWithdrawalEpochInfo, this.params());
        if (isWithdrawalEpochFinished) {
            BoxedUnit boxedUnit;
            Seq<AccountPayment> feePayments = stateView.getFeePaymentsInfo(modWithdrawalEpochInfo.epoch(), (Option<AccountBlockFeeInfo>)None$.MODULE$);
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("End of Withdrawal Epoch {} reached, added {} rewards with block {}", new Object[]{BoxesRunTime.boxToInteger((int)modWithdrawalEpochInfo.epoch()), BoxesRunTime.boxToInteger((int)feePayments.length()), mod.header().id()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            byte[] feePaymentsHash = AccountFeePaymentsUtils$.MODULE$.calculateFeePaymentsHash(feePayments);
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(feePaymentsHash))) {
                BoxedUnit boxedUnit2;
                String errMsg = new StringBuilder(72).append("Block ").append(mod.id()).append(": computed feePaymentsHash ").append(BytesUtils.toHexString(feePaymentsHash)).append(" is different from the one in the block").toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            feePayments.foreach((Function1 & Serializable & scala.Serializable)payment -> {
                AccountState.$anonfun$evalForgersReward$1(this, stateView, payment);
                return BoxedUnit.UNIT;
            });
        } else if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(AccountFeePaymentsUtils$.MODULE$.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH()))) {
            String errMsg = new StringBuilder(66).append("Block ").append(mod.id()).append(" has feePaymentsHash ").append(BytesUtils.toHexString(mod.feePaymentsHash())).append(" defined when no fee payments expected.").toString();
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void validateTopQualityCertificate(WithdrawalEpochCertificate topQualityCertificate, AccountStateView stateView) {
        int certReferencedEpochNumber = topQualityCertificate.epochNumber();
        Seq<WithdrawalRequest> expectedWithdrawalRequests = stateView.getWithdrawalRequests(certReferencedEpochNumber);
        if (topQualityCertificate.backwardTransferOutputs().size() != expectedWithdrawalRequests.size()) {
            throw new IllegalStateException(new StringBuilder(139).append("Epoch ").append(certReferencedEpochNumber).append(" top quality certificate backward transfers ").append("number ").append(topQualityCertificate.backwardTransferOutputs().size()).append(" is different than expected ").append(expectedWithdrawalRequests.size()).append(". ").append("Node's active chain is the fork from MC perspective.").toString());
        }
        ((IterableLike)topQualityCertificate.backwardTransferOutputs().zip(expectedWithdrawalRequests, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AccountState.$anonfun$validateTopQualityCertificate$1(certReferencedEpochNumber, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isSwitchingConsensusEpoch(long blockTimeStamp) {
        int currentConsensusEpoch;
        int blockConsensusEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params(), blockTimeStamp);
        return blockConsensusEpoch != (currentConsensusEpoch = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(0))));
    }

    public Try<AccountState> rollbackTo(String version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            AccountStateMetadataStorage newMetaState = (AccountStateMetadataStorage)$this.stateMetadataStorage.rollback(new ByteArrayWrapper(package$.MODULE$.versionToBytes(version))).get();
            return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, version, newMetaState, $this.stateDbStorage, $this.messageProcessors);
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isErrorEnabled()) {
                    this.$outer.log().underlying().error("Exception was thrown during rollback.", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int maxRollbackDepth() {
        return this.stateMetadataStorage.rollbackVersions().size();
    }

    @Override
    public AccountStateView getView() {
        Hash stateRoot = new Hash(this.stateMetadataStorage.getAccountStateRoot());
        StateDB statedb = new StateDB(this.stateDbStorage, stateRoot);
        return new AccountStateView(this.stateMetadataStorage.getView(), statedb, this.messageProcessors);
    }

    public StateDbAccountStateView getStateDbViewFromRoot(byte[] stateRoot) {
        return new StateDbAccountStateView(new StateDB(this.stateDbStorage, new Hash(stateRoot)), this.messageProcessors);
    }

    @Override
    public Seq<WithdrawalRequest> getWithdrawalRequests(int withdrawalEpoch) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.getWithdrawalRequests(withdrawalEpoch));
    }

    @Override
    public Seq<BackwardTransfer> backwardTransfers(int withdrawalEpoch) {
        return (Seq)((TraversableLike)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.getWithdrawalRequests(withdrawalEpoch))).map((Function1 & Serializable & scala.Serializable)wr -> new BackwardTransfer(wr.proposition().bytes(), wr.valueInZennies()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$8 -> x$8.keyRotationProof(withdrawalEpoch, indexOfSigner, keyType));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        Some some;
        block3: {
            block2: {
                if (withdrawalEpoch == -1) break block2;
                Enumeration.Value value = this.params().circuitType();
                Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
                if (value != null ? !value.equals(value2) : value2 != null) break block3;
            }
            some = new Some((Object)new CertifiersKeys((Vector<SchnorrProposition>)this.params().signersPublicKeys().toVector(), (Vector<SchnorrProposition>)this.params().mastersPublicKeys().toVector()));
            return some;
        }
        some = (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$9 -> x$9.certifiersKeys(withdrawalEpoch));
        return some;
    }

    @Override
    public Option<Object> lastCertificateReferencedEpoch() {
        return this.stateMetadataStorage.lastCertificateReferencedEpoch();
    }

    @Override
    public Option<String> lastCertificateSidechainBlockId() {
        return this.stateMetadataStorage.lastCertificateSidechainBlockId();
    }

    @Override
    public Option<WithdrawalEpochCertificate> certificate(int referencedWithdrawalEpoch) {
        return this.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        return this.stateMetadataStorage.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public boolean hasCeased() {
        return this.stateMetadataStorage.hasCeased();
    }

    @Override
    public Seq<AccountPayment> getFeePaymentsInfo(int withdrawalEpoch, Option<AccountBlockFeeInfo> blockToAppendFeeInfo) {
        Seq<AccountBlockFeeInfo> feePaymentInfoSeq = this.stateMetadataStorage.getFeePayments(withdrawalEpoch);
        return AccountFeePaymentsUtils$.MODULE$.getForgersRewards(feePaymentInfoSeq);
    }

    @Override
    public Option<AccountBlockFeeInfo> getFeePaymentsInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public WithdrawalEpochInfo getWithdrawalEpochInfo() {
        return this.stateMetadataStorage.getWithdrawalEpochInfo();
    }

    @Override
    public Option<Object> getConsensusEpochNumber() {
        return this.stateMetadataStorage.getConsensusEpochNumber();
    }

    @Override
    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$10 -> x$10.getOrderedForgingStakesInfoSeq());
    }

    @Override
    public Tuple2<String, ConsensusEpochInfo> getCurrentConsensusEpochInfo() {
        Seq<ForgingStakeInfo> forgingStakes = this.getOrderedForgingStakesInfoSeq();
        if (forgingStakes.isEmpty()) {
            throw new IllegalStateException("ForgerStakes list can't be empty.");
        }
        Option<Object> option = this.getConsensusEpochNumber();
        if (!(option instanceof Some)) {
            throw new IllegalStateException("Can't retrieve Consensus Epoch related info form StateStorage.");
        }
        Some some = (Some)option;
        int consensusEpochNumber = BoxesRunTime.unboxToInt((Object)some.value());
        String lastBlockInEpoch = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)this.stateMetadataStorage.lastVersionId().get()).data());
        ConsensusEpochInfo consensusEpochInfo = new ConsensusEpochInfo(consensusEpochNumber, MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)forgingStakes.map((Function1 & Serializable & scala.Serializable)info -> info.hash(), Seq$.MODULE$.canBuildFrom())).asJava()), BoxesRunTime.unboxToLong((Object)((TraversableOnce)forgingStakes.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.stakeAmount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Tuple2 tuple2 = new Tuple2((Object)lastBlockInEpoch, (Object)consensusEpochInfo);
        return tuple2;
    }

    @Override
    public BigInteger getBalance(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$12 -> x$12.getBalance(address));
    }

    @Override
    public byte[] getAccountStateRoot() {
        return this.stateMetadataStorage.getAccountStateRoot();
    }

    @Override
    public byte[] getCodeHash(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$13 -> x$13.getCodeHash(address));
    }

    @Override
    public BigInteger getNonce(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$14 -> x$14.getNonce(address));
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$15 -> x$15.getListOfForgersStakes());
    }

    @Override
    public Seq<Object> getAllowedForgerList() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$16 -> x$16.getAllowedForgerList());
    }

    @Override
    public Option<ForgerStakeData> getForgerStakeData(String stakeId) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$17 -> x$17.getForgerStakeData(stakeId));
    }

    @Override
    public EthereumConsensusDataLog[] getLogs(byte[] txHash) {
        return (EthereumConsensusDataLog[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$18 -> x$18.getLogs(txHash));
    }

    @Override
    public byte[] getIntermediateRoot() {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$19 -> x$19.getIntermediateRoot());
    }

    @Override
    public byte[] getCode(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$20 -> x$20.getCode(address));
    }

    @Override
    public BigInteger getNextBaseFee() {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$21 -> x$21.getNextBaseFee());
    }

    @Override
    public Option<EthereumReceipt> getTransactionReceipt(byte[] txHash) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$22 -> x$22.getTransactionReceipt(txHash));
    }

    @Override
    public ResourceHandle getStateDbHandle() {
        return (ResourceHandle)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$23 -> x$23.getStateDbHandle());
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$24 -> x$24.getAccountStorage(address, key));
    }

    @Override
    public byte[] getAccountStorageBytes(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$25 -> x$25.getAccountStorageBytes(address, key));
    }

    @Override
    public boolean accountExists(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.accountExists(address))));
    }

    @Override
    public boolean isEoaAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.isEoaAccount(address))));
    }

    @Override
    public boolean isSmartContractAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)x$28.isSmartContractAccount(address))));
    }

    public Try<BoxedUnit> validate(AccountTransaction<Proposition, Proof<Proposition>> tx) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!(tx instanceof EthereumTransaction)) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(46).append("Transaction ").append(tx.id()).append(": instance of class ").append(tx.getClass().getName()).append(", not of type ").append(EthereumTransaction.class.getName()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if ((ethTx.isEIP155() || ethTx.isEIP1559()) && !BoxesRunTime.equalsNumObject((Number)ethTx.getChainId(), (Object)BoxesRunTime.boxToLong((long)this.params().chainId()))) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(61).append("Transaction ").append(ethTx.id()).append(": chainId=").append(ethTx.getChainId()).append(" is different from expected SC chainId ").append(this.params().chainId()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new InvalidTransactionChainIdException(errMsg, InvalidTransactionChainIdException$.MODULE$.$lessinit$greater$default$2());
            }
            ethTx.semanticValidity();
            Address sender = ethTx.getFrom().address();
            GasFeeFork feeFork = GasFeeFork$.MODULE$.get(BoxesRunTime.unboxToInt((Object)$this.stateMetadataStorage.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
            if (feeFork.blockGasLimit().compareTo(ethTx.getGasLimit()) < 0) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Transaction gas limit exceeds block gas limit: tx gas limit ").append(ethTx.getGasLimit()).append(", block gas limit ").append(feeFork.blockGasLimit()).toString());
            }
            if (feeFork.baseFeeMinimum().compareTo(ethTx.getMaxFeePerGas()) > 0) {
                throw new IllegalArgumentException(new StringBuilder(64).append("max fee per gas below minimum: address ").append(sender).append(", maxFeePerGas ").append(ethTx.getMaxFeePerGas()).append(", minimum ").append(feeFork.baseFeeMinimum()).toString());
            }
            this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                AccountState.$anonfun$validate$3(sender, ethTx, stateView);
                return BoxedUnit.UNIT;
            });
        }).recoverWith((PartialFunction)new scala.Serializable(this, tx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;
            private final AccountTransaction tx$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isDebugEnabled()) {
                    this.$outer.log().underlying().debug(new StringBuilder(22).append("Not valid transaction ").append(this.tx$1.id()).toString(), A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tx$1 = tx$1;
            }
        });
    }

    @Override
    public boolean isWithdrawalEpochLastIndex() {
        return WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(this.getWithdrawalEpochInfo(), this.params());
    }

    @Override
    public boolean isForgingOpen() {
        return this.params().restrictForgers() ? BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.isForgingOpen()))) : true;
    }

    @Override
    public Option<byte[]> utxoMerkleTreeRoot(int withdrawalEpoch) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$8(AccountStateView stateView$1, AccountBlock mod$1, MainchainBlockReferenceData mcBlockRefData) {
        stateView$1.addTopQualityCertificates(mcBlockRefData, mod$1.id());
        stateView$1.applyMainchainBlockReferenceData(mcBlockRefData);
    }

    public static final /* synthetic */ boolean $anonfun$applyModifier$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$10(AccountState $this, AccountStateView stateView$1, GasPool blockGasPool$1, BlockContext blockContext$1, ObjectRef cumGasUsed$1, byte[] blockHash$1, int blockNumber$1, ListBuffer receiptList$1, ObjectRef cumBaseFee$1, ObjectRef cumForgerTips$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Tuple2 tuple22;
            BigInteger txGasUsed;
            AccountTransaction tx = (AccountTransaction)tuple2._1();
            int txIndex = tuple2._2$mcI$sp();
            boolean bl = false;
            Failure failure = null;
            Try<EthereumConsensusDataReceipt> try_ = stateView$1.applyTransaction(tx, txIndex, blockGasPool$1, blockContext$1);
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                EthereumConsensusDataReceipt consensusDataReceipt = (EthereumConsensusDataReceipt)success.value();
                txGasUsed = consensusDataReceipt.cumulativeGasUsed().subtract((BigInteger)cumGasUsed$1.elem);
                cumGasUsed$1.elem = consensusDataReceipt.cumulativeGasUsed();
                EthereumTransaction ethTx = (EthereumTransaction)tx;
                byte[] txHash = BytesUtils.fromHexString(ethTx.id());
                None$ contractAddress = ethTx.getTo().isEmpty() ? Option$.MODULE$.apply((Object)Secp256k1.generateContractAddress(ethTx.getFrom().address(), ethTx.getNonce())) : None$.MODULE$;
                EthereumReceipt fullReceipt = new EthereumReceipt(consensusDataReceipt, txHash, txIndex, blockHash$1, blockNumber$1, txGasUsed, (Option<Address>)contractAddress);
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("Adding to receipt list: {}", new Object[]{fullReceipt.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                receiptList$1.$plus$eq((Object)fullReceipt);
                Tuple2<BigInteger, BigInteger> tuple23 = GasUtil$.MODULE$.getTxFeesPerGas(ethTx, blockContext$1.baseFee);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                BigInteger txBaseFeePerGas = (BigInteger)tuple23._1();
                BigInteger txForgerTipPerGas = (BigInteger)tuple23._2();
                tuple22 = new Tuple2((Object)txBaseFeePerGas, (Object)txForgerTipPerGas);
            } else {
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable err = failure.exception();
                    if (err instanceof GasLimitReached) {
                        BoxedUnit boxedUnit;
                        GasLimitReached gasLimitReached = (GasLimitReached)err;
                        if ($this.log().underlying().isErrorEnabled()) {
                            $this.log().underlying().error("Could not apply tx, block gas limit exceeded");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new IllegalArgumentException("Could not apply tx, block gas limit exceeded", gasLimitReached);
                    }
                }
                if (bl) {
                    BoxedUnit boxedUnit;
                    Throwable err = failure.exception();
                    if ($this.log().underlying().isErrorEnabled()) {
                        $this.log().underlying().error("Could not apply tx", err);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(err);
                }
                throw new MatchError(try_);
            }
            Tuple2 tuple24 = tuple22;
            BigInteger txBaseFeePerGas = (BigInteger)tuple24._1();
            BigInteger txForgerTipPerGas = (BigInteger)tuple24._2();
            cumBaseFee$1.elem = ((BigInteger)cumBaseFee$1.elem).add(txBaseFeePerGas.multiply(txGasUsed));
            cumForgerTips$1.elem = ((BigInteger)cumForgerTips$1.elem).add(txForgerTipPerGas.multiply(txGasUsed));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$evalForgersReward$1(AccountState $this, AccountStateView stateView$2, AccountPayment payment) {
        BoxedUnit boxedUnit;
        stateView$2.addBalance(payment.address().address(), payment.value());
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug(" address: {} / value: {}", new Object[]{payment.address().address(), payment.value()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$validateTopQualityCertificate$1(int certReferencedEpochNumber$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MainchainBackwardTransferCertificateOutput certOutput = (MainchainBackwardTransferCertificateOutput)tuple2._1();
            WithdrawalRequest expectedWithdrawalRequest = (WithdrawalRequest)tuple2._2();
            if (certOutput.amount() != expectedWithdrawalRequest.valueInZennies() || !Arrays.equals(certOutput.pubKeyHash(), expectedWithdrawalRequest.proposition().bytes())) {
                throw new IllegalStateException(new StringBuilder(135).append("Epoch ").append(certReferencedEpochNumber$2).append(" top quality certificate backward transfers ").append("data is different than expected. Node's active chain is the fork from MC perspective.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validate$3(Address sender$1, EthereumTransaction ethTx$1, AccountStateView stateView) {
        BigInteger stateNonce = stateView.getNonce(sender$1);
        if (stateNonce.compareTo(ethTx$1.getNonce()) > 0) {
            throw new NonceTooLowException(sender$1, ethTx$1.getNonce(), stateNonce);
        }
        BigInteger maxTxCost = ethTx$1.maxCost();
        BigInteger currentBalance = stateView.getBalance(sender$1);
        if (currentBalance.compareTo(maxTxCost) < 0) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Insufficient funds for executing transaction: balance ").append(currentBalance).append(", tx cost ").append(maxTxCost).toString());
        }
        if (!stateView.isEoaAccount(sender$1)) {
            throw new SenderNotEoaException(sender$1, stateView.getCodeHash(sender$1));
        }
    }

    public AccountState(NetworkParams params, NetworkTimeProvider timeProvider, HistoryBlockHashProvider blockHashProvider, String version, AccountStateMetadataStorage stateMetadataStorage, Database stateDbStorage, Seq<MessageProcessor> messageProcessors) {
        this.params = params;
        this.timeProvider = timeProvider;
        this.blockHashProvider = blockHashProvider;
        this.version = version;
        this.stateMetadataStorage = stateMetadataStorage;
        this.stateDbStorage = stateDbStorage;
        this.messageProcessors = messageProcessors;
        TransactionValidation.$init$((TransactionValidation)this);
        ClosableResourceHandler.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

