/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.secret;

import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.secret.PrivateKeySecp256k1Serializer;
import io.horizen.account.utils.Secp256k1;
import io.horizen.proposition.ProofOfKnowledgeProposition;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.secret.SecretsIdsEnum;
import io.horizen.utils.BytesUtils;
import java.util.Arrays;

public final class PrivateKeySecp256k1
implements Secret {
    private static final byte privateKeySecp256k1SecretId = SecretsIdsEnum.PrivateKeySecp256k1SecretId.id();
    private final byte[] privateKey;
    private final AddressProposition address;

    public PrivateKeySecp256k1(byte[] privateKey) {
        if (privateKey.length != 32) {
            throw new IllegalArgumentException(String.format("Incorrect private key length, %d expected, %d found", 32, privateKey.length));
        }
        this.privateKey = Arrays.copyOf(privateKey, 32);
        this.address = new AddressProposition(Secp256k1.getAddress(Secp256k1.getPublicKey(privateKey)));
    }

    @Override
    public byte secretTypeId() {
        return privateKeySecp256k1SecretId;
    }

    @Override
    public SecretSerializer serializer() {
        return PrivateKeySecp256k1Serializer.getSerializer();
    }

    @Override
    public AddressProposition publicImage() {
        return this.address;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeySecp256k1)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PrivateKeySecp256k1 other = (PrivateKeySecp256k1)obj;
        return Arrays.equals(this.privateKey, other.privateKey);
    }

    public int hashCode() {
        return Arrays.hashCode(this.privateKey);
    }

    @Override
    public boolean owns(ProofOfKnowledgeProposition proposition) {
        return this.publicImage().equals(proposition);
    }

    @Override
    public SignatureSecp256k1 sign(byte[] message) {
        Secp256k1.Signature signature = Secp256k1.sign(this.privateKey, message);
        return new SignatureSecp256k1(signature.v, signature.r, signature.s);
    }

    public byte[] privateKeyBytes() {
        return Arrays.copyOf(this.privateKey, 32);
    }

    @Override
    public Boolean isPublicKeyValid() {
        return true;
    }

    public String toString() {
        return String.format("PrivateKeySecp256k1{privateKey=%s}", BytesUtils.toHexString(this.privateKey).substring(0, 8));
    }
}

