/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.proof;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.horizen.account.proof.SignatureSecp256k1Serializer;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.secret.PrivateKeySecp256k1;
import io.horizen.account.utils.Secp256k1;
import io.horizen.evm.Address;
import io.horizen.json.Views;
import io.horizen.json.serializer.HexNoPrefixBigIntegerSerializer;
import io.horizen.proof.ProofOfKnowledge;
import io.horizen.proof.ProofSerializer;
import java.math.BigInteger;

@JsonView(value={Views.Default.class})
public final class SignatureSecp256k1
implements ProofOfKnowledge<PrivateKeySecp256k1, AddressProposition> {
    @JsonProperty(value="v")
    @JsonSerialize(using=HexNoPrefixBigIntegerSerializer.class)
    private final BigInteger v;
    @JsonProperty(value="r")
    @JsonSerialize(using=HexNoPrefixBigIntegerSerializer.class)
    private final BigInteger r;
    @JsonProperty(value="s")
    @JsonSerialize(using=HexNoPrefixBigIntegerSerializer.class)
    private final BigInteger s;
    public static final BigInteger secp256k1N = new BigInteger("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141", 16);
    public static final BigInteger secp256k1halfN = secp256k1N.divide(BigInteger.TWO);

    public static void verifySignatureData(BigInteger v, BigInteger r, BigInteger s) {
        if (v == null || r == null || s == null) {
            throw new IllegalArgumentException("Null obj passed in signature data: v=" + (v == null ? "NULL" : v.toString(16)) + ", r=" + (r == null ? "NULL" : r.toString(16)) + ", s=" + (s == null ? "NULL" : s.toString(16)));
        }
        if (v.signum() <= 0 || r.signum() <= 0 || s.signum() <= 0) {
            throw new IllegalArgumentException("Non positive v/r/s obj passed in signature data");
        }
        if (v.bitLength() > 8) {
            throw new IllegalArgumentException("Too large a v obj passed in signature data");
        }
        int v_val = v.intValueExact();
        if (v_val != 27 && v_val != 28) {
            throw new IllegalArgumentException("Invalid v obj passed in signature data: " + v_val);
        }
        if (s.compareTo(secp256k1halfN) > 0) {
            throw new IllegalArgumentException("Invalid s obj passed in signature data");
        }
        if (r.compareTo(secp256k1N) >= 0) {
            throw new IllegalArgumentException("Invalid signature r/s obj passed in signature data");
        }
    }

    public SignatureSecp256k1(BigInteger v_in, BigInteger r_in, BigInteger s_in) {
        SignatureSecp256k1.verifySignatureData(v_in, r_in, s_in);
        this.v = v_in;
        this.r = r_in;
        this.s = s_in;
    }

    @Override
    public boolean isValid(AddressProposition proposition, byte[] message) {
        return Secp256k1.verify(message, this.v, this.r, this.s, proposition.address().toBytes());
    }

    @Override
    public boolean isValid(Address address, byte[] message) {
        return Secp256k1.verify(message, this.v, this.r, this.s, address.toBytes());
    }

    @Override
    public ProofSerializer serializer() {
        return SignatureSecp256k1Serializer.getSerializer();
    }

    public BigInteger getV() {
        return this.v;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public String toString() {
        return String.format("SignatureSecp256k1{v=%s, r=%s, s=%s}", this.v.toString(16), this.r.toString(16), this.s.toString(16));
    }
}

