/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.forger;

import akka.util.Timeout;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlock$;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.mempool.AccountMemoryPool;
import io.horizen.account.mempool.MempoolMap;
import io.horizen.account.mempool.TransactionsByPriceAndNonceIter;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.secret.PrivateKeySecp256k1;
import io.horizen.account.state.AccountState;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.FeeCapTooLowException;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountFeePaymentsUtils$;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.Bloom;
import io.horizen.account.utils.Bloom$;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.account.wallet.AccountWallet;
import io.horizen.block.AccountOmmerSerializer$;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.Ommer;
import io.horizen.block.SidechainBlockBase;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.forge.AbstractForgeMessageBuilder;
import io.horizen.forge.ForgeFailure;
import io.horizen.forge.ForgeResult;
import io.horizen.forge.ForgeSuccess;
import io.horizen.forge.MainchainSynchronizer;
import io.horizen.history.AbstractHistory;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.Secret;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.ClosableResourceHandler;
import io.horizen.utils.DynamicTypedSerializer;
import io.horizen.utils.ForgingStakeMerklePathInfo;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.MerklePath;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.Pair;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import io.horizen.vrf.VrfOutput;
import io.horizen.wallet.AbstractWallet;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewHolder;
import sparkz.core.NodeViewModifier$;
import sparkz.util.package$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001\u0002\r\u001a\u0001\tB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"IA\u000b\u0001B\u0001B\u0003%QK\u0017\u0005\t7\u0002\u0011\t\u0011)A\u00059\")!\r\u0001C\u0001G\u0016!!\u000e\u0001\u0001l\u000b\u0011\t\b\u0001\u0001:\u0006\ta\u0004\u0001!_\u0003\u0006\u007f\u0002\u0001\u0011\u0011A\u0003\u0007\u0003\u001b\u0001\u0001!a\u0004\u0006\r\u0005m\u0001\u0001AA\u000f\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!+\u0001\t\u0013\tY\u000bC\u0004\u0002^\u0002!\t%a8\t\u0013\t\u0015\u0007!%A\u0005\u0002\t\u001d\u0007b\u0002Bo\u0001\u0011\u0005#q\u001c\u0005\b\u0007\u0007\u0001A\u0011IB\u0003\u0011\u001d\u0019Y\u0003\u0001C!\u0007[Aqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0004\u0004J\u0001!\tea\u0013\t\u000f\r]\u0004\u0001\"\u0001\u0004z!91q\u0010\u0001\u0005B\r\u0005\u0005bBBB\u0001\u0011\u00053\u0011\u0011\u0002\u001b\u0003\u000e\u001cw.\u001e8u\r>\u0014x-Z'fgN\fw-\u001a\"vS2$WM\u001d\u0006\u00035m\taAZ8sO\u0016\u0014(B\u0001\u000f\u001e\u0003\u001d\t7mY8v]RT!AH\u0010\u0002\u000f!|'/\u001b>f]*\t\u0001%\u0001\u0002j_\u000e\u00011c\u0001\u0001$\tB)AeJ\u0015<\u00036\tQE\u0003\u0002';\u0005)am\u001c:hK&\u0011\u0001&\n\u0002\u001c\u0003\n\u001cHO]1di\u001a{'oZ3NKN\u001c\u0018mZ3Ck&dG-\u001a:\u0011\t)js&N\u0007\u0002W)\u0011AfG\u0001\fiJ\fgn]1di&|g.\u0003\u0002/W\t\u0011\u0012iY2pk:$HK]1og\u0006\u001cG/[8o!\t\u00014'D\u00012\u0015\t\u0011T$A\u0006qe>\u0004xn]5uS>t\u0017B\u0001\u001b2\u0005-\u0001&o\u001c9pg&$\u0018n\u001c8\u0011\u0007YJt&D\u00018\u0015\tAT$A\u0003qe>|g-\u0003\u0002;o\t)\u0001K]8pMB\u0011AhP\u0007\u0002{)\u0011ahG\u0001\u0006E2|7m[\u0005\u0003\u0001v\u0012!#Q2d_VtGO\u00117pG.DU-\u00193feB\u0011AHQ\u0005\u0003\u0007v\u0012A\"Q2d_VtGO\u00117pG.\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005%3%aF\"m_N\f'\r\\3SKN|WO]2f\u0011\u0006tG\r\\3s\u0003Ui\u0017-\u001b8dQ\u0006LgnU=oG\"\u0014xN\\5{KJ\u0004\"\u0001\n'\n\u00055+#!F'bS:\u001c\u0007.Y5o'ft7\r\u001b:p]&TXM]\u0001\nG>l\u0007/\u00198j_:\u0004\"\u0001\u0015*\u000e\u0003ES!AT\u000e\n\u0005M\u000b&!J*jI\u0016\u001c\u0007.Y5o\u0003\u000e\u001cw.\u001e8u)J\fgn]1di&|gn]\"p[B\fg.[8o\u0003\u0019\u0001\u0018M]1ngB\u0011a\u000bW\u0007\u0002/*\u0011A+H\u0005\u00033^\u0013QBT3uo>\u00148\u000eU1sC6\u001c\u0018B\u0001+(\u0003\r\nG\u000e\\8x\u001d><VMY:pG.,GoQ8o]\u0016\u001cG/[8o\u0013:\u0014Vm\u001a;fgR\u0004\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0006I\u001a<\u0007.\u001b\t\u0003K\u0002i\u0011!\u0007\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0005\u0006\u001d\u0016\u0001\ra\u0014\u0005\u0006)\u0016\u0001\r!\u0016\u0005\u00067\u0016\u0001\r\u0001\u0018\u0002\u0004\rBK\u0005C\u00017p\u001b\u0005i'B\u00018\u001c\u0003\u0015\u0019\u0007.Y5o\u0013\t\u0001XN\u0001\fBG\u000e|WO\u001c;GK\u0016\u0004\u0016-_7f]R\u001c\u0018J\u001c4p\u0005\u0015A5\u000bV(S!\t\u0019h/D\u0001u\u0015\t)8$A\u0004ti>\u0014\u0018mZ3\n\u0005]$(!F!dG>,h\u000e\u001e%jgR|'/_*u_J\fw-\u001a\u0002\u0003-2\u0003\"A_?\u000e\u0003mT!\u0001`\u000e\u0002\r]\fG\u000e\\3u\u0013\tq8PA\u0007BG\u000e|WO\u001c;XC2dW\r\u001e\u0002\u0004\u0011&\u001b\u0006\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d1$A\u0004iSN$xN]=\n\t\u0005-\u0011Q\u0001\u0002\u000f\u0003\u000e\u001cw.\u001e8u\u0011&\u001cHo\u001c:z\u0005\ti5\u000b\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bG\u0001\u0006gR\fG/Z\u0005\u0005\u00033\t\u0019B\u0001\u0007BG\u000e|WO\u001c;Ti\u0006$XM\u0001\u0002N!B!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$m\tq!\\3na>|G.\u0003\u0003\u0002(\u0005\u0005\"!E!dG>,h\u000e^'f[>\u0014\u0018\u0010U8pY\u0006\u00012m\\7qkR,'\t\\8dW&sgm\u001c\u000b\u000f\u0003[\t\u0019'!\u001c\u0002x\u0005\u001d\u0015\u0011SAP!%i\u0016qFA\u001a\u0003/\nI&C\u0002\u00022y\u0013a\u0001V;qY\u0016\u001c\u0004CBA\u001b\u0003\u000b\nYE\u0004\u0003\u00028\u0005\u0005c\u0002BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u\u0012%\u0001\u0004=e>|GOP\u0005\u0002?&\u0019\u00111\t0\u0002\u000fA\f7m[1hK&!\u0011qIA%\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0007r\u0006\u0003BA'\u0003'j!!a\u0014\u000b\t\u0005E\u00131C\u0001\be\u0016\u001cW-\u001b9u\u0013\u0011\t)&a\u0014\u00039\u0015#\b.\u001a:fk6\u001cuN\\:f]N,8\u000fR1uCJ+7-Z5qiB)\u0011QGA#SA!\u00111LA0\u001b\t\tiF\u0003\u0002H7%!\u0011\u0011MA/\u0005M\t5mY8v]R\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0011\u001d\t)\u0007\u0004a\u0001\u0003O\nAA^5foB!\u0011\u0011CA5\u0013\u0011\tY'a\u0005\u0003!\u0005\u001b7m\\;oiN#\u0018\r^3WS\u0016<\bbBA8\u0019\u0001\u0007\u0011\u0011O\u0001\u0016g&$Wm\u00195bS:$&/\u00198tC\u000e$\u0018n\u001c8t!\u0015\t)$a\u001d*\u0013\u0011\t)(!\u0013\u0003\u0011%#XM]1cY\u0016Dq!!\u001f\r\u0001\u0004\tY(\u0001\u000fnC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dKN$\u0015\r^1\u0011\r\u0005U\u0012QIA?!\u0011\ty(a!\u000e\u0005\u0005\u0005%B\u0001 \u001e\u0013\u0011\t))!!\u000375\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0011\u001d\tI\t\u0004a\u0001\u0003\u0017\u000bAB\u00197pG.\u001cuN\u001c;fqR\u0004B!!\u0005\u0002\u000e&!\u0011qRA\n\u00051\u0011En\\2l\u0007>tG/\u001a=u\u0011\u001d\t\u0019\n\u0004a\u0001\u0003+\u000bQBZ8sO\u0016\u0014\u0018\t\u001a3sKN\u001c\b\u0003BAL\u00037k!!!'\u000b\u0005IZ\u0012\u0002BAO\u00033\u0013!#\u00113ee\u0016\u001c8\u000f\u0015:pa>\u001c\u0018\u000e^5p]\"9\u0011\u0011\u0015\u0007A\u0002\u0005\r\u0016!\u00032m_\u000e\\7+\u001b>f!\ri\u0016QU\u0005\u0004\u0003Os&\u0001\u0002'p]\u001e\fq\u0003\u001e:z\u0003B\u0004H._!oI\u001e+GO\u00117pG.LeNZ8\u0015\u0019\u00055\u0016qZAj\u0003+\f9.!7\u0011\r\u0005=\u0016QWA]\u001b\t\t\tLC\u0002\u00024z\u000bA!\u001e;jY&!\u0011qWAY\u0005\r!&/\u001f\t\f;\u0006m\u00161GA,\u0003\u007f\u000by,C\u0002\u0002>z\u0013a\u0001V;qY\u0016$\u0004\u0003BAa\u0003\u0017l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\u0005[\u0006$\bN\u0003\u0002\u0002J\u0006!!.\u0019<b\u0013\u0011\ti-a1\u0003\u0015\tKw-\u00138uK\u001e,'\u000fC\u0004\u0002R6\u0001\r!a\u001a\u0002\u0013M$\u0018\r^3WS\u0016<\bbBA=\u001b\u0001\u0007\u00111\u0010\u0005\b\u0003_j\u0001\u0019AA9\u0011\u001d\tI)\u0004a\u0001\u0003\u0017Cq!a7\u000e\u0001\u0004\t\u0019+A\u0006cY>\u001c7nU5{K&s\u0017AD2sK\u0006$XMT3x\u00052|7m\u001b\u000b'\u0003C\fI/!>\u0002\u0000\n\r!1\u0006B\u001b\u0005o\u0011ID!\u0012\u0003R\t\u0005$\u0011\u000fB>\u0005\u0017\u0013)Ja*\u00032\n\u0005\u0007CBAX\u0003k\u000b\u0019\u000f\u0005\u0004\u0002\u0000\u0005\u0015\u0018fO\u0005\u0005\u0003O\f\tI\u0001\nTS\u0012,7\r[1j]\ncwnY6CCN,\u0007bBAv\u001d\u0001\u0007\u0011Q^\u0001\t]>$WMV5foB!\u0011q^Ay\u001b\u0005\u0001\u0011bAAzO\t!a+[3x\u0011\u001d\t9P\u0004a\u0001\u0003s\fqB\u0019:b]\u000eD\u0007k\\5oi&sgm\u001c\t\u0005\u0003_\fY0C\u0002\u0002~\u001e\u0012qB\u0011:b]\u000eD\u0007k\\5oi&sgm\u001c\u0005\u0007\u0005\u0003q\u0001\u0019\u0001/\u00025%\u001cx+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007\u000eT1ti\ncwnY6\t\u000f\t\u0015a\u00021\u0001\u0003\b\u0005A\u0001/\u0019:f]RLE\r\u0005\u0003\u0003\n\t\u0015b\u0002\u0002B\u0006\u0005?qAA!\u0004\u0003\u001c9!!q\u0002B\u000b\u001d\u0011\tID!\u0005\n\u0005\tM\u0011AB:qCJ\\'0\u0003\u0003\u0003\u0018\te\u0011\u0001B2pe\u0016T!Aa\u0005\n\u0007y\u0012iB\u0003\u0003\u0003\u0018\te\u0011\u0002\u0002B\u0011\u0005G\tQA\u00117pG.T1A\u0010B\u000f\u0013\u0011\u00119C!\u000b\u0003\u000f\tcwnY6JI*!!\u0011\u0005B\u0012\u0011\u001d\u0011iC\u0004a\u0001\u0005_\t\u0011\u0002^5nKN$\u0018-\u001c9\u0011\t\t%!\u0011G\u0005\u0005\u0005g\u0011ICA\u0005US6,7\u000f^1na\"9\u0011\u0011\u0010\bA\u0002\u0005m\u0004bBA8\u001d\u0001\u0007\u0011\u0011\u000f\u0005\b\u0005wq\u0001\u0019\u0001B\u001f\u0003Ai\u0017-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u00148\u000f\u0005\u0004\u00026\u0005\u0015#q\b\t\u0005\u0003\u007f\u0012\t%\u0003\u0003\u0003D\u0005\u0005%aD'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:\t\u000f\t\u001dc\u00021\u0001\u0003J\u00051q.\\7feN\u0004b!!\u000e\u0002F\t-\u0003#BA@\u0005\u001bZ\u0014\u0002\u0002B(\u0003\u0003\u0013QaT7nKJDqAa\u0015\u000f\u0001\u0004\u0011)&A\bpo:,'\u000f\u0015:jm\u0006$XmS3z!\u0011\u00119F!\u0018\u000e\u0005\te#b\u0001B.;\u000511/Z2sKRLAAa\u0018\u0003Z\ty\u0001K]5wCR,7*Z=3kU\n\u0014\bC\u0004\u0003d9\u0001\rA!\u001a\u0002!\u0019|'oZ5oON#\u0018m[3J]\u001a|\u0007\u0003\u0002B4\u0005[j!A!\u001b\u000b\u0007\t-T$A\u0005d_:\u001cXM\\:vg&!!q\u000eB5\u0005A1uN]4j]\u001e\u001cF/Y6f\u0013:4w\u000eC\u0004\u0003t9\u0001\rA!\u001e\u0002\u0011Y\u0014h\r\u0015:p_\u001a\u00042A\u000eB<\u0013\r\u0011Ih\u000e\u0002\t-J4\u0007K]8pM\"9!Q\u0010\bA\u0002\t}\u0014!\u0003<sM>+H\u000f];u!\u0011\u0011\tIa\"\u000e\u0005\t\r%b\u0001BC;\u0005\u0019aO\u001d4\n\t\t%%1\u0011\u0002\n-J4w*\u001e;qkRDqA!$\u000f\u0001\u0004\u0011y)\u0001\u000eg_J<\u0017N\\4Ti\u0006\\W-\u00138g_6+'o\u001b7f!\u0006$\b\u000eE\u0002F\u0005#K1Aa%G\u0005)iUM]6mKB\u000bG\u000f\u001b\u0005\u0007\u001d:\u0001\rAa&\u0011\r\u0015\u0013I*\u000bBO\u0013\r\u0011YJ\u0012\u0002\u0017\tft\u0017-\\5d)f\u0004X\rZ*fe&\fG.\u001b>feB)!q\u0014BRS5\u0011!\u0011\u0015\u0006\u0003YuIAA!*\u0003\"\n)BK]1og\u0006\u001cG/[8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bb\u0002BU\u001d\u0001\u0007!1V\u0001\u000fS:\u0004X\u000f\u001e\"m_\u000e\\7+\u001b>f!\ri&QV\u0005\u0004\u0005_s&aA%oi\"I!1\u0017\b\u0011\u0002\u0003\u0007!QW\u0001\u0010g&<g.\u0019;ve\u0016|\u0005\u000f^5p]B)QLa.\u0003<&\u0019!\u0011\u00180\u0003\r=\u0003H/[8o!\r1$QX\u0005\u0004\u0005\u007f;$AD*jO:\fG/\u001e:feU*\u0014'\u000f\u0005\t\u0005\u0007t\u0001\u0013!a\u00019\u0006I\u0011n\u001d)f]\u0012LgnZ\u0001\u001aGJ,\u0017\r^3OK^\u0014En\\2lI\u0011,g-Y;mi\u0012\n\u0004(\u0006\u0002\u0003J*\u001aALa3,\u0005\t5\u0007\u0003\u0002Bh\u00053l!A!5\u000b\t\tM'Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa6_\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0014\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\u001d:fG\u0006d7-\u001e7bi\u0016\u0014En\\2l\u0011\u0016\fG-\u001a:TSj,GC\u0003BV\u0005C\u0014)Pa>\u0004\u0002!9!Q\u0001\tA\u0002\t\r\b\u0003\u0002Bs\u0005_tAAa:\u0003l:!!q\u0002Bu\u0013\u0011\t\u0019L!\u0007\n\t\u0005\r#Q\u001e\u0006\u0005\u0003g\u0013I\"\u0003\u0003\u0003r\nM(AC'pI&4\u0017.\u001a:JI*!\u00111\tBw\u0011\u001d\u0011i\u0003\u0005a\u0001\u0003GCqA!?\u0011\u0001\u0004\u0011Y0\u0001\u000eg_J<\u0017N\\4Ti\u0006\\W-T3sW2,\u0007+\u0019;i\u0013:4w\u000eE\u0002F\u0005{L1Aa@G\u0005i1uN]4j]\u001e\u001cF/Y6f\u001b\u0016\u00148\u000e\\3QCRD\u0017J\u001c4p\u0011\u001d\u0011\u0019\b\u0005a\u0001\u0005k\nadY8mY\u0016\u001cG\u000f\u0016:b]N\f7\r^5p]N4%o\\7NK6\u0004vn\u001c7\u0015\u001d\r\u001d11CB\u000b\u0007/\u0019Yb!\n\u0004(A!1\u0011BB\b!\u0011\tyba\u0003\n\t\r5\u0011\u0011\u0005\u0002\u000b\u001b\u0016l\u0007o\\8m\u001b\u0006\u0004\u0018\u0002BB\t\u0007\u0017\u00111\u0004\u0016:b]N\f7\r^5p]N\u0014\u0015\u0010\u0015:jG\u0016\fe\u000e\u001a(p]\u000e,\u0007bBAv#\u0001\u0007\u0011Q\u001e\u0005\b\u00037\f\u0002\u0019\u0001BV\u0011\u001d\u0019I\"\u0005a\u0001\u0003w\n1$\\1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3ECR\f\u0007bBB\u000f#\u0001\u00071qD\u0001\u0014o&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\u001c\t\u0004\u000b\u000e\u0005\u0012bAB\u0012\r\n\u0019r+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_\"9!QF\tA\u0002\t=\u0002bBB\u0015#\u0001\u0007\u0011\u0011O\u0001\tM>\u00148-\u001a3Uq\u0006iq-\u001a;P[6,'o]*ju\u0016$BAa+\u00040!9!q\t\nA\u0002\t%\u0013\u0001D4fiN#\u0018\r^3S_>$H\u0003CB\u001b\u0007\u0003\u001a\u0019ea\u0012\u0011\u000bu\u001b9da\u000f\n\u0007\rebLA\u0003BeJ\f\u0017\u0010E\u0002^\u0007{I1aa\u0010_\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005\u001d1\u00031\u0001\u0002\u0002!91QI\nA\u0002\u0005\r\u0016\u0001\u00064pe\u001e,GM\u00117pG.$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002xN\u0001\r!!?\u0002;\u001d,GOR8sO&twm\u0015;bW\u0016lUM]6mKB\u000bG\u000f[%oM>$bb!\u0014\u0004P\r-4QNB8\u0007c\u001a\u0019\b\u0005\u0004\u00026\u0005\u0015#1 \u0005\b\u0007#\"\u0002\u0019AB*\u0003aqW\r\u001f;D_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM\u001d\t\u0005\u0007+\u001a)G\u0004\u0003\u0004X\r\rd\u0002BB-\u0007CrAaa\u0017\u0004`9!\u0011\u0011HB/\u0013\u0005\u0001\u0013B\u0001\u0010 \u0013\r\u0011Y'H\u0005\u0005\u0003\u0007\u0012I'\u0003\u0003\u0004h\r%$\u0001F\"p]N,gn];t\u000bB|7\r\u001b(v[\n,'O\u0003\u0003\u0002D\t%\u0004\"\u0002?\u0015\u0001\u0004I\bbBA\u0004)\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003+!\u0002\u0019AA\b\u0011\u001d\t9\u0010\u0006a\u0001\u0003sDqa!\u001e\u0015\u0001\u0004\t\u0019+\u0001\noKb$(\t\\8dWRKW.Z:uC6\u0004\u0018aD4fiB+g\u000eZ5oO\ncwnY6\u0015\t\rm4Q\u0010\t\u0005;\n]\u0016\tC\u0004\u0002lV\u0001\r!!<\u0002/\u001d,G/T1y\u00052|7m[(wKJDW-\u00193TSj,GC\u0001BV\u0003=9W\r^'bq\ncwnY6TSj,\u0007")
public class AccountForgeMessageBuilder
extends AbstractForgeMessageBuilder<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock>
implements ClosableResourceHandler {
    @Override
    public <A extends AutoCloseable, B> B using(A resource, Function1<A, B> fun) {
        return (B)ClosableResourceHandler.using$(this, resource, fun);
    }

    public Tuple3<Seq<EthereumConsensusDataReceipt>, Seq<AccountTransaction<Proposition, Proof<Proposition>>>, AccountBlockFeeInfo> computeBlockInfo(AccountStateView view, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, BlockContext blockContext, AddressProposition forgerAddress, long blockSize) {
        Tuple4 tuple4 = (Tuple4)this.tryApplyAndGetBlockInfo(view, mainchainBlockReferencesData, sidechainTransactions, blockContext, blockSize).get();
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Seq receiptList = (Seq)tuple4._1();
        Seq appliedTransactions = (Seq)tuple4._2();
        BigInteger cumBaseFee = (BigInteger)tuple4._3();
        BigInteger cumForgerTips = (BigInteger)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)receiptList, (Object)appliedTransactions, (Object)cumBaseFee, (Object)cumForgerTips);
        Tuple4 tuple43 = tuple42;
        Seq receiptList2 = (Seq)tuple43._1();
        Seq appliedTransactions2 = (Seq)tuple43._2();
        BigInteger cumBaseFee2 = (BigInteger)tuple43._3();
        BigInteger cumForgerTips2 = (BigInteger)tuple43._4();
        return new Tuple3((Object)receiptList2, (Object)appliedTransactions2, (Object)new AccountBlockFeeInfo(cumBaseFee2, cumForgerTips2, forgerAddress));
    }

    private Try<Tuple4<Seq<EthereumConsensusDataReceipt>, Seq<AccountTransaction<Proposition, Proof<Proposition>>>, BigInteger, BigInteger>> tryApplyAndGetBlockInfo(AccountStateView stateView, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, BlockContext blockContext, long blockSizeIn) {
        Try try_;
        Object object = new Object();
        try {
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                mainchainBlockReferencesData.foreach((Function1 & Serializable & scala.Serializable)mcBlockRefData -> {
                    AccountForgeMessageBuilder.$anonfun$tryApplyAndGetBlockInfo$2(stateView, mcBlockRefData);
                    return BoxedUnit.UNIT;
                });
                ListBuffer receiptList = new ListBuffer();
                ListBuffer listOfTxsInBlock = new ListBuffer();
                BigInteger cumGasUsed = BigInteger.ZERO;
                BigInteger cumBaseFee = BigInteger.ZERO;
                BigInteger cumForgerTips = BigInteger.ZERO;
                GasPool blockGasPool = new GasPool(blockContext$1.blockGasLimit);
                long blockSize = blockSizeIn;
                Iterator iter = sidechainTransactions.iterator();
                while (iter.hasNext()) {
                    AccountTransaction accountTransaction;
                    AccountTransaction<Proposition, Proof<Proposition>> accountTransaction2;
                    if (blockGasPool.getGas().compareTo(GasUtil$.MODULE$.TxGas()) < 0) {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isTraceEnabled()) {
                            this.log().underlying().trace("Finishing forging because block cannot contain any additional tx");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new NonLocalReturnControl(object, (Object)new Success((Object)new Tuple4((Object)receiptList, (Object)listOfTxsInBlock, (Object)cumBaseFee, (Object)cumForgerTips)));
                    }
                    TransactionsByPriceAndNonceIter priceAndNonceIter = (TransactionsByPriceAndNonceIter)iter;
                    AccountTransaction<Proposition, Proof<Proposition>> tx = priceAndNonceIter.peek();
                    long txSize = tx.size() + 1L;
                    if (blockSize + txSize > (long)this.getMaxBlockSize()) {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isTraceEnabled()) {
                            this.log().underlying().trace("Could not apply tx, reason: block size limit exceeded (block size: {}, tx size: {}, limit: {}", new Object[]{BoxesRunTime.boxToLong((long)blockSize), BoxesRunTime.boxToLong((long)txSize), BoxesRunTime.boxToInteger((int)this.getMaxBlockSize())});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        accountTransaction2 = priceAndNonceIter.removeAndSkipAccount();
                        continue;
                    }
                    Try<EthereumConsensusDataReceipt> try_ = stateView.applyTransaction(tx, listOfTxsInBlock.size(), blockGasPool, blockContext);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        EthereumConsensusDataReceipt consensusDataReceipt = (EthereumConsensusDataReceipt)success.value();
                        EthereumTransaction ethTx = (EthereumTransaction)tx;
                        receiptList.$plus$eq((Object)consensusDataReceipt);
                        listOfTxsInBlock.$plus$eq(tx);
                        BigInteger txGasUsed = consensusDataReceipt.cumulativeGasUsed().subtract(cumGasUsed);
                        cumGasUsed = consensusDataReceipt.cumulativeGasUsed();
                        Tuple2<BigInteger, BigInteger> tuple2 = GasUtil$.MODULE$.getTxFeesPerGas(ethTx, blockContext$1.baseFee);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        BigInteger txBaseFeePerGas = (BigInteger)tuple2._1();
                        BigInteger txForgerTipPerGas = (BigInteger)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)txBaseFeePerGas, (Object)txForgerTipPerGas);
                        Tuple2 tuple23 = tuple22;
                        BigInteger txBaseFeePerGas2 = (BigInteger)tuple23._1();
                        BigInteger txForgerTipPerGas2 = (BigInteger)tuple23._2();
                        cumBaseFee = cumBaseFee.add(txBaseFeePerGas2.multiply(txGasUsed));
                        cumForgerTips = cumForgerTips.add(txForgerTipPerGas2.multiply(txGasUsed));
                        blockSize += txSize;
                        accountTransaction = (AccountTransaction)priceAndNonceIter.next();
                    } else if (try_ instanceof Failure) {
                        AccountTransaction accountTransaction3;
                        BoxedUnit boxedUnit;
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        if (this.log().underlying().isTraceEnabled()) {
                            this.log().underlying().trace("Could not apply tx, reason: {}", new Object[]{err.getMessage()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        Throwable throwable = err;
                        if (throwable instanceof GasLimitReached) {
                            accountTransaction3 = priceAndNonceIter.removeAndSkipAccount();
                        } else {
                            if (throwable instanceof FeeCapTooLowException) {
                                throw new NonLocalReturnControl(object, (Object)new Success((Object)new Tuple4((Object)receiptList, (Object)listOfTxsInBlock, (Object)cumBaseFee, (Object)cumForgerTips)));
                            }
                            if (throwable instanceof NonceTooLowException) {
                                BoxedUnit boxedUnit2;
                                NonceTooLowException nonceTooLowException = (NonceTooLowException)throwable;
                                if (this.log().underlying().isErrorEnabled()) {
                                    this.log().underlying().error("******** Could not apply tx for NonceTooLowException ******* : {}", new Object[]{nonceTooLowException.getMessage()});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                accountTransaction3 = (AccountTransaction)priceAndNonceIter.next();
                            } else {
                                BoxedUnit boxedUnit3;
                                if (this.log().underlying().isWarnEnabled()) {
                                    this.log().underlying().warn(new StringBuilder(28).append("Could not forge tx, reason: ").append(throwable.getMessage()).toString(), throwable);
                                    boxedUnit3 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit3 = BoxedUnit.UNIT;
                                }
                                accountTransaction3 = priceAndNonceIter.removeAndSkipAccount();
                            }
                        }
                        accountTransaction = accountTransaction3;
                    } else {
                        throw new MatchError(try_);
                    }
                    accountTransaction2 = accountTransaction;
                }
                return new Tuple4((Object)receiptList, (Object)listOfTxsInBlock, (Object)cumBaseFee, (Object)cumForgerTips);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                try_ = (Try)ex.value();
            }
            throw ex;
        }
        return try_;
    }

    @Override
    public Try<SidechainBlockBase<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader>> createNewBlock(NodeViewHolder.CurrentView<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> nodeView, AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo, boolean isWithdrawalEpochLastBlock, String parentId, long timestamp, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, Seq<MainchainHeader> mainchainHeaders, Seq<Ommer<AccountBlockHeader>> ommers, PrivateKey25519 ownerPrivateKey, ForgingStakeInfo forgingStakeInfo, VrfProof vrfProof, VrfOutput vrfOutput, MerklePath forgingStakeInfoMerklePath, DynamicTypedSerializer<AccountTransaction<Proposition, Proof<Proposition>>, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> companion, int inputBlockSize, Option<Signature25519> signatureOption, boolean isPending) {
        Tuple4 tuple4;
        Tuple4 tuple42;
        List<Secret> addressList = ((AbstractWallet)nodeView.vault()).secretsOfType(PrivateKeySecp256k1.class);
        AddressProposition forgerAddress = (AddressProposition)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(addressList).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)x$3 -> (AddressProposition)x$3.publicImage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (!isPending) {
                throw new IllegalArgumentException("No addresses in wallet!");
            }
            return new AddressProposition(Address.ZERO);
        });
        BigInteger baseFee = FeeUtils$.MODULE$.calculateBaseFee((AccountHistory)nodeView.history(), parentId);
        GasFeeFork feeFork = GasFeeFork$.MODULE$.get(TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(super.params(), timestamp));
        BigInteger gasLimit = feeFork.blockGasLimit();
        SidechainBlockInfo parentInfo = ((AbstractHistory)nodeView.history()).blockInfoById(parentId);
        BlockContext blockContext = new BlockContext(forgerAddress.address(), timestamp, baseFee, gasLimit, parentInfo.height() + 1, TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(super.params(), timestamp), WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mainchainBlockReferencesData.size(), parentInfo.withdrawalEpochInfo(), super.params()).epoch(), super.params().chainId(), (HistoryBlockHashProvider)nodeView.history(), new Hash(vrfOutput.bytes()));
        String string = ((AbstractHistory)nodeView.history()).bestBlockId();
        String string2 = branchPointInfo.branchPointId();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            tuple42 = (Tuple4)this.using(((AccountState)nodeView.state()).getView(), (Function1 & Serializable & scala.Serializable)dummyView -> {
                Seq<AccountPayment> seq;
                Tuple3<Seq<EthereumConsensusDataReceipt>, Seq<AccountTransaction<Proposition, Proof<Proposition>>>, AccountBlockFeeInfo> resultTuple = this.computeBlockInfo((AccountStateView)dummyView, sidechainTransactions, mainchainBlockReferencesData, blockContext, forgerAddress, inputBlockSize);
                Seq receiptList = (Seq)resultTuple._1();
                Seq appliedTxList = (Seq)resultTuple._2();
                AccountBlockFeeInfo currentBlockPayments = (AccountBlockFeeInfo)resultTuple._3();
                if (isWithdrawalEpochLastBlock) {
                    String string = ((AbstractHistory)nodeView.history()).bestBlockId();
                    String string2 = branchPointInfo.branchPointId();
                    Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Last block of the withdrawal epoch expect to be a continuation of the tip.");
                    Predef$.MODULE$.require(ommers.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No Ommers allowed for the last block of the withdrawal epoch.");
                    int withdrawalEpochNumber = dummyView.getWithdrawalEpochInfo().epoch();
                    Seq<AccountPayment> feePayments = dummyView.getFeePaymentsInfo(withdrawalEpochNumber, (Option<AccountBlockFeeInfo>)new Some((Object)currentBlockPayments));
                    feePayments.foreach((Function1 & Serializable & scala.Serializable)payment -> {
                        dummyView.addBalance(payment.address().address(), payment.value());
                        return BoxedUnit.UNIT;
                    });
                    seq = feePayments;
                } else {
                    seq = (Seq<AccountPayment>)Nil$.MODULE$;
                }
                Seq<AccountPayment> feePayments = seq;
                return new Tuple4((Object)dummyView.getIntermediateRoot(), (Object)receiptList, (Object)appliedTxList, (Object)feePayments);
            });
        } else {
            Predef$.MODULE$.require(ommers.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected ommers when branching point is not the blockchain tip");
            Predef$.MODULE$.require(sidechainTransactions.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No txs expected in a block with ommers");
            Predef$.MODULE$.require(mainchainBlockReferencesData.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No Mainchain reference data expected in a block with ommers");
            tuple42 = tuple4 = new Tuple4((Object)((AccountBlock)((AbstractHistory)nodeView.history()).getBlockById(parentId).get()).header().stateRoot(), (Object)Nil$.MODULE$, (Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        byte[] stateRoot = (byte[])tuple4._1();
        Seq receiptList = (Seq)tuple4._2();
        Seq appliedTxList = (Seq)tuple4._3();
        Seq feePayments = (Seq)tuple4._4();
        Tuple4 tuple43 = new Tuple4((Object)stateRoot, (Object)receiptList, (Object)appliedTxList, (Object)feePayments);
        Tuple4 tuple44 = tuple43;
        byte[] stateRoot2 = (byte[])tuple44._1();
        Seq receiptList2 = (Seq)tuple44._2();
        Seq appliedTxList2 = (Seq)tuple44._3();
        Seq feePayments2 = (Seq)tuple44._4();
        byte[] receiptsRoot = AccountBlock$.MODULE$.calculateReceiptRoot((Seq<EthereumConsensusDataReceipt>)receiptList2);
        BigInteger gasUsed = (BigInteger)receiptList2.lastOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.cumulativeGasUsed()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
        byte[] feePaymentsHash = AccountFeePaymentsUtils$.MODULE$.calculateFeePaymentsHash((Seq<AccountPayment>)feePayments2);
        Bloom logsBloom = Bloom$.MODULE$.fromReceipts((Seq<EthereumConsensusDataReceipt>)receiptList2);
        Try<AccountBlock> block = AccountBlock$.MODULE$.create(parentId, AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION(), timestamp, mainchainBlockReferencesData, (Seq<AccountTransaction<Proposition, Proof<Proposition>>>)appliedTxList2, mainchainHeaders, ommers, ownerPrivateKey, forgingStakeInfo, vrfProof, vrfOutput, forgingStakeInfoMerklePath, feePaymentsHash, stateRoot2, receiptsRoot, forgerAddress, baseFee, gasUsed, gasLimit, (SidechainAccountTransactionsCompanion)companion, logsBloom, AccountBlock$.MODULE$.create$default$22());
        return block;
    }

    @Override
    public boolean createNewBlock$default$18() {
        return false;
    }

    @Override
    public int precalculateBlockHeaderSize(String parentId, long timestamp, ForgingStakeMerklePathInfo forgingStakeMerklePathInfo, VrfProof vrfProof) {
        AccountBlockHeader header = new AccountBlockHeader(AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION(), parentId, timestamp, forgingStakeMerklePathInfo.forgingStakeInfo(), forgingStakeMerklePathInfo.merklePath(), vrfProof, new VrfOutput(new byte[VrfOutput.OUTPUT_LENGTH]), new byte[MerkleTree.ROOT_HASH_LENGTH], new byte[MerkleTree.ROOT_HASH_LENGTH], new byte[MerkleTree.ROOT_HASH_LENGTH], new byte[MerkleTree.ROOT_HASH_LENGTH], AddressProposition.ZERO, BigInteger.ONE.shiftLeft(256).subtract(BigInteger.ONE), BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MAX_VALUE), new byte[MerkleTree.ROOT_HASH_LENGTH], Long.MAX_VALUE, new byte[NodeViewModifier$.MODULE$.ModifierIdSize()], new Bloom(), new Signature25519(new byte[Signature25519.SIGNATURE_LENGTH]));
        return header.bytes().length;
    }

    public MempoolMap.TransactionsByPriceAndNonce collectTransactionsFromMemPool(NodeViewHolder.CurrentView<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> nodeView, int blockSizeIn, Seq<MainchainBlockReferenceData> mainchainBlockReferenceData, WithdrawalEpochInfo withdrawalEpochInfo, long timestamp, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> forcedTx) {
        return ((AccountMemoryPool)nodeView.pool()).takeExecutableTxs(forcedTx);
    }

    @Override
    public int getOmmersSize(Seq<Ommer<AccountBlockHeader>> ommers) {
        ListSerializer<Ommer<AccountBlockHeader>> ommersSerializer = new ListSerializer<Ommer<AccountBlockHeader>>(AccountOmmerSerializer$.MODULE$);
        return ommersSerializer.toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(ommers).asJava()).length;
    }

    public byte[] getStateRoot(AccountHistory history, long forgedBlockTimestamp, AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo) {
        String parentId = branchPointInfo.branchPointId();
        String lastBlockId = history.getLastBlockIdOfPrePreviousEpochs(forgedBlockTimestamp, parentId);
        Optional lastBlock = history.getBlockById(lastBlockId);
        return ((AccountBlock)lastBlock.get()).header().stateRoot();
    }

    public Seq<ForgingStakeMerklePathInfo> getForgingStakeMerklePathInfo(int nextConsensusEpochNumber, AccountWallet wallet, AccountHistory history, AccountState state, AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo, long nextBlockTimestamp) {
        Seq secrets;
        Seq walletPubKeys;
        byte[] stateRoot = this.getStateRoot(history, nextBlockTimestamp, branchPointInfo);
        Seq forgingStakeInfoSeq = (Seq)this.using(state.getStateDbViewFromRoot(stateRoot), (Function1 & Serializable & scala.Serializable)stateViewFromRoot -> stateViewFromRoot.getOrderedForgingStakesInfoSeq());
        Seq filteredForgingStakeInfoSeq = (Seq)forgingStakeInfoSeq.filter(arg_0 -> AccountForgeMessageBuilder.$anonfun$getForgingStakeMerklePathInfo$3$adapted(walletPubKeys = (Seq)(secrets = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allSecrets()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> e.publicImage(), Seq$.MODULE$.canBuildFrom()), arg_0));
        if (filteredForgingStakeInfoSeq.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        MerkleTree forgingStakeInfoTree = MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)forgingStakeInfoSeq.map((Function1 & Serializable & scala.Serializable)info -> info.hash(), Seq$.MODULE$.canBuildFrom())).asJava());
        Buffer merkleTreeLeaves = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(forgingStakeInfoTree.leaves()).asScala()).map((Function1 & Serializable & scala.Serializable)leaf -> new ByteArrayWrapper((byte[])leaf), Buffer$.MODULE$.canBuildFrom());
        Seq forgingStakeMerklePathInfoSeq = (Seq)filteredForgingStakeInfoSeq.flatMap((Function1 & Serializable & scala.Serializable)forgingStakeInfo -> {
            Iterable iterable;
            int n = merkleTreeLeaves.indexOf((Object)new ByteArrayWrapper(forgingStakeInfo.hash()));
            switch (n) {
                case -1: {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isWarnEnabled()) {
                        this.log().underlying().warn("ForgingStakeInfo not a leaf in merkle tree: should never happen: {} ", new Object[]{forgingStakeInfo});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    break;
                }
                default: {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new ForgingStakeMerklePathInfo((ForgingStakeInfo)forgingStakeInfo, forgingStakeInfoTree.getMerklePathForLeaf(n))));
                    break;
                }
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        return forgingStakeMerklePathInfoSeq;
    }

    public Option<AccountBlock> getPendingBlock(NodeViewHolder.CurrentView<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> nodeView) {
        Option option;
        String bestBlockId = ((AbstractHistory)nodeView.history()).bestBlockId();
        AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo = new AbstractForgeMessageBuilder.BranchPointInfo(this, bestBlockId, (Seq<ByteArrayWrapper>)((Seq)Nil$.MODULE$), (Seq<ByteArrayWrapper>)((Seq)Nil$.MODULE$));
        PrivateKey25519 blockSignPrivateKey = new PrivateKey25519(new byte[PrivateKey25519.PRIVATE_KEY_LENGTH], new byte[PrivateKey25519.PUBLIC_KEY_LENGTH]);
        ForgingStakeInfo forgingStakeInfo = new ForgingStakeInfo(new PublicKey25519Proposition(new byte[PublicKey25519Proposition.KEY_LENGTH]), new VrfPublicKey(new byte[VrfPublicKey.KEY_LENGTH]), 0L);
        ForgingStakeMerklePathInfo forgingStakeMerklePathInfo = new ForgingStakeMerklePathInfo(forgingStakeInfo, new MerklePath(new ArrayList<Pair<Byte, byte[]>>()));
        VrfProof vrfProof = new VrfProof(new byte[VrfProof.PROOF_LENGTH]);
        SidechainBlockInfo bestBlockInfo = ((AbstractHistory)nodeView.history()).blockInfoById(bestBlockId);
        VrfOutput vrfOutput = (VrfOutput)bestBlockInfo.vrfOutputOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> new VrfOutput(new byte[VrfOutput.OUTPUT_LENGTH]));
        Timeout mcRefDataRetrievalTimeout = new Timeout(5L, TimeUnit.SECONDS);
        ForgeResult forgeResult = this.forgeBlock(nodeView, System.currentTimeMillis() / 1000L, branchPointInfo, forgingStakeMerklePathInfo, blockSignPrivateKey, vrfProof, vrfOutput, mcRefDataRetrievalTimeout, (Iterable)Nil$.MODULE$, true);
        if (forgeResult instanceof ForgeSuccess) {
            ForgeSuccess forgeSuccess = (ForgeSuccess)forgeResult;
            Object block = forgeSuccess.block();
            option = Option$.MODULE$.apply((Object)((AccountBlock)block));
        } else if (forgeResult instanceof ForgeFailure) {
            option = Option$.MODULE$.empty();
        } else {
            throw new MatchError((Object)forgeResult);
        }
        return option;
    }

    @Override
    public int getMaxBlockOverheadSize() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE();
    }

    @Override
    public int getMaxBlockSize() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_SIZE();
    }

    public static final /* synthetic */ void $anonfun$tryApplyAndGetBlockInfo$2(AccountStateView stateView$1, MainchainBlockReferenceData mcBlockRefData) {
        String dummyBlockId = package$.MODULE$.bytesToId(new byte[32]);
        stateView$1.addTopQualityCertificates(mcBlockRefData, dummyBlockId);
        stateView$1.applyMainchainBlockReferenceData(mcBlockRefData);
    }

    public static final /* synthetic */ boolean $anonfun$getForgingStakeMerklePathInfo$3(Seq walletPubKeys$1, ForgingStakeInfo p) {
        return walletPubKeys$1.contains((Object)p.blockSignPublicKey()) && walletPubKeys$1.contains((Object)p.vrfPublicKey());
    }

    public AccountForgeMessageBuilder(MainchainSynchronizer mainchainSynchronizer, SidechainAccountTransactionsCompanion companion, NetworkParams params, boolean allowNoWebsocketConnectionInRegtest) {
        super(mainchainSynchronizer, companion, params, allowNoWebsocketConnectionInRegtest);
        ClosableResourceHandler.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$getForgingStakeMerklePathInfo$3$adapted(Seq walletPubKeys$1, ForgingStakeInfo p) {
        return BoxesRunTime.boxToBoolean((boolean)AccountForgeMessageBuilder.$anonfun$getForgingStakeMerklePathInfo$3(walletPubKeys$1, p));
    }
}

