/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.block;

import akka.util.ByteString;
import io.horizen.account.block.AccountBlock$;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.proposition.AddressPropositionSerializer;
import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.account.utils.Bloom;
import io.horizen.account.utils.BloomSerializer$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.consensus.ForgingStakeInfoSerializer$;
import io.horizen.history.validation.InvalidSidechainBlockHeaderException;
import io.horizen.history.validation.InvalidSidechainBlockHeaderException$;
import io.horizen.proof.Signature25519;
import io.horizen.proof.Signature25519Serializer;
import io.horizen.proof.VrfProof;
import io.horizen.proof.VrfProofSerializer;
import io.horizen.utils.MerklePath;
import io.horizen.utils.MerklePathSerializer;
import io.horizen.utils.MerkleTree;
import io.horizen.vrf.VrfOutput;
import io.horizen.vrf.VrfOutputSerializer;
import java.math.BigInteger;
import scala.util.Try;
import sparkz.core.NodeViewModifier$;
import sparkz.core.package$;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Serializer;
import sparkz.util.serialization.Writer;

public final class AccountBlockHeaderSerializer$
implements SparkzSerializer<AccountBlockHeader> {
    public static AccountBlockHeaderSerializer$ MODULE$;

    static {
        new AccountBlockHeaderSerializer$();
    }

    public ByteString toByteString(Object obj) {
        return SparkzSerializer.toByteString$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseByteString(ByteString byteString) {
        return SparkzSerializer.parseByteString$((SparkzSerializer)this, (ByteString)byteString);
    }

    public Try<AccountBlockHeader> parseByteStringTry(ByteString byteString) {
        return SparkzSerializer.parseByteStringTry$((SparkzSerializer)this, (ByteString)byteString);
    }

    public byte[] toBytes(Object obj) {
        return SparkzSerializer.toBytes$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseBytes(byte[] bytes) {
        return SparkzSerializer.parseBytes$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<AccountBlockHeader> parseBytesTry(byte[] bytes) {
        return SparkzSerializer.parseBytesTry$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<AccountBlockHeader> parseTry(Reader r) {
        return Serializer.parseTry$((Serializer)this, (Reader)r);
    }

    public void serialize(AccountBlockHeader obj, Writer w) {
        w.put(obj.version());
        w.putBytes((byte[])package$.MODULE$.idToBytes().apply((Object)obj.parentId()));
        w.putLong(obj.timestamp());
        ForgingStakeInfoSerializer$.MODULE$.serialize(obj.forgingStakeInfo(), w);
        MerklePathSerializer.getSerializer().serialize(obj.forgingStakeMerklePath(), w);
        VrfProofSerializer.getSerializer().serialize(obj.vrfProof(), w);
        VrfOutputSerializer.getSerializer().serialize(obj.vrfOutput(), w);
        w.putBytes(obj.sidechainTransactionsMerkleRootHash());
        w.putBytes(obj.mainchainMerkleRootHash());
        w.putBytes(obj.stateRoot());
        w.putBytes(obj.receiptsRoot());
        AddressPropositionSerializer.getSerializer().serialize(obj.forgerAddress(), w);
        byte[] baseFee = obj.baseFee().toByteArray();
        w.putInt(baseFee.length);
        w.putBytes(baseFee);
        byte[] gasUsed = obj.gasUsed().toByteArray();
        w.putInt(gasUsed.length);
        w.putBytes(gasUsed);
        byte[] gasLimit = obj.gasLimit().toByteArray();
        w.putInt(gasLimit.length);
        w.putBytes(gasLimit);
        w.putBytes(obj.ommersMerkleRootHash());
        w.putLong(obj.ommersCumulativeScore());
        w.putBytes(obj.feePaymentsHash());
        BloomSerializer$.MODULE$.serialize(obj.logsBloom(), w);
        Signature25519Serializer.getSerializer().serialize(obj.signature(), w);
    }

    public AccountBlockHeader parse(Reader r) {
        byte version = r.getByte();
        if (version != AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION()) {
            throw new InvalidSidechainBlockHeaderException(new StringBuilder(42).append("SidechainAccountBlock version ").append(version).append(" is invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
        }
        String parentId = (String)package$.MODULE$.bytesToId().apply((Object)r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize()));
        long timestamp = r.getLong();
        ForgingStakeInfo forgingStakeInfo = ForgingStakeInfoSerializer$.MODULE$.parse(r);
        MerklePath forgingStakeMerkle = MerklePathSerializer.getSerializer().parse(r);
        VrfProof vrfProof = VrfProofSerializer.getSerializer().parse(r);
        VrfOutput vrfOutput = VrfOutputSerializer.getSerializer().parse(r);
        byte[] sidechainTransactionsMerkleRootHash = r.getBytes(MerkleTree.ROOT_HASH_LENGTH);
        byte[] mainchainMerkleRootHash = r.getBytes(MerkleTree.ROOT_HASH_LENGTH);
        byte[] stateRoot = r.getBytes(MerkleTree.ROOT_HASH_LENGTH);
        byte[] receiptsRoot = r.getBytes(MerkleTree.ROOT_HASH_LENGTH);
        AddressProposition forgerAddress = AddressPropositionSerializer.getSerializer().parse(r);
        int baseFeeSize = r.getInt();
        BigInteger baseFee = new BigIntegerUInt256(r.getBytes(baseFeeSize)).getBigInt();
        int gasUsedSize = r.getInt();
        BigInteger gasUsed = new BigIntegerUInt256(r.getBytes(gasUsedSize)).getBigInt();
        int gasLimitSize = r.getInt();
        BigInteger gasLimit = new BigIntegerUInt256(r.getBytes(gasLimitSize)).getBigInt();
        byte[] ommersMerkleRootHash = r.getBytes(MerkleTree.ROOT_HASH_LENGTH);
        long ommersCumulativeScore = r.getLong();
        byte[] feePaymentsHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        Bloom logsBloom = BloomSerializer$.MODULE$.parse(r);
        Signature25519 signature = Signature25519Serializer.getSerializer().parse(r);
        return new AccountBlockHeader(version, parentId, timestamp, forgingStakeInfo, forgingStakeMerkle, vrfProof, vrfOutput, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, stateRoot, receiptsRoot, forgerAddress, baseFee, gasUsed, gasLimit, ommersMerkleRootHash, ommersCumulativeScore, feePaymentsHash, logsBloom, signature);
    }

    private AccountBlockHeaderSerializer$() {
        MODULE$ = this;
        Serializer.$init$((Serializer)this);
        SparkzSerializer.$init$((SparkzSerializer)this);
    }
}

