/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.block;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import io.horizen.account.block.AccountBlock$;
import io.horizen.account.block.AccountBlockHeader$;
import io.horizen.account.block.AccountBlockHeaderSerializer$;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.utils.Bloom;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.history.validation.InvalidSidechainBlockHeaderException;
import io.horizen.history.validation.InvalidSidechainBlockHeaderException$;
import io.horizen.json.Views;
import io.horizen.json.serializer.MerklePathJsonSerializer;
import io.horizen.json.serializer.SparkzModifierIdSerializer;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.MerklePath;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple20;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.package$;
import sparkz.core.serialization.BytesSerializable;
import sparkz.core.serialization.SparkzSerializer;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"messageToSign", "serializer"})
@ScalaSignature(bytes="\u0006\u0001\u00115b\u0001B*U\u0001vC\u0001\"\u001f\u0001\u0003\u0016\u0004%\tE\u001f\u0005\n\u0003\u0013\u0001!\u0011#Q\u0001\nmD!\"a\u0003\u0001\u0005+\u0007I\u0011IA\u0007\u0011)\ty\u0003\u0001B\tB\u0003%\u0011q\u0002\u0005\u000b\u0003c\u0001!Q3A\u0005B\u0005M\u0002BCA\u001e\u0001\tE\t\u0015!\u0003\u00026!Q\u0011Q\b\u0001\u0003\u0016\u0004%\t%a\u0010\t\u0015\u00055\u0003A!E!\u0002\u0013\t\t\u0005\u0003\u0006\u0002P\u0001\u0011)\u001a!C!\u0003#B!\"a\u0018\u0001\u0005#\u0005\u000b\u0011BA*\u0011)\t\t\u0007\u0001BK\u0002\u0013\u0005\u00131\r\u0005\u000b\u0003c\u0002!\u0011#Q\u0001\n\u0005\u0015\u0004BCA:\u0001\tU\r\u0011\"\u0001\u0002v!Q\u00111\u0011\u0001\u0003\u0012\u0003\u0006I!a\u001e\t\u0015\u0005\u0015\u0005A!f\u0001\n\u0003\n9\t\u0003\u0006\u0002\u0016\u0002\u0011\t\u0012)A\u0005\u0003\u0013C!\"a&\u0001\u0005+\u0007I\u0011IAD\u0011)\tI\n\u0001B\tB\u0003%\u0011\u0011\u0012\u0005\u000b\u00037\u0003!Q3A\u0005\u0002\u0005\u001d\u0005BCAO\u0001\tE\t\u0015!\u0003\u0002\n\"Q\u0011q\u0014\u0001\u0003\u0016\u0004%\t!a\"\t\u0015\u0005\u0005\u0006A!E!\u0002\u0013\tI\t\u0003\u0006\u0002$\u0002\u0011)\u001a!C\u0001\u0003KC!\"a-\u0001\u0005#\u0005\u000b\u0011BAT\u0011)\t)\f\u0001BK\u0002\u0013\u0005\u0011q\u0017\u0005\u000b\u0003\u0013\u0004!\u0011#Q\u0001\n\u0005e\u0006BCAf\u0001\tU\r\u0011\"\u0001\u00028\"Q\u0011Q\u001a\u0001\u0003\u0012\u0003\u0006I!!/\t\u0015\u0005=\u0007A!f\u0001\n\u0003\t9\f\u0003\u0006\u0002R\u0002\u0011\t\u0012)A\u0005\u0003sC!\"a5\u0001\u0005+\u0007I\u0011IAD\u0011)\t)\u000e\u0001B\tB\u0003%\u0011\u0011\u0012\u0005\u000b\u0003/\u0004!Q3A\u0005B\u0005e\u0007BCAq\u0001\tE\t\u0015!\u0003\u0002\\\"Q\u00111\u001d\u0001\u0003\u0016\u0004%\t%a\"\t\u0015\u0005\u0015\bA!E!\u0002\u0013\tI\t\u0003\u0006\u0002h\u0002\u0011)\u001a!C\u0001\u0003SD!\"!>\u0001\u0005#\u0005\u000b\u0011BAv\u0011)\t9\u0010\u0001BK\u0002\u0013\u0005\u0013\u0011 \u0005\u000b\u0005\u0003\u0001!\u0011#Q\u0001\n\u0005m\bb\u0002B\u0002\u0001\u0011\u0005!QA\u0003\u0007\u0005_\u0002\u0001Ea\u0002\t\u000f\t]\u0002\u0001\"\u0011\u0003r!Q!\u0011\u0010\u0001\t\u0006\u0004%\t%a\"\t\u000f\tm\u0004\u0001\"\u0011\u0003~!9!Q\u0014\u0001\u0005B\t}\u0005\"\u0003BY\u0001\u0005\u0005I\u0011\u0001BZ\u0011%\u0011i\u000eAI\u0001\n\u0003\u0011y\u000eC\u0005\u0003t\u0002\t\n\u0011\"\u0001\u0003v\"I!\u0011 \u0001\u0012\u0002\u0013\u0005!1 \u0005\n\u0005\u007f\u0004\u0011\u0013!C\u0001\u0007\u0003A\u0011b!\u0002\u0001#\u0003%\taa\u0002\t\u0013\r-\u0001!%A\u0005\u0002\r5\u0001\"CB\t\u0001E\u0005I\u0011AB\n\u0011%\u00199\u0002AI\u0001\n\u0003\u0019I\u0002C\u0005\u0004\u001e\u0001\t\n\u0011\"\u0001\u0004\u001a!I1q\u0004\u0001\u0012\u0002\u0013\u00051\u0011\u0004\u0005\n\u0007C\u0001\u0011\u0013!C\u0001\u00073A\u0011ba\t\u0001#\u0003%\ta!\n\t\u0013\r%\u0002!%A\u0005\u0002\r-\u0002\"CB\u0018\u0001E\u0005I\u0011AB\u0016\u0011%\u0019\t\u0004AI\u0001\n\u0003\u0019Y\u0003C\u0005\u00044\u0001\t\n\u0011\"\u0001\u0004\u001a!I1Q\u0007\u0001\u0012\u0002\u0013\u00051q\u0007\u0005\n\u0007w\u0001\u0011\u0013!C\u0001\u00073A\u0011b!\u0010\u0001#\u0003%\taa\u0010\t\u0013\r\r\u0003!%A\u0005\u0002\r\u0015\u0003\"CB%\u0001\u0005\u0005I\u0011IB&\u0011%\u00199\u0006AA\u0001\n\u0003\u0019I\u0006C\u0005\u0004b\u0001\t\t\u0011\"\u0001\u0004d!I1q\u000e\u0001\u0002\u0002\u0013\u00053\u0011\u000f\u0005\n\u0007\u007f\u0002\u0011\u0011!C\u0001\u0007\u0003C\u0011ba#\u0001\u0003\u0003%\te!$\t\u0013\r=\u0005!!A\u0005B\rE\u0005BDBK\u0001A\u0005\u0019\u0011!A\u0005\n\r]51T\u0004\n\u0007\u001b$\u0016\u0011!E\u0001\u0007\u001f4\u0001b\u0015+\u0002\u0002#\u00051\u0011\u001b\u0005\b\u0005\u0007iE\u0011ABp\u0011%\u0011i*TA\u0001\n\u000b\u001a\t\u000fC\u0005\u0004d6\u000b\t\u0011\"!\u0004f\"IAqB'\u0002\u0002\u0013\u0005E\u0011\u0003\u0005\n\tGi\u0015\u0011!C\u0005\tK\u0011!#Q2d_VtGO\u00117pG.DU-\u00193fe*\u0011QKV\u0001\u0006E2|7m\u001b\u0006\u0003/b\u000bq!Y2d_VtGO\u0003\u0002Z5\u00069\u0001n\u001c:ju\u0016t'\"A.\u0002\u0005%|7\u0001A\n\u0007\u0001y#\u0017n\u001d<\u0011\u0005}\u0013W\"\u00011\u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0003\r\u0005s\u0017PU3g!\t)w-D\u0001g\u0015\t)\u0006,\u0003\u0002iM\nA2+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0007*Z1eKJ\u0014\u0015m]3\u0011\u0005)\fX\"A6\u000b\u00051l\u0017!D:fe&\fG.\u001b>bi&|gN\u0003\u0002o_\u0006!1m\u001c:f\u0015\u0005\u0001\u0018AB:qCJ\\'0\u0003\u0002sW\n\t\")\u001f;fgN+'/[1mSj\f'\r\\3\u0011\u0005}#\u0018BA;a\u0005\u001d\u0001&o\u001c3vGR\u0004\"aX<\n\u0005a\u0004'\u0001D*fe&\fG.\u001b>bE2,\u0017a\u0002<feNLwN\\\u000b\u0002wB\u0019A0a\u0001\u000f\u0005u|X\"\u0001@\u000b\u0005Uk\u0017bAA\u0001}\u0006)!\t\\8dW&!\u0011QAA\u0004\u0005\u001d1VM]:j_:T1!!\u0001\u007f\u0003!1XM]:j_:\u0004\u0013\u0001\u00039be\u0016tG/\u00133\u0016\u0005\u0005=\u0001\u0003BA\t\u0003SqA!a\u0005\u0002$9!\u0011QCA\u0010\u001d\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e9\u00061AH]8pizJ\u0011\u0001]\u0005\u0004\u0003Cy\u0017\u0001B;uS2LA!!\n\u0002(\u00059\u0001/Y2lC\u001e,'bAA\u0011_&!\u00111FA\u0017\u0005)iu\u000eZ5gS\u0016\u0014\u0018\n\u001a\u0006\u0005\u0003K\t9#A\u0005qCJ,g\u000e^%eA\u0005IA/[7fgR\fW\u000e]\u000b\u0003\u0003k\u00012\u0001`A\u001c\u0013\u0011\tI$a\u0002\u0003\u0013QKW.Z:uC6\u0004\u0018A\u0003;j[\u0016\u001cH/Y7qA\u0005\u0001bm\u001c:hS:<7\u000b^1lK&sgm\\\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fB\u0016!C2p]N,gn];t\u0013\u0011\tY%!\u0012\u0003!\u0019{'oZ5oON#\u0018m[3J]\u001a|\u0017!\u00054pe\u001eLgnZ*uC.,\u0017J\u001c4pA\u00051bm\u001c:hS:<7\u000b^1lK6+'o\u001b7f!\u0006$\b.\u0006\u0002\u0002TA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Za\u000bQ!\u001e;jYNLA!!\u0018\u0002X\tQQ*\u001a:lY\u0016\u0004\u0016\r\u001e5\u0002/\u0019|'oZ5oON#\u0018m[3NKJ\\G.\u001a)bi\"\u0004\u0013\u0001\u0003<sMB\u0013xn\u001c4\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-\u0004,A\u0003qe>|g-\u0003\u0003\u0002p\u0005%$\u0001\u0003,sMB\u0013xn\u001c4\u0002\u0013Y\u0014h\r\u0015:p_\u001a\u0004\u0013!\u0003<sM>+H\u000f];u+\t\t9\b\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bW\u0001\u0004mJ4\u0017\u0002BAA\u0003w\u0012\u0011B\u0016:g\u001fV$\b/\u001e;\u0002\u0015Y\u0014hmT;uaV$\b%A\u0012tS\u0012,7\r[1j]R\u0013\u0018M\\:bGRLwN\\:NKJ\\G.\u001a*p_RD\u0015m\u001d5\u0016\u0005\u0005%\u0005#B0\u0002\f\u0006=\u0015bAAGA\n)\u0011I\u001d:bsB\u0019q,!%\n\u0007\u0005M\u0005M\u0001\u0003CsR,\u0017\u0001J:jI\u0016\u001c\u0007.Y5o)J\fgn]1di&|gn]'fe.dWMU8pi\"\u000b7\u000f\u001b\u0011\u0002/5\f\u0017N\\2iC&tW*\u001a:lY\u0016\u0014vn\u001c;ICND\u0017\u0001G7bS:\u001c\u0007.Y5o\u001b\u0016\u00148\u000e\\3S_>$\b*Y:iA\u0005I1\u000f^1uKJ{w\u000e^\u0001\u000bgR\fG/\u001a*p_R\u0004\u0013\u0001\u0004:fG\u0016L\u0007\u000f^:S_>$\u0018!\u0004:fG\u0016L\u0007\u000f^:S_>$\b%A\u0007g_J<WM]!eIJ,7o]\u000b\u0003\u0003O\u0003B!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[3\u0016a\u00039s_B|7/\u001b;j_:LA!!-\u0002,\n\u0011\u0012\t\u001a3sKN\u001c\bK]8q_NLG/[8o\u000391wN]4fe\u0006#GM]3tg\u0002\nqAY1tK\u001a+W-\u0006\u0002\u0002:B!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017\u0001B7bi\"T!!a1\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\fiL\u0001\u0006CS\u001eLe\u000e^3hKJ\f\u0001BY1tK\u001a+W\rI\u0001\bO\u0006\u001cXk]3e\u0003!9\u0017m]+tK\u0012\u0004\u0013\u0001C4bg2KW.\u001b;\u0002\u0013\u001d\f7\u000fT5nSR\u0004\u0013\u0001F8n[\u0016\u00148/T3sW2,'k\\8u\u0011\u0006\u001c\b.A\u000bp[6,'o]'fe.dWMU8pi\"\u000b7\u000f\u001b\u0011\u0002+=lW.\u001a:t\u0007VlW\u000f\\1uSZ,7kY8sKV\u0011\u00111\u001c\t\u0004?\u0006u\u0017bAApA\n!Aj\u001c8h\u0003YyW.\\3sg\u000e+X.\u001e7bi&4XmU2pe\u0016\u0004\u0013a\u00044fKB\u000b\u00170\\3oiND\u0015m\u001d5\u0002!\u0019,W\rU1z[\u0016tGo\u001d%bg\"\u0004\u0013!\u00037pON\u0014En\\8n+\t\tY\u000f\u0005\u0003\u0002n\u0006EXBAAx\u0015\r\tIFV\u0005\u0005\u0003g\fyOA\u0003CY>|W.\u0001\u0006m_\u001e\u001c(\t\\8p[\u0002\n\u0011b]5h]\u0006$XO]3\u0016\u0005\u0005m\b\u0003BA4\u0003{LA!a@\u0002j\tq1+[4oCR,(/\u001a\u001a6kEJ\u0014AC:jO:\fG/\u001e:fA\u00051A(\u001b8jiz\"\"Fa\u0002\u0003\f\t5!\u0011\tB\"\u0005\u000b\u0012\tFa\u0015\u0003V\t]#\u0011\fB.\u0005;\u0012yF!\u0019\u0003d\t\u0015$q\rB5\u0005W\u0012i\u0007E\u0002\u0003\n\u0001i\u0011\u0001\u0016\u0005\u0006s&\u0002\ra\u001f\u0005\b\u0003\u0017I\u0003\u0019AA\bQ!\u0011iA!\u0005\u0003.\t=\u0002\u0003\u0002B\n\u0005Si!A!\u0006\u000b\t\t]!\u0011D\u0001\u000bC:tw\u000e^1uS>t'\u0002\u0002B\u000e\u0005;\t\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0005\u0005?\u0011\t#A\u0004kC\u000e\\7o\u001c8\u000b\t\t\r\"QE\u0001\nM\u0006\u001cH/\u001a:y[2T!Aa\n\u0002\u0007\r|W.\u0003\u0003\u0003,\tU!!\u0004&t_:\u001cVM]5bY&TX-A\u0003vg&twm\t\u0002\u00032A!!1\u0007B\u001f\u001b\t\u0011)D\u0003\u0003\u00038\te\u0012AC:fe&\fG.\u001b>fe*\u0019!1\b-\u0002\t)\u001cxN\\\u0005\u0005\u0005\u007f\u0011)D\u0001\u000eTa\u0006\u00148N_'pI&4\u0017.\u001a:JIN+'/[1mSj,'\u000fC\u0004\u00022%\u0002\r!!\u000e\t\u000f\u0005u\u0012\u00061\u0001\u0002B!9\u0011qJ\u0015A\u0002\u0005M\u0003\u0006\u0003B#\u0005#\u0011iC!\u0013$\u0005\t-\u0003\u0003\u0002B\u001a\u0005\u001bJAAa\u0014\u00036\tAR*\u001a:lY\u0016\u0004\u0016\r\u001e5Kg>t7+\u001a:jC2L'0\u001a:\t\u000f\u0005\u0005\u0014\u00061\u0001\u0002f!9\u00111O\u0015A\u0002\u0005]\u0004bBACS\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003/K\u0003\u0019AAE\u0011\u001d\tY*\u000ba\u0001\u0003\u0013Cq!a(*\u0001\u0004\tI\tC\u0004\u0002$&\u0002\r!a*\t\u000f\u0005U\u0016\u00061\u0001\u0002:\"9\u00111Z\u0015A\u0002\u0005e\u0006bBAhS\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003'L\u0003\u0019AAE\u0011\u001d\t9.\u000ba\u0001\u00037Dq!a9*\u0001\u0004\tI\tC\u0004\u0002h&\u0002\r!a;\t\u000f\u0005]\u0018\u00061\u0001\u0002|\n\tQ*\u0006\u0002\u0003tA)!N!\u001e\u0003\b%\u0019!qO6\u0003!M\u0003\u0018M]6{'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018!D7fgN\fw-\u001a+p'&<g.\u0001\ttK6\fg\u000e^5d-\u0006d\u0017\u000eZ5usR!!q\u0010BH!\u0019\u0011\tI!\"\u0003\n6\u0011!1\u0011\u0006\u0004\u0003C\u0001\u0017\u0002\u0002BD\u0005\u0007\u00131\u0001\u0016:z!\ry&1R\u0005\u0004\u0005\u001b\u0003'\u0001B+oSRDqA!%.\u0001\u0004\u0011\u0019*\u0001\u0004qCJ\fWn\u001d\t\u0005\u0005+\u0013I*\u0004\u0002\u0003\u0018*\u0019!\u0011\u0013-\n\t\tm%q\u0013\u0002\u000e\u001d\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!)\u0011\t\t\r&1\u0016\b\u0005\u0005K\u00139\u000bE\u0002\u0002\u0018\u0001L1A!+a\u0003\u0019\u0001&/\u001a3fM&!!Q\u0016BX\u0005\u0019\u0019FO]5oO*\u0019!\u0011\u00161\u0002\t\r|\u0007/\u001f\u000b+\u0005\u000f\u0011)La.\u0003:\nm&Q\u0018B`\u0005\u0003\u0014\u0019M!2\u0003H\n%'1\u001aBg\u0005\u001f\u0014\tNa5\u0003V\n]'\u0011\u001cBn\u0011\u001dIx\u0006%AA\u0002mD\u0011\"a\u00030!\u0003\u0005\r!a\u0004\t\u0013\u0005Er\u0006%AA\u0002\u0005U\u0002\"CA\u001f_A\u0005\t\u0019AA!\u0011%\tye\fI\u0001\u0002\u0004\t\u0019\u0006C\u0005\u0002b=\u0002\n\u00111\u0001\u0002f!I\u00111O\u0018\u0011\u0002\u0003\u0007\u0011q\u000f\u0005\n\u0003\u000b{\u0003\u0013!a\u0001\u0003\u0013C\u0011\"a&0!\u0003\u0005\r!!#\t\u0013\u0005mu\u0006%AA\u0002\u0005%\u0005\"CAP_A\u0005\t\u0019AAE\u0011%\t\u0019k\fI\u0001\u0002\u0004\t9\u000bC\u0005\u00026>\u0002\n\u00111\u0001\u0002:\"I\u00111Z\u0018\u0011\u0002\u0003\u0007\u0011\u0011\u0018\u0005\n\u0003\u001f|\u0003\u0013!a\u0001\u0003sC\u0011\"a50!\u0003\u0005\r!!#\t\u0013\u0005]w\u0006%AA\u0002\u0005m\u0007\"CAr_A\u0005\t\u0019AAE\u0011%\t9o\fI\u0001\u0002\u0004\tY\u000fC\u0005\u0002x>\u0002\n\u00111\u0001\u0002|\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BqU\rY(1]\u0016\u0003\u0005K\u0004BAa:\u0003p6\u0011!\u0011\u001e\u0006\u0005\u0005W\u0014i/A\u0005v]\u000eDWmY6fI*\u0019!q\u00031\n\t\tE(\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005oTC!a\u0004\u0003d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u007fU\u0011\t)Da9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u001111\u0001\u0016\u0005\u0003\u0003\u0012\u0019/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r%!\u0006BA*\u0005G\fabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0004\u0010)\"\u0011Q\rBr\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]*\"a!\u0006+\t\u0005]$1]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019YB\u000b\u0003\u0002\n\n\r\u0018AD2paf$C-\u001a4bk2$H%O\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132a\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\n\u0014'A\bd_BLH\u0005Z3gCVdG\u000fJ\u00193+\t\u00199C\u000b\u0003\u0002(\n\r\u0018aD2paf$C-\u001a4bk2$H%M\u001a\u0016\u0005\r5\"\u0006BA]\u0005G\fqbY8qs\u0012\"WMZ1vYR$\u0013\u0007N\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132k\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\nd'A\bd_BLH\u0005Z3gCVdG\u000fJ\u00198+\t\u0019ID\u000b\u0003\u0002\\\n\r\u0018aD2paf$C-\u001a4bk2$H%\r\u001d\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%ce*\"a!\u0011+\t\u0005-(1]\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133aU\u00111q\t\u0016\u0005\u0003w\u0014\u0019/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007\u001b\u0002Baa\u0014\u0004V5\u00111\u0011\u000b\u0006\u0005\u0007'\n\t-\u0001\u0003mC:<\u0017\u0002\u0002BW\u0007#\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"aa\u0017\u0011\u0007}\u001bi&C\u0002\u0004`\u0001\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$Ba!\u001a\u0004lA\u0019qla\u001a\n\u0007\r%\u0004MA\u0002B]fD\u0011b!\u001cG\u0003\u0003\u0005\raa\u0017\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019\u0019\b\u0005\u0004\u0004v\rm4QM\u0007\u0003\u0007oR1a!\u001fa\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007{\u001a9H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BBB\u0007\u0013\u00032aXBC\u0013\r\u00199\t\u0019\u0002\b\u0005>|G.Z1o\u0011%\u0019i\u0007SA\u0001\u0002\u0004\u0019)'\u0001\u0005iCND7i\u001c3f)\t\u0019Y&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0007\u0007\u001b\u0019\nC\u0005\u0004n)\u000b\t\u00111\u0001\u0004f\u000512/\u001e9fe\u0012\u001aX-\\1oi&\u001cg+\u00197jI&$\u0018\u0010\u0006\u0003\u0003\u0000\re\u0005b\u0002BI\u0017\u0002\u0007!1S\u0005\u0004\u0005w:\u0007f\u0002\u0001\u0004 \u000e%61\u0016\t\u0005\u0007C\u001b)+\u0004\u0002\u0004$*!!q\u0003B\u000f\u0013\u0011\u00199ka)\u0003))\u001bxN\\%h]>\u0014X\r\u0015:pa\u0016\u0014H/[3t\u0003\u00151\u0018\r\\;fY\u0011\u0019ika,\"\u0005\te\u0014E\u0001B\u001cQ\u001d\u000111WBU\u0007s\u0003Ba!)\u00046&!1qWBR\u0005!Q5o\u001c8WS\u0016<HFAB^G\t\u0019i\f\u0005\u0003\u0004@\u000e\u001dg\u0002BBa\u0007\u0007l!A!\u000f\n\t\r\u0015'\u0011H\u0001\u0006-&,wo]\u0005\u0005\u0007\u0013\u001cYMA\u0004EK\u001a\fW\u000f\u001c;\u000b\t\r\u0015'\u0011H\u0001\u0013\u0003\u000e\u001cw.\u001e8u\u00052|7m\u001b%fC\u0012,'\u000fE\u0002\u0003\n5\u001bB!TBjmBi3Q[Bnw\u0006=\u0011QGA!\u0003'\n)'a\u001e\u0002\n\u0006%\u0015\u0011RAE\u0003O\u000bI,!/\u0002:\u0006%\u00151\\AE\u0003W\fYPa\u0002\u000e\u0005\r]'bABmA\u00069!/\u001e8uS6,\u0017\u0002BBo\u0007/\u0014!#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83aQ\u00111q\u001a\u000b\u0003\u0007\u001b\nQ!\u00199qYf$\"Fa\u0002\u0004h\u000e%81^Bw\u0007_\u001c\tpa=\u0004v\u000e]8\u0011`B~\u0007{\u001cy\u0010\"\u0001\u0005\u0004\u0011\u0015Aq\u0001C\u0005\t\u0017!i\u0001C\u0003z!\u0002\u00071\u0010C\u0004\u0002\fA\u0003\r!a\u0004\t\u000f\u0005E\u0002\u000b1\u0001\u00026!9\u0011Q\b)A\u0002\u0005\u0005\u0003bBA(!\u0002\u0007\u00111\u000b\u0005\b\u0003C\u0002\u0006\u0019AA3\u0011\u001d\t\u0019\b\u0015a\u0001\u0003oBq!!\"Q\u0001\u0004\tI\tC\u0004\u0002\u0018B\u0003\r!!#\t\u000f\u0005m\u0005\u000b1\u0001\u0002\n\"9\u0011q\u0014)A\u0002\u0005%\u0005bBAR!\u0002\u0007\u0011q\u0015\u0005\b\u0003k\u0003\u0006\u0019AA]\u0011\u001d\tY\r\u0015a\u0001\u0003sCq!a4Q\u0001\u0004\tI\fC\u0004\u0002TB\u0003\r!!#\t\u000f\u0005]\u0007\u000b1\u0001\u0002\\\"9\u00111\u001d)A\u0002\u0005%\u0005bBAt!\u0002\u0007\u00111\u001e\u0005\b\u0003o\u0004\u0006\u0019AA~\u0003\u001d)h.\u00199qYf$B\u0001b\u0005\u0005 A)q\f\"\u0006\u0005\u001a%\u0019Aq\u00031\u0003\r=\u0003H/[8o!)zF1D>\u0002\u0010\u0005U\u0012\u0011IA*\u0003K\n9(!#\u0002\n\u0006%\u0015\u0011RAT\u0003s\u000bI,!/\u0002\n\u0006m\u0017\u0011RAv\u0003wL1\u0001\"\ba\u0005\u001d!V\u000f\u001d7feAB\u0011\u0002\"\tR\u0003\u0003\u0005\rAa\u0002\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001C\u0014!\u0011\u0019y\u0005\"\u000b\n\t\u0011-2\u0011\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class AccountBlockHeader
implements SidechainBlockHeaderBase,
BytesSerializable,
Product {
    private byte[] messageToSign;
    private final byte version;
    private final String parentId;
    private final long timestamp;
    private final ForgingStakeInfo forgingStakeInfo;
    private final MerklePath forgingStakeMerklePath;
    private final VrfProof vrfProof;
    private final VrfOutput vrfOutput;
    private final byte[] sidechainTransactionsMerkleRootHash;
    private final byte[] mainchainMerkleRootHash;
    private final byte[] stateRoot;
    private final byte[] receiptsRoot;
    private final AddressProposition forgerAddress;
    private final BigInteger baseFee;
    private final BigInteger gasUsed;
    private final BigInteger gasLimit;
    private final byte[] ommersMerkleRootHash;
    private final long ommersCumulativeScore;
    private final byte[] feePaymentsHash;
    private final Bloom logsBloom;
    private final Signature25519 signature;
    @JsonSerialize(using=SparkzModifierIdSerializer.class)
    private String id;
    private volatile byte bitmap$0;

    public static Option<Tuple20<Object, String, Object, ForgingStakeInfo, MerklePath, VrfProof, VrfOutput, byte[], byte[], byte[], byte[], AddressProposition, BigInteger, BigInteger, BigInteger, byte[], Object, byte[], Bloom, Signature25519>> unapply(AccountBlockHeader accountBlockHeader) {
        return AccountBlockHeader$.MODULE$.unapply(accountBlockHeader);
    }

    public static AccountBlockHeader apply(byte by, String string, long l, ForgingStakeInfo forgingStakeInfo, MerklePath merklePath, VrfProof vrfProof, VrfOutput vrfOutput, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, AddressProposition addressProposition, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray5, long l2, byte[] byArray6, Bloom bloom, Signature25519 signature25519) {
        return AccountBlockHeader$.MODULE$.apply(by, string, l, forgingStakeInfo, merklePath, vrfProof, vrfOutput, byArray, byArray2, byArray3, byArray4, addressProposition, bigInteger, bigInteger2, bigInteger3, byArray5, l2, byArray6, bloom, signature25519);
    }

    public static Function1<Tuple20<Object, String, Object, ForgingStakeInfo, MerklePath, VrfProof, VrfOutput, byte[], byte[], byte[], byte[], AddressProposition, BigInteger, BigInteger, BigInteger, byte[], Object, byte[], Bloom, Signature25519>, AccountBlockHeader> tupled() {
        return AccountBlockHeader$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<String, Function1<Object, Function1<ForgingStakeInfo, Function1<MerklePath, Function1<VrfProof, Function1<VrfOutput, Function1<byte[], Function1<byte[], Function1<byte[], Function1<byte[], Function1<AddressProposition, Function1<BigInteger, Function1<BigInteger, Function1<BigInteger, Function1<byte[], Function1<Object, Function1<byte[], Function1<Bloom, Function1<Signature25519, AccountBlockHeader>>>>>>>>>>>>>>>>>>>> curried() {
        return AccountBlockHeader$.MODULE$.curried();
    }

    public byte[] bytes() {
        return BytesSerializable.bytes$((BytesSerializable)this);
    }

    private String id$lzycompute() {
        AccountBlockHeader accountBlockHeader = this;
        synchronized (accountBlockHeader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.id = SidechainBlockHeaderBase.id$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.id;
    }

    @Override
    public String id() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.id$lzycompute() : this.id;
    }

    private /* synthetic */ Try super$semanticValidity(NetworkParams params) {
        return SidechainBlockHeaderBase.semanticValidity$(this, params);
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public String parentId() {
        return this.parentId;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public ForgingStakeInfo forgingStakeInfo() {
        return this.forgingStakeInfo;
    }

    @Override
    public MerklePath forgingStakeMerklePath() {
        return this.forgingStakeMerklePath;
    }

    @Override
    public VrfProof vrfProof() {
        return this.vrfProof;
    }

    public VrfOutput vrfOutput() {
        return this.vrfOutput;
    }

    @Override
    public byte[] sidechainTransactionsMerkleRootHash() {
        return this.sidechainTransactionsMerkleRootHash;
    }

    @Override
    public byte[] mainchainMerkleRootHash() {
        return this.mainchainMerkleRootHash;
    }

    public byte[] stateRoot() {
        return this.stateRoot;
    }

    public byte[] receiptsRoot() {
        return this.receiptsRoot;
    }

    public AddressProposition forgerAddress() {
        return this.forgerAddress;
    }

    public BigInteger baseFee() {
        return this.baseFee;
    }

    public BigInteger gasUsed() {
        return this.gasUsed;
    }

    public BigInteger gasLimit() {
        return this.gasLimit;
    }

    @Override
    public byte[] ommersMerkleRootHash() {
        return this.ommersMerkleRootHash;
    }

    @Override
    public long ommersCumulativeScore() {
        return this.ommersCumulativeScore;
    }

    @Override
    public byte[] feePaymentsHash() {
        return this.feePaymentsHash;
    }

    public Bloom logsBloom() {
        return this.logsBloom;
    }

    @Override
    public Signature25519 signature() {
        return this.signature;
    }

    public SparkzSerializer<AccountBlockHeader> serializer() {
        return AccountBlockHeaderSerializer$.MODULE$;
    }

    private byte[] messageToSign$lzycompute() {
        AccountBlockHeader accountBlockHeader = this;
        synchronized (accountBlockHeader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.messageToSign = Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{this.version()}), ClassTag$.MODULE$.Byte()), (byte[])package$.MODULE$.idToBytes().apply((Object)this.parentId()), Longs.toByteArray((long)this.timestamp()), this.forgingStakeInfo().hash(), this.vrfProof().bytes(), this.vrfOutput().bytes(), this.forgingStakeMerklePath().bytes(), this.sidechainTransactionsMerkleRootHash(), this.mainchainMerkleRootHash(), this.stateRoot(), this.receiptsRoot(), this.forgerAddress().bytes(), this.baseFee().toByteArray(), this.gasUsed().toByteArray(), this.gasLimit().toByteArray(), this.ommersMerkleRootHash(), Longs.toByteArray((long)this.ommersCumulativeScore()), this.feePaymentsHash(), this.logsBloom().getBytes()});
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.messageToSign;
    }

    @Override
    public byte[] messageToSign() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.messageToSign$lzycompute() : this.messageToSign;
    }

    @Override
    public Try<BoxedUnit> semanticValidity(NetworkParams params) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Try try_ = this.super$semanticValidity(params);
            if (try_ instanceof Success) {
                if (this.stateRoot().length != MerkleTree.ROOT_HASH_LENGTH) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(51).append("AccountBlockHeader ").append(this.id()).append(": invalid stateRoot.length ").append(this.stateRoot().length).append(" != ").append(MerkleTree.ROOT_HASH_LENGTH).append(".").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
                if (this.receiptsRoot().length != MerkleTree.ROOT_HASH_LENGTH) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(54).append("AccountBlockHeader ").append(this.id()).append(": invalid receiptsRoot.length ").append(this.receiptsRoot().length).append(" != ").append(MerkleTree.ROOT_HASH_LENGTH).append(".").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
                if (this.version() != AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION()) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(41).append("AccountBlockHeader ").append(this.id()).append(": version ").append(this.version()).append(" is invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
                if (!this.signature().isValid(this.forgingStakeInfo().blockSignPublicKey(), this.messageToSign())) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(42).append("AccountBlockHeader ").append(this.id()).append(": signature is invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
                Try try_2 = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.gasLimit().longValueExact());
                if (!(try_2 instanceof Success)) {
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable exception = failure.exception();
                        throw new InvalidSidechainBlockHeaderException(new StringBuilder(46).append("AccountBlockHeader ").append(this.id()).append(": gasLimit size overflows. ").append(exception.getMessage()).toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                    }
                    throw new MatchError((Object)try_2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Try try_3 = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.gasUsed().longValueExact());
                if (!(try_3 instanceof Success)) {
                    if (try_3 instanceof Failure) {
                        Failure failure = (Failure)try_3;
                        Throwable exception = failure.exception();
                        throw new InvalidSidechainBlockHeaderException(new StringBuilder(46).append("AccountBlockHeader ").append(this.id()).append(": gasUsed size overflows.. ").append(exception.getMessage()).toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                    }
                    throw new MatchError((Object)try_3);
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                if (this.baseFee().signum() < 1) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(68).append("AccountBlockHeader ").append(this.id()).append(": baseFee=").append(this.baseFee()).append(" is non positive and therefore invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
                GasFeeFork feeFork = GasFeeFork$.MODULE$.get(TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params, this.timestamp()));
                if (this.gasLimit().compareTo(feeFork.blockGasLimit()) != 0) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(42).append("AccountBlockHeader ").append(this.id()).append(": gasLimit=").append(this.gasLimit()).append(" is invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
                if (this.gasUsed().signum() < 0) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(66).append("AccountBlockHeader ").append(this.id()).append(": gasUsed=").append(this.gasUsed()).append(" is below zero and therefore invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
                if (this.gasUsed().compareTo(this.gasLimit()) > 0) {
                    throw new InvalidSidechainBlockHeaderException(new StringBuilder(78).append("AccountBlockHeader ").append(this.id()).append(": gasUsed=").append(this.gasUsed()).append(" is greater than gasLimit=").append(this.gasLimit()).append(" and therefore invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
                }
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw exception;
                }
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return new StringBuilder(48).append("AccountBlockHeader(").append(this.id()).append(", ").append(this.version()).append(", ").append(this.timestamp()).append(", ").append(this.forgingStakeInfo()).append(", ").append(this.vrfProof()).append(", ").append(BytesUtils.toHexString(this.sidechainTransactionsMerkleRootHash())).append(", ").append(BytesUtils.toHexString(this.mainchainMerkleRootHash())).append(", ").append(BytesUtils.toHexString(this.stateRoot())).append(", ").append(BytesUtils.toHexString(this.receiptsRoot())).append(", ").append(this.forgerAddress()).append(this.baseFee()).append(", ").append(this.gasUsed()).append(", ").append(this.gasLimit()).append(", ").append(BytesUtils.toHexString(this.ommersMerkleRootHash())).append(", ").append(this.ommersCumulativeScore()).append(", ").append(this.signature()).append(")").toString();
    }

    public AccountBlockHeader copy(byte version, String parentId, long timestamp, ForgingStakeInfo forgingStakeInfo, MerklePath forgingStakeMerklePath, VrfProof vrfProof, VrfOutput vrfOutput, byte[] sidechainTransactionsMerkleRootHash, byte[] mainchainMerkleRootHash, byte[] stateRoot, byte[] receiptsRoot, AddressProposition forgerAddress, BigInteger baseFee, BigInteger gasUsed, BigInteger gasLimit, byte[] ommersMerkleRootHash, long ommersCumulativeScore, byte[] feePaymentsHash, Bloom logsBloom, Signature25519 signature) {
        return new AccountBlockHeader(version, parentId, timestamp, forgingStakeInfo, forgingStakeMerklePath, vrfProof, vrfOutput, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, stateRoot, receiptsRoot, forgerAddress, baseFee, gasUsed, gasLimit, ommersMerkleRootHash, ommersCumulativeScore, feePaymentsHash, logsBloom, signature);
    }

    public byte copy$default$1() {
        return this.version();
    }

    public byte[] copy$default$10() {
        return this.stateRoot();
    }

    public byte[] copy$default$11() {
        return this.receiptsRoot();
    }

    public AddressProposition copy$default$12() {
        return this.forgerAddress();
    }

    public BigInteger copy$default$13() {
        return this.baseFee();
    }

    public BigInteger copy$default$14() {
        return this.gasUsed();
    }

    public BigInteger copy$default$15() {
        return this.gasLimit();
    }

    public byte[] copy$default$16() {
        return this.ommersMerkleRootHash();
    }

    public long copy$default$17() {
        return this.ommersCumulativeScore();
    }

    public byte[] copy$default$18() {
        return this.feePaymentsHash();
    }

    public Bloom copy$default$19() {
        return this.logsBloom();
    }

    public String copy$default$2() {
        return this.parentId();
    }

    public Signature25519 copy$default$20() {
        return this.signature();
    }

    public long copy$default$3() {
        return this.timestamp();
    }

    public ForgingStakeInfo copy$default$4() {
        return this.forgingStakeInfo();
    }

    public MerklePath copy$default$5() {
        return this.forgingStakeMerklePath();
    }

    public VrfProof copy$default$6() {
        return this.vrfProof();
    }

    public VrfOutput copy$default$7() {
        return this.vrfOutput();
    }

    public byte[] copy$default$8() {
        return this.sidechainTransactionsMerkleRootHash();
    }

    public byte[] copy$default$9() {
        return this.mainchainMerkleRootHash();
    }

    public String productPrefix() {
        return "AccountBlockHeader";
    }

    public int productArity() {
        return 20;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToByte((byte)this.version());
                break;
            }
            case 1: {
                object = this.parentId();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.timestamp());
                break;
            }
            case 3: {
                object = this.forgingStakeInfo();
                break;
            }
            case 4: {
                object = this.forgingStakeMerklePath();
                break;
            }
            case 5: {
                object = this.vrfProof();
                break;
            }
            case 6: {
                object = this.vrfOutput();
                break;
            }
            case 7: {
                object = this.sidechainTransactionsMerkleRootHash();
                break;
            }
            case 8: {
                object = this.mainchainMerkleRootHash();
                break;
            }
            case 9: {
                object = this.stateRoot();
                break;
            }
            case 10: {
                object = this.receiptsRoot();
                break;
            }
            case 11: {
                object = this.forgerAddress();
                break;
            }
            case 12: {
                object = this.baseFee();
                break;
            }
            case 13: {
                object = this.gasUsed();
                break;
            }
            case 14: {
                object = this.gasLimit();
                break;
            }
            case 15: {
                object = this.ommersMerkleRootHash();
                break;
            }
            case 16: {
                object = BoxesRunTime.boxToLong((long)this.ommersCumulativeScore());
                break;
            }
            case 17: {
                object = this.feePaymentsHash();
                break;
            }
            case 18: {
                object = this.logsBloom();
                break;
            }
            case 19: {
                object = this.signature();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AccountBlockHeader;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.version());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parentId()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.forgingStakeInfo()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.forgingStakeMerklePath()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.vrfProof()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.vrfOutput()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sidechainTransactionsMerkleRootHash()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.mainchainMerkleRootHash()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stateRoot()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.receiptsRoot()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.forgerAddress()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.baseFee()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.gasUsed()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.gasLimit()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ommersMerkleRootHash()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.ommersCumulativeScore()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.feePaymentsHash()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.logsBloom()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.signature()));
        return Statics.finalizeHash((int)n, (int)20);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AccountBlockHeader)) return false;
        boolean bl = true;
        if (!bl) return false;
        AccountBlockHeader accountBlockHeader = (AccountBlockHeader)x$1;
        if (this.version() != accountBlockHeader.version()) return false;
        String string = this.parentId();
        String string2 = accountBlockHeader.parentId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.timestamp() != accountBlockHeader.timestamp()) return false;
        ForgingStakeInfo forgingStakeInfo = this.forgingStakeInfo();
        ForgingStakeInfo forgingStakeInfo2 = accountBlockHeader.forgingStakeInfo();
        if (forgingStakeInfo == null) {
            if (forgingStakeInfo2 != null) {
                return false;
            }
        } else if (!((Object)forgingStakeInfo).equals(forgingStakeInfo2)) return false;
        MerklePath merklePath = this.forgingStakeMerklePath();
        MerklePath merklePath2 = accountBlockHeader.forgingStakeMerklePath();
        if (merklePath == null) {
            if (merklePath2 != null) {
                return false;
            }
        } else if (!((Object)merklePath).equals(merklePath2)) return false;
        VrfProof vrfProof = this.vrfProof();
        VrfProof vrfProof2 = accountBlockHeader.vrfProof();
        if (vrfProof == null) {
            if (vrfProof2 != null) {
                return false;
            }
        } else if (!((Object)vrfProof).equals(vrfProof2)) return false;
        VrfOutput vrfOutput = this.vrfOutput();
        VrfOutput vrfOutput2 = accountBlockHeader.vrfOutput();
        if (vrfOutput == null) {
            if (vrfOutput2 != null) {
                return false;
            }
        } else if (!((Object)vrfOutput).equals(vrfOutput2)) return false;
        if (this.sidechainTransactionsMerkleRootHash() != accountBlockHeader.sidechainTransactionsMerkleRootHash()) return false;
        if (this.mainchainMerkleRootHash() != accountBlockHeader.mainchainMerkleRootHash()) return false;
        if (this.stateRoot() != accountBlockHeader.stateRoot()) return false;
        if (this.receiptsRoot() != accountBlockHeader.receiptsRoot()) return false;
        AddressProposition addressProposition = this.forgerAddress();
        AddressProposition addressProposition2 = accountBlockHeader.forgerAddress();
        if (addressProposition == null) {
            if (addressProposition2 != null) {
                return false;
            }
        } else if (!((Object)addressProposition).equals(addressProposition2)) return false;
        if (!BoxesRunTime.equalsNumNum((Number)this.baseFee(), (Number)accountBlockHeader.baseFee())) return false;
        if (!BoxesRunTime.equalsNumNum((Number)this.gasUsed(), (Number)accountBlockHeader.gasUsed())) return false;
        if (!BoxesRunTime.equalsNumNum((Number)this.gasLimit(), (Number)accountBlockHeader.gasLimit())) return false;
        if (this.ommersMerkleRootHash() != accountBlockHeader.ommersMerkleRootHash()) return false;
        if (this.ommersCumulativeScore() != accountBlockHeader.ommersCumulativeScore()) return false;
        if (this.feePaymentsHash() != accountBlockHeader.feePaymentsHash()) return false;
        Bloom bloom = this.logsBloom();
        Bloom bloom2 = accountBlockHeader.logsBloom();
        if (bloom == null) {
            if (bloom2 != null) {
                return false;
            }
        } else if (!((Object)bloom).equals(bloom2)) return false;
        Signature25519 signature25519 = this.signature();
        Signature25519 signature255192 = accountBlockHeader.signature();
        if (signature25519 == null) {
            if (signature255192 != null) {
                return false;
            }
        } else if (!((Object)signature25519).equals(signature255192)) return false;
        if (!accountBlockHeader.canEqual(this)) return false;
        return true;
    }

    public AccountBlockHeader(byte version, @JsonSerialize(using=SparkzModifierIdSerializer.class) String parentId, long timestamp, ForgingStakeInfo forgingStakeInfo, @JsonSerialize(using=MerklePathJsonSerializer.class) MerklePath forgingStakeMerklePath, VrfProof vrfProof, VrfOutput vrfOutput, byte[] sidechainTransactionsMerkleRootHash, byte[] mainchainMerkleRootHash, byte[] stateRoot, byte[] receiptsRoot, AddressProposition forgerAddress, BigInteger baseFee, BigInteger gasUsed, BigInteger gasLimit, byte[] ommersMerkleRootHash, long ommersCumulativeScore, byte[] feePaymentsHash, Bloom logsBloom, Signature25519 signature) {
        this.version = version;
        this.parentId = parentId;
        this.timestamp = timestamp;
        this.forgingStakeInfo = forgingStakeInfo;
        this.forgingStakeMerklePath = forgingStakeMerklePath;
        this.vrfProof = vrfProof;
        this.vrfOutput = vrfOutput;
        this.sidechainTransactionsMerkleRootHash = sidechainTransactionsMerkleRootHash;
        this.mainchainMerkleRootHash = mainchainMerkleRootHash;
        this.stateRoot = stateRoot;
        this.receiptsRoot = receiptsRoot;
        this.forgerAddress = forgerAddress;
        this.baseFee = baseFee;
        this.gasUsed = gasUsed;
        this.gasLimit = gasLimit;
        this.ommersMerkleRootHash = ommersMerkleRootHash;
        this.ommersCumulativeScore = ommersCumulativeScore;
        this.feePaymentsHash = feePaymentsHash;
        this.logsBloom = logsBloom;
        this.signature = signature;
        SidechainBlockHeaderBase.$init$(this);
        BytesSerializable.$init$((BytesSerializable)this);
        Product.$init$((Product)this);
    }
}

