/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.service;

import io.horizen.account.api.rpc.service.Backend;
import io.horizen.account.api.rpc.service.Backend$GasAndReward$2$;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import sparkz.util.package;
import supertagged.package;

public final class Backend$ {
    public static Backend$ MODULE$;
    private final BigInteger MAX_GAS_PRICE;

    static {
        new Backend$();
    }

    private BigInteger MAX_GAS_PRICE() {
        return this.MAX_GAS_PRICE;
    }

    public BigInteger calculateGasPrice(AccountHistory history, BigInteger baseFee) {
        return this.suggestTipCap(history).add(baseFee).min(this.MAX_GAS_PRICE());
    }

    public BigInteger suggestTipCap(AccountHistory history) {
        return this.suggestTipCap(history, 20, 60, this.MAX_GAS_PRICE(), BigInteger.TWO);
    }

    public BigInteger suggestTipCap(AccountHistory history, int blockCount, int percentile, BigInteger maxPrice, BigInteger ignorePrice) {
        int blockHeight = history.getCurrentHeight();
        Integer blocks = Predef$.MODULE$.int2Integer(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(blockCount * 2), blockHeight)), 1024));
        int limit = 3;
        IntRef collected = IntRef.create((int)0);
        BooleanRef moreBlocksNeeded = BooleanRef.create((boolean)false);
        Seq prices = (Seq)((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(blocks)).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> !moreBlocksNeeded$1.elem || collected$1.elem < 2).map((Function1 & Serializable & scala.Serializable)i -> Backend$.$anonfun$suggestTipCap$2(history, blockHeight, ignorePrice, limit, collected, blockCount, moreBlocksNeeded, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return ((BigInteger)((Option)((PartialFunction)prices.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).lift().apply((Object)BoxesRunTime.boxToInteger((int)((prices.length() - 1) * percentile / 100)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO)).min(maxPrice);
    }

    public int suggestTipCap$default$2() {
        return 20;
    }

    public int suggestTipCap$default$3() {
        return 60;
    }

    public BigInteger suggestTipCap$default$4() {
        return this.MAX_GAS_PRICE();
    }

    public BigInteger suggestTipCap$default$5() {
        return BigInteger.TWO;
    }

    private Seq<BigInteger> getBlockPrices(AccountBlock block, BigInteger ignoreUnder, int limit) {
        return (Seq)((IterableLike)((SeqLike)((TraversableLike)((TraversableLike)block.transactions().filter((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)Backend$.$anonfun$getBlockPrices$1(block, tx)))).map((Function1 & Serializable & scala.Serializable)tx -> MODULE$.getEffectiveGasTip((EthereumTransaction)tx, block.header().baseFee()), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)gasTip -> BoxesRunTime.boxToBoolean((boolean)Backend$.$anonfun$getBlockPrices$3(ignoreUnder, gasTip)))).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).take(limit);
    }

    public BigInteger[] getRewardsForBlock(AccountBlock block, AccountStateView stateView, double[] percentiles) {
        public class Io_horizen_account_api_rpc_service_Backend$GasAndReward$1
        implements Product,
        scala.Serializable {
            private final long gasUsed;
            private final BigInteger reward;

            public long gasUsed() {
                return this.gasUsed;
            }

            public BigInteger reward() {
                return this.reward;
            }

            public Io_horizen_account_api_rpc_service_Backend$GasAndReward$1 copy(long gasUsed, BigInteger reward) {
                return new Io_horizen_account_api_rpc_service_Backend$GasAndReward$1(gasUsed, reward);
            }

            public long copy$default$1() {
                return this.gasUsed();
            }

            public BigInteger copy$default$2() {
                return this.reward();
            }

            public String productPrefix() {
                return "GasAndReward";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Number number;
                int n = x$1;
                switch (n) {
                    case 0: {
                        number = BoxesRunTime.boxToLong((long)this.gasUsed());
                        break;
                    }
                    case 1: {
                        number = this.reward();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return number;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Io_horizen_account_api_rpc_service_Backend$GasAndReward$1;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.gasUsed()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reward()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Io_horizen_account_api_rpc_service_Backend$GasAndReward$1 var4_4 = (Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)x$1;
                if (this.gasUsed() != var4_4.gasUsed()) return false;
                if (!BoxesRunTime.equalsNumNum((Number)this.reward(), (Number)var4_4.reward())) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public Io_horizen_account_api_rpc_service_Backend$GasAndReward$1(long gasUsed, BigInteger reward) {
                this.gasUsed = gasUsed;
                this.reward = reward;
                Product.$init$((Product)this);
            }
        }
        LazyRef GasAndReward$module = new LazyRef();
        Seq txs = (Seq)block.transactions().map((Function1 & Serializable & scala.Serializable)x$3 -> (EthereumTransaction)x$3, Seq$.MODULE$.canBuildFrom());
        if (txs.isEmpty()) {
            return (BigInteger[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentiles)).map((Function1 & Serializable & scala.Serializable)x$4 -> Backend$.$anonfun$getRewardsForBlock$2(BoxesRunTime.unboxToDouble((Object)x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BigInteger.class)));
        }
        Iterator sortedRewards = ((IterableLike)((SeqLike)txs.map((Function1 & Serializable & scala.Serializable)tx -> this.GasAndReward$3(GasAndReward$module).apply(((EthereumReceipt)stateView.getTransactionReceipt(BytesUtils.fromHexString(tx.id())).get()).gasUsed().longValueExact(), MODULE$.getEffectiveGasTip((EthereumTransaction)tx, block.header().baseFee())), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.reward(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).iterator();
        ObjectRef current = ObjectRef.create((Object)((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)sortedRewards.next()));
        LongRef sumGasUsed = LongRef.create((long)((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)current.elem).gasUsed());
        BigInteger[] rewards = new BigInteger[percentiles.length];
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentiles)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long thresholdGasUsed = (long)(block.header().gasUsed().doubleValue() * percentiles[i] / (double)100);
            while (sumGasUsed$1.elem < thresholdGasUsed && sortedRewards.hasNext()) {
                current$1.elem = (Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)sortedRewards.next();
                sumGasUsed$1.elem += ((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)current$1.elem).gasUsed();
            }
            rewards$1[i] = ((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)current$1.elem).reward();
        });
        return rewards;
    }

    private BigInteger getEffectiveGasTip(EthereumTransaction tx, BigInteger baseFee) {
        return baseFee == null ? tx.getMaxPriorityFeePerGas() : tx.getMaxPriorityFeePerGas().min(tx.getMaxFeePerGas().subtract(baseFee));
    }

    public static final /* synthetic */ Seq $anonfun$suggestTipCap$2(AccountHistory history$1, int blockHeight$1, BigInteger ignorePrice$1, int limit$1, IntRef collected$1, int blockCount$1, BooleanRef moreBlocksNeeded$1, int i) {
        Seq<BigInteger> blockPrices;
        block0: {
            AccountBlock block = (AccountBlock)history$1.blockIdByHeight(blockHeight$1 - i).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)package.ModifierId$.MODULE$.apply(x$2, package.Tagger$.MODULE$.baseRaw())).flatMap((Function1 & Serializable & scala.Serializable)blockId -> history$1.getStorageBlockById((String)blockId)).get();
            blockPrices = MODULE$.getBlockPrices(block, ignorePrice$1, limit$1);
            collected$1.elem += blockPrices.length();
            if (i < blockCount$1) break block0;
            moreBlocksNeeded$1.elem = true;
        }
        return blockPrices;
    }

    public static final /* synthetic */ boolean $anonfun$getBlockPrices$1(AccountBlock block$1, AccountTransaction tx) {
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(tx.getFrom().bytes())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(block$1.forgerPublicKey().bytes()));
    }

    public static final /* synthetic */ boolean $anonfun$getBlockPrices$3(BigInteger ignoreUnder$1, BigInteger gasTip) {
        return ignoreUnder$1 == null || gasTip.compareTo(ignoreUnder$1) >= 0;
    }

    public static final /* synthetic */ BigInteger $anonfun$getRewardsForBlock$2(double x$4) {
        return BigInteger.ZERO;
    }

    private static final /* synthetic */ Backend$GasAndReward$2$ GasAndReward$lzycompute$1(LazyRef GasAndReward$module$1) {
        Backend$GasAndReward$2$ backend$GasAndReward$2$;
        LazyRef lazyRef = GasAndReward$module$1;
        synchronized (lazyRef) {
            backend$GasAndReward$2$ = GasAndReward$module$1.initialized() ? (Backend$GasAndReward$2$)((Object)GasAndReward$module$1.value()) : (Backend$GasAndReward$2$)((Object)GasAndReward$module$1.initialize((Object)new Backend$GasAndReward$2$()));
        }
        return backend$GasAndReward$2$;
    }

    private final Backend$GasAndReward$2$ GasAndReward$3(LazyRef GasAndReward$module$1) {
        return GasAndReward$module$1.initialized() ? (Backend$GasAndReward$2$)((Object)GasAndReward$module$1.value()) : Backend$.GasAndReward$lzycompute$1(GasAndReward$module$1);
    }

    private Backend$() {
        MODULE$ = this;
        this.MAX_GAS_PRICE = FeeUtils$.MODULE$.INITIAL_BASE_FEE().multiply(BigInteger.valueOf(500L));
    }
}

