/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.request;

import com.fasterxml.jackson.databind.JsonNode;
import io.horizen.account.api.rpc.handler.RpcException;
import io.horizen.account.api.rpc.request.RpcId;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.account.api.rpc.utils.RpcError;
import java.util.List;

public class RpcRequest {
    public final String jsonrpc;
    public final RpcId id;
    public final String method;
    public final JsonNode params;
    private static final List<String> mandatoryFields = List.of("jsonrpc", "id", "method");
    private static final List<String> stringFields = List.of("jsonrpc", "method");
    private static final String JSON_RPC_VERSION = "2.0";

    public RpcRequest(JsonNode json) throws RpcException {
        for (String field : mandatoryFields) {
            if (json.has(field)) continue;
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidRequest, String.format("missing field: %s", field)));
        }
        for (String field : stringFields) {
            if (json.get(field).isTextual()) continue;
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidRequest, String.format("field must be string: %s", field)));
        }
        try {
            this.id = new RpcId(json.get("id"));
        }
        catch (IllegalArgumentException e) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidRequest, e.getMessage()));
        }
        this.jsonrpc = json.get("jsonrpc").asText();
        if (!this.jsonrpc.equals(JSON_RPC_VERSION)) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidRequest, "jsonrpc value is not valid"));
        }
        this.method = json.get("method").asText();
        this.params = json.get("params");
    }

    public String toString() {
        return String.format("RpcRequest={jsonrpc='%s', id='%s', method='%s', params=%s}", this.jsonrpc, this.id.toString(), this.method, this.params);
    }
}

