/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.http.route;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import io.horizen.AbstractSidechainNodeViewHolder;
import io.horizen.account.api.http.route.AccountWalletApiRoute$;
import io.horizen.account.api.http.route.AccountWalletErrorResponse;
import io.horizen.account.api.http.route.AccountWalletRestScheme;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.secret.PrivateKeySecp256k1;
import io.horizen.account.secret.PrivateKeySecp256k1Creator;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.api.http.ApiResponseUtil$;
import io.horizen.api.http.JacksonSupport$;
import io.horizen.api.http.route.WalletBaseApiRoute;
import io.horizen.api.http.route.WalletBaseErrorResponse;
import io.horizen.api.http.route.WalletBaseRestScheme;
import io.horizen.companion.SidechainSecretsCompanion;
import io.horizen.node.NodeWalletBase;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.core.settings.RESTApiSettings;

@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0014)\u0001VB\u0001b\u001f\u0001\u0003\u0016\u0004%\t\u0005 \u0005\f\u0003\u001b\u0001!\u0011#Q\u0001\nu\fy\u0001\u0003\u0006\u0002\u0012\u0001\u0011)\u001a!C\u0001\u0003'A!\"!\n\u0001\u0005#\u0005\u000b\u0011BA\u000b\u0011)\t9\u0003\u0001BK\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003o\u0001!\u0011#Q\u0001\n\u0005-\u0002BCA\u001d\u0001\t\u0015\r\u0011b\u0011\u0002<!a\u00111\t\u0001\u0003\u0002\u0003\u0006I!!\u0010\u0002F!Q\u0011q\t\u0001\u0003\u0006\u0004%\u0019%!\u0013\t\u0019\u0005]\u0003A!A!\u0002\u0013\tY%!\u0017\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!A\u0011\u0006\u0001b\u0001\n\u0003\ny\u0007\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BA9\u0011%\t\t\u000b\u0001b\u0001\n\u0007\n\u0019\u000b\u0003\u0005\u00022\u0002\u0001\u000b\u0011BAS\u0011\u001d\t\u0019\f\u0001C\u0001\u0003_Bq!!.\u0001\t\u0003\ty\u0007C\u0004\u00028\u0002!\t!a\u001c\t\u000f\u0005e\u0006\u0001\"\u0001\u0002p!I\u00111\u0018\u0001\u0002\u0002\u0013\u0005\u0011Q\u0018\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0001\u0003\u001bD\u0011\"a9\u0001#\u0003%\t!!:\t\u0013\u0005%\b!%A\u0005\u0002\u0005-\b\"CAx\u0001\u0005\u0005I\u0011IAy\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\u000e\u0001\t\t\u0011\"\u0001\u0003\u0010!I!1\u0004\u0001\u0002\u0002\u0013\u0005#Q\u0004\u0005\n\u0005W\u0001\u0011\u0011!C\u0001\u0005[A\u0011Ba\u000e\u0001\u0003\u0003%\tE!\u000f\t\u0013\tm\u0002!!A\u0005B\tu\u0002\"\u0003B \u0001\u0005\u0005I\u0011\tB!\u000f%\u0011)\u0005KA\u0001\u0012\u0003\u00119E\u0002\u0005(Q\u0005\u0005\t\u0012\u0001B%\u0011\u001d\tY&\tC\u0001\u0005#B\u0011Ba\u000f\"\u0003\u0003%)E!\u0010\t\u0013\tM\u0013%!A\u0005\u0002\nU\u0003\"\u0003B2C\u0005\u0005I\u0011\u0011B3\u0011%\u00119(IA\u0001\n\u0013\u0011IHA\u000bBG\u000e|WO\u001c;XC2dW\r^!qSJ{W\u000f^3\u000b\u0005%R\u0013!\u0002:pkR,'BA\u0016-\u0003\u0011AG\u000f\u001e9\u000b\u00055r\u0013aA1qS*\u0011q\u0006M\u0001\bC\u000e\u001cw.\u001e8u\u0015\t\t$'A\u0004i_JL'0\u001a8\u000b\u0003M\n!![8\u0004\u0001M!\u0001A\u000e:y!-94(P(V1z#w\r\\8\u000e\u0003aR!!K\u001d\u000b\u0005-R$BA\u00171\u0013\ta\u0004H\u0001\nXC2dW\r\u001e\"bg\u0016\f\u0005/\u001b*pkR,\u0007\u0003\u0002 B\u0007&k\u0011a\u0010\u0006\u0003\u0001:\n1\u0002\u001e:b]N\f7\r^5p]&\u0011!i\u0010\u0002\u0013\u0003\u000e\u001cw.\u001e8u)J\fgn]1di&|g\u000e\u0005\u0002E\u000f6\tQI\u0003\u0002Ga\u0005Y\u0001O]8q_NLG/[8o\u0013\tAUIA\u0006Qe>\u0004xn]5uS>t\u0007c\u0001&N\u00076\t1J\u0003\u0002Ma\u0005)\u0001O]8pM&\u0011aj\u0013\u0002\u0006!J|wN\u001a\t\u0003!Nk\u0011!\u0015\u0006\u0003%:\nQA\u00197pG.L!\u0001V)\u0003%\u0005\u001b7m\\;oi\ncwnY6IK\u0006$WM\u001d\t\u0003!ZK!aV)\u0003\u0019\u0005\u001b7m\\;oi\ncwnY6\u0011\u0005ecV\"\u0001.\u000b\u0005ms\u0013!B2iC&t\u0017BA/[\u0005Y\t5mY8v]R4U-\u001a)bs6,g\u000e^:J]\u001a|\u0007CA0c\u001b\u0005\u0001'BA1/\u0003\u0011qw\u000eZ3\n\u0005\r\u0004'A\u0005(pI\u0016\f5mY8v]RD\u0015n\u001d;pef\u0004\"aX3\n\u0005\u0019\u0004'\u0001\u0005(pI\u0016\f5mY8v]R\u001cF/\u0019;f!\tA'.D\u0001j\u0015\t\t\u0007'\u0003\u0002lS\nqaj\u001c3f/\u0006dG.\u001a;CCN,\u0007CA0n\u0013\tq\u0007MA\u000bO_\u0012,\u0017iY2pk:$X*Z7pef\u0004vn\u001c7\u0011\u0005}\u0003\u0018BA9a\u0005=\t5mY8v]Rtu\u000eZ3WS\u0016<\bCA:w\u001b\u0005!(\"A;\u0002\u000bM\u001c\u0017\r\\1\n\u0005]$(a\u0002)s_\u0012,8\r\u001e\t\u0003gfL!A\u001f;\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011M,G\u000f^5oON,\u0012! \t\u0004}\u0006%Q\"A@\u000b\u0007m\f\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B2pe\u0016T!!a\u0002\u0002\rM\u0004\u0018M]6{\u0013\r\tYa \u0002\u0010%\u0016\u001bF+\u00119j'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0005\u0003wn\n!d]5eK\u000eD\u0017-\u001b8O_\u0012,g+[3x\u0011>dG-\u001a:SK\u001a,\"!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005)\u0011m\u0019;pe*\u0011\u0011qD\u0001\u0005C.\\\u0017-\u0003\u0003\u0002$\u0005e!\u0001C!di>\u0014(+\u001a4\u00027MLG-Z2iC&tgj\u001c3f-&,w\u000fS8mI\u0016\u0014(+\u001a4!\u0003e\u0019\u0018\u000eZ3dQ\u0006LgnU3de\u0016$8oQ8na\u0006t\u0017n\u001c8\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\u0002'A\u0005d_6\u0004\u0018M\\5p]&!\u0011QGA\u0018\u0005e\u0019\u0016\u000eZ3dQ\u0006LgnU3de\u0016$8oQ8na\u0006t\u0017n\u001c8\u00025MLG-Z2iC&t7+Z2sKR\u001c8i\\7qC:LwN\u001c\u0011\u0002\u000f\r|g\u000e^3yiV\u0011\u0011Q\b\t\u0005\u0003/\ty$\u0003\u0003\u0002B\u0005e!aD!di>\u0014(+\u001a4GC\u000e$xN]=\u0002\u0011\r|g\u000e^3yi\u0002J1!!\u000f<\u0003\t)7-\u0006\u0002\u0002LA!\u0011QJA*\u001b\t\tyEC\u0002\u0002RQ\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\t)&a\u0014\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA%\u0019\u0011qI\u001e\u0002\rqJg.\u001b;?)!\ty&!\u001b\u0002l\u00055DCBA1\u0003K\n9\u0007E\u0002\u0002d\u0001i\u0011\u0001\u000b\u0005\b\u0003sY\u00019AA\u001f\u0011\u001d\t9e\u0003a\u0002\u0003\u0017BQa_\u0006A\u0002uDq!!\u0005\f\u0001\u0004\t)\u0002C\u0004\u0002(-\u0001\r!a\u000b\u0016\u0005\u0005E\u0004\u0003BA:\u00033sA!!\u001e\u0002\u0014:!\u0011qOAG\u001d\u0011\tI(a\"\u000f\t\u0005m\u0014Q\u0011\b\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011\u001b\u0002\rq\u0012xn\u001c;?\u0013\t\ty\"C\u0002,\u0003;IA!!#\u0002\f\u0006A1oY1mC\u0012\u001cHNC\u0002,\u0003;IA!a$\u0002\u0012\u000611/\u001a:wKJTA!!#\u0002\f&!\u0011QSAL\u0003\u001d\u0001\u0018mY6bO\u0016TA!a$\u0002\u0012&!\u00111TAO\u0005\u0015\u0011v.\u001e;f\u0015\u0011\t)*a&\u0002\rI|W\u000f^3!\u0003\r!\u0018mZ\u000b\u0003\u0003K\u0003R!a*\u0002.>l!!!+\u000b\u0007\u0005-F/A\u0004sK\u001adWm\u0019;\n\t\u0005=\u0016\u0011\u0016\u0002\t\u00072\f7o\u001d+bO\u0006!A/Y4!\u0003e\u0019'/Z1uKB\u0013\u0018N^1uK.+\u0017pU3daJ*dg[\u0019\u0002\u0015\u001d,GOQ1mC:\u001cW-A\bhKR$v\u000e^1m\u0005\u0006d\u0017M\\2f\u000399W\r^!mY\n\u000bG.\u00198dKN\fAaY8qsRA\u0011qXAc\u0003\u000f\fI\r\u0006\u0004\u0002b\u0005\u0005\u00171\u0019\u0005\b\u0003s!\u00029AA\u001f\u0011\u001d\t9\u0005\u0006a\u0002\u0003\u0017Bqa\u001f\u000b\u0011\u0002\u0003\u0007Q\u0010C\u0005\u0002\u0012Q\u0001\n\u00111\u0001\u0002\u0016!I\u0011q\u0005\u000b\u0011\u0002\u0003\u0007\u00111F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyMK\u0002~\u0003#\\#!a5\u0011\t\u0005U\u0017q\\\u0007\u0003\u0003/TA!!7\u0002\\\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;$\u0018AC1o]>$\u0018\r^5p]&!\u0011\u0011]Al\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9O\u000b\u0003\u0002\u0016\u0005E\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003[TC!a\u000b\u0002R\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a=\u0011\t\u0005U\u0018q`\u0007\u0003\u0003oTA!!?\u0002|\u0006!A.\u00198h\u0015\t\ti0\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0001\u0003o\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0004!\r\u0019(\u0011B\u0005\u0004\u0005\u0017!(aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\t\u0005/\u00012a\u001dB\n\u0013\r\u0011)\u0002\u001e\u0002\u0004\u0003:L\b\"\u0003B\r5\u0005\u0005\t\u0019\u0001B\u0004\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0004\t\u0007\u0005C\u00119C!\u0005\u000e\u0005\t\r\"b\u0001B\u0013i\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%\"1\u0005\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00030\tU\u0002cA:\u00032%\u0019!1\u0007;\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u0004\u000f\u0002\u0002\u0003\u0007!\u0011C\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qA\u0001\ti>\u001cFO]5oOR\u0011\u00111_\u0001\u0007KF,\u0018\r\\:\u0015\t\t=\"1\t\u0005\n\u00053y\u0012\u0011!a\u0001\u0005#\tQ#Q2d_VtGoV1mY\u0016$\u0018\t]5S_V$X\rE\u0002\u0002d\u0005\u001aB!\tB&qB\u00191O!\u0014\n\u0007\t=CO\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u000f\nQ!\u00199qYf$\u0002Ba\u0016\u0003^\t}#\u0011\r\u000b\u0007\u0003C\u0012IFa\u0017\t\u000f\u0005eB\u0005q\u0001\u0002>!9\u0011q\t\u0013A\u0004\u0005-\u0003\"B>%\u0001\u0004i\bbBA\tI\u0001\u0007\u0011Q\u0003\u0005\b\u0003O!\u0003\u0019AA\u0016\u0003\u001d)h.\u00199qYf$BAa\u001a\u0003tA)1O!\u001b\u0003n%\u0019!1\u000e;\u0003\r=\u0003H/[8o!!\u0019(qN?\u0002\u0016\u0005-\u0012b\u0001B9i\n1A+\u001e9mKNB\u0011B!\u001e&\u0003\u0003\u0005\r!!\u0019\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B>!\u0011\t)P! \n\t\t}\u0014q\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class AccountWalletApiRoute
extends WalletBaseApiRoute<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView>
implements Product,
scala.Serializable {
    private final ActorRef sidechainNodeViewHolderRef;
    private final SidechainSecretsCompanion sidechainSecretsCompanion;
    private final Function1<RequestContext, Future<RouteResult>> route;
    private final ClassTag<AccountNodeView> tag;

    public static Option<Tuple3<RESTApiSettings, ActorRef, SidechainSecretsCompanion>> unapply(AccountWalletApiRoute accountWalletApiRoute) {
        return AccountWalletApiRoute$.MODULE$.unapply(accountWalletApiRoute);
    }

    public static AccountWalletApiRoute apply(RESTApiSettings rESTApiSettings, ActorRef actorRef, SidechainSecretsCompanion sidechainSecretsCompanion, ActorRefFactory actorRefFactory, ExecutionContext executionContext) {
        return AccountWalletApiRoute$.MODULE$.apply(rESTApiSettings, actorRef, sidechainSecretsCompanion, actorRefFactory, executionContext);
    }

    @Override
    public RESTApiSettings settings() {
        return super.settings();
    }

    @Override
    public ActorRef sidechainNodeViewHolderRef() {
        return this.sidechainNodeViewHolderRef;
    }

    public SidechainSecretsCompanion sidechainSecretsCompanion() {
        return this.sidechainSecretsCompanion;
    }

    @Override
    public ActorRefFactory context() {
        return super.context();
    }

    @Override
    public ExecutionContext ec() {
        return super.ec();
    }

    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.route;
    }

    @Override
    public ClassTag<AccountNodeView> tag() {
        return this.tag;
    }

    public Function1<RequestContext, Future<RouteResult>> createPrivateKeySecp256k1() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createPrivateKeySecp256k1")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$1 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(WalletBaseRestScheme.ReqCreateKey.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$2 -> this.withNodeView((Function1 & Serializable & scala.Serializable)x$3 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Success success;
            PrivateKeySecp256k1 secret;
            ActorRef x$32;
            Timeout x$2;
            AbstractSidechainNodeViewHolder.ReceivableMessages.GenerateSecret<PrivateKeySecp256k1> x$1;
            ActorRef qual$1 = package$.MODULE$.ask(this.sidechainNodeViewHolderRef());
            Future secretFuture = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, x$1 = new AbstractSidechainNodeViewHolder.ReceivableMessages.GenerateSecret<PrivateKeySecp256k1>(PrivateKeySecp256k1Creator.getInstance()), x$2 = this.timeout(), x$32 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, x$1));
            Try try_ = (Try)Await$.MODULE$.result((Awaitable)secretFuture, (Duration)this.timeout().duration());
            if (try_ instanceof Success && (secret = (PrivateKeySecp256k1)(success = (Success)try_).value()) != null) {
                PrivateKeySecp256k1 privateKeySecp256k1 = secret;
                function1 = ApiResponseUtil$.MODULE$.toResponse(new WalletBaseRestScheme.RespCreatePrivateKey(privateKeySecp256k1.publicImage()));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new WalletBaseErrorResponse.ErrorSecretNotAdded("Failed to create secret.", Optional.of(e)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> getBalance() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("getBalance")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$4 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountWalletRestScheme.ReqGetBalance.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            try {
                AddressProposition fromAddr = new AddressProposition(BytesUtils.fromHexString(body2.address()));
                BigInteger fromBalance = sidechainNodeView.getNodeState().getBalance(fromAddr.address());
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletRestScheme.RespGetBalance(fromBalance));
            }
            catch (Exception e) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletErrorResponse.ErrorCouldNotGetBalance("Could not get balance", Optional.of(e)));
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> getTotalBalance() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("getTotalBalance")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$5 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountWalletRestScheme.ReqGetTotalBalance.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$6 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            block3: {
                try {
                    NodeWalletBase wallet = sidechainNodeView.getNodeWallet();
                    java.util.List<Secret> addressList = wallet.secretsOfType(PrivateKeySecp256k1.class);
                    if (addressList.isEmpty()) {
                        function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletRestScheme.RespGetBalance(BigInteger.ZERO));
                        break block3;
                    }
                    Buffer listOfAddressPropositions = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(addressList).asScala()).map((Function1 & Serializable & scala.Serializable)s -> (AddressProposition)s.publicImage(), Buffer$.MODULE$.canBuildFrom());
                    ObjectRef totalBalance = ObjectRef.create((Object)BigInteger.ZERO);
                    listOfAddressPropositions.foreach((Function1 & Serializable & scala.Serializable)address -> {
                        totalBalance.elem = ((BigInteger)totalBalance.elem).add(sidechainNodeView.getNodeState().getBalance(address.address()));
                        return BoxedUnit.UNIT;
                    });
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletRestScheme.RespGetBalance((BigInteger)totalBalance.elem));
                }
                catch (Exception e) {
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletErrorResponse.ErrorCouldNotGetBalance("Could not get balance", Optional.of(e)));
                }
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> getAllBalances() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("getAllBalances")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$7 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountWalletRestScheme.ReqGetTotalBalance.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$8 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            block3: {
                try {
                    NodeWalletBase wallet = sidechainNodeView.getNodeWallet();
                    java.util.List<Secret> addressList = wallet.secretsOfType(PrivateKeySecp256k1.class);
                    if (addressList.isEmpty()) {
                        function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletRestScheme.RespGetAllBalances((List<AccountWalletRestScheme.AccountBalance>)((TraversableOnce)Nil$.MODULE$).toList()));
                        break block3;
                    }
                    Buffer addressPropositions = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(addressList).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> (AddressProposition)x$9.publicImage(), Buffer$.MODULE$.canBuildFrom());
                    List accountBalances = (List)addressPropositions.foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(listToFill, addressProposition) -> (List)listToFill.$colon$plus((Object)new AccountWalletRestScheme.AccountBalance(addressProposition.address().toStringNoPrefix(), sidechainNodeView.getNodeState().getBalance(addressProposition.address())), List$.MODULE$.canBuildFrom()));
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletRestScheme.RespGetAllBalances((List<AccountWalletRestScheme.AccountBalance>)accountBalances));
                }
                catch (Exception e) {
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountWalletErrorResponse.ErrorCouldNotGetBalance("Could not get balance", Optional.of(e)));
                }
            }
            return function1;
        }))));
    }

    public AccountWalletApiRoute copy(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, SidechainSecretsCompanion sidechainSecretsCompanion, ActorRefFactory context, ExecutionContext ec) {
        return new AccountWalletApiRoute(settings, sidechainNodeViewHolderRef, sidechainSecretsCompanion, context, ec);
    }

    public RESTApiSettings copy$default$1() {
        return this.settings();
    }

    public ActorRef copy$default$2() {
        return this.sidechainNodeViewHolderRef();
    }

    public SidechainSecretsCompanion copy$default$3() {
        return this.sidechainSecretsCompanion();
    }

    public String productPrefix() {
        return "AccountWalletApiRoute";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.settings();
                break;
            }
            case 1: {
                object = this.sidechainNodeViewHolderRef();
                break;
            }
            case 2: {
                object = this.sidechainSecretsCompanion();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AccountWalletApiRoute;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AccountWalletApiRoute)) return false;
        boolean bl = true;
        if (!bl) return false;
        AccountWalletApiRoute accountWalletApiRoute = (AccountWalletApiRoute)x$1;
        RESTApiSettings rESTApiSettings = this.settings();
        RESTApiSettings rESTApiSettings2 = accountWalletApiRoute.settings();
        if (rESTApiSettings == null) {
            if (rESTApiSettings2 != null) {
                return false;
            }
        } else if (!rESTApiSettings.equals(rESTApiSettings2)) return false;
        ActorRef actorRef = this.sidechainNodeViewHolderRef();
        ActorRef actorRef2 = accountWalletApiRoute.sidechainNodeViewHolderRef();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!actorRef.equals(actorRef2)) return false;
        SidechainSecretsCompanion sidechainSecretsCompanion = this.sidechainSecretsCompanion();
        SidechainSecretsCompanion sidechainSecretsCompanion2 = accountWalletApiRoute.sidechainSecretsCompanion();
        if (sidechainSecretsCompanion == null) {
            if (sidechainSecretsCompanion2 != null) {
                return false;
            }
        } else if (!((Object)sidechainSecretsCompanion).equals(sidechainSecretsCompanion2)) return false;
        if (!accountWalletApiRoute.canEqual(this)) return false;
        return true;
    }

    public AccountWalletApiRoute(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, SidechainSecretsCompanion sidechainSecretsCompanion, ActorRefFactory context, ExecutionContext ec) {
        this.sidechainNodeViewHolderRef = sidechainNodeViewHolderRef;
        this.sidechainSecretsCompanion = sidechainSecretsCompanion;
        super(settings, sidechainNodeViewHolderRef, sidechainSecretsCompanion, context, ec, ClassTag$.MODULE$.apply(AccountNodeView.class));
        Product.$init$((Product)this);
        this.route = (Function1)Directive$.MODULE$.addByNameNullaryApply(this.pathPrefix(this._segmentStringToPathMatcher("wallet"))).apply((Function0 & Serializable & scala.Serializable)() -> this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation(this.createPrivateKey25519()).$tilde(this.createVrfSecret())).$tilde(this.allPublicKeys())).$tilde(this.createPrivateKeySecp256k1())).$tilde(this.getBalance())).$tilde(this.getTotalBalance())).$tilde(this.getAllBalances())).$tilde(this.importSecret())).$tilde(this.exportSecret())).$tilde(this.dumpSecrets())).$tilde(this.importSecrets()));
        this.tag = ClassTag$.MODULE$.apply(AccountNodeView.class);
    }
}

