/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.http.route;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import com.google.common.primitives.Bytes;
import io.horizen.SidechainTypes;
import io.horizen.account.api.http.route.AccountTransactionApiRoute$;
import io.horizen.account.api.http.route.AccountTransactionErrorResponse;
import io.horizen.account.api.http.route.AccountTransactionRestScheme;
import io.horizen.account.api.http.route.AccountTransactionRestScheme$;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.secret.PrivateKeySecp256k1;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.AddWithdrawalRequestCmdInput;
import io.horizen.account.state.CertificateKeyRotationMsgProcessor$;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.OpenStakeForgerListCmdInput;
import io.horizen.account.state.RemoveStakeCmdInput;
import io.horizen.account.state.WithdrawalMsgProcessor$;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.EthereumTransactionUtils;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.api.http.ApiResponse;
import io.horizen.api.http.ApiResponseUtil$;
import io.horizen.api.http.ErrorResponse;
import io.horizen.api.http.JacksonSupport$;
import io.horizen.api.http.route.TransactionBaseApiRoute;
import io.horizen.api.http.route.TransactionBaseErrorResponse;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.cryptolibprovider.CryptoLibProvider$;
import io.horizen.evm.Address;
import io.horizen.node.NodeWalletBase;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proof.SchnorrProof;
import io.horizen.proof.SchnorrSignatureSerializer;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.MCPublicKeyHashProposition;
import io.horizen.proposition.MCPublicKeyHashPropositionSerializer;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.proposition.SchnorrPropositionSerializer;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.Secret;
import io.horizen.utils.BytesUtils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Optional;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.settings.RESTApiSettings;

@ScalaSignature(bytes="\u0006\u0001\u0011Ua\u0001\u0002\"D\u0001BC!\"!\u000e\u0001\u0005+\u0007I\u0011IA\u001c\u0011)\tY\u0005\u0001B\tB\u0003%\u0011\u0011\b\u0005\u000b\u0003\u001b\u0002!Q3A\u0005\u0002\u0005=\u0003BCA1\u0001\tE\t\u0015!\u0003\u0002R!Q\u00111\r\u0001\u0003\u0016\u0004%\t!a\u0014\t\u0015\u0005\u0015\u0004A!E!\u0002\u0013\t\t\u0006\u0003\u0006\u0002h\u0001\u0011)\u001a!C\u0001\u0003SB!\"!\u001e\u0001\u0005#\u0005\u000b\u0011BA6\u0011)\t9\b\u0001BK\u0002\u0013\u0005\u0011\u0011\u0010\u0005\u000b\u0003\u000b\u0003!\u0011#Q\u0001\n\u0005m\u0004BCAD\u0001\tU\r\u0011\"\u0001\u0002\n\"Q\u0011q\u0016\u0001\u0003\u0012\u0003\u0006I!a#\t\u0015\u0005E\u0006A!b\u0001\n\u0007\n\u0019\f\u0003\u0007\u0002<\u0002\u0011\t\u0011)A\u0005\u0003k\u000bi\f\u0003\u0006\u0002@\u0002\u0011)\u0019!C\"\u0003\u0003DA\"a4\u0001\u0005\u0003\u0005\u000b\u0011BAb\u0003#Dq!a5\u0001\t\u0003\t)\u000eC\u0005\u0002n\u0002\u0011\r\u0011b\u0011\u0002p\"A\u0011Q \u0001!\u0002\u0013\t\t\u0010\u0003\u0005E\u0001\t\u0007I\u0011IA\u0000\u0011!\u0011I\u0003\u0001Q\u0001\n\t\u0005\u0001b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011y\b\u0001C\u0001\u0003\u007fDqA!!\u0001\t\u0003\ty\u0010C\u0004\u0003\u0004\u0002!\t!a@\t\u000f\t\u0015\u0005\u0001\"\u0001\u0002\u0000\"9!q\u0011\u0001\u0005\u0002\u0005}\bb\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005c\u0003A\u0011AA\u0000\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0003\u007fDqA!.\u0001\t\u0003\ty\u0010C\u0004\u00038\u0002!\t!a@\t\u000f\te\u0006\u0001\"\u0001\u0002\u0000\"9!1\u0018\u0001\u0005\u0002\u0005}\bb\u0002B_\u0001\u0011\u0005\u0011q \u0005\b\u0005\u007f\u0003A\u0011AA\u0000\u0011\u001d\u0011\t\r\u0001C\u0001\u0003\u007fDqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003v\u0002!\tAa>\t\u000f\r\u0015\u0001\u0001\"\u0001\u0004\b!911\u0004\u0001\u0005\u0002\ru\u0001bBB\u0015\u0001\u0011%11\u0006\u0005\n\u0007\u000b\u0002\u0011\u0011!C\u0001\u0007\u000fB\u0011ba\u0017\u0001#\u0003%\ta!\u0018\t\u0013\rM\u0004!%A\u0005\u0002\rU\u0004\"CB=\u0001E\u0005I\u0011AB;\u0011%\u0019Y\bAI\u0001\n\u0003\u0019i\bC\u0005\u0004\u0002\u0002\t\n\u0011\"\u0001\u0004\u0004\"I1q\u0011\u0001\u0012\u0002\u0013\u00051\u0011\u0012\u0005\n\u0007\u001b\u0003\u0011\u0011!C!\u0007\u001fC\u0011ba'\u0001\u0003\u0003%\ta!(\t\u0013\r}\u0005!!A\u0005\u0002\r\u0005\u0006\"CBW\u0001\u0005\u0005I\u0011IBX\u0011%\u0019i\fAA\u0001\n\u0003\u0019y\fC\u0005\u0004J\u0002\t\t\u0011\"\u0011\u0004L\"I1Q\u001a\u0001\u0002\u0002\u0013\u00053q\u001a\u0005\n\u0007#\u0004\u0011\u0011!C!\u0007'<\u0011ba6D\u0003\u0003E\ta!7\u0007\u0011\t\u001b\u0015\u0011!E\u0001\u00077Dq!a5=\t\u0003\u0019\u0019\u000fC\u0005\u0004Nr\n\t\u0011\"\u0012\u0004P\"I1Q\u001d\u001f\u0002\u0002\u0013\u00055q\u001d\u0005\n\u0007wd\u0014\u0011!CA\u0007{D\u0011\u0002b\u0003=\u0003\u0003%I\u0001\"\u0004\u00035\u0005\u001b7m\\;oiR\u0013\u0018M\\:bGRLwN\\!qSJ{W\u000f^3\u000b\u0005\u0011+\u0015!\u0002:pkR,'B\u0001$H\u0003\u0011AG\u000f\u001e9\u000b\u0005!K\u0015aA1qS*\u0011!jS\u0001\bC\u000e\u001cw.\u001e8u\u0015\taU*A\u0004i_JL'0\u001a8\u000b\u00039\u000b!![8\u0004\u0001MA\u0001!UA\u000e\u0003G\ty\u0003\u0005\bS-bS\u0007o]=\u0000\u0003\u000b\ty!!\u0006\u000e\u0003MS!\u0001\u0012+\u000b\u0005\u0019+&B\u0001%L\u0013\t96KA\fUe\u0006t7/Y2uS>t')Y:f\u0003BL'k\\;uKB!\u0011\f\u00180e\u001b\u0005Q&BA.J\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\u0005uS&AE!dG>,h\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u0004\"a\u00182\u000e\u0003\u0001T!!Y&\u0002\u0017A\u0014x\u000e]8tSRLwN\\\u0005\u0003G\u0002\u00141\u0002\u0015:pa>\u001c\u0018\u000e^5p]B\u0019Q\r\u001b0\u000e\u0003\u0019T!aZ&\u0002\u000bA\u0014xn\u001c4\n\u0005%4'!\u0002)s_>4\u0007CA6o\u001b\u0005a'BA7J\u0003\u0015\u0011Gn\\2l\u0013\tyGN\u0001\nBG\u000e|WO\u001c;CY>\u001c7\u000eS3bI\u0016\u0014\bCA6r\u0013\t\u0011HN\u0001\u0007BG\u000e|WO\u001c;CY>\u001c7\u000e\u0005\u0002uo6\tQO\u0003\u0002w\u0013\u0006)1\r[1j]&\u0011\u00010\u001e\u0002\u0017\u0003\u000e\u001cw.\u001e8u\r\u0016,\u0007+Y=nK:$8/\u00138g_B\u0011!0`\u0007\u0002w*\u0011A0S\u0001\u0005]>$W-\u0003\u0002\u007fw\n\u0011bj\u001c3f\u0003\u000e\u001cw.\u001e8u\u0011&\u001cHo\u001c:z!\rQ\u0018\u0011A\u0005\u0004\u0003\u0007Y(\u0001\u0005(pI\u0016\f5mY8v]R\u001cF/\u0019;f!\u0011\t9!a\u0003\u000e\u0005\u0005%!B\u0001?L\u0013\u0011\ti!!\u0003\u0003\u001d9{G-Z,bY2,GOQ1tKB\u0019!0!\u0005\n\u0007\u0005M1PA\u000bO_\u0012,\u0017iY2pk:$X*Z7pef\u0004vn\u001c7\u0011\u0007i\f9\"C\u0002\u0002\u001am\u0014q\"Q2d_VtGOT8eKZKWm\u001e\t\u0005\u0003;\ty\"D\u0001L\u0013\r\t\tc\u0013\u0002\u000f'&$Wm\u00195bS:$\u0016\u0010]3t!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"BAA\u0015\u0003\u0015\u00198-\u00197b\u0013\u0011\ti#a\n\u0003\u000fA\u0013x\u000eZ;diB!\u0011QEA\u0019\u0013\u0011\t\u0019$a\n\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011M,G\u000f^5oON,\"!!\u000f\u0011\t\u0005m\u0012qI\u0007\u0003\u0003{QA!!\u000e\u0002@)!\u0011\u0011IA\"\u0003\u0011\u0019wN]3\u000b\u0005\u0005\u0015\u0013AB:qCJ\\'0\u0003\u0003\u0002J\u0005u\"a\u0004*F'R\u000b\u0005/[*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013AG:jI\u0016\u001c\u0007.Y5o\u001d>$WMV5fo\"{G\u000eZ3s%\u00164WCAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\nQ!Y2u_JT!!a\u0017\u0002\t\u0005\\7.Y\u0005\u0005\u0003?\n)F\u0001\u0005BGR|'OU3g\u0003m\u0019\u0018\u000eZ3dQ\u0006LgNT8eKZKWm\u001e%pY\u0012,'OU3gA\u0005a2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\f5\r^8s%\u00164\u0017!H:jI\u0016\u001c\u0007.Y5o)J\fgn]1di&|g.Q2u_J\u0014VM\u001a\u0011\u0002\u0013\r|W\u000e]1oS>tWCAA6!\u0011\ti'!\u001d\u000e\u0005\u0005=$bAA4\u0013&!\u00111OA8\u0005\u0015\u001a\u0016\u000eZ3dQ\u0006Lg.Q2d_VtG\u000f\u0016:b]N\f7\r^5p]N\u001cu.\u001c9b]&|g.\u0001\u0006d_6\u0004\u0018M\\5p]\u0002\na\u0001]1sC6\u001cXCAA>!\u0011\ti(!!\u000e\u0005\u0005}$bAA<\u0017&!\u00111QA@\u00055qU\r^<pe.\u0004\u0016M]1ng\u00069\u0001/\u0019:b[N\u0004\u0013aC2je\u000e,\u0018\u000e\u001e+za\u0016,\"!a#\u0011\t\u00055\u0015\u0011\u0016\b\u0005\u0003\u001f\u000b\u0019K\u0004\u0003\u0002\u0012\u0006}e\u0002BAJ\u0003;sA!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033{\u0015A\u0002\u001fs_>$h(C\u0001O\u0013\taU*C\u0002\u0002\".\u000b\u0011c\u0019:zaR|G.\u001b2qe>4\u0018\u000eZ3s\u0013\u0011\t)+a*\u0002\u0019\rK'oY;jiRK\b/Z:\u000b\u0007\u0005\u00056*\u0003\u0003\u0002,\u00065&\u0001D\"je\u000e,\u0018\u000e\u001e+za\u0016\u001c(\u0002BAS\u0003O\u000bAbY5sGVLG\u000fV=qK\u0002\nqaY8oi\u0016DH/\u0006\u0002\u00026B!\u00111KA\\\u0013\u0011\tI,!\u0016\u0003\u001f\u0005\u001bGo\u001c:SK\u001a4\u0015m\u0019;pef\f\u0001bY8oi\u0016DH\u000fI\u0005\u0004\u0003c3\u0016AA3d+\t\t\u0019\r\u0005\u0003\u0002F\u0006-WBAAd\u0015\u0011\tI-a\n\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002N\u0006\u001d'\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\rI\u0005\u0004\u0003\u007f3\u0016A\u0002\u001fj]&$h\b\u0006\b\u0002X\u0006\u0005\u00181]As\u0003O\fI/a;\u0015\r\u0005e\u0017Q\\Ap!\r\tY\u000eA\u0007\u0002\u0007\"9\u0011\u0011W\tA\u0004\u0005U\u0006bBA`#\u0001\u000f\u00111\u0019\u0005\b\u0003k\t\u0002\u0019AA\u001d\u0011\u001d\ti%\u0005a\u0001\u0003#Bq!a\u0019\u0012\u0001\u0004\t\t\u0006C\u0004\u0002hE\u0001\r!a\u001b\t\u000f\u0005]\u0014\u00031\u0001\u0002|!9\u0011qQ\tA\u0002\u0005-\u0015a\u0001;bOV\u0011\u0011\u0011\u001f\t\u0007\u0003g\fI0!\u0006\u000e\u0005\u0005U(\u0002BA|\u0003O\tqA]3gY\u0016\u001cG/\u0003\u0003\u0002|\u0006U(\u0001C\"mCN\u001cH+Y4\u0002\tQ\fw\rI\u000b\u0003\u0005\u0003\u0001BAa\u0001\u0003$9!!Q\u0001B\u000f\u001d\u0011\u00119Aa\u0006\u000f\t\t%!\u0011\u0003\b\u0005\u0005\u0017\u0011yA\u0004\u0003\u0002\u0016\n5\u0011BAA.\u0013\r1\u0015\u0011L\u0005\u0005\u0005'\u0011)\"\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\r1\u0015\u0011L\u0005\u0005\u00053\u0011Y\"\u0001\u0004tKJ4XM\u001d\u0006\u0005\u0005'\u0011)\"\u0003\u0003\u0003 \t\u0005\u0012a\u00029bG.\fw-\u001a\u0006\u0005\u00053\u0011Y\"\u0003\u0003\u0003&\t\u001d\"!\u0002*pkR,'\u0002\u0002B\u0010\u0005C\taA]8vi\u0016\u0004\u0013\u0001E4fi\u001aKG\u000f^5oON+7M]3u)!\u0011yC!\u0011\u0003F\tm\u0003CBA\u0013\u0005c\u0011)$\u0003\u0003\u00034\u0005\u001d\"AB(qi&|g\u000e\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\r\u0011Y$S\u0001\u0007g\u0016\u001c'/\u001a;\n\t\t}\"\u0011\b\u0002\u0014!JLg/\u0019;f\u0017\u0016L8+Z2qeU24.\r\u0005\b\u0005\u00072\u0002\u0019AA\u000b\u0003!qw\u000eZ3WS\u0016<\bb\u0002B$-\u0001\u0007!\u0011J\u0001\fMJ|W.\u00113ee\u0016\u001c8\u000f\u0005\u0004\u0002&\tE\"1\n\t\u0005\u0005\u001b\u0012)F\u0004\u0003\u0003P\tE\u0003\u0003BAK\u0003OIAAa\u0015\u0002(\u00051\u0001K]3eK\u001aLAAa\u0016\u0003Z\t11\u000b\u001e:j]\u001eTAAa\u0015\u0002(!9!Q\f\fA\u0002\t}\u0013\u0001\u0004;y-\u0006dW/Z%o/\u0016L\u0007\u0003\u0002B1\u0005Wj!Aa\u0019\u000b\t\t\u0015$qM\u0001\u0005[\u0006$\bN\u0003\u0002\u0003j\u0005!!.\u0019<b\u0013\u0011\u0011iGa\u0019\u0003\u0015\tKw-\u00138uK\u001e,'/A\rtS\u001etGK]1og\u0006\u001cG/[8o/&$\bnU3de\u0016$HC\u0002B:\u0005s\u0012Y\bE\u0002Z\u0005kJ1Aa\u001e[\u0005M)E\u000f[3sKVlGK]1og\u0006\u001cG/[8o\u0011\u001d\u0011Yd\u0006a\u0001\u0005kAqA! \u0018\u0001\u0004\u0011\u0019(\u0001\u0002uq\u000692M]3bi\u0016dUmZ1dsR\u0013\u0018M\\:bGRLwN\\\u0001\u001eGJ,\u0017\r^3MK\u001e\f7-_#J!F*T\u0007\u0016:b]N\f7\r^5p]\u0006A2M]3bi\u0016,\u0015\nU\u00196ke\"&/\u00198tC\u000e$\u0018n\u001c8\u0002\u001fMLwM\u001c+sC:\u001c\u0018m\u0019;j_:\fab\u001c9f]\u001a{'oZ3s\u0019&\u001cH/\u0001\nhKR\u0014En\\2l'&<gnU3de\u0016$HC\u0002BG\u0005G\u0013i\u000b\u0005\u0004\u0003\u0010\nU%\u0011T\u0007\u0003\u0005#SAAa%\u0002(\u0005!Q\u000f^5m\u0013\u0011\u00119J!%\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0003\u001c\n}UB\u0001BO\u0015\r\u0011YdS\u0005\u0005\u0005C\u0013iJA\bQe&4\u0018\r^3LKf\u0014T'N\u0019:\u0011\u001d\u0011)+\ba\u0001\u0005O\u000b1BZ8sO\u0016\u0014\u0018J\u001c3fqB!\u0011Q\u0005BU\u0013\u0011\u0011Y+a\n\u0003\u0007%sG\u000fC\u0004\u00030v\u0001\r!!\u0002\u0002\r]\fG\u000e\\3u\u0003=i\u0017m[3G_J<WM]*uC.,\u0017!E:qK:$gi\u001c:hS:<7\u000b^1lK\u0006\u0001\u0012\r\u001c7G_J<\u0017N\\4Ti\u0006\\Wm]\u0001\u0012C2dwn^3e\r>\u0014x-\u001a:MSN$\u0018aD7z\r>\u0014x-\u001b8h'R\f7.Z:\u0002\u001b]LG\u000f\u001b3sC^\u001cu.\u001b8t\u0003U\tG\u000e\\,ji\"$'/Y<bYJ+\u0017/^3tiN\f1c\u0019:fCR,7+\\1si\u000e{g\u000e\u001e:bGR\fAd\u0019:fCR,7*Z=S_R\fG/[8o)J\fgn]1di&|g.A\u000ef]\u000e|G-Z!eI:+wo\u0015;bW\u0016\u001cU\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005\u0005\u000f\u0014\u0019\u000e\u0005\u0004\u0002&\t%'QZ\u0005\u0005\u0005\u0017\f9CA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002&\t=\u0017\u0002\u0002Bi\u0003O\u0011AAQ=uK\"9!Q[\u0014A\u0002\t]\u0017a\u00044pe\u001e,'o\u0015;bW\u0016LeNZ8\u0011\t\te'q\u001e\b\u0005\u00057\u0014YO\u0004\u0003\u0003^\n%h\u0002\u0002Bp\u0005OtAA!9\u0003f:!\u0011\u0011\u0013Br\u0013\tQ5*\u0003\u0002I\u0013&\u0011aiR\u0005\u0003\t\u0016K1A!<D\u0003q\t5mY8v]R$&/\u00198tC\u000e$\u0018n\u001c8SKN$8k\u00195f[\u0016LAA!=\u0003t\n9BK]1og\u0006\u001cG/[8o\r>\u0014x-\u001a:PkR\u0004X\u000f\u001e\u0006\u0004\u0005[\u001c\u0015!G3oG>$Wm\u00149f]N#\u0018m[3D[\u0012\u0014V-];fgR$bAa2\u0003z\nm\bb\u0002BSQ\u0001\u0007!q\u0015\u0005\b\u0005{D\u0003\u0019\u0001B\u0000\u0003%\u0019\u0018n\u001a8biV\u0014X\rE\u0002f\u0007\u0003I1aa\u0001g\u00059\u0019\u0016n\u001a8biV\u0014XMM\u001b6ce\n!$\u001a8d_\u0012,7\u000b]3oIN#\u0018m[3D[\u0012\u0014V-];fgR$bAa2\u0004\n\r]\u0001bBB\u0006S\u0001\u00071QB\u0001\u0013g&<g.\u0019;ve\u0016\u001cVm\u001993kYZ\u0017\u0007\u0005\u0003\u0004\u0010\rMQBAB\t\u0015\t9\u0017*\u0003\u0003\u0004\u0016\rE!AE*jO:\fG/\u001e:f'\u0016\u001c\u0007OM\u001b7WFBqa!\u0007*\u0001\u0004\u0011Y%A\u0004ti\u0006\\W-\u00133\u0002A\u0015t7m\u001c3f\u0003\u0012$g*Z<XSRDGM]1xC2\u0014V-];fgR\u001cU\u000e\u001a\u000b\u0005\u0005\u000f\u001cy\u0002C\u0004\u0004\")\u0002\raa\t\u0002\u0015]LG\u000f\u001b3sC^\fG\u000e\u0005\u0003\u0003Z\u000e\u0015\u0012\u0002BB\u0014\u0005g\u0014A\u0004\u0016:b]N\f7\r^5p]^KG\u000f\u001b3sC^\fGNU3rk\u0016\u001cH/A\u000fdQ\u0016\u001c7nS3z%>$\u0018\r^5p]B\u0013xn\u001c4WC2LG-\u001b;z)\u0019\u0019ica\u000e\u0004BA1\u0011Q\u0005B\u0019\u0007_\u0001Ba!\r\u000445\tA+C\u0002\u00046Q\u0013Q\"\u0012:s_J\u0014Vm\u001d9p]N,\u0007bBB\u001dW\u0001\u000711H\u0001\u0005E>$\u0017\u0010\u0005\u0003\u0003Z\u000eu\u0012\u0002BB \u0005g\u0014qDU3r\u0007J,\u0017\r^3LKf\u0014v\u000e^1uS>tGK]1og\u0006\u001cG/[8o\u0011\u001d\u0019\u0019e\u000ba\u0001\u0005O\u000bQ!\u001a9pG\"\fAaY8qsRq1\u0011JB(\u0007#\u001a\u0019f!\u0016\u0004X\reCCBAm\u0007\u0017\u001ai\u0005C\u0004\u000222\u0002\u001d!!.\t\u000f\u0005}F\u0006q\u0001\u0002D\"I\u0011Q\u0007\u0017\u0011\u0002\u0003\u0007\u0011\u0011\b\u0005\n\u0003\u001bb\u0003\u0013!a\u0001\u0003#B\u0011\"a\u0019-!\u0003\u0005\r!!\u0015\t\u0013\u0005\u001dD\u0006%AA\u0002\u0005-\u0004\"CA<YA\u0005\t\u0019AA>\u0011%\t9\t\fI\u0001\u0002\u0004\tY)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r}#\u0006BA\u001d\u0007CZ#aa\u0019\u0011\t\r\u00154qN\u0007\u0003\u0007ORAa!\u001b\u0004l\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0007[\n9#\u0001\u0006b]:|G/\u0019;j_:LAa!\u001d\u0004h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u000f\u0016\u0005\u0003#\u001a\t'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0010\u0016\u0005\u0003W\u001a\t'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u0015%\u0006BA>\u0007C\nabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0004\f*\"\u00111RB1\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111\u0011\u0013\t\u0005\u0007'\u001bI*\u0004\u0002\u0004\u0016*!1q\u0013B4\u0003\u0011a\u0017M\\4\n\t\t]3QS\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005O\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004$\u000e%\u0006\u0003BA\u0013\u0007KKAaa*\u0002(\t\u0019\u0011I\\=\t\u0013\r-V'!AA\u0002\t\u001d\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00042B111WB]\u0007Gk!a!.\u000b\t\r]\u0016qE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB^\u0007k\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!1\u0011YBd!\u0011\t)ca1\n\t\r\u0015\u0017q\u0005\u0002\b\u0005>|G.Z1o\u0011%\u0019YkNA\u0001\u0002\u0004\u0019\u0019+\u0001\u0005iCND7i\u001c3f)\t\u00119+\u0001\u0005u_N#(/\u001b8h)\t\u0019\t*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0007\u0003\u001c)\u000eC\u0005\u0004,j\n\t\u00111\u0001\u0004$\u0006Q\u0012iY2pk:$HK]1og\u0006\u001cG/[8o\u0003BL'k\\;uKB\u0019\u00111\u001c\u001f\u0014\u000bq\u001ai.a\f\u0011\t\u0005\u00152q\\\u0005\u0005\u0007C\f9C\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u00073\fQ!\u00199qYf$bb!;\u0004p\u000eE81_B{\u0007o\u001cI\u0010\u0006\u0004\u0002Z\u000e-8Q\u001e\u0005\b\u0003c{\u00049AA[\u0011\u001d\tyl\u0010a\u0002\u0003\u0007Dq!!\u000e@\u0001\u0004\tI\u0004C\u0004\u0002N}\u0002\r!!\u0015\t\u000f\u0005\rt\b1\u0001\u0002R!9\u0011qM A\u0002\u0005-\u0004bBA<\u007f\u0001\u0007\u00111\u0010\u0005\b\u0003\u000f{\u0004\u0019AAF\u0003\u001d)h.\u00199qYf$Baa@\u0005\bA1\u0011Q\u0005B\u0019\t\u0003\u0001\u0002#!\n\u0005\u0004\u0005e\u0012\u0011KA)\u0003W\nY(a#\n\t\u0011\u0015\u0011q\u0005\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\u0011%\u0001)!AA\u0002\u0005e\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t!y\u0001\u0005\u0003\u0004\u0014\u0012E\u0011\u0002\u0002C\n\u0007+\u0013aa\u00142kK\u000e$\b")
public class AccountTransactionApiRoute
extends TransactionBaseApiRoute<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView>
implements SidechainTypes,
Product,
scala.Serializable {
    private final RESTApiSettings settings;
    private final ActorRef sidechainNodeViewHolderRef;
    private final ActorRef sidechainTransactionActorRef;
    private final SidechainAccountTransactionsCompanion companion;
    private final NetworkParams params;
    private final Enumeration.Value circuitType;
    private final ClassTag<AccountNodeView> tag;
    private final Function1<RequestContext, Future<RouteResult>> route;

    public static Option<Tuple6<RESTApiSettings, ActorRef, ActorRef, SidechainAccountTransactionsCompanion, NetworkParams, Enumeration.Value>> unapply(AccountTransactionApiRoute accountTransactionApiRoute) {
        return AccountTransactionApiRoute$.MODULE$.unapply(accountTransactionApiRoute);
    }

    public static AccountTransactionApiRoute apply(RESTApiSettings rESTApiSettings, ActorRef actorRef, ActorRef actorRef2, SidechainAccountTransactionsCompanion sidechainAccountTransactionsCompanion, NetworkParams networkParams, Enumeration.Value value, ActorRefFactory actorRefFactory, ExecutionContext executionContext) {
        return AccountTransactionApiRoute$.MODULE$.apply(rESTApiSettings, actorRef, actorRef2, sidechainAccountTransactionsCompanion, networkParams, value, actorRefFactory, executionContext);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public RESTApiSettings settings() {
        return this.settings;
    }

    @Override
    public ActorRef sidechainNodeViewHolderRef() {
        return this.sidechainNodeViewHolderRef;
    }

    public ActorRef sidechainTransactionActorRef() {
        return this.sidechainTransactionActorRef;
    }

    public SidechainAccountTransactionsCompanion companion() {
        return this.companion;
    }

    public NetworkParams params() {
        return this.params;
    }

    public Enumeration.Value circuitType() {
        return this.circuitType;
    }

    @Override
    public ActorRefFactory context() {
        return super.context();
    }

    @Override
    public ExecutionContext ec() {
        return super.ec();
    }

    @Override
    public ClassTag<AccountNodeView> tag() {
        return this.tag;
    }

    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.route;
    }

    private Option<PrivateKeySecp256k1> getFittingSecret(AccountNodeView nodeView, Option<String> fromAddress, BigInteger txValueInWei) {
        NodeWalletBase wallet = nodeView.getNodeWallet();
        java.util.List<Secret> allAccounts = wallet.secretsOfType(PrivateKeySecp256k1.class);
        Option secret = ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(allAccounts).find((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)AccountTransactionApiRoute.$anonfun$getFittingSecret$1(fromAddress, nodeView, txValueInWei, a)));
        return secret.nonEmpty() ? Option$.MODULE$.apply((Object)((PrivateKeySecp256k1)secret.get())) : Option$.MODULE$.empty();
    }

    private EthereumTransaction signTransactionWithSecret(PrivateKeySecp256k1 secret, EthereumTransaction tx) {
        byte[] messageToSign = tx.messageToSign();
        SignatureSecp256k1 msgSignature = secret.sign(messageToSign);
        return new EthereumTransaction(tx, new SignatureSecp256k1(msgSignature.getV(), msgSignature.getR(), msgSignature.getS()));
    }

    public Function1<RequestContext, Future<RouteResult>> createLegacyTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createLegacyTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$1 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqLegacyTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            BigInteger txCost = ((BigInteger)body2.value().getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO)).add(body2.gasLimit().multiply(body2.gasPrice()));
            return (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Function1<RequestContext, Future<RouteResult>> function1;
                Option<PrivateKeySecp256k1> secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, body2.from(), txCost);
                Option<PrivateKeySecp256k1> option = secret;
                if (option instanceof Some) {
                    Function1<RequestContext, Future<RouteResult>> resp;
                    Function1<RequestContext, Future<RouteResult>> function12;
                    Some some = (Some)option;
                    PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                    BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(secret2.publicImage().address()));
                    EthereumTransaction unsignedTx = new EthereumTransaction(EthereumTransactionUtils.getToAddressFromString((String)body2.to().orNull(Predef$.MODULE$.$conforms())), nonce, body2.gasPrice(), body2.gasLimit(), (BigInteger)body2.value().getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO), EthereumTransactionUtils.getDataFromString(body2.data()), body2.signature_v().isDefined() ? new SignatureSecp256k1(new BigInteger((String)body2.signature_v().get(), 16), new BigInteger((String)body2.signature_r().get(), 16), new BigInteger((String)body2.signature_s().get(), 16)) : null);
                    if (BoxesRunTime.unboxToBoolean((Object)body2.outputRawBytes().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                        function12 = ApiResponseUtil$.MODULE$.toResponse((ApiResponse)this.rawTransactionResponseRepresentation().apply(this.ethereumTxToScat(unsignedTx)));
                    } else {
                        EthereumTransaction signedTx = this.signTransactionWithSecret(secret2, unsignedTx);
                        function12 = this.validateAndSendTransaction(this.ethereumTxToScat(signedTx), this.validateAndSendTransaction$default$2());
                    }
                    function1 = resp = function12;
                } else if (None$.MODULE$.equals(option)) {
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("ErrorInsufficientBalance", Optional.empty()));
                } else {
                    throw new MatchError(option);
                }
                return function1;
            });
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createLegacyEIP155Transaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createLegacyEIP155Transaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$2 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqLegacyTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            BigInteger txCost = ((BigInteger)body2.value().getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO)).add(body2.gasLimit().multiply(body2.gasPrice()));
            return (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Function1<RequestContext, Future<RouteResult>> function1;
                Option<PrivateKeySecp256k1> secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, body2.from(), txCost);
                Option<PrivateKeySecp256k1> option = secret;
                if (option instanceof Some) {
                    Function1<RequestContext, Future<RouteResult>> resp;
                    Function1<RequestContext, Future<RouteResult>> function12;
                    Some some = (Some)option;
                    PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                    BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(secret2.publicImage().address()));
                    EthereumTransaction unsignedTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), EthereumTransactionUtils.getToAddressFromString((String)body2.to().orNull(Predef$.MODULE$.$conforms())), nonce, body2.gasPrice(), body2.gasLimit(), (BigInteger)body2.value().getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO), EthereumTransactionUtils.getDataFromString(body2.data()), body2.signature_v().isDefined() ? new SignatureSecp256k1(new BigInteger((String)body2.signature_v().get(), 16), new BigInteger((String)body2.signature_r().get(), 16), new BigInteger((String)body2.signature_s().get(), 16)) : null);
                    if (BoxesRunTime.unboxToBoolean((Object)body2.outputRawBytes().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                        function12 = ApiResponseUtil$.MODULE$.toResponse((ApiResponse)this.rawTransactionResponseRepresentation().apply(this.ethereumTxToScat(unsignedTx)));
                    } else {
                        EthereumTransaction signedTx = this.signTransactionWithSecret(secret2, unsignedTx);
                        function12 = this.validateAndSendTransaction(this.ethereumTxToScat(signedTx), this.validateAndSendTransaction$default$2());
                    }
                    function1 = resp = function12;
                } else if (None$.MODULE$.equals(option)) {
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("ErrorInsufficientBalance", Optional.empty()));
                } else {
                    throw new MatchError(option);
                }
                return function1;
            });
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createEIP1559Transaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createEIP1559Transaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$3 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqEIP1559Transaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            BigInteger txCost = ((BigInteger)body2.value().getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO)).add(body2.gasLimit().multiply(body2.maxFeePerGas()));
            return (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Function1<RequestContext, Future<RouteResult>> function1;
                Option<PrivateKeySecp256k1> secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, body2.from(), txCost);
                Option<PrivateKeySecp256k1> option = secret;
                if (option instanceof Some) {
                    Function1<RequestContext, Future<RouteResult>> resp;
                    Function1<RequestContext, Future<RouteResult>> function12;
                    Some some = (Some)option;
                    PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                    BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(secret2.publicImage().address()));
                    EthereumTransaction unsignedTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), EthereumTransactionUtils.getToAddressFromString((String)body2.to().orNull(Predef$.MODULE$.$conforms())), nonce, body2.gasLimit(), body2.maxPriorityFeePerGas(), body2.maxFeePerGas(), (BigInteger)body2.value().getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO), EthereumTransactionUtils.getDataFromString(body2.data()), body2.signature_v().isDefined() ? new SignatureSecp256k1(new BigInteger((String)body2.signature_v().get(), 16), new BigInteger((String)body2.signature_r().get(), 16), new BigInteger((String)body2.signature_s().get(), 16)) : null);
                    if (BoxesRunTime.unboxToBoolean((Object)body2.outputRawBytes().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                        function12 = ApiResponseUtil$.MODULE$.toResponse((ApiResponse)this.rawTransactionResponseRepresentation().apply(this.ethereumTxToScat(unsignedTx)));
                    } else {
                        EthereumTransaction signedTx = this.signTransactionWithSecret(secret2, unsignedTx);
                        function12 = this.validateAndSendTransaction(this.ethereumTxToScat(signedTx), this.validateAndSendTransaction$default$2());
                    }
                    function1 = resp = function12;
                } else if (None$.MODULE$.equals(option)) {
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("ErrorInsufficientBalance", Optional.empty()));
                } else {
                    throw new MatchError(option);
                }
                return function1;
            });
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> signTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("signTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$4 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqSignTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try try_ = this.companion().parseBytesTry(BytesUtils.fromHexString(body2.transactionBytes()));
            if (try_ instanceof Success) {
                Function1<RequestContext, Future<RouteResult>> function12;
                Success success = (Success)try_;
                AccountTransaction unsignedTx = (AccountTransaction)success.value();
                BigInteger txCost = unsignedTx.maxCost();
                Option<PrivateKeySecp256k1> secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, body2.from(), txCost);
                Option<PrivateKeySecp256k1> option = secret;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                    EthereumTransaction signedTx = this.signTransactionWithSecret(secret2, (EthereumTransaction)unsignedTx);
                    function12 = ApiResponseUtil$.MODULE$.toResponse((ApiResponse)this.rawTransactionResponseRepresentation().apply(this.ethereumTxToScat(signedTx)));
                } else if (None$.MODULE$.equals(option)) {
                    function12 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("ErrorInsufficientBalance", Optional.empty()));
                } else {
                    throw new MatchError(option);
                }
                function1 = function12;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorByteTransactionParsing("ErrorByteTransactionParsing", Optional.of(exception)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> openForgerList() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("openForgerList")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$5 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqOpenStakeForgerList.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> !this.params().restrictForgers() ? ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorOpenForgersList("The list of forger is not restricted (see configuration)", Optional.empty())) : (Function1<RequestContext, Future<RouteResult>>)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            BigInteger valueInWei = BigInteger.ZERO;
            BigInteger baseFee = sidechainNodeView.getNodeState().getNextBaseFee();
            BigInteger maxPriorityFeePerGas = BigInteger.valueOf(120L);
            BigInteger maxFeePerGas = BigInteger.TWO.multiply(baseFee).add(maxPriorityFeePerGas);
            BigInteger gasLimit = BigInteger.valueOf(500000L);
            if (body2.gasInfo().isDefined()) {
                maxFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxFeePerGas();
                maxPriorityFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxPriorityFeePerGas();
                gasLimit = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).gasLimit();
            }
            BigInteger txCost = valueInWei.add(maxFeePerGas.multiply(gasLimit));
            Try<PrivateKey25519> try_ = this.getBlockSignSecret(body2.forgerIndex(), sidechainNodeView.getNodeWallet());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorOpenForgersList(new StringBuilder(42).append("Could not get proposition for forgerIndex=").append(body2.forgerIndex()).toString(), Optional.of(e)));
            } else if (try_ instanceof Success) {
                Function1<RequestContext, Future<RouteResult>> function12;
                Success success = (Success)try_;
                PrivateKey25519 blockSignSecret = (PrivateKey25519)success.value();
                Option<PrivateKeySecp256k1> secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, (Option<String>)None$.MODULE$, txCost);
                Option<PrivateKeySecp256k1> option = secret;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PrivateKeySecp256k1 txCreatorSecret = (PrivateKeySecp256k1)some.value();
                    BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(txCreatorSecret.publicImage().address()));
                    byte[] msgToSign = ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(body2.forgerIndex(), txCreatorSecret.publicImage().address(), nonce.toByteArray());
                    Signature25519 signature = blockSignSecret.sign(msgToSign);
                    byte[] dataBytes = this.encodeOpenStakeCmdRequest(body2.forgerIndex(), signature);
                    EthereumTransaction tmpTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), Optional.of(new AddressProposition(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS())), nonce, gasLimit, maxPriorityFeePerGas, maxFeePerGas, valueInWei, dataBytes, null);
                    function12 = this.validateAndSendTransaction(this.ethereumTxToScat(this.signTransactionWithSecret(txCreatorSecret, tmpTx)), this.validateAndSendTransaction$default$2());
                } else if (None$.MODULE$.equals(option)) {
                    function12 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("No account with enough balance found", Optional.empty()));
                } else {
                    throw new MatchError(option);
                }
                function1 = function12;
            } else {
                throw new MatchError(try_);
            }
            return function1;
        }))));
    }

    private Try<PrivateKey25519> getBlockSignSecret(int forgerIndex, NodeWalletBase wallet) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Optional<Secret> secret;
            Try blockSignProposition = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (PublicKey25519Proposition)((Tuple2)this.params().allowedForgersList().apply(forgerIndex))._1());
            Try try_ = blockSignProposition;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new IllegalArgumentException(new StringBuilder(51).append("Could not get proposition for forgerIndex=").append(forgerIndex).append("; error: ").append(e.getMessage()).toString());
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                PublicKey25519Proposition prop = (PublicKey25519Proposition)success.value();
                secret = wallet.secretByPublicKey(prop);
                if (secret.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(56).append("Could not get secret in wallet for proposition for prop=").append(prop).toString());
                }
            } else {
                throw new MatchError((Object)try_);
            }
            PrivateKey25519 privateKey25519 = (PrivateKey25519)secret.get();
            return privateKey25519;
        });
    }

    public Function1<RequestContext, Future<RouteResult>> makeForgerStake() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("makeForgerStake")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$6 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqCreateForgerStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            BigInteger txCost;
            Option<PrivateKeySecp256k1> secret;
            Option<PrivateKeySecp256k1> option;
            BigInteger valueInWei = ZenWeiConverter$.MODULE$.convertZenniesToWei(body2.forgerStakeInfo().value());
            BigInteger baseFee = sidechainNodeView.getNodeState().getNextBaseFee();
            BigInteger maxPriorityFeePerGas = BigInteger.valueOf(120L);
            BigInteger maxFeePerGas = BigInteger.TWO.multiply(baseFee).add(maxPriorityFeePerGas);
            BigInteger gasLimit = BigInteger.valueOf(500000L);
            if (body2.gasInfo().isDefined()) {
                maxFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxFeePerGas();
                maxPriorityFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxPriorityFeePerGas();
                gasLimit = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).gasLimit();
            }
            if ((option = (secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, (Option<String>)None$.MODULE$, txCost = valueInWei.add(maxFeePerGas.multiply(gasLimit))))) instanceof Some) {
                Some some = (Some)option;
                PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(secret2.publicImage().address()));
                byte[] dataBytes = this.encodeAddNewStakeCmdRequest(body2.forgerStakeInfo());
                EthereumTransaction tmpTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), Optional.of(new AddressProposition(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS())), nonce, gasLimit, maxPriorityFeePerGas, maxFeePerGas, valueInWei, dataBytes, null);
                function1 = this.validateAndSendTransaction(this.ethereumTxToScat(this.signTransactionWithSecret(secret2, tmpTx)), this.validateAndSendTransaction$default$2());
            } else if (None$.MODULE$.equals(option)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("No account with enough balance found", Optional.empty()));
            } else {
                throw new MatchError(option);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> spendForgingStake() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("spendForgingStake")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$7 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqSpendForgingStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            BigInteger txCost;
            Option<PrivateKeySecp256k1> secret;
            Option<PrivateKeySecp256k1> option;
            BigInteger valueInWei = BigInteger.ZERO;
            BigInteger baseFee = sidechainNodeView.getNodeState().getNextBaseFee();
            BigInteger maxPriorityFeePerGas = BigInteger.valueOf(120L);
            BigInteger maxFeePerGas = BigInteger.TWO.multiply(baseFee).add(maxPriorityFeePerGas);
            BigInteger gasLimit = BigInteger.valueOf(500000L);
            if (body2.gasInfo().isDefined()) {
                maxFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxFeePerGas();
                maxPriorityFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxPriorityFeePerGas();
                gasLimit = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).gasLimit();
            }
            if ((option = (secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, (Option<String>)None$.MODULE$, txCost = valueInWei.add(maxFeePerGas.multiply(gasLimit))))) instanceof Some) {
                Function1<RequestContext, Future<RouteResult>> function12;
                Some some = (Some)option;
                PrivateKeySecp256k1 txCreatorSecret = (PrivateKeySecp256k1)some.value();
                BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(txCreatorSecret.publicImage().address()));
                Option<ForgerStakeData> stakeDataOpt = sidechainNodeView.getNodeState().getForgerStakeData(body2.stakeId());
                Option<ForgerStakeData> option2 = stakeDataOpt;
                if (option2 instanceof Some) {
                    Function1<RequestContext, Future<RouteResult>> function13;
                    Some some2 = (Some)option2;
                    ForgerStakeData stakeData = (ForgerStakeData)some2.value();
                    Optional<Secret> stakeOwnerSecretOpt = sidechainNodeView.getNodeWallet().secretByPublicKey(stakeData.ownerPublicKey());
                    if (stakeOwnerSecretOpt.isEmpty()) {
                        function13 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorForgerStakeOwnerNotFound("Forger Stake Owner not found"));
                    } else {
                        PrivateKeySecp256k1 stakeOwnerSecret = (PrivateKeySecp256k1)stakeOwnerSecretOpt.get();
                        byte[] msgToSign = ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(BytesUtils.fromHexString(body2.stakeId()), txCreatorSecret.publicImage().address(), nonce.toByteArray());
                        SignatureSecp256k1 signature = stakeOwnerSecret.sign(msgToSign);
                        byte[] dataBytes = this.encodeSpendStakeCmdRequest(signature, body2.stakeId());
                        EthereumTransaction tmpTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), Optional.of(new AddressProposition(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS())), nonce, gasLimit, maxPriorityFeePerGas, maxFeePerGas, valueInWei, dataBytes, null);
                        function13 = this.validateAndSendTransaction(this.ethereumTxToScat(this.signTransactionWithSecret(txCreatorSecret, tmpTx)), this.validateAndSendTransaction$default$2());
                    }
                    function12 = function13;
                } else if (None$.MODULE$.equals(option2)) {
                    function12 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorForgerStakeNotFound(new StringBuilder(36).append("No Forger Stake found with stake id ").append(body2.stakeId()).toString()));
                } else {
                    throw new MatchError(option2);
                }
                function1 = function12;
            } else if (None$.MODULE$.equals(option)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("No account with enough balance found", Optional.empty()));
            } else {
                throw new MatchError(option);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> allForgingStakes() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("allForgingStakes")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> this.withNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            NodeAccountState accountState = sidechainNodeView.getNodeState();
            Seq<AccountForgingStakeInfo> listOfForgerStakes = accountState.getListOfForgersStakes();
            return ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionRestScheme.RespForgerStakes((List<AccountForgingStakeInfo>)listOfForgerStakes.toList()));
        }));
    }

    public Function1<RequestContext, Future<RouteResult>> allowedForgerList() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("allowedForgerList")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            if (this.params().restrictForgers()) {
                Seq<Tuple2<PublicKey25519Proposition, VrfPublicKey>> allowedForgerKeysList = this.params().allowedForgersList();
                function1 = this.withNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                    NodeAccountState accountState = sidechainNodeView.getNodeState();
                    Seq<Object> forgersIndexList = accountState.getAllowedForgerList();
                    Seq resultList = (Seq)forgersIndexList.zip((GenIterable)allowedForgerKeysList, Seq$.MODULE$.canBuildFrom());
                    Seq allowedForgerInfoSeq = (Seq)resultList.map((Function1 & Serializable & scala.Serializable)entry -> new AccountTransactionRestScheme.RespForgerInfo((PublicKey25519Proposition)((Tuple2)entry._2())._1(), (VrfPublicKey)((Tuple2)entry._2())._2(), entry._1$mcI$sp()), Seq$.MODULE$.canBuildFrom());
                    return ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionRestScheme.RespAllowedForgerList((List<AccountTransactionRestScheme.RespForgerInfo>)allowedForgerInfoSeq.toList()));
                });
            } else {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionRestScheme.RespAllowedForgerList((List<AccountTransactionRestScheme.RespForgerInfo>)((TraversableOnce)Nil$.MODULE$).toList()));
            }
            return function1;
        });
    }

    public Function1<RequestContext, Future<RouteResult>> myForgingStakes() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("myForgingStakes")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$8 -> this.withNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            NodeAccountState accountState = sidechainNodeView.getNodeState();
            Seq<AccountForgingStakeInfo> listOfForgerStakes = accountState.getListOfForgersStakes();
            if (listOfForgerStakes.nonEmpty()) {
                NodeWalletBase wallet = sidechainNodeView.getNodeWallet();
                Seq walletPubKeys = ((TraversableOnce)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(wallet.allSecrets()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.publicImage(), Iterable$.MODULE$.canBuildFrom())).toSeq();
                SeqView ownedStakes = (SeqView)listOfForgerStakes.view().filter((Function1 & Serializable & scala.Serializable)stake -> BoxesRunTime.boxToBoolean((boolean)walletPubKeys.contains((Object)stake.forgerStakeData().ownerPublicKey())));
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionRestScheme.RespForgerStakes((List<AccountForgingStakeInfo>)ownedStakes.toList()));
            } else {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionRestScheme.RespForgerStakes((List<AccountForgingStakeInfo>)((TraversableOnce)Nil$.MODULE$).toList()));
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> withdrawCoins() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("withdrawCoins")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$10 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqWithdrawCoins.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            BigInteger txCost;
            Option<PrivateKeySecp256k1> secret;
            Option<PrivateKeySecp256k1> option;
            byte[] dataBytes = this.encodeAddNewWithdrawalRequestCmd(body2.withdrawalRequest());
            BigInteger valueInWei = ZenWeiConverter$.MODULE$.convertZenniesToWei(body2.withdrawalRequest().value());
            Option<AccountTransactionRestScheme.EIP1559GasInfo> gasInfo = body2.gasInfo();
            BigInteger baseFee = sidechainNodeView.getNodeState().getNextBaseFee();
            BigInteger maxPriorityFeePerGas = BigInteger.valueOf(120L);
            BigInteger maxFeePerGas = BigInteger.TWO.multiply(baseFee).add(maxPriorityFeePerGas);
            BigInteger gasLimit = BigInteger.valueOf(500000L);
            if (gasInfo.isDefined()) {
                maxFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)gasInfo.get()).maxFeePerGas();
                maxPriorityFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)gasInfo.get()).maxPriorityFeePerGas();
                gasLimit = ((AccountTransactionRestScheme.EIP1559GasInfo)gasInfo.get()).gasLimit();
            }
            if ((option = (secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, (Option<String>)None$.MODULE$, txCost = valueInWei.add(maxFeePerGas.multiply(gasLimit))))) instanceof Some) {
                Some some = (Some)option;
                PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(secret2.publicImage().address()));
                EthereumTransaction tmpTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), Optional.of(new AddressProposition(WithdrawalMsgProcessor$.MODULE$.contractAddress())), nonce, gasLimit, maxPriorityFeePerGas, maxFeePerGas, valueInWei, dataBytes, null);
                function1 = this.validateAndSendTransaction(this.ethereumTxToScat(this.signTransactionWithSecret(secret2, tmpTx)), this.validateAndSendTransaction$default$2());
            } else if (None$.MODULE$.equals(option)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("No account with enough balance found", Optional.empty()));
            } else {
                throw new MatchError(option);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> allWithdrawalRequests() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("allWithdrawalRequests")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqAllWithdrawalRequests.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> this.withNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            NodeAccountState accountState = sidechainNodeView.getNodeState();
            Seq<WithdrawalRequest> listOfWithdrawalRequests = accountState.getWithdrawalRequests(body2.epochNum());
            return ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionRestScheme.RespAllWithdrawalRequests((List<WithdrawalRequest>)listOfWithdrawalRequests.toList()));
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createSmartContract() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createSmartContract")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$11 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqCreateContract.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            BigInteger txCost;
            Option<PrivateKeySecp256k1> secret;
            Option<PrivateKeySecp256k1> option;
            BigInteger valueInWei = BigInteger.ZERO;
            BigInteger baseFee = sidechainNodeView.getNodeState().getNextBaseFee();
            BigInteger maxPriorityFeePerGas = GasUtil$.MODULE$.TxGasContractCreation();
            BigInteger maxFeePerGas = BigInteger.TWO.multiply(baseFee).add(maxPriorityFeePerGas);
            BigInteger gasLimit = BigInteger.valueOf(500000L);
            if (body2.gasInfo().isDefined()) {
                maxFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxFeePerGas();
                maxPriorityFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).maxPriorityFeePerGas();
                gasLimit = ((AccountTransactionRestScheme.EIP1559GasInfo)body2.gasInfo().get()).gasLimit();
            }
            if ((option = (secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, (Option<String>)None$.MODULE$, txCost = valueInWei.add(maxFeePerGas.multiply(gasLimit))))) instanceof Some) {
                Some some = (Some)option;
                PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                String to = null;
                BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(secret2.publicImage().address()));
                String data = body2.contractCode();
                EthereumTransaction tmpTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), EthereumTransactionUtils.getToAddressFromString(to), nonce, gasLimit, maxPriorityFeePerGas, maxFeePerGas, valueInWei, EthereumTransactionUtils.getDataFromString(data), null);
                function1 = this.validateAndSendTransaction(this.ethereumTxToScat(this.signTransactionWithSecret(secret2, tmpTx)), this.validateAndSendTransaction$default$2());
            } else if (None$.MODULE$.equals(option)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("No account with enough balance found", Optional.empty()));
            } else {
                throw new MatchError(option);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> createKeyRotationTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createKeyRotationTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$12 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(AccountTransactionRestScheme.ReqCreateKeyRotationTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1 function1;
            Enumeration.Value value = this.circuitType();
            Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorBadCircuit("The current circuit doesn't support key rotation transaction!", Optional.empty()));
            } else {
                Enumeration.Value value4 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    function1 = (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                        Function1<RequestContext, Future<RouteResult>> function1;
                        Option<ErrorResponse> option = this.checkKeyRotationProofValidity((AccountTransactionRestScheme.ReqCreateKeyRotationTransaction)body2, sidechainNodeView.getNodeState().getWithdrawalEpochInfo().epoch());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            ErrorResponse errorResponse = (ErrorResponse)some.value();
                            function1 = ApiResponseUtil$.MODULE$.toResponse(errorResponse);
                        } else if (None$.MODULE$.equals(option)) {
                            Function1<RequestContext, Future<RouteResult>> function12;
                            BigInteger txCost;
                            Option<PrivateKeySecp256k1> secret;
                            Option<PrivateKeySecp256k1> option2;
                            String data = AccountTransactionRestScheme$.MODULE$.encodeSubmitKeyRotationRequestCmd((AccountTransactionRestScheme.ReqCreateKeyRotationTransaction)body2);
                            Option<AccountTransactionRestScheme.EIP1559GasInfo> gasInfo = body2.gasInfo();
                            BigInteger baseFee = ((AccountBlock)sidechainNodeView.getNodeHistory().getBestBlock()).header().baseFee();
                            BigInteger maxPriorityFeePerGas = BigInteger.valueOf(120L);
                            BigInteger maxFeePerGas = BigInteger.TWO.multiply(baseFee).add(maxPriorityFeePerGas);
                            BigInteger gasLimit = BigInteger.TWO.multiply(GasUtil$.MODULE$.TxGas());
                            if (gasInfo.isDefined()) {
                                maxFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)gasInfo.get()).maxFeePerGas();
                                maxPriorityFeePerGas = ((AccountTransactionRestScheme.EIP1559GasInfo)gasInfo.get()).maxPriorityFeePerGas();
                                gasLimit = ((AccountTransactionRestScheme.EIP1559GasInfo)gasInfo.get()).gasLimit();
                            }
                            if ((option2 = (secret = this.getFittingSecret((AccountNodeView)sidechainNodeView, (Option<String>)None$.MODULE$, txCost = maxFeePerGas.multiply(gasLimit)))) instanceof Some) {
                                Some some = (Some)option2;
                                PrivateKeySecp256k1 secret2 = (PrivateKeySecp256k1)some.value();
                                BigInteger nonce = (BigInteger)body2.nonce().getOrElse((Function0 & Serializable & scala.Serializable)() -> sidechainNodeView.getNodeState().getNonce(secret2.publicImage().address()));
                                EthereumTransaction tmpTx = new EthereumTransaction(Predef$.MODULE$.long2Long(this.params().chainId()), Optional.of(new AddressProposition(CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractAddress())), nonce, gasLimit, maxPriorityFeePerGas, maxFeePerGas, BigInteger.ZERO, EthereumTransactionUtils.getDataFromString(data), null);
                                function12 = this.validateAndSendTransaction(this.ethereumTxToScat(this.signTransactionWithSecret(secret2, tmpTx)), this.validateAndSendTransaction$default$2());
                            } else if (None$.MODULE$.equals(option2)) {
                                function12 = ApiResponseUtil$.MODULE$.toResponse(new AccountTransactionErrorResponse.ErrorInsufficientBalance("No account with enough balance found", Optional.empty()));
                            } else {
                                throw new MatchError(option2);
                            }
                            function1 = function12;
                        } else {
                            throw new MatchError(option);
                        }
                        return function1;
                    });
                } else {
                    throw new MatchError((Object)value);
                }
            }
            return function1;
        })));
    }

    public byte[] encodeAddNewStakeCmdRequest(AccountTransactionRestScheme.TransactionForgerOutput forgerStakeInfo) {
        PublicKey25519Proposition blockSignPublicKey = new PublicKey25519Proposition(BytesUtils.fromHexString((String)forgerStakeInfo.blockSignPublicKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> forgerStakeInfo.ownerAddress())));
        VrfPublicKey vrfPubKey = new VrfPublicKey(BytesUtils.fromHexString(forgerStakeInfo.vrfPubKey()));
        AddNewStakeCmdInput addForgerStakeInput = new AddNewStakeCmdInput(new ForgerPublicKeys(blockSignPublicKey, vrfPubKey), new Address(new StringBuilder(2).append("0x").append(forgerStakeInfo.ownerAddress()).toString()));
        return Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd()), addForgerStakeInput.encode()});
    }

    public byte[] encodeOpenStakeCmdRequest(int forgerIndex, Signature25519 signature) {
        OpenStakeForgerListCmdInput openStakeForgerListInput = new OpenStakeForgerListCmdInput(forgerIndex, signature);
        return Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd()), openStakeForgerListInput.encode()});
    }

    public byte[] encodeSpendStakeCmdRequest(SignatureSecp256k1 signatureSecp256k1, String stakeId) {
        RemoveStakeCmdInput spendForgerStakeInput = new RemoveStakeCmdInput(BytesUtils.fromHexString(stakeId), signatureSecp256k1);
        return Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd()), spendForgerStakeInput.encode()});
    }

    public byte[] encodeAddNewWithdrawalRequestCmd(AccountTransactionRestScheme.TransactionWithdrawalRequest withdrawal) {
        MCPublicKeyHashProposition mcAddrHash = (MCPublicKeyHashProposition)MCPublicKeyHashPropositionSerializer.getSerializer().parseBytes(BytesUtils.fromHorizenPublicKeyAddress(withdrawal.mainchainAddress(), this.params()));
        AddWithdrawalRequestCmdInput addWithdrawalRequestInput = new AddWithdrawalRequestCmdInput(mcAddrHash);
        return Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(WithdrawalMsgProcessor$.MODULE$.AddNewWithdrawalReqCmdSig()), addWithdrawalRequestInput.encode()});
    }

    private Option<ErrorResponse> checkKeyRotationProofValidity(AccountTransactionRestScheme.ReqCreateKeyRotationTransaction body2, int epoch) {
        byte[] byArray;
        int index = body2.keyIndex();
        int keyType = body2.keyType();
        SchnorrProposition newKey = SchnorrPropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(body2.newKey()));
        SchnorrProof newKeySignature = (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(body2.newKeySignature()));
        if (index < 0 || index >= this.params().signersPublicKeys().length()) {
            return new Some((Object)new AccountTransactionErrorResponse.ErrorInvalidKeyRotationProof(new StringBuilder(45).append("Key rotation proof - key index out of range: ").append(index).toString()));
        }
        if (keyType < 0 || keyType >= KeyRotationProofTypes$.MODULE$.maxId()) {
            return new Some((Object)new AccountTransactionErrorResponse.ErrorInvalidKeyRotationProof(new StringBuilder(57).append("Key rotation proof - key type enumeration value invalid: ").append(keyType).toString()));
        }
        Enumeration.Value value = KeyRotationProofTypes$.MODULE$.apply(keyType);
        Enumeration.Value value2 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForSigningKeyUpdate(newKey.pubKeyBytes(), epoch, this.params().sidechainId());
        } else {
            Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForMasterKeyUpdate(newKey.pubKeyBytes(), epoch, this.params().sidechainId());
            } else {
                throw new MatchError((Object)value);
            }
        }
        byte[] messageToSign = byArray;
        if (!newKeySignature.isValid(newKey, messageToSign)) {
            return new Some((Object)new AccountTransactionErrorResponse.ErrorInvalidKeyRotationProof(new StringBuilder(48).append("Key rotation proof - self signature is invalid: ").append(index).toString()));
        }
        return None$.MODULE$;
    }

    public AccountTransactionApiRoute copy(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, ActorRef sidechainTransactionActorRef, SidechainAccountTransactionsCompanion companion, NetworkParams params, Enumeration.Value circuitType, ActorRefFactory context, ExecutionContext ec) {
        return new AccountTransactionApiRoute(settings, sidechainNodeViewHolderRef, sidechainTransactionActorRef, companion, params, circuitType, context, ec);
    }

    public RESTApiSettings copy$default$1() {
        return this.settings();
    }

    public ActorRef copy$default$2() {
        return this.sidechainNodeViewHolderRef();
    }

    public ActorRef copy$default$3() {
        return this.sidechainTransactionActorRef();
    }

    public SidechainAccountTransactionsCompanion copy$default$4() {
        return this.companion();
    }

    public NetworkParams copy$default$5() {
        return this.params();
    }

    public Enumeration.Value copy$default$6() {
        return this.circuitType();
    }

    public String productPrefix() {
        return "AccountTransactionApiRoute";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.settings();
                break;
            }
            case 1: {
                object = this.sidechainNodeViewHolderRef();
                break;
            }
            case 2: {
                object = this.sidechainTransactionActorRef();
                break;
            }
            case 3: {
                object = this.companion();
                break;
            }
            case 4: {
                object = this.params();
                break;
            }
            case 5: {
                object = this.circuitType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AccountTransactionApiRoute;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AccountTransactionApiRoute)) return false;
        boolean bl = true;
        if (!bl) return false;
        AccountTransactionApiRoute accountTransactionApiRoute = (AccountTransactionApiRoute)x$1;
        RESTApiSettings rESTApiSettings = this.settings();
        RESTApiSettings rESTApiSettings2 = accountTransactionApiRoute.settings();
        if (rESTApiSettings == null) {
            if (rESTApiSettings2 != null) {
                return false;
            }
        } else if (!rESTApiSettings.equals(rESTApiSettings2)) return false;
        ActorRef actorRef = this.sidechainNodeViewHolderRef();
        ActorRef actorRef2 = accountTransactionApiRoute.sidechainNodeViewHolderRef();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!actorRef.equals(actorRef2)) return false;
        ActorRef actorRef3 = this.sidechainTransactionActorRef();
        ActorRef actorRef4 = accountTransactionApiRoute.sidechainTransactionActorRef();
        if (actorRef3 == null) {
            if (actorRef4 != null) {
                return false;
            }
        } else if (!actorRef3.equals(actorRef4)) return false;
        SidechainAccountTransactionsCompanion sidechainAccountTransactionsCompanion = this.companion();
        SidechainAccountTransactionsCompanion sidechainAccountTransactionsCompanion2 = accountTransactionApiRoute.companion();
        if (sidechainAccountTransactionsCompanion == null) {
            if (sidechainAccountTransactionsCompanion2 != null) {
                return false;
            }
        } else if (!((Object)sidechainAccountTransactionsCompanion).equals(sidechainAccountTransactionsCompanion2)) return false;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = accountTransactionApiRoute.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        Enumeration.Value value = this.circuitType();
        Enumeration.Value value2 = accountTransactionApiRoute.circuitType();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!accountTransactionApiRoute.canEqual(this)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getFittingSecret$1(Option fromAddress$1, AccountNodeView nodeView$1, BigInteger txValueInWei$1, Secret a) {
        if (!fromAddress$1.isEmpty()) {
            String string = BytesUtils.toHexString(((PrivateKeySecp256k1)a).publicImage().address().toBytes());
            Object object = fromAddress$1.get();
            if (string == null) {
                if (object != null) {
                    return false;
                }
            } else if (!string.equals(object)) return false;
        }
        if (nodeView$1.getNodeState().getBalance(((PrivateKeySecp256k1)a).publicImage().address()).compareTo(txValueInWei$1) < 0) return false;
        return true;
    }

    public AccountTransactionApiRoute(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, ActorRef sidechainTransactionActorRef, SidechainAccountTransactionsCompanion companion, NetworkParams params, Enumeration.Value circuitType, ActorRefFactory context, ExecutionContext ec) {
        this.settings = settings;
        this.sidechainNodeViewHolderRef = sidechainNodeViewHolderRef;
        this.sidechainTransactionActorRef = sidechainTransactionActorRef;
        this.companion = companion;
        this.params = params;
        this.circuitType = circuitType;
        super(sidechainTransactionActorRef, companion, context, ec);
        SidechainTypes.$init$(this);
        Product.$init$((Product)this);
        this.tag = ClassTag$.MODULE$.apply(AccountNodeView.class);
        this.route = (Function1)Directive$.MODULE$.addByNameNullaryApply(this.pathPrefix(this._segmentStringToPathMatcher("transaction"))).apply((Function0 & Serializable & scala.Serializable)() -> this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation(this.allTransactions()).$tilde(this.createLegacyEIP155Transaction())).$tilde(this.createEIP1559Transaction())).$tilde(this.createLegacyTransaction())).$tilde(this.sendTransaction())).$tilde(this.signTransaction())).$tilde(this.makeForgerStake())).$tilde(this.withdrawCoins())).$tilde(this.spendForgingStake())).$tilde(this.createSmartContract())).$tilde(this.allWithdrawalRequests())).$tilde(this.allForgingStakes())).$tilde(this.myForgingStakes())).$tilde(this.decodeTransactionBytes())).$tilde(this.openForgerList())).$tilde(this.allowedForgerList())).$tilde(this.createKeyRotationTransaction()));
    }
}

