/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.abi;

import java.util.List;
import org.web3j.abi.DefaultFunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Type;
import org.web3j.utils.Numeric;

public interface ABIDecoder<T> {
    public List<TypeReference<Type>> getListOfABIParamTypes();

    default public int getABIDataParamsLengthInBytes() {
        return 32 * this.getListOfABIParamTypes().size();
    }

    default public T decode(byte[] abiEncodedData) {
        if (abiEncodedData.length != this.getABIDataParamsLengthInBytes()) {
            throw new IllegalArgumentException("Wrong message data field length: " + abiEncodedData.length + ", expected: " + this.getABIDataParamsLengthInBytes());
        }
        String inputParamsString = Numeric.toHexString((byte[])abiEncodedData);
        DefaultFunctionReturnDecoder decoder = new DefaultFunctionReturnDecoder();
        List listOfParams = decoder.decodeFunctionResult(inputParamsString, this.getListOfABIParamTypes());
        return this.createType(listOfParams);
    }

    public T createType(List<Type> var1);
}

