/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.horizen.AbstractSidechainApp;
import io.horizen.ChainInfo;
import io.horizen.SidechainAppEvents$SidechainApplicationStart$;
import io.horizen.SidechainAppStopper;
import io.horizen.SidechainSettings;
import io.horizen.SidechainSyncInfoMessageSpec$;
import io.horizen.account.AccountNodeViewHolderRef$;
import io.horizen.account.api.http.AccountApplicationApiGroup;
import io.horizen.account.api.http.route.AccountApplicationApiRoute;
import io.horizen.account.api.http.route.AccountBlockApiRoute;
import io.horizen.account.api.http.route.AccountEthRpcRoute;
import io.horizen.account.api.http.route.AccountTransactionApiRoute;
import io.horizen.account.api.http.route.AccountWalletApiRoute;
import io.horizen.account.api.rpc.handler.RpcHandler;
import io.horizen.account.api.rpc.service.EthService;
import io.horizen.account.api.rpc.service.RpcProcessor;
import io.horizen.account.api.rpc.service.RpcUtils$;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.block.AccountBlockSerializer;
import io.horizen.account.certificatesubmitter.AccountCertificateSubmitterRef$;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.forger.AccountForgerRef$;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.network.AccountNodeViewSynchronizer$;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.storage.AccountHistoryStorage;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.websocket.WebSocketAccountServerRef$;
import io.horizen.api.http.SidechainBlockActorRef$;
import io.horizen.api.http.SidechainTransactionActorRef$;
import io.horizen.api.http.SidechainTransactionRateLimiterActorRef$;
import io.horizen.api.http.route.MainchainBlockApiRoute;
import io.horizen.api.http.route.SidechainNodeApiRoute;
import io.horizen.api.http.route.SidechainSubmitterApiRoute;
import io.horizen.block.SidechainBlockBase$;
import io.horizen.certificatesubmitter.network.CertificateSignaturesManagerRef$;
import io.horizen.consensus.ConsensusDataStorage;
import io.horizen.evm.Database;
import io.horizen.evm.LevelDBDatabase;
import io.horizen.fork.ForkConfigurator;
import io.horizen.helper.NodeViewProvider;
import io.horizen.helper.NodeViewProviderImpl;
import io.horizen.helper.TransactionSubmitProvider;
import io.horizen.helper.TransactionSubmitProviderImpl;
import io.horizen.network.SyncStatusActorRef$;
import io.horizen.node.NodeWalletBase;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.storage.leveldb.VersionedLevelDbStorageAdapter;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sparkz.core.NodeViewModifier;
import sparkz.core.api.http.ApiRoute;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.core.transaction.Transaction$;

@ScalaSignature(bytes="\u0006\u0001\r]h\u0001\u0002#F\u00011C\u0011\"\u0015\u0001\u0003\u0002\u0003\u0006IAU+\t\u0013\u0019\u0004!\u0011!Q\u0001\n\u001dt\bBCA\u0003\u0001\t\u0005\t\u0015!\u0003\u0002\b!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u0019\u0005m\u0003A!A!\u0002\u0013\ti&!\"\t\u0015\u00055\u0005A!A!\u0002\u0013\ty\t\u0003\u0007\u0002$\u0002\u0011\t\u0011)A\u0005\u0003K\u000bY\u000b\u0003\u0007\u00024\u0002\u0011\t\u0011)A\u0005\u0003k\u000b\t\r\u0003\u0007\u0002J\u0002\u0011\t\u0011)A\u0005\u0003\u0017\f\t\u000e\u0003\u0007\u0002Z\u0002\u0011\t\u0011)A\u0005\u00037\f\u0019\u000fC\u0004\u0002n\u0002!\t!a<\u0006\r\t\u001d\u0002\u0001IA\u000b\u000b\u0019\u0011I\u0003\u0001\u0011\u0003,\u00151!q\u0007\u0001!\u0005sA\u0011Ba\u0010\u0001\u0005\u0004%\tE!\u0011\t\u0011\t\r\u0003\u0001)A\u0005\u0003WB!B!\u0012\u0001\u0011\u000b\u0007I\u0011\u0003B$\u0011)\u0011)\u0006\u0001EC\u0002\u0013\u0005#q\u000b\u0005\n\u00053\u0002!\u0019!C\u0001\u0005\u0003B\u0001Ba\u0017\u0001A\u0003%\u00111\u000e\u0005\n\u0005;\u0002!\u0019!C\u0001\u0005?B\u0001Ba\u001b\u0001A\u0003%!\u0011\r\u0005\n\u0005[\u0002!\u0019!C\u0001\u0005?B\u0001Ba\u001c\u0001A\u0003%!\u0011\r\u0005\n\u0005c\u0002!\u0019!C\u0001\u0005?B\u0001Ba\u001d\u0001A\u0003%!\u0011\r\u0005\n\u0005k\u0002!\u0019!C\u0001\u0005?B\u0001Ba\u001e\u0001A\u0003%!\u0011\r\u0005\n\u0005s\u0002!\u0019!C\t\u0005wB\u0001B!#\u0001A\u0003%!Q\u0010\u0005\n\u0005\u0017\u0003!\u0019!C\t\u0005\u001bC\u0001B!'\u0001A\u0003%!q\u0012\u0005\n\u00057\u0003!\u0019!C\t\u0005;C\u0001Ba+\u0001A\u0003%!q\u0014\u0005\n\u0005[\u0003!\u0019!C\t\u0005_C\u0001Ba.\u0001A\u0003%!\u0011\u0017\u0005\n\u0005s\u0003!\u0019!C\t\u0005wC\u0001B!3\u0001A\u0003%!Q\u0018\u0005\n\u0005\u0017\u0004!\u0019!C!\u0005\u001bD\u0001Ba8\u0001A\u0003%!q\u001a\u0005\b\u0005C\u0004A\u0011\u0001Br\u0011%\u0019y\u0003\u0001b\u0001\n\u0003\u0012i\r\u0003\u0005\u00042\u0001\u0001\u000b\u0011\u0002Bh\u0011%\u0019\u0019\u0004\u0001b\u0001\n\u0003\u0011i\r\u0003\u0005\u00046\u0001\u0001\u000b\u0011\u0002Bh\u0011%\u00199\u0004\u0001b\u0001\n\u0003\u0011i\r\u0003\u0005\u0004:\u0001\u0001\u000b\u0011\u0002Bh\u0011%\u0019Y\u0004\u0001b\u0001\n\u0003\u0011i\r\u0003\u0005\u0004>\u0001\u0001\u000b\u0011\u0002Bh\u0011%\u0019y\u0004\u0001b\u0001\n\u0003\u0011i\r\u0003\u0005\u0004B\u0001\u0001\u000b\u0011\u0002Bh\u0011%\u0019\u0019\u0005\u0001b\u0001\n\u0003\u0011i\r\u0003\u0005\u0004F\u0001\u0001\u000b\u0011\u0002Bh\u0011%\u00199\u0005\u0001b\u0001\n\u0003\u0011i\r\u0003\u0005\u0004J\u0001\u0001\u000b\u0011\u0002Bh\u0011%\u0019Y\u0005\u0001b\u0001\n\u0003\u0019i\u0005\u0003\u0005\u0004`\u0001\u0001\u000b\u0011BB(\u0011%\u0019\t\u0007\u0001b\u0001\n\u0003\u0019\u0019\u0007\u0003\u0005\u0004r\u0001\u0001\u000b\u0011BB3\u0011)\u0019\u0019\b\u0001EC\u0002\u0013\u00053Q\u000f\u0005\u000b\u0007'\u0003\u0001R1A\u0005B\rU\u0004\"CBK\u0001\t\u0007I\u0011ABL\u0011!\u0019)\u000f\u0001Q\u0001\n\re\u0005bBBt\u0001\u0011\u00051q\u0013\u0005\n\u0007S\u0004!\u0019!C\u0001\u0007WD\u0001ba=\u0001A\u0003%1Q\u001e\u0005\b\u0007k\u0004A\u0011IBv\u0005M\t5mY8v]R\u001c\u0016\u000eZ3dQ\u0006Lg.\u00119q\u0015\t1u)A\u0004bG\u000e|WO\u001c;\u000b\u0005!K\u0015a\u00025pe&TXM\u001c\u0006\u0002\u0015\u0006\u0011\u0011n\\\u0002\u0001'\t\u0001Q\n\u0005\u0002O\u001f6\tq)\u0003\u0002Q\u000f\n!\u0012IY:ue\u0006\u001cGoU5eK\u000eD\u0017-\u001b8BaB\f\u0011c]5eK\u000eD\u0017-\u001b8TKR$\u0018N\\4t!\tq5+\u0003\u0002U\u000f\n\t2+\u001b3fG\"\f\u0017N\\*fiRLgnZ:\n\u0005E{\u0005\u0006B\u0001XG\u0012\u0004\"\u0001W1\u000e\u0003eS!AW.\u0002\t9\fW.\u001a\u0006\u00039v\u000ba!\u001b8kK\u000e$(B\u00010`\u0003\u00199wn\\4mK*\t\u0001-A\u0002d_6L!AY-\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0003\u0015\f\u0011cU5eK\u000eD\u0017-\u001b8TKR$\u0018N\\4t\u0003]\u0019Wo\u001d;p[N+7M]3u'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000f\u0005\u0003i[>,X\"A5\u000b\u0005)\\\u0017\u0001B;uS2T\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002oS\n9\u0001*Y:i\u001b\u0006\u0004\bC\u00019t\u001b\u0005\t(B\u0001:l\u0003\u0011a\u0017M\\4\n\u0005Q\f(\u0001\u0002\"zi\u0016\u00042A^=|\u001b\u00059(B\u0001=H\u0003\u0019\u0019Xm\u0019:fi&\u0011!p\u001e\u0002\u0011'\u0016\u001c'/\u001a;TKJL\u0017\r\\5{KJ\u0004\"A\u001e?\n\u0005u<(AB*fGJ,G/\u0003\u0002g\u001f\"*!aV2\u0002\u0002\u0005\u0012\u00111A\u0001\u0018\u0007V\u001cHo\\7TK\u000e\u0014X\r^*fe&\fG.\u001b>feN\f1eY;ti>l\u0017iY2pk:$HK]1og\u0006\u001cG/[8o'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000fE\u0003i[>\fI\u0001\u0005\u0004\u0002\f\u0005E\u0011QC\u0007\u0003\u0003\u001bQ1!a\u0004H\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\u0016)J\fgn]1di&|gnU3sS\u0006d\u0017N_3s!!\t9\"a\u0007\u0002 \u0005-RBAA\r\u0015\r\ty!R\u0005\u0005\u0003;\tIB\u0001\nBG\u000e|WO\u001c;Ue\u0006t7/Y2uS>t\u0007\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015r)A\u0006qe>\u0004xn]5uS>t\u0017\u0002BA\u0015\u0003G\u00111\u0002\u0015:pa>\u001c\u0018\u000e^5p]B1\u0011QFA\u001a\u0003?i!!a\f\u000b\u0007\u0005Er)A\u0003qe>|g-\u0003\u0003\u00026\u0005=\"!\u0002)s_>4\u0007&B\u0002XG\u0006e\u0012EAA\u001e\u0003\r\u001aUo\u001d;p[\u0006\u001b7m\\;oiR\u0013\u0018M\\:bGRLwN\\*fe&\fG.\u001b>feN\fqbY;ti>l\u0017\t]5He>,\bo\u001d\t\u0006Q\u0006\u0005\u0013QI\u0005\u0004\u0003\u0007J'\u0001\u0002'jgR\u0004B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0003iiR\u0004(bAA(\u000b\u0006\u0019\u0011\r]5\n\t\u0005M\u0013\u0011\n\u0002\u001b\u0003\u000e\u001cw.\u001e8u\u0003B\u0004H.[2bi&|g.\u00119j\u000fJ|W\u000f\u001d\u0015\u0006\t]\u001b\u0017qK\u0011\u0003\u00033\nqbQ;ti>l\u0017\t]5He>,\bo]\u0001\u0011e\u0016TWm\u0019;fI\u0006\u0003\u0018\u000eU1uQN\u0004R\u0001[A!\u0003?\u0002\u0002\"!\u0019\u0002h\u0005-\u00141N\u0007\u0003\u0003GR1!!\u001aH\u0003\u0015)H/\u001b7t\u0013\u0011\tI'a\u0019\u0003\tA\u000b\u0017N\u001d\t\u0005\u0003[\nyH\u0004\u0003\u0002p\u0005m\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005U4*\u0001\u0004=e>|GO\u0010\u0006\u0003\u0003s\nQa]2bY\u0006LA!! \u0002x\u00051\u0001K]3eK\u001aLA!!!\u0002\u0004\n11\u000b\u001e:j]\u001eTA!! \u0002x%\u0019\u00111L()\u000b\u001596-!#\"\u0005\u0005-\u0015\u0001\u0005*fU\u0016\u001cG/\u001a3Ba&\u0004\u0016\r\u001e5t\u0003]\u0019Wo\u001d;p[6+7o]1hKB\u0013xnY3tg>\u00148\u000fE\u0003i\u0003\u0003\n\t\n\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9*R\u0001\u0006gR\fG/Z\u0005\u0005\u00037\u000b)J\u0001\tNKN\u001c\u0018mZ3Qe>\u001cWm]:pe\"*aaV2\u0002 \u0006\u0012\u0011\u0011U\u0001\u0018\u0007V\u001cHo\\7NKN\u001c\u0018mZ3Qe>\u001cWm]:peN\f!#\u00199qY&\u001c\u0017\r^5p]N#x\u000e\u001d9feB\u0019a*a*\n\u0007\u0005%vIA\nTS\u0012,7\r[1j]\u0006\u0003\bo\u0015;paB,'/C\u0002\u0002$>CSaB,d\u0003_\u000b#!!-\u0002%\u0005\u0003\b\u000f\\5dCRLwN\\*u_B\u0004XM]\u0001\u0011M>\u00148nQ8oM&<WO]1u_J\u0004B!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w;\u0015\u0001\u00024pe.LA!a0\u0002:\n\u0001bi\u001c:l\u0007>tg-[4ve\u0006$xN]\u0005\u0004\u0003g{\u0005&\u0002\u0005XG\u0006\u0015\u0017EAAd\u0003E1uN]6D_:4\u0017nZ;sCRLwN\\\u0001\nG\"\f\u0017N\\%oM>\u00042ATAg\u0013\r\tym\u0012\u0002\n\u0007\"\f\u0017N\\%oM>L1!!3PQ\u0015IqkYAkC\t\t9.A\u0005DQ\u0006Lg.\u00138g_\u0006i1/Z2p]\u0012\u001c\u0018J\\*m_R\u0004B!!8\u0002`6\u0011\u0011qO\u0005\u0005\u0003C\f9HA\u0002J]RL1!!:P\u0003Y\u0019wN\\:f]N,8oU3d_:$7/\u00138TY>$\b&\u0002\u0006XG\u0006%\u0018EAAv\u0003Y\u0019uN\\:f]N,8oU3d_:$7/\u00138TY>$\u0018A\u0002\u001fj]&$h\b\u0006\f\u0002r\u0006U\u0018\u0011`A\u007f\u0005\u0003\u0011)A!\u0003\u0003\u000e\tE!Q\u0003B\r!\r\t\u0019\u0010A\u0007\u0002\u000b\")\u0011k\u0003a\u0001%\"*\u0011Q_,dI\")am\u0003a\u0001O\"2\u0011\u0011`,d\u0003\u0003Aq!!\u0002\f\u0001\u0004\t9\u0001\u000b\u0004\u0002~^\u001b\u0017\u0011\b\u0005\b\u0003{Y\u0001\u0019AA Q\u0019\u0011\taV2\u0002X!9\u00111L\u0006A\u0002\u0005u\u0003F\u0002B\u0003/\u000e\fI\tC\u0004\u0002\u000e.\u0001\r!a$)\r\t%qkYAP\u0011\u001d\t\u0019k\u0003a\u0001\u0003KCcA!\u0004XG\u0006=\u0006bBAZ\u0017\u0001\u0007\u0011Q\u0017\u0015\u0007\u0005#96-!2\t\u000f\u0005%7\u00021\u0001\u0002L\"2!QC,d\u0003+Dq!!7\f\u0001\u0004\tY\u000e\u000b\u0004\u0003\u001a]\u001b\u0017\u0011\u001e\u0015\u0004\u0017\t}\u0001\u0003\u0002B\u0011\u0005Gi\u0011aW\u0005\u0004\u0005KY&AB%oU\u0016\u001cGO\u0001\u0002U1\n!\u0001+T(E!\u0011\u0011iCa\r\u000e\u0005\t=\"b\u0001B\u0019\u000b\u0006)!\r\\8dW&!!Q\u0007B\u0018\u00051\t5mY8v]R\u0014En\\2l\u0005\u0011qe\u000b\u0013+\u0011\t\u0005M(1H\u0005\u0004\u0005{)%AH!dG>,h\u000e^*jI\u0016\u001c\u0007.Y5o\u001d>$WMV5fo\"{G\u000eZ3s\u00035\u0019x/Y4hKJ\u001cuN\u001c4jOV\u0011\u00111N\u0001\u000fg^\fwmZ3s\u0007>tg-[4!\u0003y\u0019\u0018\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]N\u001cu.\u001c9b]&|g.\u0006\u0002\u0003JA!!1\nB)\u001b\t\u0011iEC\u0002\u0003P\u0015\u000b\u0011bY8na\u0006t\u0017n\u001c8\n\t\tM#Q\n\u0002&'&$Wm\u00195bS:\f5mY8v]R$&/\u00198tC\u000e$\u0018n\u001c8t\u0007>l\u0007/\u00198j_:\fAbZ3oKNL7O\u00117pG.,\"Aa\u000b\u0002'\u0011\fG/\u0019#je\u0006\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002)\u0011\fG/\u0019#je\u0006\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5!\u0003-\u0019Xm\u0019:fiN#xN]3\u0016\u0005\t\u0005\u0004\u0003\u0002B2\u0005Oj!A!\u001a\u000b\u0005)[\u0017\u0002\u0002B5\u0005K\u0012AAR5mK\u0006a1/Z2sKR\u001cFo\u001c:fA\u0005qQ.\u001a;b'R\fG/Z*u_J,\u0017aD7fi\u0006\u001cF/\u0019;f'R|'/\u001a\u0011\u0002\u0019!L7\u000f^8ssN#xN]3\u0002\u001b!L7\u000f^8ssN#xN]3!\u00039\u0019wN\\:f]N,8o\u0015;pe\u0016\fqbY8og\u0016t7/^:Ti>\u0014X\rI\u0001\u0017g&$Wm\u00195bS:\u001cVm\u0019:fiN#xN]1hKV\u0011!Q\u0010\t\u0005\u0005\u007f\u0012))\u0004\u0002\u0003\u0002*\u0019!1Q$\u0002\u000fM$xN]1hK&!!q\u0011BA\u0005Y\u0019\u0016\u000eZ3dQ\u0006LgnU3de\u0016$8\u000b^8sC\u001e,\u0017aF:jI\u0016\u001c\u0007.Y5o'\u0016\u001c'/\u001a;Ti>\u0014\u0018mZ3!\u0003Q\u0019H/\u0019;f\u001b\u0016$\u0018\rZ1uCN#xN]1hKV\u0011!q\u0012\t\u0005\u0005#\u0013)*\u0004\u0002\u0003\u0014*\u0019!1Q#\n\t\t]%1\u0013\u0002\u001c\u0003\u000e\u001cw.\u001e8u'R\fG/Z'fi\u0006$\u0017\r^1Ti>\u0014\u0018mZ3\u0002+M$\u0018\r^3NKR\fG-\u0019;b'R|'/Y4fA\u0005q1\u000f^1uK\u0012\u00137\u000b^8sC\u001e,WC\u0001BP!\u0011\u0011\tKa*\u000e\u0005\t\r&b\u0001BS\u000f\u0006\u0019QM^7\n\t\t%&1\u0015\u0002\u0010\u0019\u00164X\r\u001c#C\t\u0006$\u0018MY1tK\u0006y1\u000f^1uK\u0012\u00137\u000b^8sC\u001e,\u0007%A\ftS\u0012,7\r[1j]\"K7\u000f^8ssN#xN]1hKV\u0011!\u0011\u0017\t\u0005\u0005#\u0013\u0019,\u0003\u0003\u00036\nM%!F!dG>,h\u000e\u001e%jgR|'/_*u_J\fw-Z\u0001\u0019g&$Wm\u00195bS:D\u0015n\u001d;pef\u001cFo\u001c:bO\u0016\u0004\u0013\u0001F2p]N,gn];t\t\u0006$\u0018m\u0015;pe\u0006<W-\u0006\u0002\u0003>B!!q\u0018Bc\u001b\t\u0011\tMC\u0002\u0003D\u001e\u000b\u0011bY8og\u0016t7/^:\n\t\t\u001d'\u0011\u0019\u0002\u0015\u0007>t7/\u001a8tkN$\u0015\r^1Ti>\u0014\u0018mZ3\u0002+\r|gn]3ogV\u001cH)\u0019;b'R|'/Y4fA\u0005\tbn\u001c3f-&,w\u000fS8mI\u0016\u0014(+\u001a4\u0016\u0005\t=\u0007\u0003\u0002Bi\u00057l!Aa5\u000b\t\tU'q[\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u00053\fA!Y6lC&!!Q\u001cBj\u0005!\t5\r^8s%\u00164\u0017A\u00058pI\u00164\u0016.Z<I_2$WM\u001d*fM\u0002\n1#\\8eS\u001aLWM]*fe&\fG.\u001b>feN,\"A!:\u0011\u0011\u00055$q\u001dBv\u0007\u0013IAA!;\u0002\u0004\n\u0019Q*\u00199\u0011\t\t581\u0001\b\u0005\u0005_\u0014iP\u0004\u0003\u0003r\n]h\u0002BA9\u0005gL!A!>\u0002\rM\u0004\u0018M]6{\u0013\u0011\u0011IPa?\u0002\t\r|'/\u001a\u0006\u0003\u0005kLAAa@\u0004\u0002\u00059\u0001/Y2lC\u001e,'\u0002\u0002B}\u0005wLAa!\u0002\u0004\b\tqQj\u001c3jM&,'\u000fV=qK&#'\u0002\u0002B\u0000\u0007\u0003\u0001Daa\u0003\u0004\u001cA11QBB\n\u0007/i!aa\u0004\u000b\t\rE1\u0011A\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\t\rU1q\u0002\u0002\u0011'B\f'o\u001b>TKJL\u0017\r\\5{KJ\u0004Ba!\u0007\u0004\u001c1\u0001AaCB\u000fS\u0005\u0005\t\u0011!B\u0001\u0007?\u00111a\u0018\u00132#\u0011\u0019\tca\n\u0011\t\u0005u71E\u0005\u0005\u0007K\t9HA\u0004O_RD\u0017N\\4\u0011\t\r%21F\u0007\u0003\u0007\u0003IAa!\f\u0004\u0002\t\u0001bj\u001c3f-&,w/T8eS\u001aLWM]\u0001\u0015]>$WMV5foNKhn\u00195s_:L'0\u001a:\u0002+9|G-\u001a,jK^\u001c\u0016P\\2ie>t\u0017N_3sA\u0005a2/\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\gi\u001c:hKJ\f5\r^8s%\u00164\u0017!H:jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b$pe\u001e,'/Q2u_J\u0014VM\u001a\u0011\u00029MLG-Z2iC&tGK]1og\u0006\u001cG/[8o\u0003\u000e$xN\u001d*fM\u0006i2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\f5\r^8s%\u00164\u0007%\u0001\ftS\u0012,7\r[1j]\ncwnY6BGR|'OU3g\u0003]\u0019\u0018\u000eZ3dQ\u0006LgN\u00117pG.\f5\r^8s%\u00164\u0007%A\fdKJ$\u0018NZ5dCR,7+\u001e2nSR$XM\u001d*fM\u0006A2-\u001a:uS\u001aL7-\u0019;f'V\u0014W.\u001b;uKJ\u0014VM\u001a\u0011\u0002?\r,'\u000f^5gS\u000e\fG/Z*jO:\fG/\u001e:fg6\u000bg.Y4feJ+g-\u0001\u0011dKJ$\u0018NZ5dCR,7+[4oCR,(/Z:NC:\fw-\u001a:SK\u001a\u0004\u0013AE:z]\u000e\u001cF/\u0019;vg\u0006\u001bGo\u001c:SK\u001a\f1c]=oGN#\u0018\r^;t\u0003\u000e$xN\u001d*fM\u0002\n!B\u001d9d\u0011\u0006tG\r\\3s+\t\u0019y\u0005\u0005\u0003\u0004R\rmSBAB*\u0015\u0011\u0019)fa\u0016\u0002\u000f!\fg\u000e\u001a7fe*!1\u0011LA'\u0003\r\u0011\boY\u0005\u0005\u0007;\u001a\u0019F\u0001\u0006Sa\u000eD\u0015M\u001c3mKJ\f1B\u001d9d\u0011\u0006tG\r\\3sA\u0005a!\u000f]2Qe>\u001cWm]:peV\u00111Q\r\t\u0005\u0007O\u001ai'\u0004\u0002\u0004j)!11NB,\u0003\u001d\u0019XM\u001d<jG\u0016LAaa\u001c\u0004j\ta!\u000b]2Qe>\u001cWm]:pe\u0006i!\u000f]2Qe>\u001cWm]:pe\u0002\nA#\u00199qY&\u001c\u0017\r^5p]\u0006\u0003\u0018NU8vi\u0016\u001cXCAB<!\u0019\u0019Ih!!\u0004\b:!11PB@\u001d\u0011\t\th! \n\u0005\u0005e\u0014\u0002\u0002B\u0000\u0003oJAaa!\u0004\u0006\n\u00191+Z9\u000b\t\t}\u0018q\u000f\t\u0005\u0007\u0013\u001by)\u0004\u0002\u0004\f*!\u00111JBG\u0015\u0011\tye!\u0001\n\t\rE51\u0012\u0002\t\u0003BL'k\\;uK\u0006i1m\u001c:f\u0003BL'k\\;uKN\f\u0001C\\8eKZKWm\u001e)s_ZLG-\u001a:\u0016\u0005\re\u0005CFBN\u0007C\u001b)k!+\u00040\u000eE6QXBe\u0007\u001f\u001cIna8\u000e\u0005\ru%bABP\u000f\u00061\u0001.\u001a7qKJLAaa)\u0004\u001e\n\u0001bj\u001c3f-&,w\u000f\u0015:pm&$WM\u001d\t\u0004\u0007OcQ\"\u0001\u0001\u0011\t\t521V\u0005\u0005\u0007[\u0013yC\u0001\nBG\u000e|WO\u001c;CY>\u001c7\u000eS3bI\u0016\u0014\bcABT\u001bA!11WB]\u001b\t\u0019)LC\u0002\u00048\u0016\u000bQa\u00195bS:LAaa/\u00046\n1\u0012iY2pk:$h)Z3QCflWM\u001c;t\u0013:4w\u000e\u0005\u0003\u0004@\u000e\u0015WBABa\u0015\r\u0019\u0019-R\u0001\u0005]>$W-\u0003\u0003\u0004H\u000e\u0005'A\u0005(pI\u0016\f5mY8v]RD\u0015n\u001d;pef\u0004Baa0\u0004L&!1QZBa\u0005Aqu\u000eZ3BG\u000e|WO\u001c;Ti\u0006$X\r\u0005\u0003\u0004R\u000eUWBABj\u0015\r\u0019\u0019mR\u0005\u0005\u0007/\u001c\u0019N\u0001\bO_\u0012,w+\u00197mKR\u0014\u0015m]3\u0011\t\r}61\\\u0005\u0005\u0007;\u001c\tMA\u000bO_\u0012,\u0017iY2pk:$X*Z7pef\u0004vn\u001c7\u0011\t\r}6\u0011]\u0005\u0005\u0007G\u001c\tMA\bBG\u000e|WO\u001c;O_\u0012,g+[3x\u0003Eqw\u000eZ3WS\u0016<\bK]8wS\u0012,'\u000fI\u0001\u0014O\u0016$hj\u001c3f-&,w\u000f\u0015:pm&$WM]\u0001\u001aiJ\fgn]1di&|gnU;c[&$\bK]8wS\u0012,'/\u0006\u0002\u0004nB111TBx\u0007KKAa!=\u0004\u001e\nIBK]1og\u0006\u001cG/[8o'V\u0014W.\u001b;Qe>4\u0018\u000eZ3s\u0003i!(/\u00198tC\u000e$\u0018n\u001c8Tk\nl\u0017\u000e\u001e)s_ZLG-\u001a:!\u0003q9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cVOY7jiB\u0013xN^5eKJ\u0004")
public class AccountSidechainApp
extends AbstractSidechainApp {
    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion;
    private AccountBlock genesisBlock;
    private Seq<ApiRoute> applicationApiRoutes;
    private Seq<ApiRoute> coreApiRoutes;
    @Named(value="CustomAccountTransactionSerializers")
    private HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers;
    @Named(value="CustomApiGroups")
    private java.util.List<AccountApplicationApiGroup> customApiGroups;
    private final String swaggerConfig;
    private final String dataDirAbsolutePath;
    private final File secretStore;
    private final File metaStateStore;
    private final File historyStore;
    private final File consensusStore;
    private final SidechainSecretStorage sidechainSecretStorage;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final LevelDBDatabase stateDbStorage;
    private final AccountHistoryStorage sidechainHistoryStorage;
    private final ConsensusDataStorage consensusDataStorage;
    private final ActorRef nodeViewHolderRef;
    private final ActorRef nodeViewSynchronizer;
    private final ActorRef sidechainBlockForgerActorRef;
    private final ActorRef sidechainTransactionActorRef;
    private final ActorRef sidechainBlockActorRef;
    private final ActorRef certificateSubmitterRef;
    private final ActorRef certificateSignaturesManagerRef;
    private final ActorRef syncStatusActorRef;
    private final RpcHandler rpcHandler;
    private final RpcProcessor rpcProcessor;
    private final NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider;
    private final TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider;
    private volatile byte bitmap$0;

    public String swaggerConfig() {
        return this.swaggerConfig;
    }

    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sidechainTransactionsCompanion = new SidechainAccountTransactionsCompanion(this.customAccountTransactionSerializers);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.customAccountTransactionSerializers = null;
        return this.sidechainTransactionsCompanion;
    }

    public SidechainAccountTransactionsCompanion sidechainTransactionsCompanion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sidechainTransactionsCompanion$lzycompute() : this.sidechainTransactionsCompanion;
    }

    private AccountBlock genesisBlock$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.genesisBlock = (AccountBlock)new AccountBlockSerializer(this.sidechainTransactionsCompanion()).parseBytes(BytesUtils.fromHexString(super.sidechainSettings().genesisData().scGenesisBlockHex()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.genesisBlock;
    }

    @Override
    public AccountBlock genesisBlock() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.genesisBlock$lzycompute() : this.genesisBlock;
    }

    public String dataDirAbsolutePath() {
        return this.dataDirAbsolutePath;
    }

    public File secretStore() {
        return this.secretStore;
    }

    public File metaStateStore() {
        return this.metaStateStore;
    }

    public File historyStore() {
        return this.historyStore;
    }

    public File consensusStore() {
        return this.consensusStore;
    }

    public SidechainSecretStorage sidechainSecretStorage() {
        return this.sidechainSecretStorage;
    }

    public AccountStateMetadataStorage stateMetadataStorage() {
        return this.stateMetadataStorage;
    }

    public LevelDBDatabase stateDbStorage() {
        return this.stateDbStorage;
    }

    public AccountHistoryStorage sidechainHistoryStorage() {
        return this.sidechainHistoryStorage;
    }

    public ConsensusDataStorage consensusDataStorage() {
        return this.consensusDataStorage;
    }

    public ActorRef nodeViewHolderRef() {
        return this.nodeViewHolderRef;
    }

    public Map<Object, SparkzSerializer<? extends NodeViewModifier>> modifierSerializers() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)SidechainBlockBase$.MODULE$.ModifierTypeId())), (Object)new AccountBlockSerializer(this.sidechainTransactionsCompanion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)Transaction$.MODULE$.ModifierTypeId())), (Object)this.sidechainTransactionsCompanion())}));
    }

    public ActorRef nodeViewSynchronizer() {
        return this.nodeViewSynchronizer;
    }

    public ActorRef sidechainBlockForgerActorRef() {
        return this.sidechainBlockForgerActorRef;
    }

    public ActorRef sidechainTransactionActorRef() {
        return this.sidechainTransactionActorRef;
    }

    public ActorRef sidechainBlockActorRef() {
        return this.sidechainBlockActorRef;
    }

    public ActorRef certificateSubmitterRef() {
        return this.certificateSubmitterRef;
    }

    public ActorRef certificateSignaturesManagerRef() {
        return this.certificateSignaturesManagerRef;
    }

    public ActorRef syncStatusActorRef() {
        return this.syncStatusActorRef;
    }

    public RpcHandler rpcHandler() {
        return this.rpcHandler;
    }

    public RpcProcessor rpcProcessor() {
        return this.rpcProcessor;
    }

    private Seq<ApiRoute> applicationApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.applicationApiRoutes = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.customApiGroups).asScala()).map((Function1 & Serializable & scala.Serializable)apiRoute -> new AccountApplicationApiRoute(this.settings().restApi(), (AccountApplicationApiGroup)apiRoute, this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem()), Buffer$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        this.customApiGroups = null;
        return this.applicationApiRoutes;
    }

    @Override
    public Seq<ApiRoute> applicationApiRoutes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.applicationApiRoutes$lzycompute() : this.applicationApiRoutes;
    }

    private Seq<ApiRoute> coreApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.coreApiRoutes = (Seq)new .colon.colon(new MainchainBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainBlockActorRef(), this.sidechainTransactionsCompanion(), this.sidechainBlockForgerActorRef(), this.params(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainNodeApiRoute(this.peerManagerRef(), this.networkControllerRef(), this.timeProvider(), this.settings().restApi(), this.nodeViewHolderRef(), this, this.params(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountTransactionApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainTransactionActorRef(), this.sidechainTransactionsCompanion(), this.params(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon((Object)new AccountWalletApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainSecretsCompanion(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainSubmitterApiRoute(this.settings().restApi(), this.params(), this.certificateSubmitterRef(), this.nodeViewHolderRef(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.Nothing()), (List)new .colon.colon((Object)new AccountEthRpcRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.rpcProcessor(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)Nil$.MODULE$)))))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.coreApiRoutes;
    }

    @Override
    public Seq<ApiRoute> coreApiRoutes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.coreApiRoutes$lzycompute() : this.coreApiRoutes;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider() {
        return this.nodeViewProvider;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> getNodeViewProvider() {
        return this.nodeViewProvider();
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider() {
        return this.transactionSubmitProvider;
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> getTransactionSubmitProvider() {
        return this.transactionSubmitProvider();
    }

    @Inject
    public AccountSidechainApp(@Named(value="SidechainSettings") SidechainSettings sidechainSettings, @Named(value="CustomSecretSerializers") HashMap<Byte, SecretSerializer<Secret>> customSecretSerializers, @Named(value="CustomAccountTransactionSerializers") HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers, @Named(value="CustomApiGroups") java.util.List<AccountApplicationApiGroup> customApiGroups, @Named(value="RejectedApiPaths") java.util.List<Pair<String, String>> rejectedApiPaths, @Named(value="CustomMessageProcessors") java.util.List<MessageProcessor> customMessageProcessors, @Named(value="ApplicationStopper") SidechainAppStopper applicationStopper, @Named(value="ForkConfiguration") ForkConfigurator forkConfigurator, @Named(value="ChainInfo") ChainInfo chainInfo, @Named(value="ConsensusSecondsInSlot") int secondsInSlot) {
        ActorRef actorRef;
        this.customAccountTransactionSerializers = customAccountTransactionSerializers;
        this.customApiGroups = customApiGroups;
        super(sidechainSettings, customSecretSerializers, rejectedApiPaths, applicationStopper, forkConfigurator, chainInfo, secondsInSlot);
        this.swaggerConfig = Source$.MODULE$.fromResource("account/api/accountApi.yaml", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.UTF8()).getLines().mkString("\n");
        Predef$.MODULE$.require(!this.isCSWEnabled(), (Function0 & Serializable & scala.Serializable)() -> "Ceased Sidechain Withdrawal (CSW) should not be enabled in AccountSidechainApp!");
        this.dataDirAbsolutePath = super.sidechainSettings().sparkzSettings().dataDir().getAbsolutePath();
        this.secretStore = new File(new StringBuilder(7).append(this.dataDirAbsolutePath()).append("/secret").toString());
        this.metaStateStore = new File(new StringBuilder(6).append(this.dataDirAbsolutePath()).append("/state").toString());
        this.historyStore = new File(new StringBuilder(8).append(this.dataDirAbsolutePath()).append("/history").toString());
        this.consensusStore = new File(new StringBuilder(14).append(this.dataDirAbsolutePath()).append("/consensusData").toString());
        this.sidechainSecretStorage = new SidechainSecretStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.secretStore())), this.sidechainSecretsCompanion());
        this.stateMetadataStorage = new AccountStateMetadataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.metaStateStore())));
        this.stateDbStorage = this.registerClosableResource(new LevelDBDatabase(new StringBuilder(10).append(this.dataDirAbsolutePath()).append("/evm-state").toString()));
        this.sidechainHistoryStorage = new AccountHistoryStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.historyStore())), this.sidechainTransactionsCompanion(), this.params());
        this.consensusDataStorage = new ConsensusDataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.consensusStore())));
        if (this.sidechainSecretStorage().isEmpty()) {
            super.sidechainSettings().wallet().genesisSecrets().foreach((Function1 & Serializable & scala.Serializable)secretHex -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretHex))));
            super.sidechainSettings().withdrawalEpochCertificateSettings().signersSecrets().foreach((Function1 & Serializable & scala.Serializable)secretSchnorr -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretSchnorr))));
        }
        this.nodeViewHolderRef = AccountNodeViewHolderRef$.MODULE$.apply(super.sidechainSettings(), this.sidechainHistoryStorage(), this.consensusDataStorage(), this.stateMetadataStorage(), (Database)this.stateDbStorage(), (Seq<MessageProcessor>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(customMessageProcessors).asScala()), this.sidechainSecretStorage(), this.params(), this.timeProvider(), this.genesisBlock(), this.actorSystem());
        this.nodeViewSynchronizer = this.actorSystem().actorOf(AccountNodeViewSynchronizer$.MODULE$.props(this.networkControllerRef(), this.nodeViewHolderRef(), SidechainSyncInfoMessageSpec$.MODULE$, this.settings().network(), this.timeProvider(), this.modifierSerializers(), this.executionContext()));
        this.sidechainBlockForgerActorRef = AccountForgerRef$.MODULE$.apply("AccountForger", super.sidechainSettings(), this.nodeViewHolderRef(), this.mainchainSynchronizer(), this.sidechainTransactionsCompanion(), this.timeProvider(), this.params(), this.actorSystem());
        if (super.sidechainSettings().apiRateLimiter().enabled()) {
            ActorRef rateLimiterActorRef = SidechainTransactionRateLimiterActorRef$.MODULE$.apply(this.nodeViewHolderRef(), super.sidechainSettings().apiRateLimiter(), this.actorSystem(), this.executionContext());
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(rateLimiterActorRef, this.actorSystem(), this.executionContext());
        } else {
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(this.nodeViewHolderRef(), this.actorSystem(), this.executionContext());
        }
        this.sidechainTransactionActorRef = actorRef;
        this.sidechainBlockActorRef = SidechainBlockActorRef$.MODULE$.apply("AccountBlock", super.sidechainSettings(), this.sidechainBlockForgerActorRef(), ClassTag$.MODULE$.apply(AccountBlock.class), ClassTag$.MODULE$.apply(AccountHistory.class), this.actorSystem(), this.executionContext());
        this.certificateSubmitterRef = AccountCertificateSubmitterRef$.MODULE$.apply(super.sidechainSettings(), this.nodeViewHolderRef(), this.secureEnclaveApiClient(), this.params(), this.mainchainNodeChannel(), this.actorSystem(), this.executionContext());
        this.certificateSignaturesManagerRef = CertificateSignaturesManagerRef$.MODULE$.apply(this.networkControllerRef(), this.certificateSubmitterRef(), this.params(), super.sidechainSettings().sparkzSettings().network(), this.actorSystem(), this.executionContext());
        this.syncStatusActorRef = SyncStatusActorRef$.MODULE$.apply("SyncStatus", super.sidechainSettings(), this.nodeViewHolderRef(), this.params(), this.timeProvider(), this.actorSystem(), this.executionContext());
        this.rpcHandler = new RpcHandler(new EthService(this.nodeViewHolderRef(), this.networkControllerRef(), this.settings().restApi().timeout(), this.params(), super.sidechainSettings().ethService(), super.sidechainSettings().sparkzSettings().network().maxIncomingConnections(), RpcUtils$.MODULE$.getClientVersion(), this.sidechainTransactionActorRef(), this.syncStatusActorRef(), this.sidechainTransactionsCompanion()));
        this.rpcProcessor = new RpcProcessor(this.rpcHandler());
        if (super.sidechainSettings().websocketServer().wsServer()) {
            ActorRef webSocketServerActor = WebSocketAccountServerRef$.MODULE$.apply(this.nodeViewHolderRef(), this.rpcProcessor(), super.sidechainSettings().websocketServer(), this.actorSystem(), this.executionContext());
        }
        this.nodeViewProvider = new NodeViewProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView>(this.nodeViewHolderRef());
        this.actorSystem().eventStream().publish((Object)SidechainAppEvents$SidechainApplicationStart$.MODULE$);
        this.transactionSubmitProvider = new TransactionSubmitProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>>(this.sidechainTransactionActorRef());
    }
}

