/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import io.horizen.AbstractSidechainApp;
import io.horizen.ChainInfo;
import io.horizen.SidechainAppStopper;
import io.horizen.SidechainSettings;
import io.horizen.account.AccountSidechainApp;
import io.horizen.account.api.http.AccountApplicationApiGroup;
import io.horizen.account.helper.AccountNodeViewHelper;
import io.horizen.account.helper.AccountNodeViewHelperImpl;
import io.horizen.account.helper.AccountTransactionSubmitHelper;
import io.horizen.account.helper.AccountTransactionSubmitHelperImpl;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.fork.ForkConfigurator;
import io.horizen.helper.SecretSubmitHelper;
import io.horizen.helper.SecretSubmitHelperImpl;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.Pair;
import java.util.HashMap;
import java.util.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!\u0002\u0005\n\u0003\u0003\u0001\u0002\"B\u000e\u0001\t\u0003a\u0002bB\u0010\u0001\u0001\u0004%\t\u0001\t\u0005\bI\u0001\u0001\r\u0011\"\u0001&\u0011\u0019q\u0003\u0001)Q\u0005C!)q\u0006\u0001C!a!)\u0011\u0007\u0001D\u0001a!)!\u0007\u0001C\u0001g\t\u0001\u0012iY2pk:$\u0018\t\u001d9N_\u0012,H.\u001a\u0006\u0003\u0015-\tq!Y2d_VtGO\u0003\u0002\r\u001b\u00059\u0001n\u001c:ju\u0016t'\"\u0001\b\u0002\u0005%|7\u0001A\n\u0003\u0001E\u0001\"AE\r\u000e\u0003MQ!\u0001F\u000b\u0002\r%t'.Z2u\u0015\t1r#\u0001\u0004h_><G.\u001a\u0006\u00021\u0005\u00191m\\7\n\u0005i\u0019\"AD!cgR\u0014\u0018m\u0019;N_\u0012,H.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003%\t1!\u00199q+\u0005\t\u0003C\u0001\u0010#\u0013\t\u0019\u0013BA\nBG\u000e|WO\u001c;TS\u0012,7\r[1j]\u0006\u0003\b/A\u0004baB|F%Z9\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDq!L\u0002\u0002\u0002\u0003\u0007\u0011%A\u0002yIE\nA!\u00199qA\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0002M\u0005a1m\u001c8gS\u001e,(/Z!qa\u0006\u0019q-\u001a;\u0015#\u0005\"D\tY?\u0002\u001c\u0005%\u0013\u0011LA9\u0003\u0003\u000b9\nC\u00036\u000f\u0001\u0007a'A\ttS\u0012,7\r[1j]N+G\u000f^5oON\u0004\"a\u000e\u001d\u000e\u0003-I!!O\u0006\u0003#MKG-Z2iC&t7+\u001a;uS:<7\u000f\u000b\u00035w\u0005\u0013\u0005C\u0001\u001f@\u001b\u0005i$B\u0001 \u0014\u0003\u0011q\u0017-\\3\n\u0005\u0001k$!\u0002(b[\u0016$\u0017!\u0002<bYV,\u0017%A\"\u0002#MKG-Z2iC&t7+\u001a;uS:<7\u000fC\u0003F\u000f\u0001\u0007a)A\fdkN$x.\\*fGJ,GoU3sS\u0006d\u0017N_3sgB!q\t\u0014(U\u001b\u0005A%BA%K\u0003\u0011)H/\u001b7\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\b\u0011\u0006\u001c\b.T1q!\ty%+D\u0001Q\u0015\t\t&*\u0001\u0003mC:<\u0017BA*Q\u0005\u0011\u0011\u0015\u0010^3\u0011\u0007UC&,D\u0001W\u0015\t96\"\u0001\u0004tK\u000e\u0014X\r^\u0005\u00033Z\u0013\u0001cU3de\u0016$8+\u001a:jC2L'0\u001a:\u0011\u0005U[\u0016B\u0001/W\u0005\u0019\u0019Vm\u0019:fi\"\"AiO!_C\u0005y\u0016aF\"vgR|WnU3de\u0016$8+\u001a:jC2L'0\u001a:t\u0011\u0015\tw\u00011\u0001c\u0003\r\u001aWo\u001d;p[\u0006\u001b7m\\;oiR\u0013\u0018M\\:bGRLwN\\*fe&\fG.\u001b>feN\u0004Ba\u0012'OGB\u0019AmZ5\u000e\u0003\u0015T!AZ\u0006\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003Q\u0016\u0014Q\u0003\u0016:b]N\f7\r^5p]N+'/[1mSj,'\u000f\u0005\u0003kY:$X\"A6\u000b\u0005\u0019L\u0011BA7l\u0005I\t5mY8v]R$&/\u00198tC\u000e$\u0018n\u001c8\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\\\u0011a\u00039s_B|7/\u001b;j_:L!a\u001d9\u0003\u0017A\u0013x\u000e]8tSRLwN\u001c\t\u0004kbtW\"\u0001<\u000b\u0005]\\\u0011!\u00029s_>4\u0017BA=w\u0005\u0015\u0001&o\\8gQ\u0011\u00017(Q>\"\u0003q\f1eQ;ti>l\u0017iY2pk:$HK]1og\u0006\u001cG/[8o'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000fC\u0003\u007f\u000f\u0001\u0007q0A\bdkN$x.\\!qS\u001e\u0013x.\u001e9t!\u00159\u0015\u0011AA\u0003\u0013\r\t\u0019\u0001\u0013\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t!$H\u000f\u001d\u0006\u0004\u0003\u001fI\u0011aA1qS&!\u00111CA\u0005\u0005i\t5mY8v]R\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ba&<%o\\;qQ\u0015i8(QA\fC\t\tI\"A\bDkN$x.\\!qS\u001e\u0013x.\u001e9t\u0011\u001d\tib\u0002a\u0001\u0003?\t\u0001C]3kK\u000e$X\rZ!qSB\u000bG\u000f[:\u0011\u000b\u001d\u000b\t!!\t\u0011\u0011\u0005\r\u0012\u0011FA\u0017\u0003[i!!!\n\u000b\u0007\u0005\u001d2\"A\u0003vi&d7/\u0003\u0003\u0002,\u0005\u0015\"\u0001\u0002)bSJ\u0004B!a\f\u0002>9!\u0011\u0011GA\u001d!\r\t\u0019\u0004K\u0007\u0003\u0003kQ1!a\u000e\u0010\u0003\u0019a$o\\8u}%\u0019\u00111\b\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tY\u0004\u000b\u0015\u0007\u00037Y\u0014)!\u0012\"\u0005\u0005\u001d\u0013\u0001\u0005*fU\u0016\u001cG/\u001a3Ba&\u0004\u0016\r\u001e5t\u0011\u001d\tYe\u0002a\u0001\u0003\u001b\n\u0011b\u00195bS:LeNZ8\u0011\u0007]\ny%C\u0002\u0002R-\u0011\u0011b\u00115bS:LeNZ8)\r\u0005%3(QA+C\t\t9&A\u0005DQ\u0006Lg.\u00138g_\"9\u00111L\u0004A\u0002\u0005u\u0013aF2vgR|W.T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:t!\u00159\u0015\u0011AA0!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3\u0013\u0005)1\u000f^1uK&!\u0011\u0011NA2\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'\u000f\u000b\u0004\u0002Zm\n\u0015QN\u0011\u0003\u0003_\nqcQ;ti>lW*Z:tC\u001e,\u0007K]8dKN\u001cxN]:\t\u000f\u0005Mt\u00011\u0001\u0002v\u0005\u0011\u0012\r\u001d9mS\u000e\fG/[8o'R|\u0007\u000f]3s!\r9\u0014qO\u0005\u0004\u0003sZ!aE*jI\u0016\u001c\u0007.Y5o\u0003B\u00048\u000b^8qa\u0016\u0014\bFBA9w\u0005\u000bi(\t\u0002\u0002\u0000\u0005\u0011\u0012\t\u001d9mS\u000e\fG/[8o'R|\u0007\u000f]3s\u0011\u001d\t\u0019i\u0002a\u0001\u0003\u000b\u000b\u0001CZ8sW\u000e{gNZ5hkJ\fGo\u001c:\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#\f\u0003\u00111wN]6\n\t\u0005=\u0015\u0011\u0012\u0002\u0011\r>\u00148nQ8oM&<WO]1u_JDc!!!<\u0003\u0006M\u0015EAAK\u0003E1uN]6D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u00033;\u0001\u0019AAN\u00035\u0019XmY8oINLen\u00157piB\u0019q%!(\n\u0007\u0005}\u0005FA\u0002J]RDc!a&<\u0003\u0006\r\u0016EAAS\u0003Y\u0019uN\\:f]N,8oU3d_:$7/\u00138TY>$\bfA\u0004\u0002*B\u0019!#a+\n\u0007\u000556C\u0001\u0005Qe>4\u0018\u000eZ3t\u0001")
public abstract class AccountAppModule
extends AbstractModule {
    private AccountSidechainApp app = null;

    public AccountSidechainApp app() {
        return this.app;
    }

    public void app_$eq(AccountSidechainApp x$1) {
        this.app = x$1;
    }

    public void configure() {
        this.bind(AccountTransactionSubmitHelper.class).to(AccountTransactionSubmitHelperImpl.class);
        this.bind(AbstractSidechainApp.class).to(AccountSidechainApp.class);
        this.bind(AccountNodeViewHelper.class).to(AccountNodeViewHelperImpl.class);
        this.bind(SecretSubmitHelper.class).to(SecretSubmitHelperImpl.class);
        this.configureApp();
    }

    public abstract void configureApp();

    @Provides
    public AccountSidechainApp get(@Named(value="SidechainSettings") SidechainSettings sidechainSettings, @Named(value="CustomSecretSerializers") HashMap<Byte, SecretSerializer<Secret>> customSecretSerializers, @Named(value="CustomAccountTransactionSerializers") HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers, @Named(value="CustomApiGroups") List<AccountApplicationApiGroup> customApiGroups, @Named(value="RejectedApiPaths") List<Pair<String, String>> rejectedApiPaths, @Named(value="ChainInfo") ChainInfo chainInfo, @Named(value="CustomMessageProcessors") List<MessageProcessor> customMessageProcessors, @Named(value="ApplicationStopper") SidechainAppStopper applicationStopper, @Named(value="ForkConfiguration") ForkConfigurator forkConfigurator, @Named(value="ConsensusSecondsInSlot") int secondsInSlot) {
        AccountAppModule accountAppModule = this;
        synchronized (accountAppModule) {
            if (this.app() == null) {
                this.app_$eq(new AccountSidechainApp(sidechainSettings, customSecretSerializers, customAccountTransactionSerializers, customApiGroups, rejectedApiPaths, customMessageProcessors, applicationStopper, forkConfigurator, chainInfo, secondsInSlot));
            }
        }
        return this.app();
    }
}

