/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.server;

import akka.actor.ActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.horizen.SidechainHistory;
import com.horizen.SidechainMemoryPool;
import com.horizen.SidechainState;
import com.horizen.SidechainSyncInfo;
import com.horizen.SidechainWallet;
import com.horizen.block.SidechainBlock;
import com.horizen.chain.FeePaymentsInfo;
import com.horizen.serialization.SerializationUtil;
import com.horizen.websocket.server.SidechainNodeChannel;
import com.horizen.websocket.server.WebSocketServerRef$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;
import scorex.util.package;
import sparkz.core.NodeViewHolder;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001\u0002\n\u0014\u0001qAQa\f\u0001\u0005\u0002ABqA\r\u0001C\u0002\u0013\r1\u0007\u0003\u0004<\u0001\u0001\u0006I\u0001\u000e\u0005\by\u0001\u0011\r\u0011b\u0001>\u0011\u0019!\u0005\u0001)A\u0005}!9Q\t\u0001b\u0001\n\u00131\u0005BB)\u0001A\u0003%q)\u0002\u0003S\u0001\u0001\u0019\u0006\"\u0002:\u0001\t\u0003\u0019\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005U\u0004\u0001\"\u0011\u0002t!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBAE\u0001\u0011%\u00111\u0012\u0002\u0019'&$Wm\u00195bS:tu\u000eZ3DQ\u0006tg.\u001a7J[Bd'B\u0001\u000b\u0016\u0003\u0019\u0019XM\u001d<fe*\u0011acF\u0001\no\u0016\u00147o\\2lKRT!\u0001G\r\u0002\u000f!|'/\u001b>f]*\t!$A\u0002d_6\u001c\u0001a\u0005\u0003\u0001;\r:\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%K5\t1#\u0003\u0002''\t!2+\u001b3fG\"\f\u0017N\u001c(pI\u0016\u001c\u0005.\u00198oK2\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u000511oY8sKbL!AL\u0015\u0003\u001bM\u001bwN]3y\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u0002%\u0001\u0005AA-\u001e:bi&|g.F\u00015!\t)\u0014(D\u00017\u0015\tQsGC\u00019\u0003\u0011\t7n[1\n\u0005i2$a\u0002+j[\u0016|W\u000f^\u0001\nIV\u0014\u0018\r^5p]\u0002\n!!Z2\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!Q\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002D\u0001\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004K\u000e\u0004\u0013AB7baB,'/F\u0001H!\tAu*D\u0001J\u0015\tQ5*\u0001\u0005eCR\f'-\u001b8e\u0015\taU*A\u0004kC\u000e\\7o\u001c8\u000b\u00059K\u0012!\u00034bgR,'\u000f_7m\u0013\t\u0001\u0016J\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0003\tYKWm\u001e\t\u0007)\n,\u0017\u000e\\8\u000f\u0005U{fB\u0001,]\u001d\t9&,D\u0001Y\u0015\tI6$\u0001\u0004=e>|GOP\u0005\u00027\u000611\u000f]1sWjL!!\u00180\u0002\t\r|'/\u001a\u0006\u00027&\u0011\u0001-Y\u0001\u000f\u001d>$WMV5fo\"{G\u000eZ3s\u0015\tif,\u0003\u0002dI\nY1)\u001e:sK:$h+[3x\u0015\t\u0001\u0017\r\u0005\u0002gO6\tq#\u0003\u0002i/\t\u00012+\u001b3fG\"\f\u0017N\u001c%jgR|'/\u001f\t\u0003M*L!a[\f\u0003\u001dMKG-Z2iC&t7\u000b^1uKB\u0011a-\\\u0005\u0003]^\u0011qbU5eK\u000eD\u0017-\u001b8XC2dW\r\u001e\t\u0003MBL!!]\f\u0003'MKG-Z2iC&tW*Z7pef\u0004vn\u001c7\u0002\u001f\u0005\u0004\b\u000f\\=P]:{G-\u001a,jK^,\"\u0001^<\u0015\u0007U\f\t\u0001\u0005\u0002wo2\u0001A!\u0002=\n\u0005\u0004I(!\u0001*\u0012\u0005il\bC\u0001\u0010|\u0013\taxDA\u0004O_RD\u0017N\\4\u0011\u0005yq\u0018BA@ \u0005\r\te.\u001f\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0003M1WO\\2uS>tGk\u001c\"f\u0003B\u0004H.[3e!\u0019q\u0012qAA\u0006k&\u0019\u0011\u0011B\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cAA\u0007\u00115\t\u0001!\u0001\u000bhKR\u0014En\\2l\u0013:4wNQ=IK&<\u0007\u000e\u001e\u000b\u0005\u0003'\tI\u0003\u0005\u0004\u0002\u0016\u0005e\u0011QD\u0007\u0003\u0003/Q!AK\u0010\n\t\u0005m\u0011q\u0003\u0002\u0004)JL\b\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0012*\u0001\u0003o_\u0012,\u0017\u0002BA\u0014\u0003C\u0011!b\u00142kK\u000e$hj\u001c3f\u0011\u001d\tYC\u0003a\u0001\u0003[\ta\u0001[3jO\"$\bc\u0001\u0010\u00020%\u0019\u0011\u0011G\u0010\u0003\u0007%sG/\u0001\nhKR\u0014En\\2l\u0013:4wNQ=ICNDG\u0003BA\n\u0003oAq!!\u000f\f\u0001\u0004\tY$\u0001\u0003iCND\u0007\u0003BA\u001f\u0003\u000brA!a\u0010\u0002BA\u0011qkH\u0005\u0004\u0003\u0007z\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0005%#AB*ue&twMC\u0002\u0002D}\t\u0011cZ3u\u001d\u0016<(\t\\8dW\"\u000b7\u000f[3t)\u0019\t\u0019\"a\u0014\u0002f!9\u0011\u0011\u000b\u0007A\u0002\u0005M\u0013!\u00047pG\u0006$xN\u001d%bg\",7\u000f\u0005\u0004\u0002V\u0005}\u00131\b\b\u0005\u0003/\nYFD\u0002X\u00033J\u0011\u0001I\u0005\u0004\u0003;z\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003C\n\u0019GA\u0002TKFT1!!\u0018 \u0011\u001d\t9\u0007\u0004a\u0001\u0003[\tQ\u0001\\5nSR\fQbZ3u\u001b\u0016l\u0007o\\8m)b\u001cH\u0003BA\n\u0003[Bq!a\u001c\u000e\u0001\u0004\t\u0019&A\u0003uq&$7/A\u0007hKR\u0014\u0016m^'f[B|w\u000e\u001c\u000b\u0003\u0003'\t\u0001cZ3u\u0005\u0016\u001cHO\u00117pG.LeNZ8\u0002\u0019\u001d,GO\u00117pG.LeNZ8\u0015\t\u0005M\u00111\u0010\u0005\b\u0003{\u0002\u0002\u0019AA@\u0003\u0015\u0011Gn\\2l!\u0011\t\t)!\"\u000e\u0005\u0005\r%bAA?/%!\u0011qQAB\u00059\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.\fQcY1mGVd\u0017\r^3CY>\u001c7\u000eU1zY>\fG\r\u0006\u0005\u0002\u001e\u00055\u0015qRAI\u0011\u001d\ti(\u0005a\u0001\u0003\u007fBq!a\u000b\u0012\u0001\u0004\ti\u0003C\u0004\u0002\u0014F\u0001\r!!&\u0002%\u0019,W\rU1z[\u0016tGo]%oM>|\u0005\u000f\u001e\t\u0006=\u0005]\u00151T\u0005\u0004\u00033{\"AB(qi&|g\u000e\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\r\t\tkF\u0001\u0006G\"\f\u0017N\\\u0005\u0005\u0003K\u000byJA\bGK\u0016\u0004\u0016-_7f]R\u001c\u0018J\u001c4p\u0001")
public class SidechainNodeChannelImpl
implements SidechainNodeChannel,
ScorexLogging {
    private final Timeout duration;
    private final ExecutionContext ec;
    private final ObjectMapper mapper;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Timeout duration() {
        return this.duration;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public <R> R applyOnNodeView(Function1<NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool>, R> functionToBeApplied) {
        Object object;
        try {
            Object result;
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(WebSocketServerRef$.MODULE$.sidechainNodeViewHolderRef());
            NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView x$1 = new NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView(functionToBeApplied);
            Timeout x$2 = this.duration();
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            Future res = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3);
            object = result = Await$.MODULE$.result((Awaitable)res, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5000)).millis());
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return (R)object;
    }

    @Override
    public Try<ObjectNode> getBlockInfoByHeight(int height) {
        return ((Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> sidechainBlockHash = ((SidechainHistory)sidechainNodeView.history()).blockIdByHeight(height);
            if (sidechainBlockHash.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(28).append("Block not found for height: ").append(height).toString());
            }
            String blockId = (String)package.ModifierId$.MODULE$.$at$at(sidechainBlockHash.get(), package.Tagger$.MODULE$.baseRaw());
            Option<SidechainBlock> sblockOpt = ((SidechainHistory)sidechainNodeView.history()).modifierById(blockId);
            if (sblockOpt.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(26).append("Block not found for hash: ").append(sidechainBlockHash).toString());
            }
            Option<FeePaymentsInfo> feePaymentsInfoOpt = ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(blockId);
            return new Tuple2(sblockOpt.get(), feePaymentsInfoOpt);
        }))).map((Function1 & Serializable & scala.Serializable)blockInfo -> this.calculateBlockPayload((SidechainBlock)blockInfo._1(), height, (Option<FeePaymentsInfo>)((Option)blockInfo._2())));
    }

    @Override
    public Try<ObjectNode> getBlockInfoByHash(String hash) {
        return ((Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String blockId = (String)package.ModifierId$.MODULE$.$at$at((Object)hash, package.Tagger$.MODULE$.baseRaw());
            Option<SidechainBlock> blockOpt = ((SidechainHistory)sidechainNodeView.history()).modifierById(blockId);
            if (blockOpt.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(26).append("Block not found for hash: ").append(hash).toString());
            }
            int height = ((SidechainHistory)sidechainNodeView.history()).blockInfoById(blockId).height();
            Option<FeePaymentsInfo> feePaymentsInfoOpt = ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(blockId);
            return new Tuple3(blockOpt.get(), (Object)BoxesRunTime.boxToInteger((int)height), feePaymentsInfoOpt);
        }))).map((Function1 & Serializable & scala.Serializable)blockInfo -> this.calculateBlockPayload((SidechainBlock)blockInfo._1(), BoxesRunTime.unboxToInt((Object)blockInfo._2()), (Option<FeePaymentsInfo>)((Option)blockInfo._3())));
    }

    @Override
    public Try<ObjectNode> getNewBlockHashes(Seq<String> locatorHashes, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            IntRef lastHeight = IntRef.create((int)-1);
            ObjectNode responsePayload = this.mapper().createObjectNode();
            SidechainSyncInfo scInfo = new SidechainSyncInfo(locatorHashes);
            Seq headerList = (Seq)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Seq<Tuple2<Object, String>> headers;
                block0: {
                    headers = ((SidechainHistory)sidechainNodeView.history()).continuationIds(scInfo, limit);
                    if (!headers.nonEmpty()) break block0;
                    lastHeight$1.elem = ((SidechainHistory)sidechainNodeView.history()).blockInfoById((String)((Tuple2)headers.last())._2()).height();
                }
                return headers;
            });
            JsonNode hashes = this.mapper().readTree(SerializationUtil.serialize(headerList.map((Function1 & Serializable & scala.Serializable)el -> (String)el._2(), Seq$.MODULE$.canBuildFrom())));
            responsePayload.put("height", lastHeight.elem);
            responsePayload.set("hashes", hashes);
            return responsePayload;
        });
    }

    @Override
    public Try<ObjectNode> getMempoolTxs(Seq<String> txids) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            ObjectNode responsePayload = this.mapper().createObjectNode();
            Seq txs = (Seq)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> ((SidechainMemoryPool)sidechainNodeView.pool()).getAll(txids));
            JsonNode txsJson = this.mapper().readTree(SerializationUtil.serialize(txs));
            responsePayload.set("transactions", txsJson);
            return var2_2;
        });
    }

    @Override
    public Try<ObjectNode> getRawMempool() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            ObjectNode responsePayload = this.mapper().createObjectNode();
            ArrayList txids = (ArrayList)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                void var1_1;
                ArrayList txs = new ArrayList();
                ((SidechainMemoryPool)sidechainNodeView.pool()).take(((SidechainMemoryPool)sidechainNodeView.pool()).size()).foreach((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)txs.add(tx.id())));
                return var1_1;
            });
            JsonNode json = this.mapper().readTree(SerializationUtil.serialize(txids.toArray()));
            responsePayload.set("transactions", json);
            responsePayload.put("size", txids.size());
            return var1_1;
        });
    }

    @Override
    public Try<ObjectNode> getBestBlockInfo() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int n;
            SidechainBlock sidechainBlock;
            Option feePaymentsInfoOpt;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = (Tuple3)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                        SidechainBlock bBlock = ((SidechainHistory)sidechainNodeView.history()).bestBlock();
                        int height = ((SidechainHistory)sidechainNodeView.history()).height();
                        Option<FeePaymentsInfo> feePaymentsInfoOpt = ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(bBlock.id());
                        return new Tuple3((Object)bBlock, (Object)BoxesRunTime.boxToInteger((int)height), feePaymentsInfoOpt);
                    });
                    if (tuple3 == null) break block2;
                    SidechainBlock bestBlock = (SidechainBlock)tuple3._1();
                    int height = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    feePaymentsInfoOpt = (Option)tuple3._3();
                    if (bestBlock == null) break block2;
                    sidechainBlock = bestBlock;
                    n = height;
                    if (feePaymentsInfoOpt != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Option option = feePaymentsInfoOpt;
            Tuple3 tuple3 = new Tuple3((Object)sidechainBlock, (Object)BoxesRunTime.boxToInteger((int)n), (Object)option);
            Tuple3 tuple32 = tuple3;
            SidechainBlock bestBlock = (SidechainBlock)tuple32._1();
            int height = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option feePaymentsInfoOpt2 = (Option)tuple32._3();
            return this.calculateBlockPayload(bestBlock, height, (Option<FeePaymentsInfo>)feePaymentsInfoOpt2);
        });
    }

    @Override
    public Try<ObjectNode> getBlockInfo(SidechainBlock block) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int n;
            Option feePaymentsInfoOpt;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = (Tuple2)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)((SidechainHistory)sidechainNodeView.history()).blockInfoById(block.id()).height()), ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(block.id())));
                    if (tuple2 == null) break block2;
                    int height = tuple2._1$mcI$sp();
                    feePaymentsInfoOpt = (Option)tuple2._2();
                    n = height;
                    if (feePaymentsInfoOpt != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Option option = feePaymentsInfoOpt;
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)n), (Object)option);
            Tuple2 tuple22 = tuple2;
            int height = tuple22._1$mcI$sp();
            Option feePaymentsInfoOpt2 = (Option)tuple22._2();
            return this.calculateBlockPayload(block, height, (Option<FeePaymentsInfo>)feePaymentsInfoOpt2);
        });
    }

    private ObjectNode calculateBlockPayload(SidechainBlock block, int height, Option<FeePaymentsInfo> feePaymentsInfoOpt) {
        ObjectNode eventPayload = this.mapper().createObjectNode();
        JsonNode blockJson = this.mapper().readTree(SerializationUtil.serialize(block));
        eventPayload.put("height", height);
        eventPayload.put("hash", block.id());
        eventPayload.set("block", blockJson);
        feePaymentsInfoOpt.foreach((Function1 & Serializable & scala.Serializable)feePaymentsInfo -> {
            JsonNode feePaymentsTxJson = this.mapper().readTree(SerializationUtil.serialize(feePaymentsInfo.transaction()));
            return (ObjectNode)eventPayload.set("feePayments", feePaymentsTxJson);
        });
        return eventPayload;
    }

    public SidechainNodeChannelImpl() {
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.duration = Timeout$.MODULE$.durationToTimeout(new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds());
        this.ec = ExecutionContext.Implicits$.MODULE$.global();
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

