/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.validation;

import com.horizen.SidechainHistory;
import com.horizen.block.Ommer;
import com.horizen.block.OmmersContainer;
import com.horizen.block.SidechainBlock;
import com.horizen.block.SidechainBlockHeader;
import com.horizen.chain.SidechainBlockInfo;
import com.horizen.consensus.ConsensusEpochAndSlot;
import com.horizen.consensus.FullConsensusEpochInfo;
import com.horizen.consensus.NonceConsensusEpochInfo;
import com.horizen.consensus.StakeConsensusEpochInfo;
import com.horizen.consensus.package$;
import com.horizen.fork.ForkManager$;
import com.horizen.params.NetworkParams;
import com.horizen.utils.TimeToEpochUtils$;
import com.horizen.validation.HistoryBlockValidator;
import com.horizen.validation.SidechainBlockSlotInFutureException;
import com.horizen.validation.SidechainBlockSlotInFutureException$;
import com.horizen.vrf.VrfOutput;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;
import sparkz.core.utils.TimeProvider;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001\u0002\u0006\f\u0001IA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006a\u0001!\t!\r\u0005\u0006i\u0001!\t%\u000e\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u0006\u001f\u0002!I\u0001\u0015\u0005\u0006)\u0002!I!\u0016\u0005\u0006U\u0002!Ia\u001b\u0005\u0007]\u0002!\t!D8\t\u0011\u0005U\u0004\u0001\"\u0001\u000e\u0003o\u0012!cQ8og\u0016t7/^:WC2LG-\u0019;pe*\u0011A\"D\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001\b\u0010\u0003\u001dAwN]5{K:T\u0011\u0001E\u0001\u0004G>l7\u0001A\n\u0005\u0001MIR\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035mi\u0011aC\u0005\u00039-\u0011Q\u0003S5ti>\u0014\u0018P\u00117pG.4\u0016\r\\5eCR|'\u000f\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!Q\u000f^5m\u0015\u0005\u0011\u0013AB:d_J,\u00070\u0003\u0002%?\ti1kY8sKbdunZ4j]\u001e\fA\u0002^5nKB\u0013xN^5eKJ\u0004\"a\n\u0018\u000e\u0003!R!!\u000b\u0016\u0002\u000bU$\u0018\u000e\\:\u000b\u0005-b\u0013\u0001B2pe\u0016T\u0011!L\u0001\u0007gB\f'o\u001b>\n\u0005=B#\u0001\u0004+j[\u0016\u0004&o\u001c<jI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00023gA\u0011!\u0004\u0001\u0005\u0006K\t\u0001\rAJ\u0001\tm\u0006d\u0017\u000eZ1uKR\u0019aGP#\u0011\u0007]J4(D\u00019\u0015\t\u0001S#\u0003\u0002;q\t\u0019AK]=\u0011\u0005Qa\u0014BA\u001f\u0016\u0005\u0011)f.\u001b;\t\u000b}\u001a\u0001\u0019\u0001!\u0002\u000b\tdwnY6\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005}j\u0011B\u0001#C\u00059\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.DQAR\u0002A\u0002\u001d\u000bq\u0001[5ti>\u0014\u0018\u0010\u0005\u0002I\u00136\tQ\"\u0003\u0002K\u001b\t\u00012+\u001b3fG\"\f\u0017N\u001c%jgR|'/_\u0001\u0015m\u0006d\u0017\u000eZ1uK\u001e+g.Z:jg\ncwnY6\u0015\u0007mje\nC\u0003@\t\u0001\u0007\u0001\tC\u0003G\t\u0001\u0007q)A\fwC2LG-\u0019;f\u001d>tw)\u001a8fg&\u001c(\t\\8dWR\u00191(U*\t\u000bI+\u0001\u0019\u0001!\u0002\u001bY,'/\u001b4jK\u0012\u0014En\\2l\u0011\u00151U\u00011\u0001H\u0003=1XM]5gsRKW.Z:uC6\u0004H\u0003B\u001eWC\u000eDQa\u0016\u0004A\u0002a\u000baC^3sS\u001aLW\r\u001a\"m_\u000e\\G+[7fgR\fW\u000e\u001d\t\u00033zs!A\u0017/\u000e\u0003mS!a\u0010\u0016\n\u0005u[\u0016!\u0002\"m_\u000e\\\u0017BA0a\u0005%!\u0016.\\3ti\u0006l\u0007O\u0003\u0002^7\")!M\u0002a\u00011\u0006!\u0002/\u0019:f]R\u0014En\\2l)&lWm\u001d;b[BDQ\u0001\u001a\u0004A\u0002\u0015\fa\u0001]1sC6\u001c\bC\u00014i\u001b\u00059'B\u00013\u000e\u0013\tIwMA\u0007OKR<xN]6QCJ\fWn]\u0001\u0018m\u0016\u0014\u0018NZ=US6,7\u000f^1na&sg)\u001e;ve\u0016$2a\u000f7n\u0011\u00159v\u00011\u0001Y\u0011\u00151u\u00011\u0001H\u000311XM]5gs>kW.\u001a:t)1Y\u0004/^?\u0002\u0006\u0005\u0015\u0012QGA\u001c\u0011\u0015\t\b\u00021\u0001s\u0003=yW.\\3sg\u000e{g\u000e^1j]\u0016\u0014\bCA!t\u0013\t!(IA\bP[6,'o]\"p]R\f\u0017N\\3s\u0011\u00151\b\u00021\u0001x\u0003u\u0019WO\u001d:f]R4U\u000f\u001c7D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|\u0007C\u0001=|\u001b\u0005I(B\u0001>\u000e\u0003%\u0019wN\\:f]N,8/\u0003\u0002}s\n1b)\u001e7m\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000eC\u0003\u007f\u0011\u0001\u0007q0A\u0011qe\u00164\u0018n\\;t\rVdGnQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_>\u0003H\u000f\u0005\u0003\u0015\u0003\u00039\u0018bAA\u0002+\t1q\n\u001d;j_:Dq!a\u0002\t\u0001\u0004\tI!A\tcKN$8J\\8x]B\u000b'/\u001a8u\u0013\u0012\u0004B!a\u0003\u0002 9!\u0011QBA\u000e\u001d\u0011\ty!!\u0007\u000f\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u0012\u0003\u0019a$o\\8u}%\t!%\u0003\u0002!C%\u0019\u0011QD\u0010\u0002\u000fA\f7m[1hK&!\u0011\u0011EA\u0012\u0005)iu\u000eZ5gS\u0016\u0014\u0018\n\u001a\u0006\u0004\u0003;y\u0002bBA\u0014\u0011\u0001\u0007\u0011\u0011F\u0001\u0014E\u0016\u001cHo\u00138po:\u0004\u0016M]3oi&sgm\u001c\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF\u0007\u0002\u000b\rD\u0017-\u001b8\n\t\u0005M\u0012Q\u0006\u0002\u0013'&$Wm\u00195bS:\u0014En\\2l\u0013:4w\u000eC\u0003G\u0011\u0001\u0007q\tC\u0004\u0002:!\u0001\r!a\u000f\u0002EA\u0014XM^5pkN,\u0005o\\2i\u001f6lWM]:J]\u001a|\u0017iY2v[Vd\u0017\r^8s!\u0019\ti$!\u0012\u0002L9!\u0011qHA\"\u001d\u0011\t\t\"!\u0011\n\u0003YI1!!\b\u0016\u0013\u0011\t9%!\u0013\u0003\u0007M+\u0017OC\u0002\u0002\u001eU\u0001r\u0001FA'\u0003#\ni&C\u0002\u0002PU\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]S\"A\u0002we\u001aLA!a\u0017\u0002V\tIaK\u001d4PkR\u0004X\u000f\u001e\t\u0005\u0003?\nyG\u0004\u0003\u0002b\u00055d\u0002BA2\u0003WrA!!\u001a\u0002j9!\u0011\u0011CA4\u0013\u0005\u0001\u0012B\u0001\b\u0010\u0013\tQX\"C\u0002\u0002\u001eeLA!!\u001d\u0002t\t\u00192i\u001c8tK:\u001cXo]*m_RtU/\u001c2fe*\u0019\u0011QD=\u0002-Y,'/\u001b4z\r>\u0014x-\u001b8h'R\f7.Z%oM>$\u0012bOA=\u0003\u0007\u000bi)!%\t\u000f\u0005m\u0014\u00021\u0001\u0002~\u00051\u0001.Z1eKJ\u00042!QA@\u0013\r\t\tI\u0011\u0002\u0015'&$Wm\u00195bS:\u0014En\\2l\u0011\u0016\fG-\u001a:\t\u000f\u0005\u0015\u0015\u00021\u0001\u0002\b\u000692\u000f^1lK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\u001c\t\u0004q\u0006%\u0015bAAFs\n92\u000b^1lK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\u001c\u0005\b\u0003\u001fK\u0001\u0019AA)\u0003%1(OZ(viB,H\u000fC\u0004\u0002\u0014&\u0001\r!!&\u0002+A,'oY3oi\u0006<WMR8sW\u0006\u0003\b\u000f\\5fIB\u0019A#a&\n\u0007\u0005eUCA\u0004C_>dW-\u00198")
public class ConsensusValidator
implements HistoryBlockValidator,
ScorexLogging {
    private final TimeProvider timeProvider;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Try<BoxedUnit> validate(SidechainBlock block, SidechainHistory history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (history.isGenesisBlock(block.id())) {
                this.validateGenesisBlock(block, history);
            } else {
                this.validateNonGenesisBlock(block, history);
            }
        });
    }

    private void validateGenesisBlock(SidechainBlock block, SidechainHistory history) {
        if (block.timestamp() != history.params().sidechainGenesisBlockTimestamp()) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Genesis block timestamp ").append(block.timestamp()).append(" is differ than expected timestamp from configuration ").append(history.params().sidechainGenesisBlockTimestamp()).toString());
        }
        boolean vrfSignIsNotCorrect = false;
        if (vrfSignIsNotCorrect) {
            throw new IllegalArgumentException("Genesis block timestamp is not signed his own forger box");
        }
    }

    private void validateNonGenesisBlock(SidechainBlock verifiedBlock, SidechainHistory history) {
        SidechainBlockInfo parentBlockInfo = history.blockInfoById(verifiedBlock.parentId());
        this.verifyTimestamp(verifiedBlock.timestamp(), parentBlockInfo.timestamp(), history.params());
        FullConsensusEpochInfo currentConsensusEpochInfo = history.getFullConsensusEpochInfoForBlock(verifiedBlock.timestamp(), verifiedBlock.parentId());
        VrfOutput vrfOutput = (VrfOutput)history.getVrfOutput(verifiedBlock.header(), currentConsensusEpochInfo.nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for block ").append(verifiedBlock.id()).append(" had been failed").toString());
        });
        int consensusEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(history.params(), verifiedBlock.timestamp());
        boolean stakePercentageForkApplied = ForkManager$.MODULE$.getSidechainConsensusEpochFork(consensusEpoch).stakePercentageForkApplied();
        this.verifyForgingStakeInfo(verifiedBlock.header(), currentConsensusEpochInfo.stakeConsensusEpochInfo(), vrfOutput, stakePercentageForkApplied);
        SidechainBlockInfo lastBlockInPreviousConsensusEpochInfo = history.blockInfoById(history.getLastBlockInPreviousConsensusEpoch(verifiedBlock.timestamp(), verifiedBlock.parentId()));
        FullConsensusEpochInfo previousFullConsensusEpochInfo = history.getFullConsensusEpochInfoForBlock(lastBlockInPreviousConsensusEpochInfo.timestamp(), lastBlockInPreviousConsensusEpochInfo.parentId());
        this.verifyOmmers(verifiedBlock, currentConsensusEpochInfo, (Option<FullConsensusEpochInfo>)new Some((Object)previousFullConsensusEpochInfo), verifiedBlock.parentId(), parentBlockInfo, history, (Seq<Tuple2<VrfOutput, Object>>)((Seq)Nil$.MODULE$));
        this.verifyTimestampInFuture(verifiedBlock.timestamp(), history);
    }

    private void verifyTimestamp(long verifiedBlockTimestamp, long parentBlockTimestamp, NetworkParams params) {
        int epochNumberForParentBlock;
        int absoluteSlotNumberForParentBlock;
        if (verifiedBlockTimestamp < parentBlockTimestamp) {
            throw new IllegalArgumentException("Block had been generated before parent block had been generated");
        }
        int absoluteSlotNumberForVerifiedBlock = TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(params, verifiedBlockTimestamp);
        if (absoluteSlotNumberForVerifiedBlock <= (absoluteSlotNumberForParentBlock = TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(params, parentBlockTimestamp))) {
            throw new IllegalArgumentException("Block absolute slot number is equal or less than parent block");
        }
        int epochNumberForVerifiedBlock = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params, verifiedBlockTimestamp);
        if (epochNumberForVerifiedBlock - (epochNumberForParentBlock = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params, parentBlockTimestamp)) > 1) {
            throw new IllegalStateException("Whole epoch had been skipped");
        }
    }

    private void verifyTimestampInFuture(long verifiedBlockTimestamp, SidechainHistory history) {
        if (TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(history.params(), verifiedBlockTimestamp) > TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(history.params(), this.timeProvider.time() / 1000L)) {
            throw new SidechainBlockSlotInFutureException("Block had been generated in the future", SidechainBlockSlotInFutureException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyOmmers(OmmersContainer ommersContainer, FullConsensusEpochInfo currentFullConsensusEpochInfo, Option<FullConsensusEpochInfo> previousFullConsensusEpochInfoOpt, String bestKnownParentId, SidechainBlockInfo bestKnownParentInfo, SidechainHistory history, Seq<Tuple2<VrfOutput, Object>> previousEpochOmmersInfoAccumulator) {
        Seq<Ommer> ommers = ommersContainer.ommers();
        if (ommers.isEmpty()) {
            return;
        }
        int ommersContainerEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(history.params(), ommersContainer.header().timestamp());
        ObjectRef accumulator = ObjectRef.create(previousEpochOmmersInfoAccumulator);
        IntRef previousOmmerEpochNumber = IntRef.create((int)ommersContainerEpochNumber);
        ObjectRef ommerCurrentFullConsensusEpochInfo = ObjectRef.create((Object)currentFullConsensusEpochInfo);
        ObjectRef ommerPreviousFullConsensusEpochInfoOpt = ObjectRef.create(previousFullConsensusEpochInfoOpt);
        ommers.foreach((Function1 & Serializable & scala.Serializable)ommer -> {
            ConsensusValidator.$anonfun$verifyOmmers$1(this, history, previousOmmerEpochNumber, ommerCurrentFullConsensusEpochInfo, previousFullConsensusEpochInfoOpt, ommersContainer, ommerPreviousFullConsensusEpochInfoOpt, bestKnownParentId, bestKnownParentInfo, accumulator, currentFullConsensusEpochInfo, ommersContainerEpochNumber, ommer);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyForgingStakeInfo(SidechainBlockHeader header, StakeConsensusEpochInfo stakeConsensusEpochInfo, VrfOutput vrfOutput, boolean percentageForkApplied) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Verify Forger box against root hash: {} by merkle path {}", new Object[]{stakeConsensusEpochInfo.rootHash(), new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.forgingStakeMerklePath().bytes())).deep().mkString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean forgingStakeIsCorrect = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeConsensusEpochInfo.rootHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.forgingStakeMerklePath().apply(header.forgingStakeInfo().hash())));
        if (!forgingStakeIsCorrect) {
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("Actual stakeInfo: rootHash: {}, totalStake: {}", new Object[]{stakeConsensusEpochInfo.rootHash(), BoxesRunTime.boxToLong((long)stakeConsensusEpochInfo.totalStake())});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new IllegalStateException(new StringBuilder(79).append("Forging stake merkle path in block ").append(header.id()).append(" is inconsistent to stakes merkle root hash ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeConsensusEpochInfo.rootHash())).deep().mkString(",")).toString());
        }
        long value = header.forgingStakeInfo().stakeAmount();
        boolean stakeIsEnough = package$.MODULE$.vrfProofCheckAgainstStake(vrfOutput, value, stakeConsensusEpochInfo.totalStake(), percentageForkApplied);
        if (!stakeIsEnough) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Stake value in forger box in block ").append(header.id()).append(" is not enough for to be forger.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$verifyOmmers$1(ConsensusValidator $this, SidechainHistory history$2, IntRef previousOmmerEpochNumber$1, ObjectRef ommerCurrentFullConsensusEpochInfo$1, Option previousFullConsensusEpochInfoOpt$1, OmmersContainer ommersContainer$1, ObjectRef ommerPreviousFullConsensusEpochInfoOpt$1, String bestKnownParentId$1, SidechainBlockInfo bestKnownParentInfo$1, ObjectRef accumulator$1, FullConsensusEpochInfo currentFullConsensusEpochInfo$1, int ommersContainerEpochNumber$1, Ommer ommer) {
        ConsensusEpochAndSlot ommerEpochAndSlot = TimeToEpochUtils$.MODULE$.timestampToEpochAndSlot(history$2.params(), ommer.header().timestamp());
        if (ommerEpochAndSlot.epochNumber() < previousOmmerEpochNumber$1.elem) {
            ommerCurrentFullConsensusEpochInfo$1.elem = (FullConsensusEpochInfo)previousFullConsensusEpochInfoOpt$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(40).append("Block ").append(ommersContainer$1.header().id()).append(" contains ommer two epochs before.").toString());
            });
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = None$.MODULE$;
        } else if (ommerEpochAndSlot.epochNumber() > previousOmmerEpochNumber$1.elem) {
            NonceConsensusEpochInfo nonce = history$2.calculateNonceForNonGenesisEpoch(bestKnownParentId$1, bestKnownParentInfo$1, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
            ommerCurrentFullConsensusEpochInfo$1.elem = new FullConsensusEpochInfo(currentFullConsensusEpochInfo$1.stakeConsensusEpochInfo(), nonce);
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = previousFullConsensusEpochInfoOpt$1;
        }
        VrfOutput ommerVrfOutput = (VrfOutput)history$2.getVrfOutput(ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for Ommer ").append(ommer.header().id()).append(" had been failed").toString());
        });
        boolean stakePercentageForkApplied = ForkManager$.MODULE$.getSidechainConsensusEpochFork(ommersContainerEpochNumber$1).stakePercentageForkApplied();
        $this.verifyForgingStakeInfo(ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).stakeConsensusEpochInfo(), ommerVrfOutput, stakePercentageForkApplied);
        $this.verifyOmmers(ommer, (FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem, (Option<FullConsensusEpochInfo>)((Option)ommerPreviousFullConsensusEpochInfoOpt$1.elem), bestKnownParentId$1, bestKnownParentInfo$1, history$2, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
        if (ommerEpochAndSlot.epochNumber() < ommersContainerEpochNumber$1) {
            Tuple2 tuple2 = new Tuple2((Object)ommerVrfOutput, (Object)BoxesRunTime.boxToInteger((int)ommerEpochAndSlot.slotNumber()));
            accumulator$1.elem = (Seq)((Seq)accumulator$1.elem).$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom());
        }
        previousOmmerEpochNumber$1.elem = ommerEpochAndSlot.epochNumber();
    }

    public ConsensusValidator(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
    }
}

