/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import com.horizen.consensus.ConsensusEpochAndSlot;
import com.horizen.consensus.package$;
import com.horizen.params.NetworkParams;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;

public final class TimeToEpochUtils$ {
    public static TimeToEpochUtils$ MODULE$;

    static {
        new TimeToEpochUtils$();
    }

    public long epochInSeconds(NetworkParams params) {
        return Math.multiplyExact(params.consensusSlotsInEpoch(), params.consensusSecondsInSlot());
    }

    public long virtualGenesisBlockTimeStamp(NetworkParams params) {
        return params.sidechainGenesisBlockTimestamp() - this.epochInSeconds(params) + (long)params.consensusSecondsInSlot();
    }

    public ConsensusEpochAndSlot timestampToEpochAndSlot(NetworkParams params, long timestamp) {
        return new ConsensusEpochAndSlot(this.timeStampToEpochNumber(params, timestamp), this.timeStampToSlotNumber(params, timestamp));
    }

    public int timeStampToEpochNumber(NetworkParams params, long timestamp) {
        return package$.MODULE$.intToConsensusEpochNumber(this.getEpochIndex(params, timestamp) + 1);
    }

    public int timeStampToSlotNumber(NetworkParams params, long timestamp) {
        long secondsFromEpochStart = timestamp - (long)this.getEpochIndex(params, timestamp) * this.epochInSeconds(params) - this.virtualGenesisBlockTimeStamp(params);
        long slotIndex = secondsFromEpochStart / (long)params.consensusSecondsInSlot();
        return package$.MODULE$.intToConsensusSlotNumber((int)slotIndex + 1);
    }

    public int timeStampToAbsoluteSlotNumber(NetworkParams params, long timestamp) {
        int slotNumber = this.timeStampToEpochNumber(params, timestamp) * params.consensusSlotsInEpoch() + this.timeStampToSlotNumber(params, timestamp);
        return package$.MODULE$.intToConsensusAbsoluteSlotNumber(slotNumber);
    }

    public long getTimeStampForEpochAndSlot(NetworkParams params, int epochNumber, int slotNumber) {
        Predef$.MODULE$.require(slotNumber <= params.consensusSlotsInEpoch());
        int totalSlots = (epochNumber - 1) * params.consensusSlotsInEpoch() + (slotNumber - 1);
        return this.virtualGenesisBlockTimeStamp(params) + (long)(totalSlots * params.consensusSecondsInSlot());
    }

    public long secondsRemainingInSlot(NetworkParams params, long timestamp) {
        long secondsElapsedInSlot = (timestamp - this.virtualGenesisBlockTimeStamp(params)) % (long)params.consensusSecondsInSlot();
        return (long)params.consensusSecondsInSlot() - secondsElapsedInSlot;
    }

    private int getEpochIndex(NetworkParams params, long timestamp) {
        Predef$.MODULE$.require(timestamp >= params.sidechainGenesisBlockTimestamp(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(76).append("Try to get index epoch for timestamp ").append(timestamp).append(" which are less than genesis timestamp ").append(params.sidechainGenesisBlockTimestamp()).toString());
        long epochIndex = (timestamp - this.virtualGenesisBlockTimeStamp(params)) / this.epochInSeconds(params);
        return (int)epochIndex;
    }

    private TimeToEpochUtils$() {
        MODULE$ = this;
    }
}

