/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import com.horizen.utils.BytesUtils;
import com.horizen.utils.MerklePath;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MerkleTree {
    public static int ROOT_HASH_LENGTH = 32;
    private int _leavesNumber;
    private List<byte[]> _merkleTree;
    private boolean _isMutated;

    private MerkleTree(int leavesNumber, List<byte[]> merkleTree, boolean isMutated) {
        this._leavesNumber = leavesNumber;
        this._merkleTree = merkleTree;
        this._isMutated = isMutated;
    }

    public static MerkleTree createMerkleTree(List<byte[]> leavesHashes) {
        if (leavesHashes == null || leavesHashes.size() == 0) {
            throw new IllegalArgumentException("Non leaves provided. Merkle Tree can not be calculated.");
        }
        ArrayList<byte[]> merkleTree = new ArrayList<byte[]>(leavesHashes);
        int offset = 0;
        int levelSize = merkleTree.size();
        boolean isMutated = false;
        while (levelSize > 1) {
            for (int left = 0; left < levelSize; left += 2) {
                int right = Math.min(left + 1, levelSize - 1);
                byte[] leftBytes = BytesUtils.reverseBytes(merkleTree.get(offset + left));
                byte[] rightBytes = BytesUtils.reverseBytes(merkleTree.get(offset + right));
                if (right == left + 1 && right + 1 == levelSize && Arrays.equals(leftBytes, rightBytes)) {
                    isMutated = true;
                }
                merkleTree.add(BytesUtils.reverseBytes(Utils.doubleSHA256HashOfConcatenation(leftBytes, rightBytes)));
            }
            offset += levelSize;
            levelSize = (levelSize + 1) / 2;
        }
        return new MerkleTree(leavesHashes.size(), merkleTree, isMutated);
    }

    public byte[] rootHash() {
        return this._merkleTree.get(this._merkleTree.size() - 1);
    }

    public List<byte[]> toList() {
        return this._merkleTree;
    }

    public int leavesNumber() {
        return this._leavesNumber;
    }

    public List<byte[]> leaves() {
        return this._merkleTree.subList(0, this._leavesNumber);
    }

    public MerklePath getMerklePathForLeaf(int leafIdx) {
        if (leafIdx < 0 || leafIdx >= this._leavesNumber) {
            throw new IllegalArgumentException("Leaf index is out of bound. Merkle Path can not be calculated.");
        }
        int offset = 0;
        int levelSize = this._leavesNumber;
        int idxOnLevel = leafIdx;
        ArrayList<Pair<Byte, byte[]>> merklePath = new ArrayList<Pair<Byte, byte[]>>();
        while (levelSize > 1) {
            boolean isOdd;
            boolean bl = isOdd = levelSize % 2 == 1;
            if (isOdd && idxOnLevel == levelSize - 1) {
                merklePath.add(new Pair<Byte, byte[]>((byte)1, this._merkleTree.get(offset + idxOnLevel)));
            } else if (idxOnLevel % 2 == 1) {
                merklePath.add(new Pair<Byte, byte[]>((byte)0, this._merkleTree.get(offset + idxOnLevel - 1)));
            } else {
                merklePath.add(new Pair<Byte, byte[]>((byte)1, this._merkleTree.get(offset + idxOnLevel + 1)));
            }
            offset += levelSize;
            levelSize = (levelSize + 1) / 2;
            idxOnLevel /= 2;
        }
        return new MerklePath(merklePath);
    }

    public boolean validateMerklePath(byte[] leaf, MerklePath merklePath) {
        return Arrays.equals(this.rootHash(), merklePath.apply(leaf));
    }

    public boolean isMutated() {
        return this._isMutated;
    }
}

