/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.horizen.box.Box;
import com.horizen.box.data.BoxData;
import com.horizen.box.data.BoxDataSerializer;
import com.horizen.box.data.ForgerBoxDataSerializer;
import com.horizen.box.data.WithdrawalRequestBoxDataSerializer;
import com.horizen.box.data.ZenBoxDataSerializer;
import com.horizen.proof.Proof;
import com.horizen.proof.ProofSerializer;
import com.horizen.proof.Signature25519Serializer;
import com.horizen.proposition.Proposition;
import com.horizen.transaction.SidechainCoreTransaction;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.utils.DynamicTypedSerializer;
import com.horizen.utils.ListSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Writer;
import sparkz.core.NodeViewModifier$;

public final class SidechainCoreTransactionSerializer
implements TransactionSerializer<SidechainCoreTransaction> {
    private static SidechainCoreTransactionSerializer serializer;
    private static final ListSerializer<BoxData<Proposition, Box<Proposition>>> boxesDataSerializer;
    private static final ListSerializer<Proof<Proposition>> proofsSerializer;

    private SidechainCoreTransactionSerializer() {
    }

    public static SidechainCoreTransactionSerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(SidechainCoreTransaction transaction, Writer writer) {
        writer.put(transaction.version());
        writer.putLong(transaction.fee());
        writer.putInt(transaction.inputsIds.size());
        for (byte[] id : transaction.inputsIds) {
            writer.putBytes(id);
        }
        boxesDataSerializer.serialize(transaction.getOutputData(), writer);
        proofsSerializer.serialize(transaction.proofs, writer);
    }

    @Override
    public SidechainCoreTransaction parse(Reader reader) {
        byte version = reader.getByte();
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Unsupported transaction version[%d].", version));
        }
        long fee = reader.getLong();
        int inputsNum = reader.getInt();
        ArrayList<byte[]> inputsIds = new ArrayList<byte[]>();
        for (int i = 0; i < inputsNum; ++i) {
            inputsIds.add(reader.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize()));
        }
        Object outputsData = boxesDataSerializer.parse(reader);
        Object proofs = proofsSerializer.parse(reader);
        return new SidechainCoreTransaction(inputsIds, (List<BoxData<Proposition, Box<Proposition>>>)outputsData, (List<Proof<Proposition>>)proofs, fee, version);
    }

    static {
        boxesDataSerializer = new ListSerializer(new DynamicTypedSerializer(new HashMap<Byte, BoxDataSerializer>(){
            {
                this.put((byte)1, ZenBoxDataSerializer.getSerializer());
                this.put((byte)2, WithdrawalRequestBoxDataSerializer.getSerializer());
                this.put((byte)3, ForgerBoxDataSerializer.getSerializer());
            }
        }, new HashMap()), 1000);
        proofsSerializer = new ListSerializer(new DynamicTypedSerializer(new HashMap<Byte, ProofSerializer>(){
            {
                this.put((byte)1, Signature25519Serializer.getSerializer());
            }
        }, new HashMap()), 1000);
        serializer = new SidechainCoreTransactionSerializer();
    }
}

