/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.box.Box;
import com.horizen.box.BoxUnlocker;
import com.horizen.proposition.Proposition;
import com.horizen.serialization.Views;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.CoreTransactionsIdsEnum;
import com.horizen.transaction.MC2SCAggregatedTransactionSerializer;
import com.horizen.transaction.MempoolIncompatibleTransactionIncompatibilityChecker;
import com.horizen.transaction.TransactionIncompatibilityChecker;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.transaction.exception.TransactionSemanticValidityException;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.utils.MerkleTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import scala.Array;
import scorex.util.encode.Base16;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"mc2scTransactionsOutputs", "encoder"})
public final class MC2SCAggregatedTransaction
extends BoxTransaction<Proposition, Box<Proposition>> {
    private byte[] mc2scTransactionsMerkleRootHash;
    private List<SidechainRelatedMainchainOutput> mc2scTransactionsOutputs;
    private List<Box<Proposition>> newBoxes;
    private final byte version;
    public static final byte MC2SC_AGGREGATED_TRANSACTION_VERSION = 1;
    public static final int MAX_MC2SC_AGGREGATED_TRANSACTION_SIZE = 0x200000;

    public MC2SCAggregatedTransaction(List<SidechainRelatedMainchainOutput> mc2scTransactionsOutputs, byte version) {
        if (mc2scTransactionsOutputs.isEmpty()) {
            throw new IllegalArgumentException("Empty sidechain related mainchain outputs passed.");
        }
        this.mc2scTransactionsOutputs = mc2scTransactionsOutputs;
        this.version = version;
    }

    public TransactionSerializer serializer() {
        return MC2SCAggregatedTransactionSerializer.getSerializer();
    }

    @Override
    public TransactionIncompatibilityChecker incompatibilityChecker() {
        return MempoolIncompatibleTransactionIncompatibilityChecker.getChecker();
    }

    @Override
    public byte[] customDataMessageToSign() {
        return Array.emptyByteArray();
    }

    @Override
    public synchronized List<BoxUnlocker<Proposition>> unlockers() {
        return new ArrayList<BoxUnlocker<Proposition>>();
    }

    @Override
    public synchronized List<Box<Proposition>> newBoxes() {
        if (this.newBoxes == null) {
            this.newBoxes = new ArrayList<Box<Proposition>>();
            for (SidechainRelatedMainchainOutput t : this.mc2scTransactionsOutputs) {
                this.newBoxes.add((Box<Proposition>)t.getBox());
            }
        }
        return Collections.unmodifiableList(this.newBoxes);
    }

    @Override
    public long fee() {
        return 0L;
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.MC2SCAggregatedTransactionId.id();
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public String id() {
        return Base16.encode((byte[])this.mc2scMerkleRootHash());
    }

    @Override
    public Boolean isCustom() {
        return false;
    }

    @Override
    public byte[] messageToSign() {
        throw new UnsupportedOperationException("MC2SCAggregatedTransaction can not be signed.");
    }

    @JsonProperty(value="mc2scTransactionsMerkleRootHash")
    public synchronized byte[] mc2scMerkleRootHash() {
        if (this.mc2scTransactionsMerkleRootHash == null) {
            ArrayList<byte[]> hashes = new ArrayList<byte[]>();
            for (SidechainRelatedMainchainOutput t : this.mc2scTransactionsOutputs) {
                hashes.add(t.hash());
            }
            this.mc2scTransactionsMerkleRootHash = MerkleTree.createMerkleTree(hashes).rootHash();
        }
        return Arrays.copyOf(this.mc2scTransactionsMerkleRootHash, this.mc2scTransactionsMerkleRootHash.length);
    }

    public List<SidechainRelatedMainchainOutput> mc2scTransactionsOutputs() {
        return Collections.unmodifiableList(this.mc2scTransactionsOutputs);
    }

    @Override
    public void semanticValidity() throws TransactionSemanticValidityException {
        if (this.version != 1) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: unsupported version number.", this.id()));
        }
        if (this.bytes().length > 0x200000) {
            throw new TransactionSemanticValidityException("Transaction is too large: " + this.bytes().length);
        }
    }

    @Override
    public byte[] customFieldsData() {
        return Array.emptyByteArray();
    }
}

