/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.horizen.box.BoxUnlocker;
import com.horizen.box.ZenBox;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.CoreTransactionsIdsEnum;
import com.horizen.transaction.FeePaymentsTransactionSerializer;
import com.horizen.transaction.MempoolIncompatibleTransactionIncompatibilityChecker;
import com.horizen.transaction.TransactionIncompatibilityChecker;
import com.horizen.transaction.exception.TransactionSemanticValidityException;
import java.util.Collections;
import java.util.List;
import scala.Array;
import sparkz.core.serialization.SparkzSerializer;

public class FeePaymentsTransaction
extends BoxTransaction<PublicKey25519Proposition, ZenBox> {
    public static final byte FEE_PAYMENTS_TRANSACTION_VERSION = 1;
    private final List<ZenBox> feePayments;
    private final byte version;

    public FeePaymentsTransaction(List<ZenBox> feePayments, byte version) {
        this.feePayments = feePayments;
        this.version = version;
    }

    @Override
    public void semanticValidity() throws TransactionSemanticValidityException {
        if (this.version != 1) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: unsupported version number.", this.id()));
        }
        if (this.feePayments.isEmpty()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no output data present.", this.id()));
        }
    }

    @Override
    public byte[] customDataMessageToSign() {
        return Array.emptyByteArray();
    }

    @Override
    public byte[] customFieldsData() {
        return Array.emptyByteArray();
    }

    @Override
    public List<BoxUnlocker<PublicKey25519Proposition>> unlockers() {
        return Collections.emptyList();
    }

    @Override
    public TransactionIncompatibilityChecker incompatibilityChecker() {
        return MempoolIncompatibleTransactionIncompatibilityChecker.getChecker();
    }

    @Override
    public List<ZenBox> newBoxes() {
        return Collections.unmodifiableList(this.feePayments);
    }

    @Override
    public long fee() {
        return 0L;
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.FeePaymentsTransactionId.id();
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }

    public SparkzSerializer serializer() {
        return FeePaymentsTransactionSerializer.getSerializer();
    }
}

