/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.companion.SidechainTransactionsCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;
import scorex.util.package;
import scorex.util.package$;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0006\f\u0001IA\u0001\u0002\u0004\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\u0007\u0001C\u0001i!)\u0001\b\u0001C\u0001s!)q\u000b\u0001C\u00011\")A\u000f\u0001C!k\")q\u000f\u0001C\u0001q\")A\u0010\u0001C\u0001{\"1q\u0010\u0001C\u0001\u0003\u0003\u0011\u0011eU5eK\u000eD\u0017-\u001b8XC2dW\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cFo\u001c:bO\u0016T!\u0001D\u0007\u0002\u000fM$xN]1hK*\u0011abD\u0001\bQ>\u0014\u0018N_3o\u0015\u0005\u0001\u0012aA2p[\u000e\u00011#\u0002\u0001\u00143u\t\u0003C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\tQ\"\u0003\u0002\u001d\u001b\tq1+\u001b3fG\"\f\u0017N\u001c+za\u0016\u001c\bC\u0001\u0010 \u001b\u0005Y\u0011B\u0001\u0011\f\u0005Q\u0019\u0016\u000eZ3dQ\u0006Lgn\u0015;pe\u0006<W-\u00138g_B\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005kRLGNC\u0001'\u0003\u0019\u00198m\u001c:fq&\u0011\u0001f\t\u0002\u000e'\u000e|'/\u001a=M_\u001e<\u0017N\\4\u0011\u0005yQ\u0013BA\u0016\f\u0005\u001d\u0019Fo\u001c:bO\u0016\fad]5eK\u000eD\u0017-\u001b8Ue\u0006t7/Y2uS>t7oQ8na\u0006t\u0017n\u001c8\u0011\u00059\nT\"A\u0018\u000b\u0005Aj\u0011!C2p[B\fg.[8o\u0013\t\u0011tF\u0001\u0010TS\u0012,7\r[1j]R\u0013\u0018M\\:bGRLwN\\:D_6\u0004\u0018M\\5p]\u00061A(\u001b8jiz\"2!\u000e\u001c8!\tq\u0002\u0001C\u0003\r\u0007\u0001\u0007\u0011\u0006C\u0003-\u0007\u0001\u0007Q&A\u0002hKR$\"AO(\u0011\u0007QYT(\u0003\u0002=+\t1q\n\u001d;j_:\u0004BAP!D\u00136\tqH\u0003\u0002A\u001b\u0005YAO]1og\u0006\u001cG/[8o\u0013\t\u0011uH\u0001\bC_b$&/\u00198tC\u000e$\u0018n\u001c8\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019k\u0011a\u00039s_B|7/\u001b;j_:L!\u0001S#\u0003\u0017A\u0013x\u000e]8tSRLwN\u001c\t\u0004\u00156\u001bU\"A&\u000b\u00051k\u0011a\u00012pq&\u0011aj\u0013\u0002\u0004\u0005>D\b\"\u0002)\u0005\u0001\u0004\t\u0016!\u0004;sC:\u001c\u0018m\u0019;j_:LE\rE\u0002\u0015%RK!aU\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Q)\u0016B\u0001,\u0016\u0005\u0011\u0011\u0015\u0010^3\u0002\rU\u0004H-\u0019;f)\rIfL\u001a\t\u00045r+T\"A.\u000b\u0005\u0011*\u0012BA/\\\u0005\r!&/\u001f\u0005\u0006?\u0016\u0001\r\u0001Y\u0001\bm\u0016\u00148/[8o!\t\tG-D\u0001c\u0015\t\u0019W\"A\u0003vi&d7/\u0003\u0002fE\n\u0001\")\u001f;f\u0003J\u0014\u0018-_,sCB\u0004XM\u001d\u0005\u0006O\u0016\u0001\r\u0001[\u0001\u0016iJ\fgn]1di&|g.\u00169eCR,G*[:u!\rI\u0017/\u0010\b\u0003U>t!a\u001b8\u000e\u00031T!!\\\t\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u00019\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!A]:\u0003\u0007M+\u0017O\u0003\u0002q+\u0005iA.Y:u-\u0016\u00148/[8o\u0013\u0012,\u0012A\u001e\t\u0004)m\u0002\u0017\u0001\u0005:pY2\u0014\u0017mY6WKJ\u001c\u0018n\u001c8t+\u0005I\bcA5{A&\u00111p\u001d\u0002\u0005\u0019&\u001cH/\u0001\u0005s_2d'-Y2l)\tIf\u0010C\u0003`\u0011\u0001\u0007\u0001-A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005\r\u0001c\u0001\u000b\u0002\u0006%\u0019\u0011qA\u000b\u0003\u000f\t{w\u000e\\3b]\u0002")
public class SidechainWalletTransactionStorage
implements SidechainTypes,
SidechainStorageInfo,
ScorexLogging {
    private final Storage storage;
    private final SidechainTransactionsCompanion sidechainTransactionsCompanion;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Option<BoxTransaction<Proposition, Box<Proposition>>> get(byte[] transactionId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(transactionId));
        if (optional.isPresent()) {
            Option option2;
            Try try_ = this.sidechainTransactionsCompanion.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                BoxTransaction transaction = (BoxTransaction)success.value();
                option2 = Option$.MODULE$.apply((Object)transaction);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while Transaction parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Try<SidechainWalletTransactionStorage> update(ByteArrayWrapper version, Seq<BoxTransaction<Proposition, Box<Proposition>>> transactionUpdateList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(transactionUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Transactions to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!transactionUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Transactions to add/update must be NOT NULL.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            transactionUpdateList.foreach((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(package$.MODULE$.idToBytes((String)package.ModifierId$.MODULE$.$at$at((Object)tx.id(), package.Tagger$.MODULE$.baseRaw()))), new ByteArrayWrapper(this.sidechainTransactionsCompanion.toBytes(tx))))));
            $this.storage.update(version, updateList, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletTransactionStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public SidechainWalletTransactionStorage(Storage storage, SidechainTransactionsCompanion sidechainTransactionsCompanion) {
        this.storage = storage;
        this.sidechainTransactionsCompanion = sidechainTransactionsCompanion;
        SidechainTypes.$init$(this);
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainTransactionsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainTransactionsCompanion must be NOT NULL.");
    }
}

