/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.cryptolibprovider.CryptoLibProvider$;
import com.horizen.cryptolibprovider.utils.InMemorySparseMerkleTreeWrapper;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.horizen.utils.UtxoMerkleTreeLeafInfo;
import com.horizen.utils.UtxoMerkleTreeLeafInfoSerializer$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\n\u0014\u0001iA\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006i\u0001!\t!\u000e\u0005\bq\u0001\u0001\r\u0011\"\u0001:\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCa!\u0013\u0001!B\u0013Q\u0004\"\u0002&\u0001\t\u0013Y\u0005B\u0002'\u0001\t\u0003)R\nC\u0003b\u0001\u0011\u0005!\rC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0004x\u0001\u0011\u0005Q\u0003\u001f\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002N!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA3\u0001\u0011\u0005\u0011q\r\u0002$'&$Wm\u00195bS:\u001cF/\u0019;f+RDx.T3sW2,GK]3f'R|'/Y4f\u0015\t!R#A\u0004ti>\u0014\u0018mZ3\u000b\u0005Y9\u0012a\u00025pe&TXM\u001c\u0006\u00021\u0005\u00191m\\7\u0004\u0001M)\u0001aG\u0011*[A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u000511oY8sKbL!\u0001K\u0012\u0003\u001bM\u001bwN]3y\u0019><w-\u001b8h!\tQ3&D\u0001\u0014\u0013\ta3C\u0001\u000bTS\u0012,7\r[1j]N#xN]1hK&sgm\u001c\t\u0003]=j\u0011!F\u0005\u0003aU\u0011abU5eK\u000eD\u0017-\u001b8UsB,7\u000f\u0005\u0002+e%\u00111g\u0005\u0002\b'R|'/Y4f\u0003\u0019a\u0014N\\5u}Q\u0011ag\u000e\t\u0003U\u0001AQ\u0001\u0006\u0002A\u0002E\n\u0011#\\3sW2,GK]3f/J\f\u0007\u000f]3s+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0015)H/\u001b7t\u0015\tyT#A\tdef\u0004Ho\u001c7jEB\u0014xN^5eKJL!!\u0011\u001f\u0003?%sW*Z7pef\u001c\u0006/\u0019:tK6+'o\u001b7f)J,Wm\u0016:baB,'/A\u000bnKJ\\G.\u001a+sK\u0016<&/\u00199qKJ|F%Z9\u0015\u0005\u0011;\u0005C\u0001\u000fF\u0013\t1UD\u0001\u0003V]&$\bb\u0002%\u0005\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0014AE7fe.dW\r\u0016:fK^\u0013\u0018\r\u001d9fe\u0002\na\u0002\\8bI6+'o\u001b7f)J,W\rF\u0001;\u00035\u0019\u0017\r\\2vY\u0006$X\rT3bMR\u0011a\n\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#V\t\u0011\u0003\\5ceV\u001cHo]5eK\u000eD\u0017-\u001b8t\u0013\t\u0019\u0006K\u0001\u0007GS\u0016dG-\u00127f[\u0016tG\u000fC\u0003V\u000f\u0001\u0007a+A\u0002c_b\u00042aV-\\\u001b\u0005A&BA+\u0016\u0013\tQ\u0006LA\u0002C_b\u0004\"\u0001X0\u000e\u0003uS!AX\u000b\u0002\u0017A\u0014x\u000e]8tSRLwN\\\u0005\u0003Av\u00131\u0002\u0015:pa>\u001c\u0018\u000e^5p]\u0006Yq-\u001a;MK\u00064\u0017J\u001c4p)\t\u00197\u000eE\u0002\u001dI\u001aL!!Z\u000f\u0003\r=\u0003H/[8o!\t9\u0017.D\u0001i\u0015\tiT#\u0003\u0002kQ\n1R\u000b\u001e=p\u001b\u0016\u00148\u000e\\3Ue\u0016,G*Z1g\u0013:4w\u000eC\u0003m\u0011\u0001\u0007Q.A\u0003c_bLE\rE\u0002\u001d]BL!a\\\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005q\t\u0018B\u0001:\u001e\u0005\u0011\u0011\u0015\u0010^3\u0002\u001b\u001d,G/T3sW2,\u0007+\u0019;i)\t)h\u000fE\u0002\u001dI6DQ\u0001\\\u0005A\u00025\f\u0001cZ3u\u00032dG*Z1wKNLeNZ8\u0016\u0003e\u0004BA_A\u0003M:\u001910!\u0001\u000f\u0005q|X\"A?\u000b\u0005yL\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\r\t\u0019!H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9!!\u0003\u0003\u0007M+\u0017OC\u0002\u0002\u0004u\t\u0011cZ3u\u001b\u0016\u00148\u000e\\3Ue\u0016,'k\\8u+\u0005i\u0017AB;qI\u0006$X\r\u0006\u0005\u0002\u0014\u0005u\u0011qEA\u0017!\u0015\t)\"!\u00077\u001b\t\t9B\u0003\u0002%;%!\u00111DA\f\u0005\r!&/\u001f\u0005\b\u0003?a\u0001\u0019AA\u0011\u0003\u001d1XM]:j_:\u00042aZA\u0012\u0013\r\t)\u0003\u001b\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJDq!!\u000b\r\u0001\u0004\tY#A\u0007c_b,7\u000fV8BaB,g\u000e\u001a\t\u0005u\u0006\u0015a\u000bC\u0004\u000201\u0001\r!!\r\u0002!\t|\u00070Z:U_J+Wn\u001c<f'\u0016$\bCBA\u001a\u0003w\t\tC\u0004\u0003\u00026\u0005]\u0002C\u0001?\u001e\u0013\r\tI$H\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0012q\b\u0002\u0004'\u0016$(bAA\u001d;\u0005iA.Y:u-\u0016\u00148/[8o\u0013\u0012,\"!!\u0012\u0011\tq!\u0017\u0011E\u0001\u0011e>dGNY1dWZ+'o]5p]N$\"!a\u0013\u0011\u000bi\f)!!\t\u0015\t\u0005=\u0013Q\u000b\t\u0006u\u0006E\u0013\u0011E\u0005\u0005\u0003'\nIA\u0001\u0003MSN$\bbBA,\u001f\u0001\u0007\u0011\u0011L\u0001\u0014[\u0006Dh*^7cKJ|eMV3sg&|gn\u001d\t\u00049\u0005m\u0013bAA/;\t\u0019\u0011J\u001c;\u0002\u0011I|G\u000e\u001c2bG.$B!a\u0005\u0002d!9\u0011q\u0004\tA\u0002\u0005\u0005\u0012aB5t\u000b6\u0004H/_\u000b\u0003\u0003S\u00022\u0001HA6\u0013\r\ti'\b\u0002\b\u0005>|G.Z1o\u0001")
public class SidechainStateUtxoMerkleTreeStorage
implements ScorexLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private InMemorySparseMerkleTreeWrapper merkleTreeWrapper;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public InMemorySparseMerkleTreeWrapper merkleTreeWrapper() {
        return this.merkleTreeWrapper;
    }

    public void merkleTreeWrapper_$eq(InMemorySparseMerkleTreeWrapper x$1) {
        this.merkleTreeWrapper = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public InMemorySparseMerkleTreeWrapper com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree() {
        void var2_2;
        int treeHeight = CryptoLibProvider$.MODULE$.cswCircuitFunctions().utxoMerkleTreeHeight();
        InMemorySparseMerkleTreeWrapper merkleTree = new InMemorySparseMerkleTreeWrapper(treeHeight);
        scala.collection.immutable.Map newLeaves = ((TraversableOnce)this.getAllLeavesInfo().map((Function1 & Serializable & scala.Serializable)leafInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.long2Long(leafInfo.position())), (Object)FieldElement.deserialize((byte[])leafInfo.leaf())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            merkleTree.addLeaves((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newLeaves).asJava());
        }
        finally {
            newLeaves.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                SidechainStateUtxoMerkleTreeStorage.$anonfun$loadMerkleTree$2(x$1);
                return BoxedUnit.UNIT;
            });
        }
        return var2_2;
    }

    public FieldElement calculateLeaf(Box<Proposition> box) {
        return CryptoLibProvider$.MODULE$.cswCircuitFunctions().getUtxoMerkleTreeLeaf(box);
    }

    public Option<UtxoMerkleTreeLeafInfo> getLeafInfo(byte[] boxId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(boxId));
        if (optional.isPresent()) {
            Option option2;
            Try<UtxoMerkleTreeLeafInfo> try_ = UtxoMerkleTreeLeafInfoSerializer$.MODULE$.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                UtxoMerkleTreeLeafInfo leafInfo = (UtxoMerkleTreeLeafInfo)success.value();
                option2 = Option$.MODULE$.apply((Object)leafInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while UtxoMerkleTreeLeafInfo parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<byte[]> getMerklePath(byte[] boxId) {
        return this.getLeafInfo(boxId).map((Function1 & Serializable & scala.Serializable)leafInfo -> this.merkleTreeWrapper().merklePath(leafInfo.position()));
    }

    public Seq<UtxoMerkleTreeLeafInfo> getAllLeavesInfo() {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).map((Function1 & Serializable & scala.Serializable)pair -> (UtxoMerkleTreeLeafInfo)UtxoMerkleTreeLeafInfoSerializer$.MODULE$.parseBytes(((ByteArrayWrapper)pair.getValue()).data()), Buffer$.MODULE$.canBuildFrom());
    }

    public byte[] getMerkleTreeRoot() {
        return this.merkleTreeWrapper().calculateRoot();
    }

    public Try<SidechainStateUtxoMerkleTreeStorage> update(ByteArrayWrapper version, Seq<Box<Proposition>> boxesToAppend, Set<ByteArrayWrapper> boxesToRemoveSet) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(boxesToAppend != null, (Function0 & Serializable & scala.Serializable)() -> "List of boxes to add must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxesToRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            java.util.List removeList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)boxesToRemoveSet.map((Function1 & Serializable & scala.Serializable)id -> Utils.calculateKey(id.data()), Set$.MODULE$.canBuildFrom())).toList()).asJava();
            Predef$.MODULE$.require(this.merkleTreeWrapper().removeLeaves((long[])((TraversableOnce)boxesToRemoveSet.flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(this.getLeafInfo(id.data()).map((Function1 & Serializable & scala.Serializable)leafInfo -> BoxesRunTime.boxToLong((long)leafInfo.position()))), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long())), (Function0 & Serializable & scala.Serializable)() -> "Failed to remove leaves from UtxoMerkleTree");
            Seq newLeavesPositions = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.merkleTreeWrapper().leftmostEmptyPositions(boxesToAppend.size())).asScala()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)), Buffer$.MODULE$.canBuildFrom());
            if (newLeavesPositions.size() != boxesToAppend.size()) {
                throw new IllegalStateException("Not enough empty leaves in the UTXOMerkleTree.");
            }
            Seq leavesToAppend = (Seq)((IterableLike)boxesToAppend.map((Function1 & Serializable & scala.Serializable)box -> new Tuple2((Object)Utils.calculateKey(box.id()), (Object)this.calculateLeaf((Box<Proposition>)box)), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)newLeavesPositions, Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.require(this.merkleTreeWrapper().addLeaves((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)leavesToAppend.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FieldElement leaf;
                long position;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        position = tuple2._2$mcJ$sp();
                        if (tuple22 != null && (leaf = (FieldElement)tuple22._2()) != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                FieldElement fieldElement = leaf;
                long l = position;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.long2Long(l)), (Object)fieldElement);
                return tuple2;
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), (Function0 & Serializable & scala.Serializable)() -> "Failed to add leaves to UtxoMerkleTree");
            java.util.List updateList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leavesToAppend.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ByteArrayWrapper byteArrayWrapper;
                FieldElement leaf;
                long position;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$2;
                        if (tuple2 == null) break block2;
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        position = tuple2._2$mcJ$sp();
                        if (tuple22 == null) break block2;
                        ByteArrayWrapper key = (ByteArrayWrapper)tuple22._1();
                        leaf = (FieldElement)tuple22._2();
                        if (key == null) break block2;
                        byteArrayWrapper = key;
                        if (leaf != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                FieldElement fieldElement = leaf;
                long l = position;
                byte[] leafBytes = fieldElement.serializeFieldElement();
                fieldElement.freeFieldElement();
                Pair<ByteArrayWrapper, ByteArrayWrapper> pair = new Pair<ByteArrayWrapper, ByteArrayWrapper>(byteArrayWrapper, new ByteArrayWrapper(new UtxoMerkleTreeLeafInfo(leafBytes, l).bytes()));
                return pair;
            }, Seq$.MODULE$.canBuildFrom())).asJava();
            $this.storage.update(version, updateList, removeList);
            return this;
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SidechainStateUtxoMerkleTreeStorage $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.merkleTreeWrapper().close();
                this.$outer.merkleTreeWrapper_$eq(this.$outer.com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree());
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<SidechainStateUtxoMerkleTreeStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            this.merkleTreeWrapper().close();
            this.merkleTreeWrapper_$eq(this.com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree());
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$loadMerkleTree$2(Tuple2 x$1) {
        ((FieldElement)x$1._2()).close();
    }

    public SidechainStateUtxoMerkleTreeStorage(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        this.merkleTreeWrapper = this.com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree();
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
    }
}

