/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.secret;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.cryptolibprovider.utils.SchnorrFunctions;
import com.horizen.node.NodeWallet;
import com.horizen.secret.SchnorrSecret;
import com.horizen.secret.Secret;
import com.horizen.secret.SecretCreator;
import java.util.EnumMap;
import java.util.List;
import scorex.crypto.hash.Blake2b256;

public class SchnorrKeyGenerator
implements SecretCreator<SchnorrSecret> {
    private static SchnorrKeyGenerator instance = new SchnorrKeyGenerator();

    private SchnorrKeyGenerator() {
    }

    public static SchnorrKeyGenerator getInstance() {
        return instance;
    }

    @Override
    public SchnorrSecret generateSecret(byte[] seed) {
        EnumMap<SchnorrFunctions.KeyType, byte[]> keys = CryptoLibProvider.schnorrFunctions().generateSchnorrKeys(seed);
        return new SchnorrSecret(keys.get((Object)SchnorrFunctions.KeyType.SECRET), keys.get((Object)SchnorrFunctions.KeyType.PUBLIC));
    }

    @Override
    public SchnorrSecret generateNextSecret(NodeWallet wallet) {
        List<Secret> prevSecrets = wallet.secretsOfType(SchnorrSecret.class);
        byte[] nonce = Ints.toByteArray((int)prevSecrets.size());
        byte[] seed = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{wallet.walletSeed(), nonce}));
        return this.generateSecret(seed);
    }
}

