/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider.utils;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.UnmodifiableIterator;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.merkletreenative.InMemorySparseMerkleTree;
import com.horizen.merkletreenative.MerklePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InMemorySparseMerkleTreeWrapper
implements AutoCloseable {
    private final Logger log = LogManager.getLogger((String)this.getClass().getName());
    private final InMemorySparseMerkleTree merkleTree;
    private final long leavesNumber;
    private final RangeSet<Long> emptyLeaves;

    public InMemorySparseMerkleTreeWrapper(int height) {
        this.merkleTree = InMemorySparseMerkleTree.init((int)height);
        this.leavesNumber = 1L << height;
        this.emptyLeaves = TreeRangeSet.create(Arrays.asList(Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(this.leavesNumber))));
    }

    public List<Long> leftmostEmptyPositions(long atMost) {
        if (atMost <= 0L) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> emptyPositions = new ArrayList<Long>();
        for (Range range : this.emptyLeaves.asRanges()) {
            UnmodifiableIterator unmodifiableIterator = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.longs()).iterator();
            while (unmodifiableIterator.hasNext()) {
                long emptyPos = (Long)unmodifiableIterator.next();
                emptyPositions.add(emptyPos);
                if ((long)emptyPositions.size() != atMost) continue;
                return emptyPositions;
            }
        }
        return emptyPositions;
    }

    public boolean isLeafEmpty(long pos) {
        return this.emptyLeaves.contains((Comparable)Long.valueOf(pos));
    }

    public long leavesNumber() {
        return this.leavesNumber;
    }

    public boolean addLeaves(Map<Long, FieldElement> leaves) {
        for (Long pos : leaves.keySet()) {
            if (this.emptyLeaves.contains((Comparable)pos)) continue;
            return false;
        }
        try {
            this.merkleTree.addLeaves(leaves);
        }
        catch (Exception e) {
            this.log.error("Failed to add leaves to InMemorySparseMerkleTree", (Throwable)e);
            return false;
        }
        for (Long pos : leaves.keySet()) {
            this.emptyLeaves.remove(Range.singleton((Comparable)pos));
        }
        return true;
    }

    public boolean removeLeaves(long[] positions) {
        HashSet<Long> positionSet = new HashSet<Long>();
        for (long pos : positions) {
            if (pos < 0L || pos >= this.leavesNumber() || this.isLeafEmpty(pos)) {
                return false;
            }
            positionSet.add(pos);
        }
        try {
            this.merkleTree.removeLeaves(positionSet);
        }
        catch (Exception e) {
            this.log.error("Failed to remove leaves from InMemorySparseMerkleTree", (Throwable)e);
            return false;
        }
        for (long pos : positions) {
            this.emptyLeaves.add(Range.closedOpen((Comparable)Long.valueOf(pos), (Comparable)Long.valueOf(pos + 1L)));
        }
        return true;
    }

    public byte[] calculateRoot() {
        try {
            this.merkleTree.finalizeInPlace();
            FieldElement root = this.merkleTree.root();
            byte[] rootBytes = root.serializeFieldElement();
            root.freeFieldElement();
            return rootBytes;
        }
        catch (Exception e) {
            this.log.error("Failed to calculate root of InMemorySparseMerkleTree", (Throwable)e);
            return null;
        }
    }

    public byte[] merklePath(long pos) {
        try {
            this.merkleTree.finalizeInPlace();
            MerklePath mp = this.merkleTree.getMerklePath(pos);
            byte[] mpBytes = mp.serialize();
            mp.freeMerklePath();
            return mpBytes;
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to calculate merkle path of InMemorySparseMerkleTree at pos %d", pos), (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        this.merkleTree.close();
    }
}

