/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider.utils;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.poseidonnative.PoseidonHash;

public class CumulativeHashFunctions {
    public static int hashLength() {
        return Constants.FIELD_ELEMENT_LENGTH();
    }

    public static byte[] computeCumulativeHash(byte[] prevCumulativeHash, byte[] hashScTxsCommitment) {
        FieldElement fieldElementA = null;
        FieldElement fieldElementB = null;
        FieldElement fieldElementHash = null;
        PoseidonHash digest = null;
        try {
            fieldElementA = FieldElement.deserialize((byte[])prevCumulativeHash);
            fieldElementB = FieldElement.deserialize((byte[])hashScTxsCommitment);
            digest = PoseidonHash.getInstanceConstantLength((int)2);
            digest.update(fieldElementA);
            digest.update(fieldElementB);
            fieldElementHash = digest.finalizeHash();
            byte[] byArray = fieldElementHash.serializeFieldElement();
            return byArray;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error on computing Cumulative Commitment Tree Hash:" + ex.getMessage(), ex);
        }
        finally {
            if (fieldElementA != null) {
                fieldElementA.freeFieldElement();
            }
            if (fieldElementB != null) {
                fieldElementB.freeFieldElement();
            }
            if (fieldElementHash != null) {
                fieldElementHash.freeFieldElement();
            }
            if (digest != null) {
                digest.freePoseidonHash();
            }
        }
    }
}

