/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider;

import com.horizen.block.WithdrawalEpochCertificate;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.certnative.BackwardTransfer;
import com.horizen.certnative.WithdrawalCertificate;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.proposition.MCPublicKeyHashProposition;
import com.horizen.provingsystemnative.ProvingSystem;
import com.horizen.provingsystemnative.ProvingSystemType;
import com.horizen.schnorrnative.SchnorrSignature;
import com.horizen.utils.BytesUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import scala.Enumeration;
import scala.collection.JavaConverters;

public class CommonCircuit {
    private static final int maxSegmentSize = 262144;
    public static final int maxProofPlusVkSize = 9216;
    public static final int CUSTOM_FIELDS_NUMBER_WITH_ENABLED_CSW = 2;
    public static final int CUSTOM_FIELDS_NUMBER_WITH_DISABLED_CSW_NO_KEY_ROTATION = 0;
    public static final int CUSTOM_FIELDS_NUMBER_WITH_DISABLED_CSW_WITH_KEY_ROTATION = 32;

    public boolean generateCoboundaryMarlinDLogKeys() {
        return ProvingSystem.generateDLogKeys((ProvingSystemType)ProvingSystemType.COBOUNDARY_MARLIN, (int)262144);
    }

    public String getCoboundaryMarlinSnarkVerificationKeyHex(String verificationKeyPath) {
        if (!Files.exists(Paths.get(verificationKeyPath, new String[0]), new LinkOption[0])) {
            return "";
        }
        try {
            return BytesUtils.toHexString(Files.readAllBytes(Paths.get(verificationKeyPath, new String[0])));
        }
        catch (IOException e) {
            return "";
        }
    }

    public static WithdrawalCertificate createWithdrawalCertificate(WithdrawalEpochCertificate cert, Enumeration.Value sidechainCreationVersion) {
        return new WithdrawalCertificate(FieldElement.deserialize((byte[])cert.sidechainId()), cert.epochNumber(), JavaConverters.seqAsJavaList(cert.backwardTransferOutputs()).stream().map(bto -> new BackwardTransfer(bto.pubKeyHash(), bto.amount())).collect(Collectors.toList()), cert.quality(), FieldElement.deserialize((byte[])cert.endCumulativeScTxCommitmentTreeRoot()), cert.ftMinAmount(), cert.btrFee(), Arrays.stream((byte[][])cert.customFieldsOpt(sidechainCreationVersion).get()).map(FieldElement::deserialize).collect(Collectors.toList()));
    }

    public static List<SchnorrSignature> getSignatures(List<Optional<byte[]>> schnorrSignatureBytesList) {
        return schnorrSignatureBytesList.stream().map(signatureBytesOpt -> signatureBytesOpt.map(SchnorrSignature::deserialize).orElse(new SchnorrSignature())).collect(Collectors.toList());
    }

    public static List<BackwardTransfer> getBackwardTransfers(List<WithdrawalRequestBox> withdrawalRequestBoxes) {
        return withdrawalRequestBoxes.stream().map(box -> new BackwardTransfer(((MCPublicKeyHashProposition)box.proposition()).bytes(), box.value())).collect(Collectors.toList());
    }
}

