/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.consensus;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.consensus.NonceConsensusEpochInfo;
import com.horizen.consensus.package$ConsensusAbsoluteSlotNumber$;
import com.horizen.consensus.package$ConsensusEpochId$;
import com.horizen.consensus.package$ConsensusEpochNumber$;
import com.horizen.consensus.package$ConsensusNonce$;
import com.horizen.consensus.package$ConsensusSlotNumber$;
import com.horizen.consensus.package$VrfMessage$;
import com.horizen.cryptolibprovider.CryptoLibProvider$;
import com.horizen.cryptolibprovider.utils.FieldElementUtils;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.poseidonnative.PoseidonHash;
import com.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scorex.util.package;
import supertagged.package;

public final class package$ {
    public static package$ MODULE$;
    private final int merkleTreeHashLen;
    private final int sha256HashLen;
    private final Seq<Object> consensusNonceAllowedLengths;
    private final byte[] consensusHardcodedSaltString;
    private final int consensusPreForkLength;
    private final BigDecimal forgerStakePercentPrecision;
    private final MathContext stakeConsensusDivideMathContext;

    static {
        new package$();
    }

    public int merkleTreeHashLen() {
        return this.merkleTreeHashLen;
    }

    public int sha256HashLen() {
        return this.sha256HashLen;
    }

    public Seq<Object> consensusNonceAllowedLengths() {
        return this.consensusNonceAllowedLengths;
    }

    public byte[] consensusHardcodedSaltString() {
        return this.consensusHardcodedSaltString;
    }

    public int consensusPreForkLength() {
        return this.consensusPreForkLength;
    }

    public BigDecimal forgerStakePercentPrecision() {
        return this.forgerStakePercentPrecision;
    }

    public MathContext stakeConsensusDivideMathContext() {
        return this.stakeConsensusDivideMathContext;
    }

    public int intToConsensusEpochNumber(int consensusEpochNumber) {
        return BoxesRunTime.unboxToInt((Object)package$ConsensusEpochNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)consensusEpochNumber), package.Tagger$.MODULE$.baseRaw()));
    }

    public String blockIdToEpochId(String blockId) {
        return (String)package$ConsensusEpochId$.MODULE$.$at$at(blockId, package.Tagger$.MODULE$.baseTagged());
    }

    public String lastBlockIdInEpochId(String epochId) {
        return (String)package.ModifierId$.MODULE$.$at$at(package.PostfixSugar$.MODULE$.untag$extension(supertagged.package$.MODULE$.PostfixSugar((Object)epochId), (package.TaggedType)package$ConsensusEpochId$.MODULE$, package.Tagger$.MODULE$.baseTagged()), package.Tagger$.MODULE$.baseRaw());
    }

    public int intToConsensusSlotNumber(int consensusSlotNumber) {
        return BoxesRunTime.unboxToInt((Object)package$ConsensusSlotNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)consensusSlotNumber), package.Tagger$.MODULE$.baseRaw()));
    }

    public int intToConsensusAbsoluteSlotNumber(int consensusSlotNumber) {
        return BoxesRunTime.unboxToInt((Object)package$ConsensusAbsoluteSlotNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)consensusSlotNumber), package.Tagger$.MODULE$.baseRaw()));
    }

    public byte[] byteArrayToConsensusNonce(byte[] bytes) {
        return (byte[])package$ConsensusNonce$.MODULE$.$at$at(bytes, package.Tagger$.MODULE$.baseRaw());
    }

    public byte[] buildVrfMessage(int slotNumber, NonceConsensusEpochInfo nonce) {
        byte[] byArray;
        byte[] slotNumberBytes = Ints.toByteArray((int)slotNumber);
        byte[] nonceBytes = nonce.consensusNonce();
        byte[] resBytes = Bytes.concat((byte[][])new byte[][]{slotNumberBytes, nonceBytes, this.consensusHardcodedSaltString()});
        if (resBytes.length > this.consensusPreForkLength()) {
            Tuple2 nonceBytesHalves = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(nonceBytes)).splitAt(nonceBytes.length / 2);
            byArray = (byte[])package$VrfMessage$.MODULE$.$at$at(this.generateHashAndCleanUp((Seq<byte[]>)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{slotNumberBytes, (byte[])nonceBytesHalves._1(), (byte[])nonceBytesHalves._2(), this.consensusHardcodedSaltString()})), package.Tagger$.MODULE$.baseRaw());
        } else {
            byArray = (byte[])package$VrfMessage$.MODULE$.$at$at(resBytes, package.Tagger$.MODULE$.baseRaw());
        }
        return byArray;
    }

    private byte[] generateHashAndCleanUp(Seq<byte[]> elements) {
        PoseidonHash digest = PoseidonHash.getInstanceConstantLength((int)elements.length());
        elements.foreach((Function1 & Serializable & scala.Serializable)message -> {
            package$.$anonfun$generateHashAndCleanUp$1(digest, message);
            return BoxedUnit.UNIT;
        });
        FieldElement hash = digest.finalizeHash();
        byte[] result = hash.serializeFieldElement();
        digest.freePoseidonHash();
        hash.freeFieldElement();
        return result;
    }

    public BigInteger vrfOutputToPositiveBigInteger(VrfOutput vrfOutput) {
        return new BigInteger(1, vrfOutput.bytes());
    }

    public boolean vrfProofCheckAgainstStake(VrfOutput vrfOutput, long actualStake, long totalStake, boolean stakePercentageFork) {
        boolean bl;
        BigDecimal requiredStakePercentage = this.vrfOutputToRequiredStakePercentage(vrfOutput, stakePercentageFork);
        BigDecimal actualStakePercentage = new BigDecimal(actualStake).divide(new BigDecimal(totalStake), this.stakeConsensusDivideMathContext());
        int n = requiredStakePercentage.compareTo(actualStakePercentage);
        switch (n) {
            case -1: {
                bl = true;
                break;
            }
            case 0: {
                bl = true;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public BigDecimal vrfOutputToRequiredStakePercentage(VrfOutput vrfOutput, boolean stakePercentageFork) {
        BigDecimal bigDecimal;
        BigDecimal hashAsBigDecimal = new BigDecimal(this.vrfOutputToPositiveBigInteger(vrfOutput));
        if (stakePercentageFork) {
            BigDecimal maximumValue = new BigDecimal(2).pow(CryptoLibProvider$.MODULE$.vrfFunctions().vrfOutputLen() * 8);
            bigDecimal = hashAsBigDecimal.divide(maximumValue, this.stakeConsensusDivideMathContext()).max(new BigDecimal(1).divide(this.forgerStakePercentPrecision()));
        } else {
            bigDecimal = hashAsBigDecimal.remainder(this.forgerStakePercentPrecision()).divide(this.forgerStakePercentPrecision(), this.stakeConsensusDivideMathContext());
        }
        return bigDecimal;
    }

    public static final /* synthetic */ void $anonfun$generateHashAndCleanUp$1(PoseidonHash digest$1, byte[] message) {
        FieldElement fieldElement = FieldElementUtils.messageToFieldElement(message);
        digest$1.update(fieldElement);
        fieldElement.freeFieldElement();
    }

    private package$() {
        MODULE$ = this;
        this.merkleTreeHashLen = 32;
        this.sha256HashLen = 32;
        this.consensusNonceAllowedLengths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 32}));
        this.consensusHardcodedSaltString = "TEST".getBytes();
        this.consensusPreForkLength = 12 + this.consensusHardcodedSaltString().length;
        this.forgerStakePercentPrecision = BigDecimal.valueOf(1000000L);
        this.stakeConsensusDivideMathContext = MathContext.DECIMAL128;
    }
}

