/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.consensus;

import com.horizen.consensus.NonceConsensusEpochInfo;
import com.horizen.consensus.NonceConsensusEpochInfoSerializer$;
import com.horizen.consensus.StakeConsensusEpochInfo;
import com.horizen.consensus.StakeConsensusEpochInfoSerializer$;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0003\u0007\u0001'!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0003K\u0001\u0011\u00051\nC\u0003S\u0001\u0011\u00051\u000bC\u0003W\u0001\u0011%q\u000bC\u0003`\u0001\u0011%\u0001\rC\u0003c\u0001\u0011%1\rC\u0003o\u0001\u0011\u0005sN\u0001\u000bD_:\u001cXM\\:vg\u0012\u000bG/Y*u_J\fw-\u001a\u0006\u0003\u001b9\t\u0011bY8og\u0016t7/^:\u000b\u0005=\u0001\u0012a\u00025pe&TXM\u001c\u0006\u0002#\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u0006\u000e#!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005kRLGNC\u0001 \u0003\u0019\u00198m\u001c:fq&\u0011\u0011\u0005\b\u0002\u000e'\u000e|'/\u001a=M_\u001e<\u0017N\\4\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015r\u0011aB:u_J\fw-Z\u0005\u0003O\u0011\u0012AcU5eK\u000eD\u0017-\u001b8Ti>\u0014\u0018mZ3J]\u001a|\u0017!G2p]N,gn];t\u000bB|7\r[%oM>\u001cFo\u001c:bO\u0016\u0004\"a\t\u0016\n\u0005-\"#aB*u_J\fw-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059\u0002\u0004CA\u0018\u0001\u001b\u0005a\u0001\"\u0002\u0015\u0003\u0001\u0004I\u0013AG1eIN#\u0018m[3D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|GcA\u001a7\u007fA\u0011Q\u0003N\u0005\u0003kY\u0011A!\u00168ji\")qg\u0001a\u0001q\u00059Q\r]8dQ&#\u0007CA\u001d=\u001d\ty#(\u0003\u0002<\u0019\u00059\u0001/Y2lC\u001e,\u0017BA\u001f?\u0005A\u0019uN\\:f]N,8/\u00129pG\"LEM\u0003\u0002<\u0019!)\u0001i\u0001a\u0001\u0003\u0006q1\u000f^1lK\u0016\u0003xn\u00195J]\u001a|\u0007CA\u0018C\u0013\t\u0019EBA\fTi\u0006\\WmQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_\u0006Qr-\u001a;Ti\u0006\\WmQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_R\u0011a)\u0013\t\u0004+\u001d\u000b\u0015B\u0001%\u0017\u0005\u0019y\u0005\u000f^5p]\")q\u0007\u0002a\u0001q\u0005Q\u0012\r\u001a3O_:\u001cWmQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_R\u00191\u0007T'\t\u000b]*\u0001\u0019\u0001\u001d\t\u000b9+\u0001\u0019A(\u0002\u001d\r|gn]3ogV\u001chj\u001c8dKB\u0011q\u0006U\u0005\u0003#2\u0011qCT8oG\u0016\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\u00025\u001d,GOT8oG\u0016\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\u0015\u0005Q+\u0006cA\u000bH\u001f\")qG\u0002a\u0001q\u0005\t2\u000f^1lK\u0016\u0003xn\u00195J]\u001a|7*Z=\u0015\u0005as\u0006CA-]\u001b\u0005Q&BA.\u000f\u0003\u0015)H/\u001b7t\u0013\ti&L\u0001\tCsR,\u0017I\u001d:bs^\u0013\u0018\r\u001d9fe\")qg\u0002a\u0001q\u0005\tbn\u001c8dK\u0016\u0003xn\u00195J]\u001a|7*Z=\u0015\u0005a\u000b\u0007\"B\u001c\t\u0001\u0004A\u0014\u0001C1eI\u0016sGO]=\u0015\u0007M\"g\rC\u0003f\u0013\u0001\u0007\u0001,A\u0002lKfDQaZ\u0005A\u0002!\fQA^1mk\u0016\u00042!F5l\u0013\tQgCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0016Y&\u0011QN\u0006\u0002\u0005\u0005f$X-A\u0007mCN$h+\u001a:tS>t\u0017\nZ\u000b\u0002aB\u0019Qc\u0012-")
public class ConsensusDataStorage
implements ScorexLogging,
SidechainStorageInfo {
    private final Storage consensusEpochInfoStorage;
    private final Logger logger;

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void addStakeConsensusEpochInfo(String epochId, StakeConsensusEpochInfo stakeEpochInfo) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Storage with id:{} -- Add stake to consensus data storage: for epochId {} stake info: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode()), epochId, stakeEpochInfo});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(this.getStakeConsensusEpochInfo(epochId).forall((Function1 & Serializable & scala.Serializable)stakeInfo -> BoxesRunTime.boxToBoolean((boolean)stakeInfo.equals(stakeEpochInfo))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("StakeConsensusEpochInfo shall not be redefined for epoch ").append(epochId).toString());
        this.addEntry(this.stakeEpochInfoKey(epochId), StakeConsensusEpochInfoSerializer$.MODULE$.toBytes(stakeEpochInfo));
    }

    public Option<StakeConsensusEpochInfo> getStakeConsensusEpochInfo(String epochId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.get(this.stakeEpochInfoKey(epochId)))).map((Function1 & Serializable & scala.Serializable)byteArray -> (StakeConsensusEpochInfo)StakeConsensusEpochInfoSerializer$.MODULE$.parseBytes(byteArray.data()));
    }

    public void addNonceConsensusEpochInfo(String epochId, NonceConsensusEpochInfo consensusNonce) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Storage with id:{} -- Add nonce to consensus data storage: for epochId {} nonce info: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode()), epochId, consensusNonce});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(this.getNonceConsensusEpochInfo(epochId).forall((Function1 & Serializable & scala.Serializable)nonceInfo -> BoxesRunTime.boxToBoolean((boolean)nonceInfo.equals(consensusNonce))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("NonceConsensusEpochInfo shall not be redefined for epoch ").append(epochId).toString());
        this.addEntry(this.nonceEpochInfoKey(epochId), NonceConsensusEpochInfoSerializer$.MODULE$.toBytes(consensusNonce));
    }

    public Option<NonceConsensusEpochInfo> getNonceConsensusEpochInfo(String epochId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.get(this.nonceEpochInfoKey(epochId)))).map((Function1 & Serializable & scala.Serializable)byteArray -> (NonceConsensusEpochInfo)NonceConsensusEpochInfoSerializer$.MODULE$.parseBytes(byteArray.data()));
    }

    private ByteArrayWrapper stakeEpochInfoKey(String epochId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("stake").append(epochId).toString()));
    }

    private ByteArrayWrapper nonceEpochInfoKey(String epochId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("nonce").append(epochId).toString()));
    }

    private void addEntry(ByteArrayWrapper key, byte[] value) {
        BoxedUnit boxedUnit;
        ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> listForUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
        Pair<ByteArrayWrapper, ByteArrayWrapper> addedData = new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, new ByteArrayWrapper(value));
        listForUpdate.add(addedData);
        ByteArrayWrapper version = new ByteArrayWrapper(Utils.nextVersion());
        this.consensusEpochInfoStorage.update(version, listForUpdate, Collections.emptyList());
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug(new StringBuilder(45).append("Consensus data storage updated with version: ").append(version).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.lastVersionID()));
    }

    public ConsensusDataStorage(Storage consensusEpochInfoStorage) {
        this.consensusEpochInfoStorage = consensusEpochInfoStorage;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainStorageInfo.$init$(this);
    }
}

