/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.certificatesubmitter.strategies;

import com.horizen.SidechainHistory;
import com.horizen.SidechainMemoryPool;
import com.horizen.SidechainSettings;
import com.horizen.SidechainState;
import com.horizen.SidechainWallet;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.certificatesubmitter.CertificateSubmitter;
import com.horizen.certificatesubmitter.dataproof.CertificateDataWithoutKeyRotation;
import com.horizen.certificatesubmitter.strategies.CircuitStrategy;
import com.horizen.cryptolibprovider.ThresholdSignatureCircuit;
import com.horizen.params.NetworkParams;
import com.horizen.proof.SchnorrProof;
import com.horizen.proposition.SchnorrProposition;
import com.horizen.utils.Pair;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewHolder;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0005\u000b\u0001MA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u00037\u0001\u0011\u0005s\u0007C\u0003_\u0001\u0011\u0005s\fC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\b\u0001!I!!\u0003\u0003C]KG\u000f[8vi.+\u0017PU8uCRLwN\\\"je\u000e,\u0018\u000e^*ue\u0006$XmZ=\u000b\u0005-a\u0011AC:ue\u0006$XmZ5fg*\u0011QBD\u0001\u0015G\u0016\u0014H/\u001b4jG\u0006$Xm];c[&$H/\u001a:\u000b\u0005=\u0001\u0012a\u00025pe&TXM\u001c\u0006\u0002#\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0004+YAR\"\u0001\u0006\n\u0005]Q!aD\"je\u000e,\u0018\u000e^*ue\u0006$XmZ=\u0011\u0005eaR\"\u0001\u000e\u000b\u0005ma\u0011!\u00033bi\u0006\u0004(o\\8g\u0013\ti\"DA\u0011DKJ$\u0018NZ5dCR,G)\u0019;b/&$\bn\\;u\u0017\u0016L(k\u001c;bi&|g.\u0001\u0005tKR$\u0018N\\4t!\t\u0001\u0013%D\u0001\u000f\u0013\t\u0011cBA\tTS\u0012,7\r[1j]N+G\u000f^5oON\fa\u0001]1sC6\u001c\bCA\u0013(\u001b\u00051#BA\u0012\u000f\u0013\tAcEA\u0007OKR<xN]6QCJ\fWn]\u0001\u0011GJL\b\u000f^8mS\n\u001c\u0015N]2vSR\u0004\"a\u000b\u0018\u000e\u00031R!!\f\b\u0002#\r\u0014\u0018\u0010\u001d;pY&\u0014\u0007O]8wS\u0012,'/\u0003\u00020Y\tIB\u000b\u001b:fg\"|G\u000eZ*jO:\fG/\u001e:f\u0007&\u00148-^5u\u0003\u0019a\u0014N\\5u}Q!!g\r\u001b6!\t)\u0002\u0001C\u0003\u001f\t\u0001\u0007q\u0004C\u0003$\t\u0001\u0007A\u0005C\u0003*\t\u0001\u0007!&A\u0007hK:,'/\u0019;f!J|wN\u001a\u000b\u0004q=\u000b\u0006\u0003B\u001d=}\u001dk\u0011A\u000f\u0006\u0003w9\tQ!\u001e;jYNL!!\u0010\u001e\u0003\tA\u000b\u0017N\u001d\t\u0004\u007f\t#U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\u000b\u0005\u0013(/Y=\u0011\u0005}*\u0015B\u0001$A\u0005\u0011\u0011\u0015\u0010^3\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001\u00027b]\u001eT\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u0013\n!Aj\u001c8h\u0011\u0015\u0001V\u00011\u0001\u0019\u0003=\u0019WM\u001d;jM&\u001c\u0017\r^3ECR\f\u0007\"\u0002*\u0006\u0001\u0004\u0019\u0016a\u00069s_ZLgn\u001a$jY\u0016\f%m]8mkR,\u0007+\u0019;i!\t!6L\u0004\u0002V3B\u0011a\u000bQ\u0007\u0002/*\u0011\u0001LE\u0001\u0007yI|w\u000e\u001e \n\u0005i\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!A\u0017!\u0002)\t,\u0018\u000e\u001c3DKJ$\u0018NZ5dCR,G)\u0019;b)\rA\u0002M\u001a\u0005\u0006C\u001a\u0001\rAY\u0001\u0012g&$Wm\u00195bS:tu\u000eZ3WS\u0016<\bCA2e\u001b\u0005\u0001\u0011BA3\u0017\u0005\u00111\u0016.Z<\t\u000b\u001d4\u0001\u0019\u00015\u0002\rM$\u0018\r^;t!\tI'O\u0004\u0002ka:\u00111n\u001c\b\u0003Y:t!AV7\n\u0003EI!a\u0004\t\n\u00055q\u0011BA9\r\u0003Q\u0019UM\u001d;jM&\u001c\u0017\r^3Tk\nl\u0017\u000e\u001e;fe&\u00111\u000f\u001e\u0002\u0011'&<g.\u0019;ve\u0016\u001c8\u000b^1ukNT!!\u001d\u0007\u0002!\u001d,G/T3tg\u0006<W\rV8TS\u001etGcA<~}B\u0019\u0001p\u001f \u000e\u0003eT!A\u001f!\u0002\tU$\u0018\u000e\\\u0005\u0003yf\u00141\u0001\u0016:z\u0011\u0015\tw\u00011\u0001c\u0011\u0019yx\u00011\u0001\u0002\u0002\u0005y\"/\u001a4fe\u0016t7-\u001a3XSRDGM]1xC2,\u0005o\\2i\u001dVl'-\u001a:\u0011\u0007}\n\u0019!C\u0002\u0002\u0006\u0001\u00131!\u00138u\u0003U9W\r^+uq>lUM]6mKR\u0013X-\u001a*p_R$b!a\u0003\u0002\u0012\u0005M\u0001\u0003B \u0002\u000eyJ1!a\u0004A\u0005\u0019y\u0005\u000f^5p]\"1q\u0010\u0003a\u0001\u0003\u0003Aq!!\u0006\t\u0001\u0004\t9\"A\u0003ti\u0006$X\rE\u0002!\u00033I1!a\u0007\u000f\u00059\u0019\u0016\u000eZ3dQ\u0006Lgn\u0015;bi\u0016\u0004")
public class WithoutKeyRotationCircuitStrategy
extends CircuitStrategy<CertificateDataWithoutKeyRotation> {
    private final NetworkParams params;
    private final ThresholdSignatureCircuit cryptolibCircuit;

    @Override
    public Pair<byte[], Long> generateProof(CertificateDataWithoutKeyRotation certificateData, String provingFileAbsolutePath) {
        BoxedUnit boxedUnit;
        Seq seq;
        Seq signaturesBytes;
        block6: {
            Tuple2 tuple2;
            block5: {
                tuple2 = ((GenericTraversableTemplate)certificateData.schnorrKeyPairs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SchnorrProposition proposition = (SchnorrProposition)tuple2._1();
                    Option proof = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)proposition.bytes(), (Object)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(proof.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.bytes()))));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple2 == null) break block5;
                Seq signersPublicKeysBytes = (Seq)tuple2._1();
                signaturesBytes = (Seq)tuple2._2();
                if (signersPublicKeysBytes == null) break block5;
                seq = signersPublicKeysBytes;
                if (signaturesBytes != null) break block6;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq2 = signaturesBytes;
        Tuple2 tuple2 = new Tuple2((Object)seq, (Object)seq2);
        Tuple2 tuple22 = tuple2;
        Seq signersPublicKeysBytes = (Seq)tuple22._1();
        Seq signaturesBytes2 = (Seq)tuple22._2();
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info(new StringBuilder(101).append("Start generating proof with parameters: certificateData = ").append(certificateData).append(", ").append("signersThreshold = ").append(this.params.signersThreshold()).append(". ").append("It can take a while.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.cryptolibCircuit.createProof((List)JavaConverters$.MODULE$.seqAsJavaListConverter(certificateData.withdrawalRequests()).asJava(), certificateData.sidechainId(), certificateData.referencedEpochNumber(), certificateData.endEpochCumCommTreeHash(), certificateData.btrFee(), certificateData.ftMinAmount(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(certificateData.utxoMerkleTreeRoot())), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(signaturesBytes2).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(signersPublicKeysBytes).asJava(), this.params.signersThreshold(), provingFileAbsolutePath, true, true);
    }

    @Override
    public CertificateDataWithoutKeyRotation buildCertificateData(NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool> sidechainNodeView, CertificateSubmitter.SignaturesStatus status) {
        SidechainHistory history = (SidechainHistory)sidechainNodeView.history();
        SidechainState state = (SidechainState)sidechainNodeView.state();
        Seq<WithdrawalRequestBox> withdrawalRequests = state.withdrawalRequests(status.referencedEpoch());
        long btrFee = this.getBtrFee(status.referencedEpoch());
        int consensusEpochNumber = this.lastConsensusEpochNumberForWithdrawalEpochNumber(history, state, status.referencedEpoch());
        long ftMinAmount = this.getFtMinAmount(consensusEpochNumber);
        byte[] endEpochCumCommTreeHash = this.lastMainchainBlockCumulativeCommTreeHashForWithdrawalEpochNumber(history, state, status.referencedEpoch());
        byte[] sidechainId = this.params.sidechainId();
        Option<byte[]> utxoMerkleTreeRoot = this.getUtxoMerkleTreeRoot(status.referencedEpoch(), state);
        Seq signersPublicKeyWithSignatures = (Seq)((TraversableLike)this.params.signersPublicKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SchnorrProposition pubKey = (SchnorrProposition)tuple2._1();
            int pubKeyIndex = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)pubKey, (Object)status.knownSigs().find((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)WithoutKeyRotationCircuitStrategy.$anonfun$buildCertificateData$2(pubKeyIndex, info))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.signature()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        return new CertificateDataWithoutKeyRotation(status.referencedEpoch(), sidechainId, withdrawalRequests, endEpochCumCommTreeHash, btrFee, ftMinAmount, (Seq<Tuple2<SchnorrProposition, Option<SchnorrProof>>>)signersPublicKeyWithSignatures, utxoMerkleTreeRoot);
    }

    @Override
    public Try<byte[]> getMessageToSign(NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool> sidechainNodeView, int referencedWithdrawalEpochNumber) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option value;
            SidechainHistory history = (SidechainHistory)sidechainNodeView.history();
            SidechainState state = (SidechainState)sidechainNodeView.state();
            Seq<WithdrawalRequestBox> withdrawalRequests = state.withdrawalRequests(referencedWithdrawalEpochNumber);
            long btrFee = this.getBtrFee(referencedWithdrawalEpochNumber);
            int consensusEpochNumber = this.lastConsensusEpochNumberForWithdrawalEpochNumber(history, state, referencedWithdrawalEpochNumber);
            long ftMinAmount = this.getFtMinAmount(consensusEpochNumber);
            byte[] endEpochCumCommTreeHash = this.lastMainchainBlockCumulativeCommTreeHashForWithdrawalEpochNumber(history, state, referencedWithdrawalEpochNumber);
            byte[] sidechainId = $this.params.sidechainId();
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getUtxoMerkleTreeRoot(referencedWithdrawalEpochNumber, state));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (e instanceof IllegalStateException) {
                    throw new Exception(new StringBuilder(116).append("CertificateSubmitter is too late against the State. ").append("No utxo merkle tree root for requested epoch ").append(referencedWithdrawalEpochNumber).append(". ").append("Current epoch is ").append(state.getWithdrawalEpochInfo().epoch()).toString());
                }
            }
            if (bl) {
                BoxedUnit boxedUnit;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Exception while getting utxoMerkleTreeRoot", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new Exception(exception);
            }
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Option option = value = (Option)success.value();
            Option utxoMerkleTreeRoot = option;
            return $this.cryptolibCircuit.generateMessageToBeSigned((List)JavaConverters$.MODULE$.seqAsJavaListConverter(withdrawalRequests).asJava(), sidechainId, referencedWithdrawalEpochNumber, endEpochCumCommTreeHash, btrFee, ftMinAmount, Optional.ofNullable(utxoMerkleTreeRoot.orNull(Predef$.MODULE$.$conforms())));
        });
    }

    private Option<byte[]> getUtxoMerkleTreeRoot(int referencedWithdrawalEpochNumber, SidechainState state) {
        Option option;
        if (this.params.isCSWEnabled()) {
            Some some;
            Option<byte[]> option2 = state.utxoMerkleTreeRoot(referencedWithdrawalEpochNumber);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("UtxoMerkleTreeRoot is not defined even if CSW is enabled");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalStateException("UtxoMerkleTreeRoot is not defined");
                }
                throw new MatchError(option2);
            }
            Some some2 = some = (Some)option2;
            option = some2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$buildCertificateData$2(int pubKeyIndex$1, CertificateSubmitter.CertificateSignatureInfo info) {
        return info.pubKeyIndex() == pubKeyIndex$1;
    }

    public WithoutKeyRotationCircuitStrategy(SidechainSettings settings, NetworkParams params, ThresholdSignatureCircuit cryptolibCircuit) {
        this.params = params;
        this.cryptolibCircuit = cryptolibCircuit;
        super(settings, params);
    }
}

