/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.certificatesubmitter.strategies;

import com.horizen.SidechainHistory;
import com.horizen.SidechainMemoryPool;
import com.horizen.SidechainSettings;
import com.horizen.SidechainState;
import com.horizen.SidechainWallet;
import com.horizen.block.WithdrawalEpochCertificate;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.certificatesubmitter.CertificateSubmitter;
import com.horizen.certificatesubmitter.dataproof.CertificateDataWithKeyRotation;
import com.horizen.certificatesubmitter.keys.CertifiersKeys;
import com.horizen.certificatesubmitter.keys.KeyRotationProof;
import com.horizen.certificatesubmitter.keys.SchnorrKeysSignatures;
import com.horizen.certificatesubmitter.strategies.CircuitStrategy;
import com.horizen.cryptolibprovider.CryptoLibProvider$;
import com.horizen.cryptolibprovider.ThresholdSignatureCircuitWithKeyRotation;
import com.horizen.params.NetworkParams;
import com.horizen.proof.SchnorrProof;
import com.horizen.proposition.SchnorrProposition;
import com.horizen.utils.Pair;
import java.io.Serializable;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewHolder;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0005\u000b\u0001MA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u00037\u0001\u0011\u0005s\u0007C\u0003_\u0001\u0011\u0005s\fC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\b\u0001!I!!\u0003\u0003=]KG\u000f[&fsJ{G/\u0019;j_:\u001c\u0015N]2vSR\u001cFO]1uK\u001eL(BA\u0006\r\u0003)\u0019HO]1uK\u001eLWm\u001d\u0006\u0003\u001b9\tAcY3si&4\u0017nY1uKN,(-\\5ui\u0016\u0014(BA\b\u0011\u0003\u001dAwN]5{K:T\u0011!E\u0001\u0004G>l7\u0001A\n\u0003\u0001Q\u00012!\u0006\f\u0019\u001b\u0005Q\u0011BA\f\u000b\u0005=\u0019\u0015N]2vSR\u001cFO]1uK\u001eL\bCA\r\u001d\u001b\u0005Q\"BA\u000e\r\u0003%!\u0017\r^1qe>|g-\u0003\u0002\u001e5\tq2)\u001a:uS\u001aL7-\u0019;f\t\u0006$\u0018mV5uQ.+\u0017PU8uCRLwN\\\u0001\tg\u0016$H/\u001b8hgB\u0011\u0001%I\u0007\u0002\u001d%\u0011!E\u0004\u0002\u0012'&$Wm\u00195bS:\u001cV\r\u001e;j]\u001e\u001c\u0018A\u00029be\u0006l7\u000f\u0005\u0002&O5\taE\u0003\u0002$\u001d%\u0011\u0001F\n\u0002\u000e\u001d\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:\u0002!\r\u0014\u0018\u0010\u001d;pY&\u00147)\u001b:dk&$\bCA\u0016/\u001b\u0005a#BA\u0017\u000f\u0003E\u0019'/\u001f9u_2L'\r\u001d:pm&$WM]\u0005\u0003_1\u0012\u0001\u0006\u00165sKNDw\u000e\u001c3TS\u001et\u0017\r^;sK\u000eK'oY;ji^KG\u000f[&fsJ{G/\u0019;j_:\fa\u0001P5oSRtD\u0003\u0002\u001a4iU\u0002\"!\u0006\u0001\t\u000by!\u0001\u0019A\u0010\t\u000b\r\"\u0001\u0019\u0001\u0013\t\u000b%\"\u0001\u0019\u0001\u0016\u0002\u001b\u001d,g.\u001a:bi\u0016\u0004&o\\8g)\rAt*\u0015\t\u0005sqrt)D\u0001;\u0015\tYd\"A\u0003vi&d7/\u0003\u0002>u\t!\u0001+Y5s!\ry$\tR\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n)\u0011I\u001d:bsB\u0011q(R\u0005\u0003\r\u0002\u0013AAQ=uKB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0005Y\u0006twMC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%\u0001\u0002'p]\u001eDQ\u0001U\u0003A\u0002a\tqbY3si&4\u0017nY1uK\u0012\u000bG/\u0019\u0005\u0006%\u0016\u0001\raU\u0001\u0018aJ|g/\u001b8h\r&dW-\u00112t_2,H/\u001a)bi\"\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,A\u001b\u00059&B\u0001-\u0013\u0003\u0019a$o\\8u}%\u0011!\fQ\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[\u0001\u0006!\"-^5mI\u000e+'\u000f^5gS\u000e\fG/\u001a#bi\u0006$2\u0001\u00071g\u0011\u0015\tg\u00011\u0001c\u0003E\u0019\u0018\u000eZ3dQ\u0006LgNT8eKZKWm\u001e\t\u0003G\u0012l\u0011\u0001A\u0005\u0003KZ\u0011AAV5fo\")qM\u0002a\u0001Q\u000611\u000f^1ukN\u0004\"!\u001b:\u000f\u0005)\u0004hBA6p\u001d\tagN\u0004\u0002W[&\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003c2\tAcQ3si&4\u0017nY1uKN+(-\\5ui\u0016\u0014\u0018BA:u\u0005A\u0019\u0016n\u001a8biV\u0014Xm]*uCR,8O\u0003\u0002r\u0019\u0005\u0001r-\u001a;NKN\u001c\u0018mZ3U_NKwM\u001c\u000b\u0004ovt\bc\u0001=|}5\t\u0011P\u0003\u0002{\u0001\u0006!Q\u000f^5m\u0013\ta\u0018PA\u0002UefDQ!Y\u0004A\u0002\tDaa`\u0004A\u0002\u0005\u0005\u0011a\b:fM\u0016\u0014XM\\2fI^KG\u000f\u001b3sC^\fG.\u00129pG\"tU/\u001c2feB\u0019q(a\u0001\n\u0007\u0005\u0015\u0001IA\u0002J]R\f\u0011eZ3u'\u000eDgn\u001c:s\u0017\u0016L8oU5h]\u0006$XO]3t\u0019&\u001cHOQ=uKN$b!a\u0003\u0002\u0018\u0005\u0005\u0002\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EA\"\u0001\u0003lKf\u001c\u0018\u0002BA\u000b\u0003\u001f\u0011QcU2i]>\u0014(oS3zgNKwM\\1ukJ,7\u000fC\u0004\u0002\u001a!\u0001\r!a\u0007\u0002\u000bM$\u0018\r^3\u0011\u0007\u0001\ni\"C\u0002\u0002 9\u0011abU5eK\u000eD\u0017-\u001b8Ti\u0006$X\r\u0003\u0004\u0000\u0011\u0001\u0007\u0011\u0011\u0001")
public class WithKeyRotationCircuitStrategy
extends CircuitStrategy<CertificateDataWithKeyRotation> {
    private final NetworkParams params;
    private final ThresholdSignatureCircuitWithKeyRotation cryptolibCircuit;

    @Override
    public Pair<byte[], Long> generateProof(CertificateDataWithKeyRotation certificateData, String provingFileAbsolutePath) {
        BoxedUnit boxedUnit;
        Seq seq;
        Seq signaturesBytes;
        block6: {
            Tuple2 tuple2;
            block5: {
                tuple2 = ((GenericTraversableTemplate)certificateData.schnorrKeyPairs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SchnorrProposition proposition = (SchnorrProposition)tuple2._1();
                    Option proof = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)proposition.bytes(), (Object)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(proof.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.bytes()))));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple2 == null) break block5;
                signaturesBytes = (Seq)tuple2._2();
                if (tuple2._1() != null && signaturesBytes != null) break block6;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq2 = seq = signaturesBytes;
        Seq signaturesBytes2 = seq2;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info(new StringBuilder(101).append("Start generating proof with parameters: certificateData = ").append(certificateData).append(", ").append("signersThreshold = ").append(this.params.signersThreshold()).append(". ").append("It can take a while.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value sidechainCreationVersion = this.params.sidechainCreationVersion();
        return this.cryptolibCircuit.createProof((List)JavaConverters$.MODULE$.seqAsJavaListConverter(certificateData.withdrawalRequests()).asJava(), certificateData.sidechainId(), certificateData.referencedEpochNumber(), certificateData.endEpochCumCommTreeHash(), certificateData.btrFee(), certificateData.ftMinAmount(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(signaturesBytes2).asJava(), certificateData.schnorrKeysSignatures(), this.params.signersThreshold(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(certificateData.previousCertificateOption())), sidechainCreationVersion.id(), certificateData.genesisKeysRootHash(), provingFileAbsolutePath, true, true);
    }

    @Override
    public CertificateDataWithKeyRotation buildCertificateData(NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool> sidechainNodeView, CertificateSubmitter.SignaturesStatus status) {
        SidechainHistory history = (SidechainHistory)sidechainNodeView.history();
        SidechainState state = (SidechainState)sidechainNodeView.state();
        Seq<WithdrawalRequestBox> withdrawalRequests = state.withdrawalRequests(status.referencedEpoch());
        long btrFee = this.getBtrFee(status.referencedEpoch());
        long ftMinAmount = this.getFtMinAmount(status.referencedEpoch());
        byte[] endEpochCumCommTreeHash = this.lastMainchainBlockCumulativeCommTreeHashForWithdrawalEpochNumber(history, state, status.referencedEpoch());
        byte[] sidechainId = this.params.sidechainId();
        Option<WithdrawalEpochCertificate> previousCertificateOption = state.certificate(status.referencedEpoch() - 1);
        SchnorrKeysSignatures schnorrKeysSignatures = this.getSchnorrKeysSignaturesListBytes(state, status.referencedEpoch());
        Seq signersPublicKeyWithSignatures = (Seq)((TraversableLike)schnorrKeysSignatures.schnorrSigners().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SchnorrProposition pubKey = (SchnorrProposition)tuple2._1();
            int pubKeyIndex = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)new SchnorrProposition(pubKey.pubKeyBytes()), (Object)status.knownSigs().find((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)WithKeyRotationCircuitStrategy.$anonfun$buildCertificateData$2(pubKeyIndex, info))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.signature()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        return new CertificateDataWithKeyRotation(status.referencedEpoch(), sidechainId, withdrawalRequests, endEpochCumCommTreeHash, btrFee, ftMinAmount, (Seq<Tuple2<SchnorrProposition, Option<SchnorrProof>>>)signersPublicKeyWithSignatures, schnorrKeysSignatures, previousCertificateOption, CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().generateKeysRootHash((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.params.signersPublicKeys().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.pubKeyBytes(), Seq$.MODULE$.canBuildFrom())).toList()).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.params.mastersPublicKeys().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.pubKeyBytes(), Seq$.MODULE$.canBuildFrom())).toList()).asJava()));
    }

    @Override
    public Try<byte[]> getMessageToSign(NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool> sidechainNodeView, int referencedWithdrawalEpochNumber) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SidechainHistory history = (SidechainHistory)sidechainNodeView.history();
            SidechainState state = (SidechainState)sidechainNodeView.state();
            Seq<WithdrawalRequestBox> withdrawalRequests = state.withdrawalRequests(referencedWithdrawalEpochNumber);
            long btrFee = this.getBtrFee(referencedWithdrawalEpochNumber);
            long ftMinAmount = this.getFtMinAmount(referencedWithdrawalEpochNumber);
            byte[] endEpochCumCommTreeHash = this.lastMainchainBlockCumulativeCommTreeHashForWithdrawalEpochNumber(history, state, referencedWithdrawalEpochNumber);
            byte[] sidechainId = $this.params.sidechainId();
            byte[] keysRootHash = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getSchnorrKeysHash(this.getSchnorrKeysSignaturesListBytes(state, referencedWithdrawalEpochNumber));
            byte[] message = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().generateMessageToBeSigned((List)JavaConverters$.MODULE$.seqAsJavaListConverter(withdrawalRequests).asJava(), sidechainId, referencedWithdrawalEpochNumber, endEpochCumCommTreeHash, btrFee, ftMinAmount, keysRootHash);
            return message;
        });
    }

    private SchnorrKeysSignatures getSchnorrKeysSignaturesListBytes(SidechainState state, int referencedWithdrawalEpochNumber) {
        CertifiersKeys prevCertifierKeys = (CertifiersKeys)state.certifiersKeys(referencedWithdrawalEpochNumber - 1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Certifiers keys for previous withdrawal epoch are not present");
        });
        CertifiersKeys newCertifierKeys = (CertifiersKeys)state.certifiersKeys(referencedWithdrawalEpochNumber).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Certifiers keys for current withdrawal epoch are not present");
        });
        Tuple2 tuple2 = ((GenericTraversableTemplate)newCertifierKeys.signingKeys().indices().map((Function1 & Serializable & scala.Serializable)i -> WithKeyRotationCircuitStrategy.$anonfun$getSchnorrKeysSignaturesListBytes$3(prevCertifierKeys, newCertifierKeys, state, referencedWithdrawalEpochNumber, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexedSeq updatedSigningKeysSkSignatures = (IndexedSeq)tuple2._1();
        IndexedSeq updatedSigningKeysMkSignatures = (IndexedSeq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)updatedSigningKeysSkSignatures, (Object)updatedSigningKeysMkSignatures);
        Tuple2 tuple23 = tuple22;
        IndexedSeq updatedSigningKeysSkSignatures2 = (IndexedSeq)tuple23._1();
        IndexedSeq updatedSigningKeysMkSignatures2 = (IndexedSeq)tuple23._2();
        Tuple2 tuple24 = ((GenericTraversableTemplate)newCertifierKeys.masterKeys().indices().map((Function1 & Serializable & scala.Serializable)i -> WithKeyRotationCircuitStrategy.$anonfun$getSchnorrKeysSignaturesListBytes$4(prevCertifierKeys, newCertifierKeys, state, referencedWithdrawalEpochNumber, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        IndexedSeq updatedMasterKeysSkSignatures = (IndexedSeq)tuple24._1();
        IndexedSeq updatedMasterKeysMkSignatures = (IndexedSeq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)updatedMasterKeysSkSignatures, (Object)updatedMasterKeysMkSignatures);
        Tuple2 tuple26 = tuple25;
        IndexedSeq updatedMasterKeysSkSignatures2 = (IndexedSeq)tuple26._1();
        IndexedSeq updatedMasterKeysMkSignatures2 = (IndexedSeq)tuple26._2();
        return new SchnorrKeysSignatures((Seq<SchnorrProposition>)prevCertifierKeys.signingKeys(), (Seq<SchnorrProposition>)prevCertifierKeys.masterKeys(), (Seq<SchnorrProposition>)newCertifierKeys.signingKeys(), (Seq<SchnorrProposition>)newCertifierKeys.masterKeys(), (Seq<Option<SchnorrProof>>)updatedSigningKeysSkSignatures2, (Seq<Option<SchnorrProof>>)updatedSigningKeysMkSignatures2, (Seq<Option<SchnorrProof>>)updatedMasterKeysSkSignatures2, (Seq<Option<SchnorrProof>>)updatedMasterKeysMkSignatures2);
    }

    public static final /* synthetic */ boolean $anonfun$buildCertificateData$2(int pubKeyIndex$1, CertificateSubmitter.CertificateSignatureInfo info) {
        return info.pubKeyIndex() == pubKeyIndex$1;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getSchnorrKeysSignaturesListBytes$3(CertifiersKeys prevCertifierKeys$1, CertifiersKeys newCertifierKeys$1, SidechainState state$1, int referencedWithdrawalEpochNumber$2, int i) {
        Tuple2 tuple2;
        if (!BoxesRunTime.equals((Object)prevCertifierKeys$1.signingKeys().apply(i), (Object)newCertifierKeys$1.signingKeys().apply(i))) {
            Some some;
            KeyRotationProof keyRotationProof;
            Option<KeyRotationProof> option = state$1.keyRotationProof(referencedWithdrawalEpochNumber$2, i, 0);
            if (!(option instanceof Some) || (keyRotationProof = (KeyRotationProof)(some = (Some)option).value()) == null) {
                throw new RuntimeException(new StringBuilder(74).append("Key rotation proof of signing key is not present for certifier with index ").append(i).toString());
            }
            KeyRotationProof keyRotationProof2 = keyRotationProof;
            Tuple2 tuple22 = new Tuple2((Object)Option$.MODULE$.apply((Object)keyRotationProof2.signingKeySignature()), (Object)Option$.MODULE$.apply((Object)keyRotationProof2.masterKeySignature()));
            tuple2 = tuple22;
        } else {
            tuple2 = new Tuple2((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty());
        }
        return tuple2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getSchnorrKeysSignaturesListBytes$4(CertifiersKeys prevCertifierKeys$1, CertifiersKeys newCertifierKeys$1, SidechainState state$1, int referencedWithdrawalEpochNumber$2, int i) {
        Tuple2 tuple2;
        if (!BoxesRunTime.equals((Object)prevCertifierKeys$1.masterKeys().apply(i), (Object)newCertifierKeys$1.masterKeys().apply(i))) {
            Some some;
            KeyRotationProof keyRotationProof;
            Option<KeyRotationProof> option = state$1.keyRotationProof(referencedWithdrawalEpochNumber$2, i, 1);
            if (!(option instanceof Some) || (keyRotationProof = (KeyRotationProof)(some = (Some)option).value()) == null) {
                throw new RuntimeException(new StringBuilder(73).append("Key rotation proof of master key is not present for certifier with index ").append(i).toString());
            }
            KeyRotationProof keyRotationProof2 = keyRotationProof;
            Tuple2 tuple22 = new Tuple2((Object)Option$.MODULE$.apply((Object)keyRotationProof2.signingKeySignature()), (Object)Option$.MODULE$.apply((Object)keyRotationProof2.masterKeySignature()));
            tuple2 = tuple22;
        } else {
            tuple2 = new Tuple2((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty());
        }
        return tuple2;
    }

    public WithKeyRotationCircuitStrategy(SidechainSettings settings, NetworkParams params, ThresholdSignatureCircuitWithKeyRotation cryptolibCircuit) {
        this.params = params;
        this.cryptolibCircuit = cryptolibCircuit;
        super(settings, params);
    }
}

