/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.certificatesubmitter.strategies;

import com.horizen.SidechainHistory;
import com.horizen.SidechainMemoryPool;
import com.horizen.SidechainState;
import com.horizen.SidechainWallet;
import com.horizen.block.SidechainBlock;
import com.horizen.certificatesubmitter.CertificateSubmitter;
import com.horizen.certificatesubmitter.CertificateSubmitter$ObsoleteWithdrawalEpochException$;
import com.horizen.certificatesubmitter.strategies.CertificateSubmissionStrategy;
import com.horizen.certificatesubmitter.strategies.SubmissionWindowStatus;
import com.horizen.params.NetworkParams;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.WithdrawalEpochInfo;
import com.horizen.utils.WithdrawalEpochUtils$;
import com.horizen.websocket.client.ChainTopQualityCertificateInfo;
import com.horizen.websocket.client.MainchainNodeChannel;
import com.horizen.websocket.client.MempoolTopQualityCertificateInfo;
import com.horizen.websocket.client.TopQualityCertificates;
import com.horizen.websocket.client.WebsocketErrorResponseException;
import com.horizen.websocket.client.WebsocketInvalidErrorMessageException;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.ScorexLogging;
import sparkz.core.NodeViewHolder;

@ScalaSignature(bytes="\u0006\u0001A4Aa\u0002\u0005\u0001#!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015A\u0004\u0001\"\u0011:\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015\t\u0007\u0001\"\u0003c\u0005A\u0019U-Y:j]\u001e\u001c\u0016\u000eZ3dQ\u0006LgN\u0003\u0002\n\u0015\u0005Q1\u000f\u001e:bi\u0016<\u0017.Z:\u000b\u0005-a\u0011\u0001F2feRLg-[2bi\u0016\u001cXOY7jiR,'O\u0003\u0002\u000e\u001d\u00059\u0001n\u001c:ju\u0016t'\"A\b\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001\u0011\u0002\u0004\b\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eQR\"\u0001\u0005\n\u0005mA!!H\"feRLg-[2bi\u0016\u001cVOY7jgNLwN\\*ue\u0006$XmZ=\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001B;uS2T\u0011!I\u0001\u0007g\u000e|'/\u001a=\n\u0005\rr\"!D*d_J,\u0007\u0010T8hO&tw-\u0001\tnC&t7\r[1j]\u000eC\u0017M\u001c8fYB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0007G2LWM\u001c;\u000b\u0005)b\u0011!C<fEN|7m[3u\u0013\tasE\u0001\u000bNC&t7\r[1j]:{G-Z\"iC:tW\r\\\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005=\nT\"\u0001\u0019\u000b\u00055b\u0011B\u0001\u001a1\u00055qU\r^<pe.\u0004\u0016M]1ng\u00061A(\u001b8jiz\"2!\u000e\u001c8!\tI\u0002\u0001C\u0003%\u0007\u0001\u0007Q\u0005C\u0003.\u0007\u0001\u0007a&A\u0005hKR\u001cF/\u0019;vgR\u0019!(P\"\u0011\u0005eY\u0014B\u0001\u001f\t\u0005Y\u0019VOY7jgNLwN\\,j]\u0012|wo\u0015;biV\u001c\b\"\u0002 \u0005\u0001\u0004y\u0014!E:jI\u0016\u001c\u0007.Y5o\u001d>$WMV5foB\u0011\u0001)Q\u0007\u0002\u0001%\u0011!I\u0007\u0002\u0005-&,w\u000fC\u0003E\t\u0001\u0007Q)A\u0003cY>\u001c7\u000e\u0005\u0002G\u00116\tqI\u0003\u0002E\u0019%\u0011\u0011j\u0012\u0002\u000f'&$Wm\u00195bS:\u0014En\\2l\u00031\u0019\u0007.Z2l#V\fG.\u001b;z)\tau\n\u0005\u0002\u0014\u001b&\u0011a\n\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001V\u00011\u0001R\u0003\u0019\u0019H/\u0019;vgB\u0011!K\u0018\b\u0003'rs!\u0001V.\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u0011\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003;*\tAcQ3si&4\u0017nY1uKN+(-\\5ui\u0016\u0014\u0018BA0a\u0005A\u0019\u0016n\u001a8biV\u0014Xm]*uCR,8O\u0003\u0002^\u0015\u0005Ar-\u001a;DKJ$\u0018NZ5dCR,Gk\u001c9Rk\u0006d\u0017\u000e^=\u0015\u0005\r\\\u0007c\u00013gQ6\tQM\u0003\u0002 )%\u0011q-\u001a\u0002\u0004)JL\bCA\nj\u0013\tQGC\u0001\u0003M_:<\u0007\"\u00027\u0007\u0001\u0004i\u0017!B3q_\u000eD\u0007CA\no\u0013\tyGCA\u0002J]R\u0004")
public class CeasingSidechain
implements CertificateSubmissionStrategy,
ScorexLogging {
    private final MainchainNodeChannel mainchainChannel;
    private final NetworkParams params;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public SubmissionWindowStatus getStatus(NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool> sidechainNodeView, SidechainBlock block) {
        WithdrawalEpochInfo withdrawalEpochInfo = ((SidechainHistory)sidechainNodeView.history()).blockInfoById(block.id()).withdrawalEpochInfo();
        int referencedWithdrawalEpochNumber = withdrawalEpochInfo.epoch() - 1;
        return new SubmissionWindowStatus(referencedWithdrawalEpochNumber, WithdrawalEpochUtils$.MODULE$.inSubmitCertificateWindow(withdrawalEpochInfo, this.params));
    }

    @Override
    public boolean checkQuality(CertificateSubmitter.SignaturesStatus status) {
        if (status.knownSigs().size() >= this.params.signersThreshold()) {
            Try<Object> try_ = this.getCertificateTopQuality(status.referencedEpoch());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long currentCertificateTopQuality = BoxesRunTime.unboxToLong((Object)success.value());
                if ((long)status.knownSigs().size() > currentCertificateTopQuality) {
                    return true;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    Throwable throwable = e;
                    if (throwable instanceof WebsocketErrorResponseException) {
                        BoxedUnit boxedUnit2;
                        WebsocketErrorResponseException websocketErrorResponseException = (WebsocketErrorResponseException)throwable;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error(new StringBuilder(75).append("Mainchain error occurred while processed top quality certificates request(").append(websocketErrorResponseException).append(")").toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        return true;
                    }
                    if (throwable instanceof CertificateSubmitter.ObsoleteWithdrawalEpochException) {
                        BoxedUnit boxedUnit3;
                        CertificateSubmitter.ObsoleteWithdrawalEpochException obsoleteWithdrawalEpochException = (CertificateSubmitter.ObsoleteWithdrawalEpochException)throwable;
                        if (this.log().underlying().isInfoEnabled()) {
                            this.log().underlying().info(new StringBuilder(35).append("Sidechain is behind the Mainchain(").append(obsoleteWithdrawalEpochException).append(")").toString());
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        return false;
                    }
                    if (throwable instanceof WebsocketInvalidErrorMessageException) {
                        BoxedUnit boxedUnit4;
                        WebsocketInvalidErrorMessageException websocketInvalidErrorMessageException = (WebsocketInvalidErrorMessageException)throwable;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error(new StringBuilder(62).append("Mainchain error message is inconsistent to SC implementation(").append(websocketInvalidErrorMessageException).append(")").toString());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        return true;
                    }
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error(new StringBuilder(67).append("Unable to retrieve actual top quality certificates from Mainchain(").append(throwable).append(")").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return false;
                }
                throw new MatchError(try_);
            }
        }
        return false;
    }

    private Try<Object> getCertificateTopQuality(int epoch) {
        return this.mainchainChannel.getTopQualityCertificates(BytesUtils.toHexString(BytesUtils.reverseBytes(this.params.sidechainId()))).map((Function1 & Serializable & scala.Serializable)topQualityCertificates -> BoxesRunTime.boxToLong((long)CeasingSidechain.$anonfun$getCertificateTopQuality$1(epoch, topQualityCertificates)));
    }

    public static final /* synthetic */ long $anonfun$getCertificateTopQuality$1(int epoch$1, TopQualityCertificates topQualityCertificates) {
        long l;
        Some some;
        MempoolTopQualityCertificateInfo mempoolInfo;
        Option option;
        Tuple2 tuple2 = new Tuple2(topQualityCertificates.mempoolCertInfo(), topQualityCertificates.chainCertInfo());
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some && (mempoolInfo = (MempoolTopQualityCertificateInfo)(some = (Some)option).value()).epoch() == epoch$1) {
            l = mempoolInfo.quality();
        } else {
            Some some2;
            ChainTopQualityCertificateInfo chainInfo;
            Option option2;
            Some some3;
            MempoolTopQualityCertificateInfo mempoolInfo2;
            Option option3;
            if (tuple2 != null && (option3 = (Option)tuple2._1()) instanceof Some && (mempoolInfo2 = (MempoolTopQualityCertificateInfo)(some3 = (Some)option3).value()).epoch() > epoch$1) {
                throw new CertificateSubmitter.ObsoleteWithdrawalEpochException(new StringBuilder(47).append("Requested epoch ").append(epoch$1).append(" is obsolete. Current epoch is ").append(mempoolInfo2.quality()).toString(), CertificateSubmitter$ObsoleteWithdrawalEpochException$.MODULE$.apply$default$2());
            }
            if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some && (chainInfo = (ChainTopQualityCertificateInfo)(some2 = (Some)option2).value()).epoch() == epoch$1) {
                l = chainInfo.quality();
            } else {
                Some some4;
                ChainTopQualityCertificateInfo chainInfo2;
                Option option4;
                if (tuple2 != null && (option4 = (Option)tuple2._2()) instanceof Some && (chainInfo2 = (ChainTopQualityCertificateInfo)(some4 = (Some)option4).value()).epoch() > epoch$1) {
                    throw new CertificateSubmitter.ObsoleteWithdrawalEpochException(new StringBuilder(47).append("Requested epoch ").append(epoch$1).append(" is obsolete. Current epoch is ").append(chainInfo2.quality()).toString(), CertificateSubmitter$ObsoleteWithdrawalEpochException$.MODULE$.apply$default$2());
                }
                l = 0L;
            }
        }
        return l;
    }

    public CeasingSidechain(MainchainNodeChannel mainchainChannel, NetworkParams params) {
        this.mainchainChannel = mainchainChannel;
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
    }
}

