/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.block;

import akka.util.ByteString;
import com.horizen.block.SidechainBlock$;
import com.horizen.block.SidechainBlockHeader;
import com.horizen.consensus.ForgingStakeInfo;
import com.horizen.consensus.ForgingStakeInfoSerializer$;
import com.horizen.proof.Signature25519;
import com.horizen.proof.Signature25519Serializer;
import com.horizen.proof.VrfProof;
import com.horizen.proof.VrfProofSerializer;
import com.horizen.utils.MerklePath;
import com.horizen.utils.MerklePathSerializer;
import com.horizen.validation.InvalidSidechainBlockHeaderException;
import com.horizen.validation.InvalidSidechainBlockHeaderException$;
import scala.util.Try;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Serializer;
import scorex.util.serialization.Writer;
import sparkz.core.NodeViewModifier$;
import sparkz.core.package$;
import sparkz.core.serialization.SparkzSerializer;

public final class SidechainBlockHeaderSerializer$
implements SparkzSerializer<SidechainBlockHeader> {
    public static SidechainBlockHeaderSerializer$ MODULE$;

    static {
        new SidechainBlockHeaderSerializer$();
    }

    public ByteString toByteString(Object obj) {
        return SparkzSerializer.toByteString$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseByteString(ByteString byteString) {
        return SparkzSerializer.parseByteString$((SparkzSerializer)this, (ByteString)byteString);
    }

    public Try<SidechainBlockHeader> parseByteStringTry(ByteString byteString) {
        return SparkzSerializer.parseByteStringTry$((SparkzSerializer)this, (ByteString)byteString);
    }

    public byte[] toBytes(Object obj) {
        return SparkzSerializer.toBytes$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseBytes(byte[] bytes) {
        return SparkzSerializer.parseBytes$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<SidechainBlockHeader> parseBytesTry(byte[] bytes) {
        return SparkzSerializer.parseBytesTry$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<SidechainBlockHeader> parseTry(Reader r) {
        return Serializer.parseTry$((Serializer)this, (Reader)r);
    }

    public void serialize(SidechainBlockHeader obj, Writer w) {
        w.put(obj.version());
        w.putBytes((byte[])package$.MODULE$.idToBytes().apply((Object)obj.parentId()));
        w.putLong(obj.timestamp());
        ForgingStakeInfoSerializer$.MODULE$.serialize(obj.forgingStakeInfo(), w);
        MerklePathSerializer.getSerializer().serialize(obj.forgingStakeMerklePath(), w);
        VrfProofSerializer.getSerializer().serialize(obj.vrfProof(), w);
        w.putBytes(obj.sidechainTransactionsMerkleRootHash());
        w.putBytes(obj.mainchainMerkleRootHash());
        w.putBytes(obj.ommersMerkleRootHash());
        w.putLong(obj.ommersCumulativeScore());
        w.putBytes(obj.feePaymentsHash());
        Signature25519Serializer.getSerializer().serialize(obj.signature(), w);
    }

    public SidechainBlockHeader parse(Reader r) {
        byte version = r.getByte();
        if (version != SidechainBlock$.MODULE$.BLOCK_VERSION()) {
            throw new InvalidSidechainBlockHeaderException(new StringBuilder(35).append("SidechainBlock version ").append(version).append(" is invalid.").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
        }
        String parentId = (String)package$.MODULE$.bytesToId().apply((Object)r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize()));
        long timestamp = r.getLong();
        ForgingStakeInfo forgingStakeInfo = ForgingStakeInfoSerializer$.MODULE$.parse(r);
        MerklePath forgingStakeMerkle = MerklePathSerializer.getSerializer().parse(r);
        VrfProof vrfProof = VrfProofSerializer.getSerializer().parse(r);
        byte[] sidechainTransactionsMerkleRootHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        byte[] mainchainMerkleRootHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        byte[] ommersMerkleRootHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        long ommersCumulativeScore = r.getLong();
        byte[] feePaymentsHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        Signature25519 signature = Signature25519Serializer.getSerializer().parse(r);
        return new SidechainBlockHeader(version, parentId, timestamp, forgingStakeInfo, forgingStakeMerkle, vrfProof, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, ommersMerkleRootHash, ommersCumulativeScore, feePaymentsHash, signature);
    }

    private SidechainBlockHeaderSerializer$() {
        MODULE$ = this;
        Serializer.$init$((Serializer)this);
        SparkzSerializer.$init$((SparkzSerializer)this);
    }
}

