/*
 * Decompiled with CFR 0.152.
 */
package com.horizen;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.horizen.backup.BoxIterator;
import com.horizen.box.Box;
import com.horizen.box.BoxSerializer;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.params.NetworkParams;
import com.horizen.proposition.Proposition;
import com.horizen.storage.BackupStorage;
import com.horizen.storage.BoxBackupInterface;
import com.horizen.storage.SidechainStateStorage;
import com.horizen.storage.Storage;
import com.horizen.storage.StorageIterator;
import com.horizen.storage.leveldb.VersionedLevelDbStorageAdapter;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.BytesUtils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\b\u0011\u0001UA\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!\n\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005M!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011I\u0003!Q1A\u0005\u0002MC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u00065\u0002!\ta\u0017\u0005\b}\u0002\u0011\r\u0011\"\u0005\u0000\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u0005\u0001\"CA\b\u0001\t\u0007I\u0011CA\t\u0011!\tI\u0002\u0001Q\u0001\n\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0002\u0010'&$Wm\u00195bS:\u0014\u0015mY6va*\u0011\u0011CE\u0001\bQ>\u0014\u0018N_3o\u0015\u0005\u0019\u0012aA2p[\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\tU$\u0018\u000e\u001c\u0006\u0002C\u000511oY8sKbL!a\t\u0010\u0003\u001bM\u001bwN]3y\u0019><w-\u001b8h\u0003Q\u0019Wo\u001d;p[\n{\u0007pU3sS\u0006d\u0017N_3sgV\ta\u0005\u0005\u0003(W5\u001aT\"\u0001\u0015\u000b\u0005}I#\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y!\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002/c5\tqF\u0003\u00021S\u0005!A.\u00198h\u0013\t\u0011tF\u0001\u0003CsR,\u0007c\u0001\u001b8s5\tQG\u0003\u00027!\u0005\u0019!m\u001c=\n\u0005a*$!\u0004\"pqN+'/[1mSj,'\u000fE\u00025uqJ!aO\u001b\u0003\u0007\t{\u0007\u0010\u0005\u0002>\u00016\taH\u0003\u0002@!\u0005Y\u0001O]8q_NLG/[8o\u0013\t\teHA\u0006Qe>\u0004xn]5uS>t\u0017!F2vgR|WNQ8y'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000fI\u0001\u000eE\u0006\u001c7.\u00169Ti>\u0014\u0018mZ3\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\t\u0002\u000fM$xN]1hK&\u0011!j\u0012\u0002\b'R|'/Y4f\u00039\u0011\u0017mY6VaN#xN]1hK\u0002\n\u0011BY1dWV\u0003\b/\u001a:\u0016\u00039\u0003\"AR(\n\u0005A;%A\u0005\"pq\n\u000b7m[;q\u0013:$XM\u001d4bG\u0016\f!BY1dWV\u0003\b/\u001a:!\u0003\u0019\u0001\u0018M]1ngV\tA\u000b\u0005\u0002V/6\taK\u0003\u0002S!%\u0011\u0001L\u0016\u0002\u000e\u001d\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:\u0002\u000fA\f'/Y7tA\u00051A(\u001b8jiz\"R\u0001\u00180ncV\u0004\"!\u0018\u0001\u000e\u0003AAQ\u0001J\u0005A\u0002\u0019BCA\u00181kWB\u0011\u0011\r[\u0007\u0002E*\u00111\rZ\u0001\u0005]\u0006lWM\u0003\u0002fM\u00061\u0011N\u001c6fGRT!a\u001a\n\u0002\r\u001d|wn\u001a7f\u0013\tI'MA\u0003OC6,G-A\u0003wC2,X-I\u0001m\u0003Q\u0019Uo\u001d;p[\n{\u0007pU3sS\u0006d\u0017N_3sg\")1)\u0003a\u0001\u000b\"\"Q\u000e\u00196pC\u0005\u0001\u0018!\u0004\"bG.,\bo\u0015;pe\u0006<W\rC\u0003M\u0013\u0001\u0007a\n\u000b\u0003rA*\u001c\u0018%\u0001;\u0002\u0013\t\u000b7m[+qa\u0016\u0014\b\"\u0002*\n\u0001\u0004!\u0006\u0006B;aU^\f\u0013\u0001_\u0001\u0007!\u0006\u0014\u0018-\\:)\u0005%Q\bCA>}\u001b\u0005!\u0017BA?e\u0005\u0019IeN[3di\u000692/\u001b3fG\"\f\u0017N\u001c\"pq\u0016\u001c8i\\7qC:LwN\\\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\u0001\u0012!C2p[B\fg.[8o\u0013\u0011\tY!!\u0002\u0003/MKG-Z2iC&t'i\u001c=fg\u000e{W\u000e]1oS>t\u0017\u0001G:jI\u0016\u001c\u0007.Y5o\u0005>DXm]\"p[B\fg.[8oA\u0005i!-Y2lkB\u001cFo\u001c:bO\u0016,\"!a\u0005\u0011\u0007\u0019\u000b)\"C\u0002\u0002\u0018\u001d\u0013QBQ1dWV\u00048\u000b^8sC\u001e,\u0017A\u00042bG.,\bo\u0015;pe\u0006<W\rI\u0001\rGJ,\u0017\r^3CC\u000e\\W\u000f\u001d\u000b\t\u0003?\t)#a\u0010\u0002DA\u0019q#!\t\n\u0007\u0005\r\u0002D\u0001\u0003V]&$\bbBA\u0014\u001d\u0001\u0007\u0011\u0011F\u0001\u0011gR\fG/Z*u_J\fw-\u001a)bi\"\u0004B!a\u000b\u0002:9!\u0011QFA\u001b!\r\ty\u0003G\u0007\u0003\u0003cQ1!a\r\u0015\u0003\u0019a$o\\8u}%\u0019\u0011q\u0007\r\u0002\rA\u0013X\rZ3g\u0013\u0011\tY$!\u0010\u0003\rM#(/\u001b8h\u0015\r\t9\u0004\u0007\u0005\b\u0003\u0003r\u0001\u0019AA\u0015\u0003i\u0019\u0018\u000eZ3dQ\u0006LgN\u00117pG.LE\rV8S_2d'-Y2l\u0011\u001d\t)E\u0004a\u0001\u0003\u000f\n\u0001cY8qsN#\u0018\r^3Ti>\u0014\u0018mZ3\u0011\u0007]\tI%C\u0002\u0002La\u0011qAQ8pY\u0016\fg\u000e")
public class SidechainBackup
implements ScorexLogging {
    private final HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers;
    private final Storage backUpStorage;
    private final BoxBackupInterface backUpper;
    private final NetworkParams params;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;
    private final BackupStorage backupStorage;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers() {
        return this.customBoxSerializers;
    }

    public Storage backUpStorage() {
        return this.backUpStorage;
    }

    public BoxBackupInterface backUpper() {
        return this.backUpper;
    }

    public NetworkParams params() {
        return this.params;
    }

    public SidechainBoxesCompanion sidechainBoxesCompanion() {
        return this.sidechainBoxesCompanion;
    }

    public BackupStorage backupStorage() {
        return this.backupStorage;
    }

    public void createBackup(String stateStoragePath, String sidechainBlockIdToRollback, boolean copyStateStorage) {
        VersionedLevelDbStorageAdapter storage;
        SidechainStateStorage sidechainStateStorage;
        Try<SidechainStateStorage> try_;
        String storagePath = stateStoragePath;
        if (copyStateStorage) {
            File stateStorage = new File(stateStoragePath);
            File stateStorageBackup = new File(new StringBuilder(16).append(stateStoragePath).append("_copy_for_backup").toString());
            try {
                FileUtils.copyDirectory((File)stateStorage, (File)stateStorageBackup);
                storagePath = new StringBuilder(16).append(stateStoragePath).append("_copy_for_backup").toString();
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error during the copy of the StateStorage: ", new Object[]{t.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(43).append("Error during the copy of the StateStorage: ").append(t.getMessage()).toString());
            }
        }
        if ((try_ = (sidechainStateStorage = new SidechainStateStorage(storage = new VersionedLevelDbStorageAdapter(new File(storagePath)), this.sidechainBoxesCompanion(), this.params())).rollback(new ByteArrayWrapper(BytesUtils.fromHexString(sidechainBlockIdToRollback)))) instanceof Success) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Success success = (Success)try_;
            SidechainStateStorage stateStorage = (SidechainStateStorage)success.value();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Rollback of the SidechainStateStorage completed successfully!");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            StorageIterator stateIterator = stateStorage.getIterator();
            stateIterator.seekToFirst();
            try {
                this.backUpper().backup(new BoxIterator(stateIterator, this.sidechainBoxesCompanion()), this.backupStorage());
                storage.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit3;
                storage.close();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error during the Backup generation: ", new Object[]{t.getMessage()});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(36).append("Error during the Backup generation: ").append(t.getMessage()).toString());
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Rollback of the SidechainStateStorage couldn't end successfully...", new Object[]{e.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }

    @Inject
    public SidechainBackup(@Named(value="CustomBoxSerializers") HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers, @Named(value="BackupStorage") Storage backUpStorage, @Named(value="BackUpper") BoxBackupInterface backUpper, @Named(value="Params") NetworkParams params) {
        this.customBoxSerializers = customBoxSerializers;
        this.backUpStorage = backUpStorage;
        this.backUpper = backUpper;
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.sidechainBoxesCompanion = new SidechainBoxesCompanion(customBoxSerializers);
        this.backupStorage = new BackupStorage(backUpStorage, this.sidechainBoxesCompanion());
    }
}

