/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.horizen.websocket.client.EventHandler;
import com.horizen.websocket.client.EventPayload;
import com.horizen.websocket.client.RequestPayload;
import com.horizen.websocket.client.RequestType;
import com.horizen.websocket.client.ResponsePayload;
import com.horizen.websocket.client.WebSocketChannel;
import com.horizen.websocket.client.WebSocketChannelCommunicationClient;
import com.horizen.websocket.client.WebSocketCommunicationClient$;
import com.horizen.websocket.client.WebSocketMessageHandler;
import com.horizen.websocket.client.WebSocketServerError;
import com.horizen.websocket.client.WebsocketErrorResponseException;
import com.horizen.websocket.client.WebsocketErrorResponseException$;
import com.horizen.websocket.client.WebsocketInvalidErrorMessageException;
import com.horizen.websocket.client.WebsocketInvalidErrorMessageException$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u0010!\u0001%B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019A\u0006\u0001)A\u0005\u001d\"9\u0011\f\u0001a\u0001\n\u0013Q\u0006b\u0002>\u0001\u0001\u0004%Ia\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003\\\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9\u0001C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!A\u0011\u0011\b\u0001!B\u0013\tI\u0001C\u0006\u0002<\u0001\u0001\r\u00111A\u0005\n\u0005u\u0002bCA#\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fB1\"a\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002@!I\u0011Q\n\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002R!9\u0011q\r\u0001\u0005B\u0005%\u0004bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t)\u000e\u0001C!\u0003/Dq!!:\u0001\t\u0003\n9\u000fC\u0004\u0002n\u0002!I!a<\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011Y\u0002\u0001C!\u0005;9\u0011Ba\b!\u0003\u0003E\tA!\t\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0005GAa\u0001\u0013\u000f\u0005\u0002\t\u0015\u0002\"\u0003B\u00149E\u0005I\u0011\u0001B\u0015\u0005q9VMY*pG.,GoQ8n[Vt\u0017nY1uS>t7\t\\5f]RT!!\t\u0012\u0002\r\rd\u0017.\u001a8u\u0015\t\u0019C%A\u0005xK\n\u001cxnY6fi*\u0011QEJ\u0001\bQ>\u0014\u0018N_3o\u0015\u00059\u0013aA2p[\u000e\u00011#\u0002\u0001+aQ:\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u00022e5\t\u0001%\u0003\u00024A\t\u0019s+\u001a2T_\u000e\\W\r^\"iC:tW\r\\\"p[6,h.[2bi&|gn\u00117jK:$\bCA\u00196\u0013\t1\u0004EA\fXK\n\u001cvnY6fi6+7o]1hK\"\u000bg\u000e\u001a7feB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005kRLGNC\u0001=\u0003\u0019\u00198m\u001c:fq&\u0011a(\u000f\u0002\u000e'\u000e|'/\u001a=M_\u001e<\u0017N\\4\u0002\u001dI,\u0017/^3tiRKW.Z(viB\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\tIV\u0014\u0018\r^5p]*\u0011Q\tL\u0001\u000bG>t7-\u001e:sK:$\u0018BA$C\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fa\u0001P5oSRtDC\u0001&L!\t\t\u0004\u0001C\u0004@\u0005A\u0005\t\u0019\u0001!\u0002\r5\f\u0007\u000f]3s+\u0005q\u0005CA(W\u001b\u0005\u0001&BA)S\u0003!!\u0017\r^1cS:$'BA*U\u0003\u001dQ\u0017mY6t_:T!!\u0016\u0014\u0002\u0013\u0019\f7\u000f^3sq6d\u0017BA,Q\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\nAB]3rk\u0016\u001cHo\u001d)p_2,\u0012a\u0017\t\u00059\u0002\u0014W.D\u0001^\u0015\t)eL\u0003\u0002`Y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0005l&a\u0002+sS\u0016l\u0015\r\u001d\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015dS\"\u00014\u000b\u0005\u001dD\u0013A\u0002\u001fs_>$h(\u0003\u0002jY\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIG\u0006\u0005\u0003,]B<\u0018BA8-\u0005\u0019!V\u000f\u001d7feA\u0019\u0011O\u001d;\u000e\u0003\u0011K!a\u001d#\u0003\u000fA\u0013x.\\5tKB\u0011\u0011'^\u0005\u0003m\u0002\u0012qBU3ta>t7/\u001a)bs2|\u0017\r\u001a\t\u0004Gb$\u0018BA=m\u0005\u0015\u0019E.Y:t\u0003A\u0011X-];fgR\u001c\bk\\8m?\u0012*\u0017\u000f\u0006\u0002}\u007fB\u00111&`\u0005\u0003}2\u0012A!\u00168ji\"A\u0011\u0011\u0001\u0004\u0002\u0002\u0003\u00071,A\u0002yIE\nQB]3rk\u0016\u001cHo\u001d)p_2\u0004\u0013!E3wK:$\b*\u00198eY\u0016\u00148\u000fU8pYV\u0011\u0011\u0011\u0002\t\u00079\u0002\fY!!\u0005\u0011\u0007-\ni!C\u0002\u0002\u00101\u00121!\u00138u!\u0019\t\u0019\"!\b\u0002$9!\u0011QCA\r\u001d\r)\u0017qC\u0005\u0002[%\u0019\u00111\u0004\u0017\u0002\u000fA\f7m[1hK&!\u0011qDA\u0011\u0005\r\u0019V-\u001d\u0006\u0004\u00037a\u0003CB\u0016o\u0003K\t\t\u0004E\u00032\u0003O\tY#C\u0002\u0002*\u0001\u0012A\"\u0012<f]RD\u0015M\u001c3mKJ\u00042!MA\u0017\u0013\r\ty\u0003\t\u0002\r\u000bZ,g\u000e\u001e)bs2|\u0017\r\u001a\t\u0005Gb\fY#A\u000bfm\u0016tG\u000fS1oI2,'o\u001d)p_2|F%Z9\u0015\u0007q\f9\u0004C\u0005\u0002\u0002%\t\t\u00111\u0001\u0002\n\u0005\u0011RM^3oi\"\u000bg\u000e\u001a7feN\u0004vn\u001c7!\u0003A9XMY*pG.,Go\u00115b]:,G.\u0006\u0002\u0002@A\u0019\u0011'!\u0011\n\u0007\u0005\r\u0003E\u0001\tXK\n\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006!r/\u001a2T_\u000e\\W\r^\"iC:tW\r\\0%KF$2\u0001`A%\u0011%\t\t\u0001DA\u0001\u0002\u0004\ty$A\txK\n\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0002\nqaY8v]R,'/\u0006\u0002\u0002RA!\u00111KA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013AB1u_6L7MC\u0002F\u00037R1AOA/\u0015\t\ty&\u0001\u0003kCZ\f\u0017\u0002BA2\u0003+\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018\u0001C2pk:$XM\u001d\u0011\u0002'M,GoV3c'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0015\u0007q\fY\u0007C\u0004\u0002nA\u0001\r!a\u0010\u0002\u000f\rD\u0017M\u001c8fY\u0006Y1/\u001a8e%\u0016\fX/Z:u+\u0019\t\u0019(a'\u0002\u0000QA\u0011QOAF\u0003+\u000b9\u000bE\u0003r\u0003o\nY(C\u0002\u0002z\u0011\u0013aAR;ukJ,\u0007\u0003BA?\u0003\u007fb\u0001\u0001B\u0004\u0002\u0002F\u0011\r!a!\u0003\tI+7\u000f]\t\u0004\u0003\u000b#\bcA\u0016\u0002\b&\u0019\u0011\u0011\u0012\u0017\u0003\u000f9{G\u000f[5oO\"9\u0011QR\tA\u0002\u0005=\u0015a\u0003:fcV,7\u000f\u001e+za\u0016\u00042!MAI\u0013\r\t\u0019\n\t\u0002\f%\u0016\fX/Z:u)f\u0004X\rC\u0004\u0002\u0018F\u0001\r!!'\u0002\u000fI,\u0017/^3tiB!\u0011QPAN\t\u001d\ti*\u0005b\u0001\u0003?\u00131AU3r#\u0011\t))!)\u0011\u0007E\n\u0019+C\u0002\u0002&\u0002\u0012aBU3rk\u0016\u001cH\u000fU1zY>\fG\rC\u0004\u0002*F\u0001\r!a+\u0002\u001bI,7\u000f]8og\u0016\u001cE.\u0019>{!\u0011\u0019\u00070a\u001f\u0002)I,w-[:uKJ,e/\u001a8u\u0011\u0006tG\r\\3s+\u0011\t\t,!3\u0015\u0011\u0005M\u0016QXAa\u0003\u001f\u0004R!!.\u0002:rl!!a.\u000b\u0005ib\u0013\u0002BA^\u0003o\u00131\u0001\u0016:z\u0011\u001d\tyL\u0005a\u0001\u0003\u0017\t\u0011\"\u001a<f]R$\u0016\u0010]3\t\u000f\u0005\r'\u00031\u0001\u0002F\u00069\u0001.\u00198eY\u0016\u0014\b#B\u0019\u0002(\u0005\u001d\u0007\u0003BA?\u0003\u0013$q!a3\u0013\u0005\u0004\tiMA\u0001F#\u0011\t))a\u000b\t\u000f\u0005E'\u00031\u0001\u0002T\u0006QQM^3oi\u000ec\u0017M\u001f>\u0011\t\rD\u0018qY\u0001\u0017k:\u0014XmZ5ti\u0016\u0014XI^3oi\"\u000bg\u000e\u001a7feV!\u0011\u0011\\Ar)\u0015a\u00181\\Ao\u0011\u001d\tyl\u0005a\u0001\u0003\u0017Aq!a1\u0014\u0001\u0004\ty\u000eE\u00032\u0003O\t\t\u000f\u0005\u0003\u0002~\u0005\rHaBAf'\t\u0007\u0011QZ\u0001\u0012_:\u0014VmY3jm\u0016$W*Z:tC\u001e,Gc\u0001?\u0002j\"1\u00111\u001e\u000bA\u0002\t\fq!\\3tg\u0006<W-\u0001\u0007qe>\u001cWm]:FeJ|'\u000fF\u0002}\u0003cDq!a=\u0016\u0001\u0004\t)0\u0001\u0003kg>t\u0007cA(\u0002x&\u0019\u0011\u0011 )\u0003\u0011)\u001bxN\u001c(pI\u0016\fA\u0002\u001d:pG\u0016\u001c8/\u0012<f]R$2\u0001`A\u0000\u0011\u001d\t\u0019P\u0006a\u0001\u0003k\fq\u0002\u001d:pG\u0016\u001c8OU3ta>t7/\u001a\u000b\u0004y\n\u0015\u0001bBAz/\u0001\u0007\u0011Q_\u0001\u001b_:\u001cVM\u001c3NKN\u001c\u0018mZ3FeJ|'oT2dkJ\u0014X\r\u001a\u000b\u0006y\n-!Q\u0002\u0005\u0007\u0003WD\u0002\u0019\u00012\t\u000f\t=\u0001\u00041\u0001\u0003\u0012\u0005)1-Y;tKB!\u00111\u0003B\n\u0013\u0011\u0011)\"!\t\u0003\u0013QC'o\\<bE2,\u0017!E4f]\u0016\u0014\u0018\r^3SKF,Xm\u001d;JIV\t!-\u0001\fsKF,Xm\u001d;US6,w.\u001e;EkJ\fG/[8o)\u0005\u0001\u0015\u0001H,fEN{7m[3u\u0007>lW.\u001e8jG\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u0003cq\u0019\"\u0001\b\u0016\u0015\u0005\t\u0005\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003,)\u001a\u0001I!\f,\u0005\t=\u0002\u0003\u0002B\u0019\u0005wi!Aa\r\u000b\t\tU\"qG\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000f-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005{\u0011\u0019DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class WebSocketCommunicationClient
implements WebSocketChannelCommunicationClient,
WebSocketMessageHandler,
ScorexLogging {
    private final FiniteDuration requestTimeOut;
    private final ObjectMapper mapper;
    private TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> requestsPool;
    private TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> eventHandlersPool;
    private WebSocketChannel webSocketChannel;
    private final AtomicInteger counter;
    private final Logger logger;

    public static FiniteDuration $lessinit$greater$default$1() {
        return WebSocketCommunicationClient$.MODULE$.$lessinit$greater$default$1();
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> requestsPool() {
        return this.requestsPool;
    }

    private void requestsPool_$eq(TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> x$1) {
        this.requestsPool = x$1;
    }

    private TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> eventHandlersPool() {
        return this.eventHandlersPool;
    }

    private void eventHandlersPool_$eq(TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> x$1) {
        this.eventHandlersPool = x$1;
    }

    private WebSocketChannel webSocketChannel() {
        return this.webSocketChannel;
    }

    private void webSocketChannel_$eq(WebSocketChannel x$1) {
        this.webSocketChannel = x$1;
    }

    private AtomicInteger counter() {
        return this.counter;
    }

    @Override
    public void setWebSocketChannel(WebSocketChannel channel) {
        this.webSocketChannel_$eq(channel);
    }

    @Override
    public <Req extends RequestPayload, Resp extends ResponsePayload> Future<Resp> sendRequest(RequestType requestType, Req request, Class<Resp> responseClazz) {
        Future future;
        if (this.webSocketChannel() != null) {
            String requestId = this.generateRequestId();
            ObjectNode json = this.mapper().createObjectNode();
            json.put("msgType", 1);
            json.put("requestType", requestType.code());
            json.put("requestId", requestId);
            json.set("requestPayload", this.mapper().valueToTree(request));
            String message = json.toString();
            Promise promise = Promise$.MODULE$.apply();
            this.requestsPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)requestId), (Object)new Tuple2((Object)promise, responseClazz)));
            this.webSocketChannel().sendMessage(message);
            future = promise.future();
        } else {
            future = Promise$.MODULE$.apply().failure((Throwable)new IllegalStateException("The web socket channel must be not null.")).future();
        }
        return future;
    }

    @Override
    public <E extends EventPayload> Try<BoxedUnit> registerEventHandler(int eventType, EventHandler<E> handler, Class<E> eventClazz) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            WebSocketCommunicationClient webSocketCommunicationClient = this;
            synchronized (webSocketCommunicationClient) {
                Seq eventHandlers = (Seq)this.eventHandlersPool().getOrElse((Object)BoxesRunTime.boxToInteger((int)eventType), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
                if (eventHandlers.exists((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)WebSocketCommunicationClient.$anonfun$registerEventHandler$3(handler, h)))) {
                    throw new IllegalArgumentException("Handler is already registered.");
                }
                Seq updatedHandlers = (Seq)eventHandlers.$colon$plus((Object)new Tuple2((Object)handler, (Object)eventClazz), Seq$.MODULE$.canBuildFrom());
                this.eventHandlersPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)eventType)), (Object)updatedHandlers));
            }
        });
    }

    @Override
    public <E extends EventPayload> void unregisterEventHandler(int eventType, EventHandler<E> handler) {
        WebSocketCommunicationClient webSocketCommunicationClient = this;
        synchronized (webSocketCommunicationClient) {
            BoxedUnit boxedUnit;
            Option option = this.eventHandlersPool().get((Object)BoxesRunTime.boxToInteger((int)eventType));
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq handlers = (Seq)some.value();
                Seq updatedHandlers = (Seq)handlers.filter((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)WebSocketCommunicationClient.$anonfun$unregisterEventHandler$1(handler, h)));
                boxedUnit = this.eventHandlersPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)eventType)), (Object)updatedHandlers));
            } else if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    @Override
    public void onReceivedMessage(String message) {
        block9: {
            try {
                JsonNode json = this.mapper().readTree(message);
                int n = json.get("msgType").asInt();
                switch (n) {
                    case 0: {
                        this.processEvent(json);
                        break;
                    }
                    case 2: {
                        this.processResponse(json);
                        break;
                    }
                    case 3: {
                        this.processError(json);
                        break;
                    }
                    default: {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error(new StringBuilder(37).append("Unknown message received with type = ").append(n).toString());
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(new StringBuilder(51).append("On receive message processing exception occurred = ").append(ex.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void processError(JsonNode json) {
        Some some;
        Tuple2 tuple2;
        String requestId = json.get("requestId").asText("");
        Option option = this.requestsPool().remove((Object)requestId);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Promise promise = (Promise)tuple2._1();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (WebSocketServerError)this.mapper().convertValue((Object)json, WebSocketServerError.class));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WebSocketServerError errorResponse = (WebSocketServerError)success.value();
                promise.failure((Throwable)new WebsocketErrorResponseException(errorResponse.message(), WebsocketErrorResponseException$.MODULE$.$lessinit$greater$default$2()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                promise.failure((Throwable)new WebsocketInvalidErrorMessageException(json.toString(), WebsocketInvalidErrorMessageException$.MODULE$.$lessinit$greater$default$2()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(27).append("Unknown response received: ").append(json.toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void processEvent(JsonNode json) {
        int eventType = json.get("eventType").asInt(-1);
        Option option = this.eventHandlersPool().get((Object)BoxesRunTime.boxToInteger((int)eventType));
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq handlers = (Seq)some.value();
            JsonNode eventPayload = json.get("eventPayload");
            handlers.foreach((Function1 & Serializable & scala.Serializable)h -> {
                WebSocketCommunicationClient.$anonfun$processEvent$1(this, eventPayload, h);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(53).append("Event without defined handler received. Event type = ").append(eventType).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void processResponse(JsonNode json) {
        Some some;
        Tuple2 tuple2;
        String requestId = json.get("requestId").asText("");
        Option option = this.requestsPool().remove((Object)requestId);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            BoxedUnit boxedUnit;
            Promise promise = (Promise)tuple2._1();
            Class responseClazz = (Class)tuple2._2();
            try {
                ResponsePayload resp = (ResponsePayload)this.mapper().convertValue((Object)json.get("responsePayload"), responseClazz);
                promise.success((Object)resp);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                promise.failure(ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(46).append("Unknown response received with requested id = ").append(requestId).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    @Override
    public void onSendMessageErrorOccurred(String message, Throwable cause) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Some some;
            Tuple2 tuple2;
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error("Error from web socket channel", cause);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            JsonNode json = this.mapper().readTree(message);
            String requestId = json.get("requestId").asText("");
            Option option = this.requestsPool().remove((Object)requestId);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Promise promise = (Promise)tuple2._1();
                boxedUnit = promise.failure(cause);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    private String generateRequestId() {
        return String.valueOf(this.counter().addAndGet(1));
    }

    @Override
    public FiniteDuration requestTimeoutDuration() {
        return this.requestTimeOut;
    }

    public static final /* synthetic */ boolean $anonfun$registerEventHandler$3(EventHandler handler$1, Tuple2 h) {
        return h._1().equals(handler$1);
    }

    public static final /* synthetic */ boolean $anonfun$unregisterEventHandler$1(EventHandler handler$2, Tuple2 h) {
        return !h._1().equals(handler$2);
    }

    public static final /* synthetic */ void $anonfun$processEvent$1(WebSocketCommunicationClient $this, JsonNode eventPayload$1, Tuple2 h) {
        block3: {
            try {
                EventPayload resp = (EventPayload)$this.mapper().convertValue((Object)eventPayload$1, (Class)h._2());
                ((EventHandler)h._1()).onEvent(resp);
            }
            catch (Throwable ex) {
                BoxedUnit boxedUnit;
                if ($this.log().underlying().isErrorEnabled()) {
                    $this.log().underlying().error(new StringBuilder(37).append("Event parsing was failed by handler: ").append(ex.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public WebSocketCommunicationClient(FiniteDuration requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.requestsPool = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.eventHandlersPool = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.counter = new AtomicInteger();
    }
}

