/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import com.horizen.utils.MerklePath;
import com.horizen.utils.Pair;
import java.util.ArrayList;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Writer;
import sparkz.core.serialization.SparkzSerializer;

public class MerklePathSerializer
implements SparkzSerializer<MerklePath> {
    private static MerklePathSerializer serializer = new MerklePathSerializer();

    private MerklePathSerializer() {
    }

    public static MerklePathSerializer getSerializer() {
        return serializer;
    }

    public void serialize(MerklePath merklePath, Writer writer) {
        int size = merklePath.merklePath.size();
        writer.putInt(size);
        for (Pair<Byte, byte[]> pair : merklePath.merklePath) {
            writer.put(pair.getKey().byteValue());
            writer.putBytes(pair.getValue());
        }
    }

    public MerklePath parse(Reader reader) {
        int size = reader.getInt();
        if (size < 0) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        if (size == 0) {
            return new MerklePath(new ArrayList<Pair<Byte, byte[]>>());
        }
        ArrayList<Pair<Byte, byte[]>> merklePath = new ArrayList<Pair<Byte, byte[]>>();
        while (size > 0) {
            byte key = reader.getByte();
            byte[] value = reader.getBytes(32);
            merklePath.add(new Pair<Byte, byte[]>(key, value));
            --size;
        }
        return new MerklePath(merklePath);
    }
}

