/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.google.common.primitives.Ints;
import com.horizen.box.BoxUnlocker;
import com.horizen.box.ZenBox;
import com.horizen.box.data.ZenBoxData;
import com.horizen.proof.Proof;
import com.horizen.proof.Signature25519;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.secret.PrivateKey25519;
import com.horizen.secret.Secret;
import com.horizen.transaction.CoreTransactionsIdsEnum;
import com.horizen.transaction.OpenStakeTransactionIncompatibilityChecker;
import com.horizen.transaction.OpenStakeTransactionSerializer;
import com.horizen.transaction.SidechainNoncedTransaction;
import com.horizen.transaction.TransactionIncompatibilityChecker;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.transaction.exception.TransactionSemanticValidityException;
import com.horizen.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import scala.Array;

public class OpenStakeTransaction
extends SidechainNoncedTransaction<PublicKey25519Proposition, ZenBox, ZenBoxData> {
    public static final byte OPEN_STAKE_TRANSACTION_VERSION = 1;
    final byte[] inputId;
    private final Optional<ZenBoxData> outputData;
    final Signature25519 proof;
    private final long fee;
    private final byte version;
    private List<BoxUnlocker<PublicKey25519Proposition>> unlockers;
    private final int forgerIndex;

    public OpenStakeTransaction(byte[] inputId, Optional<ZenBoxData> outputData, Signature25519 proof, int forgerIndex, long fee, byte version) {
        this.inputId = inputId;
        this.outputData = outputData;
        this.proof = proof;
        this.forgerIndex = forgerIndex;
        this.fee = fee;
        this.version = version;
    }

    public TransactionSerializer serializer() {
        return OpenStakeTransactionSerializer.getSerializer();
    }

    @Override
    public synchronized List<BoxUnlocker<PublicKey25519Proposition>> unlockers() {
        if (this.unlockers == null) {
            this.unlockers = new ArrayList<BoxUnlocker<PublicKey25519Proposition>>();
            BoxUnlocker unlocker = new BoxUnlocker(){

                @Override
                public byte[] closedBoxId() {
                    return OpenStakeTransaction.this.inputId;
                }

                public Proof boxKey() {
                    return OpenStakeTransaction.this.proof;
                }
            };
            this.unlockers.add(unlocker);
        }
        return Collections.unmodifiableList(this.unlockers);
    }

    @Override
    protected List<ZenBoxData> getOutputData() {
        ArrayList<ZenBoxData> output = new ArrayList<ZenBoxData>();
        this.outputData.ifPresent(output::add);
        return output;
    }

    @Override
    public long fee() {
        return this.fee;
    }

    @Override
    public void transactionSemanticValidity() throws TransactionSemanticValidityException {
        if (this.version != 1) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: unsupported version number.", this.id()));
        }
        if (this.inputId == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no input data present.", this.id()));
        }
        if (this.proof == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no proof data present.", this.id()));
        }
        if (this.forgerIndex < 0) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: forgerList index negative.", this.id()));
        }
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.OpenStakeTransactionId.id();
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }

    @Override
    public byte[] customFieldsData() {
        return Array.emptyByteArray();
    }

    @Override
    public byte[] customDataMessageToSign() {
        return Ints.toByteArray((int)this.forgerIndex);
    }

    public int getForgerIndex() {
        return this.forgerIndex;
    }

    public byte[] getInputId() {
        return this.inputId;
    }

    public Optional<ZenBoxData> getOutputBox() {
        return this.outputData;
    }

    @Override
    public TransactionIncompatibilityChecker incompatibilityChecker() {
        return new OpenStakeTransactionIncompatibilityChecker();
    }

    public static OpenStakeTransaction create(Pair<ZenBox, PrivateKey25519> from, PublicKey25519Proposition changeAddress, int forgerIndex, long fee) throws TransactionSemanticValidityException {
        if (from == null) {
            throw new IllegalArgumentException("Parameters can't be null.");
        }
        if (from.getKey().value() < fee) {
            throw new IllegalArgumentException("Fee can't be greater than the input!");
        }
        Optional<ZenBoxData> output = Optional.empty();
        if (from.getKey().value() > fee) {
            output = Optional.of(new ZenBoxData(changeAddress, from.getKey().value() - fee));
        }
        OpenStakeTransaction unsignedTransaction = new OpenStakeTransaction(from.getKey().id(), output, null, forgerIndex, fee, 1);
        byte[] messageToSign = unsignedTransaction.messageToSign();
        Secret secret = from.getValue();
        OpenStakeTransaction transaction = new OpenStakeTransaction(from.getKey().id(), output, (Signature25519)secret.sign(messageToSign), forgerIndex, fee, 1);
        transaction.transactionSemanticValidity();
        return transaction;
    }
}

