/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.horizen.transaction.MC2SCAggregatedTransaction;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.transaction.mainchain.BwtRequestSerializer;
import com.horizen.transaction.mainchain.ForwardTransferSerializer;
import com.horizen.transaction.mainchain.SidechainCreationSerializer;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.utils.DynamicTypedSerializer;
import com.horizen.utils.ListSerializer;
import java.util.HashMap;
import java.util.List;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Writer;
import sparkz.core.serialization.SparkzSerializer;

public final class MC2SCAggregatedTransactionSerializer
implements TransactionSerializer<MC2SCAggregatedTransaction> {
    private static MC2SCAggregatedTransactionSerializer serializer;
    private static ListSerializer<SidechainRelatedMainchainOutput> mc2scTransactionsSerializer;

    private MC2SCAggregatedTransactionSerializer() {
    }

    public static MC2SCAggregatedTransactionSerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(MC2SCAggregatedTransaction transaction, Writer writer) {
        writer.put(transaction.version());
        mc2scTransactionsSerializer.serialize(transaction.mc2scTransactionsOutputs(), writer);
    }

    @Override
    public MC2SCAggregatedTransaction parse(Reader reader) {
        byte version = reader.getByte();
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Unsupported transaction version[%d].", version));
        }
        Object outputs = mc2scTransactionsSerializer.parse(reader);
        return new MC2SCAggregatedTransaction((List<SidechainRelatedMainchainOutput>)outputs, version);
    }

    static {
        mc2scTransactionsSerializer = new ListSerializer(new DynamicTypedSerializer(new HashMap<Byte, SparkzSerializer<SidechainRelatedMainchainOutput>>(){
            {
                this.put((byte)1, SidechainCreationSerializer.getSerializer());
                this.put((byte)2, ForwardTransferSerializer.getSerializer());
                this.put((byte)3, BwtRequestSerializer.getSerializer());
            }
        }, new HashMap()));
        serializer = new MC2SCAggregatedTransactionSerializer();
    }
}

